	PAGE    100,132
;
;	Newton Keyboard support driver for HP-LX
;
;	Copyright (C) K.Adachi(GGB01541@niftyserve.or.jp) 1997
;

VERSION	EQU	'0.5b3'

;---	COM port info

SER_PORT	EQU	03F8h
SER_IRQ		EQU	4
SER_BAUD_X227	EQU	5727 ; 9600*(21.477272/36.00)
SER_BAUD_X202	EQU	9502 ; 9600*(31.673550/32.00)
SER_BAUD	EQU	9600

SER_DT_REG	EQU	0
SER_IE_REG	EQU	1
SER_II_REG	EQU	2
SER_LC_REG	EQU	3
SER_MC_REG	EQU	4
SER_LS_REG	EQU	5
SER_MS_REG	EQU	6

SER_DLAB_LO	EQU	SER_DT_REG
SER_DLAB_HI	EQU	SER_IE_REG
SER_LC_DLAB	EQU	10000000B

SER_II_REG_MASK	EQU	07h
SER_II_REG_RLS	EQU	06h
SER_II_REG_RDA	EQU	04h


CODE	SEGMENT	WORD
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

;---	.com entry

	org	100h
start	proc	near
	call	initcom
	ret			; ...but not return from initcom
start	endp

;---	keyboard depend block
	EVEN
kdtop	label	near
; 00h		A	S	D	F
	db	01Eh,	01Fh,	020h,	021h
; 04h		H	G	Z	X
	db	023h,	022h,	02Ch,	02Dh
; 08h		C	V		B
	db	02Eh,	02Fh,	000h,	030h
; 0Ch		Q	W	E	R
	db	010h,	011h,	012h,	013h
; 10h		Y	T	1	2
	db	015h,	014h,	002h,	003h
; 14h		3	4	6	5
	db	004h,	005h,	007h,	006h
; 18h		=	9	7	-
	db	00Dh,	00Ah,	008h,	00Ch
; 1Ch		8	0	]	O
	db	009h,	00Bh,	01Bh,	018h
; 20h		U	[	I	P
	db	016h,	01Ah,	017h,	019h
; 24h		Return	L	J	'
	db	01Ch,	026h,	024h,	028h
; 28h		K	;	\	,
	db	025h,	027h,	02Bh,	033h
; 2Ch		/	N	M	.
	db	035h,	031h,	032h,	034h
; 30h		Tab	Space
	db	00Fh,	039h
nkesc_map	db	LX_Esc	; `
	db	00Eh		; Delete(as BackSpace)
; 34h					Apple
	db	000h,	000h,	000h,	000h
; 38h		Shift L
	db	02Ah
; 39h		CapsLock
NK_CapsLock	db	03Ah
; 3Ah		Option(as Alt)
	db	038h
; 3Bh		Ctrl
NK_Ctrl		db	01Dh
; 3Ch		Shift R
	db	036h,	000h,	000h,	000h

NK_Slash	EQU	02Ch
NK_Apple	EQU	037h
NK_Left		EQU	07Bh
NK_Right	EQU	07Ch
NK_Down		EQU	07Dh
NK_Up		EQU	07Eh
NK_ShiftR	EQU	03Ch
NK_MAXKEYCODE	EQU	NK_ShiftR

		EVEN
LX_Left		db	0E0h, 04Bh
LX_Up		db	0E0h, 048h
LX_Home		db	0E0h, 047h	; Apple+Left
LX_PgUp		db	0E0h, 049h	; Apple+Up
LX_Down		db	0E0h, 050h
LX_Del		db	0E0h, 053h	; Apple+Delete
LX_PgDn		db	0E0h, 051h	; Apple+Down
LX_Right	db	0E0h, 04Dh
LX_End		db	0E0h, 04Fh	; Apple+Right
LX_Ins		db	0E0h, 052h	; Apple+Shift R

LX_ExtKey	EQU	0E0h		; extended keycode
;;;LX_Esc	EQU	001h		; Apple+`
LX_Esc		EQU	001h		; `
LX_Menu		EQU	07Ah		; Apple+Space
;;;LX_BQ	EQU	029h		; `
LX_BQ		EQU	029h		; Apple+`
LX_Space	EQU	039h		; Space
LX_BS		EQU	00Eh		; BackSpace
LX_ShiftL	EQU	02Ah		; Shift L
LX_ShiftR	EQU	036h		; Shift R
LX_CapsLock	EQU	03Ah		; CapsLock
LX_Ctrl		EQU	01Dh		; Ctrl
LX_Alt		EQU	038h		; Alt
LX_1		EQU	002h		; 1
LX_Minus	EQU	00Ch		; -
LX_Equal	EQU	00Dh		; =
LX_Q		EQU	010h		; Q
LX_W		EQU	011h		; W
LX_T		EQU	014h		; T
LX_I		EQU	017h		; I
LX_Calc		EQU	078h		; Calc
LX_More		EQU	071h		; &...
LX_X		EQU	02Dh		; X
LX_C		EQU	02Eh		; C
LX_V		EQU	02Fh		; V
LX_CUT		EQU	06Dh		; CUT
LX_COPY		EQU	06Eh		; COPY
LX_PASTE	EQU	06Fh		; PASTE
LX_Comma	EQU	033h		; ,
LX_Dot		EQU	034h		; .
LX_Slash	EQU	035h		; /
LX_ZOOM		EQU	069h		; ZOOM
LX_DATE		EQU	06Ah		; DATE
LX_TIME		EQU	06Bh		; TIME
LX_SBL		EQU	01Ah		; [
LX_ScrLock	EQU	046h		; Scroll Lock(BREAK)
LX_BSlash	EQU	02Bh		; BackSlash

LX_F01_1_DIFF	EQU	03Bh-002h	; Apple+1..0(F01:03Bh, 1:002h)
LX_F11_MI_DIFF	EQU	057h-00Ch	; Apple+-..=(F11:057h, -:00Ch)
LX_FIL_Q_DIFF	EQU	072h-010h	; Apple+Q..I(Filer:072h, Q:010h)

FnFL	EQU	00010000b	; Fn flag on 40h:F1h
ALTSHF	EQU	00001000b	; ALT flag on 40h:F1h
CTRLSHF	EQU	00000100b	; CTRL flag on 40h:F1h
LEFTSHF	EQU	00000010b	; LEFT SHIFT flag on 40h:F1h
RGHTSHF	EQU	00000001b	; RIGHT SHIFT flag on 40h:F1h

;---	hooks
		EVEN
com_org_off	dw	0000h
com_org_seg	dw	0000h

ki_hook_vec	EQU	09h
ki_org_off	dw	0000h
ki_org_seg	dw	0000h

tt_hook_vec	EQU	1Ch
tt_org_off	dw	0000h
tt_org_seg	dw	0000h

;---	baudrate
	EVEN
serbaud	DW	SER_BAUD

;---	variables
		EVEN
;;;		db	'Variables======>'
my_cs		dw	00000h
		db	128 dup(0FFh)
my_stack	label	near
org_sp		dw	00000h
org_ss		dw	00000h

lxkeybuf	db	32 dup(0)	; LX key buffer
lxkeyb_ro	db	000h	; LX key buffer read offset
lxkeyb_wo	db	000h	; LX key buffer write offset

modkeyf		db	000h	; modifier key flag.
	mod_ctr	EQU	00000001b	; b0:Ctrl
	mod_apl	EQU	00000010b	; b1:Apple
	mod_apb	EQU	00000100b	; b2:If Apple key break then 1.

repstartc	db	000h
	repstartc_cnt	EQU	10	; after 550ms, start repeat.
repkey		dw	00000h	; now repeating key.

rsttim	EQU	9		; about 500ms
potrstc	db	rsttim	; decreased by INT 1Ch. if ==00h then port reinit.
beepcnt	db	000h	; if nonzero then start beepint().
ena_ntk	EQU	1
dis_ntk	EQU	0
ntk_mod	db	dis_ntk	; if ==ena_ntk then enable this driver.
optionf	db	000h	; option flags when started.
	swap_cc	EQU	00000001b	; b0: swap CapsLock and Ctrl
	swap_ar	EQU	00000010b	; b1: swap Right and Up
	invt_ck	EQU	00000100b	; b2: make invert T cursor keys
	invt_c2	EQU	00001000b	; b3: make invert T cursor keys 2
	esce_if	EQU	00010000b	; b4: Ctrl+[ -> ESC
	pb_like	EQU	00100000b	; b5: PowerBook like key.
	chg_clk	EQU	01000000b	; b6: 1=change base clock.
	help_if EQU	10000000b	; b7: 1=show help message.
	opt_msk	EQU	01111111b	; options mask

statf	db	000h	; status flag.
	has_opt	EQU	01000000b	; b6: 1=has valid option
	hp20_if	EQU	10000000b	; b7: 1=200LX,0=100LX

nkleft_map	db	NK_Left
nkright_map	db	NK_Right
nkdown_map	db	NK_Down
nkup_map	db	NK_Up

escescm	db	01Dh,      080h
	db	001h+080h, 080h
	db	01Dh+080h, 080h,000h
escescb	db	01Dh,      080h
	db	001h,      080h
	db	01Dh+080h, 080h,000h

comskip	db	000h	; If nonzero disable com port.
	comskt	EQU	18	; disable time (x55ms)

keycnt	db	000h	; valid input key counter.
kc4apl	db	000h	; for ESC emulate by Apple key.

		EVEN
com_reh_off	dw	0000h	; last re-hooked com1 vector offset.
com_reh_seg	dw	0000h	; last re-hooked com1 vector segment.
now_last_ARENA	dw	0000h	; for check now executing main program.

;---	codes
;
; write to LX key buffer
;
; IN:	DS = CS
;	AL = LX key code
;	AH = bit7:make/break bit
; OUT:	none.
;
		EVEN
wr_lxkeybuf	proc	near
	push	ax
	push	bx
	push	dx

	mov	dh,0
	mov	dl,lxkeyb_wo
	mov	bx,dx
	inc	dl
	and	dl,00011111b	; 0 to 31
	cmp	dl,lxkeyb_ro	; buffer full?
	je	wr_lxkeybuf_end	; yes!

	mov	lxkeyb_wo,dl	; store next offset
	not	ah		; invert make/break bit
	and	ah,10000000b	; use only make/break bit
	or	al,ah		; set make/break bit
	mov	[bx+offset lxkeybuf],al

	test	al,10000000b	; break
	jnz	wr_lxkeybuf_nocnt ; yes!
	cmp	al,LX_ExtKey	; extended keycode?
	je	wr_lxkeybuf_nocnt ; yes!
	inc	keycnt		; valid key counter++
wr_lxkeybuf_nocnt:

wr_lxkeybuf_end:
	pop	dx
	pop	bx
	pop	ax
	ret
wr_lxkeybuf	endp
;
; write to LX key buffer(2byte)
;
; IN:	DS = CS
;	BX = LX keycode offset
;	AH = bit7:make/break bit
; OUT:	none.
;
		EVEN
wr_lxkeybuf2	proc	near
	push	ax
	mov	al,[bx]
	call	wr_lxkeybuf
	mov	al,[bx+1]
	call	wr_lxkeybuf
	pop	ax
	ret
wr_lxkeybuf2	endp
;
; read from LX key buffer
;
; IN:	DS = CS
; OUT:	AL = LX key code
;		00 = NO DATA
;
		EVEN
rd_lxkeybuf	proc	near
	push	bx

	mov	al,0

	mov	bh,0
	mov	bl,lxkeyb_ro
	cmp	bl,lxkeyb_wo	; buffer empty?
	je	rd_lxkeybuf_end	; yes!

	mov	al,[bx+offset lxkeybuf]
	inc	bl
	and	bl,00011111b	; 0 to 31
	mov	lxkeyb_ro,bl	; store next offset

rd_lxkeybuf_end:
	pop	bx
	ret
rd_lxkeybuf	endp
;
; reset LX keyboard status
;
; IN:	DS = CS
; OUT:	none.
;
	EVEN
resetLXkey	proc	near
	push	es
	push	ax

	mov	al,lxkeyb_ro
	mov	lxkeyb_wo,al		; clear keycode buffer
	mov	repstartc,000h		; reset repeat start counter
	mov	repkey,00000h		; reset repeating key info
	and	byte ptr modkeyf, NOT (mod_apl+mod_apb) ; set Apl disable
	mov	comskip,comskt		; set com disable time

	mov	ax,40h
	mov	es,ax
	and	word ptr es:[017h], 08F0h	; clear modifier key flags
	and	byte ptr es:[0F1h], NOT 00010000b ; KBDFLGS(40:F1):bit4==FnFL
	and	byte ptr es:[0FAh], NOT 00010000b ; MISCFL (40:FA):bit4==FnFL

	pop	ax
	pop	es
	ret
resetLXkey	endp
;
; convert NK keycode to LX keycode
; and write to LX key buffer
;
; IN:	DS = CS
;	AL = NK keycode
; OUT:	none.
;
		EVEN
cnvset_nk2lx	proc	near
	push	ax
	push	bx

	mov	ah,al			; save NK keycode.
	and	al,not 10000000b	; clear make/break bit.

	test	ah,10000000b		; make?
	jz	cnvset_nk2lx_anykeybrk	; no! break!
	test	byte ptr modkeyf, mod_apb ; Has Apl breaked yet?
	jz	cnvset_nk2lx_notaplbrk	; no!
	and	byte ptr modkeyf, NOT (mod_apl+mod_apb) ; set Apl disable
cnvset_nk2lx_notaplbrk:
cnvset_nk2lx_anykeybrk:

	cmp	al,nkleft_map		; Left arrow?
	jne	cnvset_nk2lx_nl		; no!
	test	byte ptr modkeyf, mod_apl	; Apl enable?
	jnz	cnvset_nk2lx_l_apl	; yes
	mov	bx, offset LX_Left
	jmp	short cnvset_nk2lx_l_end
cnvset_nk2lx_l_apl:
	mov	bx, offset LX_Home
cnvset_nk2lx_l_end:
	call	wr_lxkeybuf2
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_nl:
	cmp	al,nkright_map		; Right arrow?
	jne	cnvset_nk2lx_nr		; no!
	test	byte ptr modkeyf, mod_apl	; Apl enable?
	jnz	cnvset_nk2lx_r_apl	; yes
	mov	bx, offset LX_Right
	jmp	short cnvset_nk2lx_r_end
cnvset_nk2lx_r_apl:
	mov	bx, offset LX_End
cnvset_nk2lx_r_end:
	call	wr_lxkeybuf2
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_nr:
	cmp	al,nkdown_map		; Down arrow?
	jne	cnvset_nk2lx_nd		; no!
	test	byte ptr modkeyf, mod_apl	; Apl enable?
	jnz	cnvset_nk2lx_d_apl	; yes
	mov	bx, offset LX_Down
	jmp	short cnvset_nk2lx_d_end
cnvset_nk2lx_d_apl:
	mov	bx, offset LX_PgDn
cnvset_nk2lx_d_end:
	call	wr_lxkeybuf2
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_nd:
	cmp	al,nkup_map		; Up arrow?
	jne	cnvset_nk2lx_nu		; no!
	test	byte ptr modkeyf, mod_apl	; Apl enable?
	jnz	cnvset_nk2lx_u_apl	; yes
	mov	bx, offset LX_Up
	jmp	short cnvset_nk2lx_u_end
cnvset_nk2lx_u_apl:
	mov	bx, offset LX_PgUp
cnvset_nk2lx_u_end:
	call	wr_lxkeybuf2
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_nu:
	test	byte ptr optionf, invt_ck ; make invert T cursor keys?
	jz	cnvset_nk2lx_norish	; no!
	cmp	al, NK_Up		; Up arrow?
	jne	cnvset_nk2lx_norish	; no!
	mov	al, NK_Slash		; change Up arrow to Slash.
cnvset_nk2lx_norish:

	test	byte ptr optionf, invt_c2 ; make invert T cursor keys 2?
	jz	cnvset_nk2lx_nolesf	; no!
	cmp	al, NK_Left		; Left arrow?
	jne	cnvset_nk2lx_nolesf	; no!
	mov	al, NK_ShiftR		; change Left arrow to ShiftR.
cnvset_nk2lx_nolesf:

	cmp	al,NK_MAXKEYCODE	; known keycode?
	jbe	cnvset_nk2lx_known	; yes!
	call	resetLXkey		; reset LX keyboard status
	jmp	cnvset_nk2lx_end	; no!
cnvset_nk2lx_known:

	cmp	al,NK_Apple		; Apple key?
	jne	cnvset_nk2lx_napl	; no!
	mov	repstartc,000h		; reset repeat start counter
	test	ah,10000000b		; make?
	jz	cnvset_nk2lx_apl_bk	; no! break!
	or	byte ptr modkeyf, mod_apl	; set Apl enable
	and	byte ptr modkeyf, NOT mod_apb ; clear Apl break flag.
	mov	al,keycnt
	mov	kc4apl,al		; set now key counter value
	jmp	short cnvset_nk2lx_apl_end
cnvset_nk2lx_apl_bk:
	or	byte ptr modkeyf, mod_apb ; set Apl break flag.
	test	byte ptr optionf, pb_like ; PowerBook like key?
	jz	cnvset_nk2lx_apl_end	; no!
	mov	al,keycnt
	cmp	al,kc4apl		; type only Apple on/off?
	jne	cnvset_nk2lx_apl_end	; no!
	mov	ax,8000h+LX_Esc		; ESC make
	call	wr_lxkeybuf
	mov	ax,0000h+LX_Esc		; ESC break
	call	wr_lxkeybuf
cnvset_nk2lx_apl_end:
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_napl:
	mov	bh,0
	mov	bl,al
	add	bx, offset kdtop	; make keycode offset
	mov	al,[bx]		; get LX keycode

	test	byte ptr optionf, esce_if ; Ctrl+[ -> ESC ?
	jz	cnvset_nk2lx_nescemu	; no!

	cmp	al,LX_SBL		; Square Blanket Left?
	jne	cnvset_nk2lx_nsbl	; no!

	push	es
	mov	bx,40h
	mov	es,bx			; BIOS data area
	test	byte ptr es:[017h],00000100b ; b2: Ctrl press
	pop	es
	jz	cnvset_nk2lx_nsbl	; no! not Ctrl press now!

	test	ah, 10000000b		; make?
	jz	cnvset_nk2lx_bsbl	; no!
	mov	bx,offset escescm	; simulate Esc make.
	jmp	short cnvset_nk2lx_sblemu

cnvset_nk2lx_bsbl:
	mov	bx,offset escescb	; simulate Esc break.

cnvset_nk2lx_sblemu:
	mov	al,[bx]
	cmp	al,000h			; simulate data end?
	je	cnvset_nk2lx_msble	; yes!
	mov	ah,al
	and	al,01111111b
	call	wr_lxkeybuf
	inc	bx
	jmp	short cnvset_nk2lx_sblemu

cnvset_nk2lx_msble:	
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_nsbl:
cnvset_nk2lx_nescemu:

	test	byte ptr modkeyf, mod_apl	; Apl enable?
	jnz	cnvset_nk2lx_apl
	jmp	cnvset_nk2lx_noapl	; no!
cnvset_nk2lx_apl:

	cmp	al, LX_BS		; BackSpace?
	jne	cnvset_nk2lx_nobs	; no!
	mov	bx, offset LX_Del	; change to Delete from BackSpace
	call	wr_lxkeybuf2
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_nobs:
	cmp	al, LX_CapsLock		; CapsLock?
	jne	cnvset_nk2lx_nosl	; no!
	test	ah, 10000000b		; make?
	jnz	cnvset_nk2lx_dofn	; yes!
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_dofn:
	push	es
	mov	ax,40h			; do Fn on/off
	mov	es,ax
	test	byte ptr es:[0F1h], 00010000b	; already Fn on?
	jnz	cnvset_nk2lx_fnoff	; yes!

	or	byte ptr es:[0F1h], FnFL ; KBDFLGS(40:F1):bit4==FnFL
	or	byte ptr es:[0FAh], FnFL ; MISCFL (40:FA):bit4==FnFL
	and	byte ptr es:[0FAh], NOT 00100000b ; MISCFL(40:FA):bit5==ClrFnEn
	jmp	short cnvset_nk2lx_fnon

cnvset_nk2lx_fnoff:
	and	byte ptr es:[0F1h], NOT FnFL ; KBDFLGS(40:F1):bit4==FnFL
	and	byte ptr es:[0FAh], NOT FnFL ; MISCFL (40:FA):bit4==FnFL

cnvset_nk2lx_fnon:
	pop	es

	jmp	cnvset_nk2lx_end

cnvset_nk2lx_nosl:
	cmp	al, LX_ShiftR		; Shift R?
	jne	cnvset_nk2lx_nosr	; no!
	mov	bx, offset LX_Ins	; change to Ins from Shift R
	call	wr_lxkeybuf2
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_nosr:
	cmp	al, LX_Esc		; ` as Esc?
	jne	cnvset_nk2lx_nobq	; no!
	mov	al, LX_BQ		; change to BQ from Esc
	call	wr_lxkeybuf
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_nobq:
	cmp	al, LX_Slash		; Slash?
	je	cnvset_nk2lx_slash	; yes!
	cmp	al, LX_BSlash		; BackSlash?
	jne	cnvset_nk2lx_noslash	; no!

cnvset_nk2lx_slash:
	push	es
	push	ax	
	mov	ax,40h
	mov	es,ax
	test	byte ptr es:[017h],00000100b	; Ctrl pressed?
	pop	ax
	pop	es
	jz	cnvset_nk2lx_noBreak	; no!

	mov	al, LX_ScrLock		; make BREAK from Ctrl+Apple+/
	jmp	short cnvset_nk2lx_brkout
cnvset_nk2lx_noBreak:
	mov	al, LX_Menu		; change to Menu from Slash
cnvset_nk2lx_brkout:
	call	wr_lxkeybuf
	jmp	cnvset_nk2lx_end

cnvset_nk2lx_noslash:
	cmp	al, LX_1		; LX keycode >= 1
	jb	cnvset_nk2lx_nofn	; no!
	cmp	al, LX_Equal		; LX keycode <= =
	ja	cnvset_nk2lx_nofn	; no!
	cmp	al, LX_Minus		; LX keycode >= -
	jae	cnvset_nk2lx_fn12	; yes!
	add	al, LX_F01_1_DIFF	; 1..0 -> F1..F10
	jmp	short cnvset_nk2lx_fn_end
cnvset_nk2lx_fn12:
	add	al, LX_F11_MI_DIFF	; -,= -> F11,F12
cnvset_nk2lx_fn_end:
	call	wr_lxkeybuf
	jmp	short cnvset_nk2lx_end
	
cnvset_nk2lx_nofn:
	cmp	al, LX_Q		; LX keycode >= Q
	jb	cnvset_nk2lx_noapk	; no!
	cmp	al, LX_I		; LX keycode <= I
	ja	cnvset_nk2lx_noapk	; no!

	test	byte ptr statf,hp20_if	; 200LX?
	jz	cnvset_nk2lx_100lx	; no!

	cmp	al, LX_W		; W?
	jb	cnvset_nk2lx_200z	; below
	cmp	al, LX_T		; T?
	ja	cnvset_nk2lx_200z	; above > T
	je	cnvset_nk2lx_200a	; equal T
	inc	al			; shift W->E,E->R,R->T
	jmp	short cnvset_nk2lx_200z
cnvset_nk2lx_200a:	
	mov	al, LX_W	; pseude Apple+W(PQ) when type Apple+T
cnvset_nk2lx_200z:

cnvset_nk2lx_100lx:
	add	al, LX_FIL_Q_DIFF	; Q..U -> Filer..123
	cmp	al, LX_Calc		; is original LX keycode I?
	jbe	cnvset_nk2lx_apknm	; no!
	mov	al, LX_More		; set &... keycode
cnvset_nk2lx_apknm:
	call	wr_lxkeybuf
	jmp	short cnvset_nk2lx_end

cnvset_nk2lx_noapk:
	cmp	al, LX_X		; X?
	jne	cnvset_nk2lx_noX	; no!
	mov	al, LX_CUT		; change to CUT from X
	call	wr_lxkeybuf
	jmp	short cnvset_nk2lx_end
cnvset_nk2lx_noX:

	cmp	al, LX_C		; C?
	jne	cnvset_nk2lx_noC	; no!
	mov	al, LX_COPY		; change to COPY from C
	call	wr_lxkeybuf
	jmp	short cnvset_nk2lx_end
cnvset_nk2lx_noC:

	cmp	al, LX_V		; V?
	jne	cnvset_nk2lx_noV	; no!
	mov	al, LX_PASTE		; change to PASTE from V
	call	wr_lxkeybuf
	jmp	short cnvset_nk2lx_end
cnvset_nk2lx_noV:

	cmp	al, LX_Space		; Space?
	jne	cnvset_nk2lx_nospc	; no!
	mov	al, LX_ZOOM		; change to ZOOM from Space
	call	wr_lxkeybuf
	jmp	short cnvset_nk2lx_end
cnvset_nk2lx_nospc:

	cmp	al, LX_Comma		; ,?
	jne	cnvset_nk2lx_noComma	; no!
	mov	al, LX_DATE		; change to DATE from ','
	call	wr_lxkeybuf
	jmp	short cnvset_nk2lx_end
cnvset_nk2lx_noComma:

	cmp	al, LX_Dot		; .?
	jne	cnvset_nk2lx_noDot	; no!
	mov	al, LX_TIME		; change to TIME from '.'
	call	wr_lxkeybuf
	jmp	short cnvset_nk2lx_end
cnvset_nk2lx_noDot:

;;;	jmp	short cnvset_nk2lx_end	; ignore this combination

cnvset_nk2lx_noapl:
	call	wr_lxkeybuf		; set converted LX keycode

cnvset_nk2lx_end:
	pop	bx
	pop	ax
	ret
cnvset_nk2lx	endp
;
; set HP-LX specific shift flags
;
; IN:	AL = keycode.
; OUT:	none.
;
	EVEN
setsftf	proc	near
	push	ax

	mov	ah,al
	and	ah,NOT 10000000b ; clear make/break flag

	cmp	ah, LX_ShiftL	; Shift L?
	jne	setsftf_nsl
	mov	ah, LEFTSHF	; set HP-LX specific flag.
	jmp	short setsftf_sfted

setsftf_nsl:
	cmp	ah, LX_ShiftR	; Shift R?
	jne	setsftf_nsr
	mov	ah, RGHTSHF	; set HP-LX specific flag.
	jmp	short setsftf_sfted

setsftf_nsr:
	cmp	ah, LX_Ctrl	; Ctrl?
	jne	setsftf_nsc
	mov	ah, CTRLSHF	; set HP-LX specific flag.
	jmp	short setsftf_sfted

setsftf_nsc:
	cmp	ah, LX_Alt	; Alt?
	jne	setsftf_nsa
	mov	ah, ALTSHF	; set HP-LX specific flag.
	jmp	short setsftf_sfted

setsftf_nsa:
	jmp	short setsftf_notsft

setsftf_sfted:
	push	es

	push	ax
	mov	ax,40h		; BIOS work area segment
	mov	es,ax
	pop	ax

	test	al,10000000b	; make or break?
	jz	setsftf_make	; make!
	not	ah
	and	es:[0F1h],ah	; clear shift flag.
	jmp	short setsftf_sftend

setsftf_make:
	or	es:[0F1h],ah	; set shift flag.

setsftf_sftend:
	pop	es
setsftf_notsft:
	pop	ax
	ret
setsftf	endp
;
; generate pseudo keyboard intr.
;
; IN:	DL = keycode.
;	DH = extended keycode.(if nonzero)
; OUT:	none.
;
		EVEN
gen_pki	proc	near
	push	ax

	cmp	dh,000h		; has extended keycode?
	je	gen_pki_nohexk	; no!
	mov	al,dh
	out	060h,al		; force set scan code.
	jmp	short $+2
	mov	ah,al
	and	ah,NOT 10000000b	; for exkey magic.
	int	09h		; pseudo keyboard intr
gen_pki_nohexk:
	mov	al,dl
	call	setsftf		; set HP-LX specific shift flag.
	out	060h,al		; force set scan code.
	jmp	short $+2
	mov	ah,al
	and	ah,NOT 10000000b	; for exkey magic.
	int	09h		; pseudo keyboard intr

	pop	ax
	ret
gen_pki	endp
;
; generate make/break keycode if has data in keybuffer.
;
; IN:	DS = CS
; OUT:	if generated make/break then ZF=0 else ZF=1
;
		EVEN
gen_mkbkkey	proc	near
	push	ax
	push	dx

	call	rd_lxkeybuf	; get LX keycode
	cmp	al,000h		; valid data?
	je	gen_mkbkkey_nodata_end	; no!

	mov	dh,0
	cmp	al,LX_ExtKey	; extended keycode?
	jne	gen_mkbkkey_noextk	; no!
	mov	dh,LX_ExtKey
	call	rd_lxkeybuf	; get LX keycode more
gen_mkbkkey_noextk:
	mov	dl,al		; save keycode
	call	gen_pki		; generate pseudo keyboard intr

	test	dl,10000000b	; make keycode?
	jnz	gen_mkbkkey_nomk	; no!

	cmp	dl, LX_ShiftL	; Shift L?
	je	gen_mkbkkey_norep	; yes! no repeat
	cmp	dl, LX_ShiftR	; Shift R?
	je	gen_mkbkkey_norep	; yes! no repeat
	cmp	dl, LX_CapsLock	; CapsLock?
	je	gen_mkbkkey_norep	; yes! no repeat
	cmp	dl, LX_Ctrl	; Ctrl?
	je	gen_mkbkkey_norep	; yes! no repeat
	cmp	dl, LX_Alt	; Alt?
	je	gen_mkbkkey_norep	; yes! no repeat

	mov	repstartc,repstartc_cnt ; set repeat start counter
	mov	repkey,dx	; set now repeating key
	jmp	short gen_mkbkkey_end

gen_mkbkkey_nomk:
	and	dl,NOT 10000000b ; make make code
	cmp	dx,repkey	; repeat key break?
	jne	gen_mkbkkey_end	; no!

	push	es
	mov	ax,40h
	mov	es,ax
	and	byte ptr es:[0F1h], NOT FnFL ; KBDFLGS(40:F1):bit4==FnFL
	and	byte ptr es:[0FAh], NOT FnFL ; MISCFL (40:FA):bit4==FnFL
	pop	es

gen_mkbkkey_norep:
	mov	repstartc,000h	; reset repeat start counter
	mov	repkey,00000h	; reset repeating key info

gen_mkbkkey_end:
	mov	ax,1
	or	ax,ax		; set ZF=0
gen_mkbkkey_nodata_end:
	pop	dx
	pop	ax
	ret
gen_mkbkkey	endp
;
; generate make/break keycode by int 1Ch
;
; IN:	DS = CS
; OUT:	if generated make/break then ZF=0 else ZF=1
;
		EVEN
gen_mkbkrep	proc	near
	push	ax
	push	dx

	call	gen_mkbkkey
	jnz	gen_mkbkrep_mkbk	; generated make or break!
				; did not generate then...
	cmp	repstartc,000h	; enable repeat counter?
	je	gen_mkbkrep_end	; no!
	cmp	repstartc,001h	; repeat start?
	jne	gen_mkbkrep_norps	; no!

	mov	dx,repkey	; get repeating key info
	call	gen_pki		; generate pseudo keyboard intr
	jmp	short gen_mkbkrep_end

gen_mkbkrep_norps:
	dec	repstartc

gen_mkbkrep_end:
	xor	ax,ax	; set ZF=1
gen_mkbkrep_mkbk:
	pop	dx
	pop	ax
	ret
gen_mkbkrep	endp
;
; com power control
;
; IN:	CX	power control
;		= 0000h		off
;		= not 0000h	on
; OUT:	none.
;
		EVEN
compower	proc	near
	pushf
	cli
	push	ax

	in	al,22h
	jmp	short $+2
	push	ax			; save index

	mov	al,10h			; select IRFMAT
	out	22h,al
	jmp	short $+2
	mov	al,00000000b		; clear IRURT
	out	23h,al
	jmp	short $+2

	mov	al,51h			; select GPIO[7-0]
	out	22h,al
	jmp	short $+2
	in	al,23h			; get GPIO[7-0]
	jmp	short $+2

	and	al,NOT 00000001b	; clear IRON3

	jcxz	compower_01
	or	al,00100000b		; set PON
	jmp	short compower_02
compower_01:
	and	al,NOT 00100000b	; clear PON
compower_02:

	out	23h,al
	jmp	short $+2

	mov	al,52h			; select GPIO[15-8]
	out	22h,al
	jmp	short $+2
	in	al,23h
	jmp	short $+2
	and	al,NOT 10000000b	; clear IRON5
	out	23h,al
	jmp	short $+2

	pop	ax
	out	22h,al			; restore index
	jmp	short $+2

	pop	ax
	popf
	ret
compower	endp

		EVEN
compower_on	proc near
	push	cx
	mov	cx,1
	call	compower
	pop	cx
	ret
compower_on	endp

		EVEN
compower_off	proc near
	push	cx
	xor	cx,cx
	call	compower
	pop	cx
	ret
compower_off	endp
;
; Initialize com port
;
; IN:	none.
; OUT:	none.
;
	EVEN
init_com	proc near
	pushf
	cli
	push	ax
	push	dx

	mov	dx,SER_PORT+SER_LC_REG
	mov	al,00000011B	; 8bit,none,stop1
	out	dx,al
	jmp	short $+2

	mov	dx,SER_PORT+SER_IE_REG
	mov	al,00000101B	; enable receive intr and receiver line status
	out	dx,al
	jmp	short $+2

	mov	dx,SER_PORT+SER_MC_REG
	mov	al,00001001B	; OUT2=1 OUT1=RTS=0 DTR=1...for kbd power
	out	dx,al
	jmp	short $+2

	mov	dx,SER_PORT+SER_LC_REG
	in	al,dx
	jmp	short $+2
	or	al,SER_LC_DLAB	; for set baudrate
	out	dx,al
	jmp	short $+2
	push	dx

	mov	dx,00001h
	mov	ax,0C200h	; DX:AX = 115200
	div	cs:serbaud	; (115200/(SER_BAUD)

	mov	dx,SER_PORT+SER_DLAB_LO
	out	dx,al	; set baudrate low
	jmp	short $+2

	mov	dx,SER_PORT+SER_DLAB_HI
	mov	al,ah
	out	dx,al	; set baudrate high
	jmp	short $+2

	pop	dx
	in	al,dx
	jmp	short $+2
	and	al,(not SER_LC_DLAB)
	out	dx,al
	jmp	short $+2

	mov	dx,SER_PORT+SER_LS_REG
	in	al,dx		; reset line status
	jmp	short $+2

	mov	dx,SER_PORT+SER_MS_REG
	in	al,dx		; reset modem status
	jmp	short $+2

	mov	dx,SER_PORT+SER_DT_REG
	in	al,dx		; clear garbage data
	jmp	short $+2

	push	cx
	mov	cx,SER_IRQ
	mov	ah,00000001B
	shl	ah,cl		; make IRQ mask clear mask
	not	ah
	pop	cx

	in	al,21h
	jmp	short $+2
	and	al,ah		; clear COMx IRQ mask
	out	21h,al
	jmp	short $+2
	mov	al,20h
	out	20h,al		; set EOI command
	jmp	short $+2

	pop	dx
	pop	ax
	popf
	ret
init_com endp
;
; Reset COM port
;
; IN:	none.
; OUT:	none.
;
	EVEN
rst_com	proc	near
	pushf
	cli
	push	ax
	push	dx

	mov	dx,SER_PORT+SER_LC_REG
	in	al,dx
	jmp	short $+2
	and	al,(not SER_LC_DLAB)	; DLAB clear
	out	dx,al
	jmp	short $+2

	mov	dx,SER_PORT+SER_IE_REG
	mov	al,00000000B	; disable all intr
	out	dx,al
	jmp	short $+2

	mov	dx,SER_PORT+SER_MC_REG
	mov	al,00000000B	; OUT2=OUT1=RTS=DTR=0
	out	dx,al
	jmp	short $+2

	push	cx
	mov	cx,SER_IRQ
	mov	ah,00000001B
	shl	ah,cl		; make IRQ mask set mask
	pop	cx

	in	al,21h
	jmp	short $+2
	or	al,ah		; set COMx IRQ mask
	out	21h,al
	jmp	short $+2

	pop	dx
	pop	ax
	popf
	ret
rst_com	endp
;
; Beep in tim_hook
;
; IN:	none.
; OUT:	none.
;
	EVEN
beepint	proc	near
	push	ax
	mov	ah,cs:beepcnt
	cmp	ah,000h		; beep end?
	jz	beepint_end	; yes!

	cmp	ah,001h		; beep on?
	jz	beepint_bon	; yes!
	cmp	ah,002h		; beep off?
	jz	beepint_bof	; yes!
	cmp	ah,003h		; beep on?
	jz	beepint_bon	; yes!
	cmp	ah,004h		; beep off?
	jz	beepint_bof	; yes!
	cmp	ah,005h		; beep stop?
	jz	beepint_stop	; yes!
	jmp	short beepint_cnt

beepint_bon:
	in	al,061h
	jmp	short $+2
	or	al,00000011b
	out	061h,al
	jmp	short beepint_cnt

beepint_bof:
	in	al,061h
	jmp	short $+2
	and	al,11111100b
	out	061h,al
	jmp	short beepint_cnt

beepint_stop:
	mov	cs:beepcnt,0FFh	; beep stop(0FFh+1=000h)
beepint_cnt:
	inc	cs:beepcnt
beepint_end:
	pop	ax
	ret
beepint	endp
;
; Scan ARENA structure for check now executing main program
;
; IN:	AX	scan target ARENA structure segment.
; OUT:	AX	if taget ARENA found, OUT:AX==IN:AX
;		else tail ARENA structure segment.
;
	EVEN
scan_ar	proc	near
	push	ds
	push	dx

	mov	dx,ax
	mov	ax,cs
	dec	ax

scan_ar_loop:
	cmp	ax,dx		; found target ARENA structure?
	je	scan_ar_end	; yes!
	mov	ds,ax		; make next ARENA structure segment
	cmp	byte ptr ds:[0000h],05Ah	; end of ARENA?
	je	scan_ar_end	; yes!
	inc	ax		; make memory block segment
	add	ax,ds:[0003h]	; add paragraph size
	jmp	short scan_ar_loop

scan_ar_end:
	pop	dx
	pop	ds
	ret
scan_ar	endp
;
; Hook routines
;
;------	INT 9 hook.

	EVEN
key_hook	proc near
	jmp	short key_hook_main

tsrmark	DB	'resident ntkey2lx here!',00h

	EVEN
key_hook_main:
	pushf
	cli

	push	ds
	push	es
	push	ax

	mov	ax,cs
	mov	ds,ax
	mov	ax,40h
	mov	es,ax			; BIOS data area

	in	al,060h			; get now LX key code
	jmp	short $+2
	out	060h,al
	jmp	short $+2

	mov	ah,es:[017h]		; SHFLGS
	and	ah,0Ch			; ALT+Ctrl press?
	cmp	ah,0Ch
	je	key_hook_hs
	jmp	key_hook_nohs		; no ALT+Ctrl press!
key_hook_hs:

	cmp	al,053h			; Del?
	jnz	key_hook_norst		; no!
	call	compower_off		; COM power off before ALT+Ctrl+Del
	call	rst_com			; reset COM port and INTR
	jmp	short key_hook_nohs

key_hook_norst:
	cmp	al,080h+033h		; ',' break?
	jnz	key_hook_noplusb	; no!
	cmp	ntk_mod, ena_ntk	; already enabled?
	je	key_hook_rstkey		; yes!
	mov	ntk_mod, ena_ntk	; enable this driver.
	mov	beepcnt, 1		; beep start.
	jmp	short key_hook_rstkey

key_hook_noplusb:
	cmp	al,033h			; ',' make?
	jnz	key_hook_noplus		; no!
	jmp	short key_hook_rstkey

key_hook_noplus:
	cmp	al,080h+034h		; '.' break?
	jnz	key_hook_nominusb	; no!
	cmp	ntk_mod, dis_ntk	; already disabled?
	je	key_hook_rstkey		; yes!
	mov	ntk_mod, dis_ntk	; disable this driver.
	call	compower_off		; COM power off
	call	rst_com			; reset COM port and INTR
	mov	beepcnt, 1		; beep start.

	push	bx
	xor	ax,ax
	mov	es,ax		; ES=0000h
	mov	bx,(SER_IRQ+8)*4 ; make INT vector offset.

	mov	ax,now_last_ARENA	; set search target ARENA segment.
	call	scan_ar		; scan ARENA structure segment.
	cmp	ax,now_last_ARENA	; same memory environment?
	jne	key_hook_orgrestore	; no!

	mov	ax,com_reh_off	; restore last re-hooked com1 vector offset.
	mov	es:[bx],ax
	mov	ax,com_reh_seg	; restore last re-hooked com1 vector segment.
	mov	es:[bx+2],ax
	jmp	short key_hook_restoreend

key_hook_orgrestore:
	mov	ax,com_org_off	; restore original com1 vector offset.
	mov	es:[bx],ax
	mov	ax,com_org_seg	; restore original com1 vector segment.
	mov	es:[bx+2],ax

key_hook_restoreend:
	pop	bx
	jmp	short key_hook_rstkey

key_hook_nominusb:
	cmp	al,034h			; '.' make?
	jnz	key_hook_nohs		; no!
	jmp	short key_hook_rstkey

key_hook_rstkey:
	in	al,060h
	jmp	short $+2
	mov	al,000h			; reset scan code.
	out	060h,al
	jmp	short $+2
	jmp	short key_hook_nohs

key_hook_nohs:
	pop	ax
	pop	es
	pop	ds

	popf

	jmp	dword ptr cs:ki_org_off
key_hook	ENDP

;------	COM IRQ hook.

	EVEN
com_hook	proc	near
	push	ax
	push	dx
	push	ds

	mov	ax,cs
	mov	ds,ax

	mov	dx,SER_PORT+SER_II_REG
	in	al,dx		; get Interrupt Identification
	jmp	short $+2
	and	al,SER_II_REG_MASK
	cmp	al,SER_II_REG_RDA ; data received ?
	je	com_hook_get	; yes!
	cmp	al,SER_II_REG_RLS ; line status change ?
	je	com_hook_line	; yes!

	mov	dx,SER_PORT+SER_MS_REG
	in	al,dx		; reset modem status
	jmp	short $+2
	mov	dx,SER_PORT+SER_LS_REG
	in	al,dx		; reset Line Status
	jmp	short com_hook_err_end

com_hook_line:
	mov	dx,SER_PORT+SER_LS_REG
	in	al,dx		; get Line Status
	jmp	short $+2
	test	al,00011110b	; something error?
	jz	com_hook_end	; no!

com_hook_err_end:
	call	resetLXkey
	jmp	short com_hook_end

com_hook_get:
	mov	dx,SER_PORT+SER_DT_REG
	in	al,dx		; get received data

	cmp	byte ptr comskip, 0 ; disable now?
	jne	com_hook_end	; yes!

	call	cnvset_nk2lx	; convert NK keycode to LX keycode.
	mov	potrstc,rsttim	; set port reinit timer.

com_hook_end:
	mov	al,20h
	out	20h,al		; EOI
	jmp	short $+2

	pop	ds
	pop	dx
	pop	ax
	iret
com_hook	endp

;------	INT 1C hook.

	EVEN
tim_hook	proc near
	pushf
	cli

	mov	cs:org_sp,sp
	mov	cs:org_ss,ss
	mov	sp,offset my_stack
	mov	ss,cs:my_cs

	push	ax
	push	ds

	mov	ax,cs
	mov	ds,ax

	call	beepint		; beep on/off/stop

	cmp	ntk_mod, dis_ntk ; already disabled this driver?
	jne	tim_hook_enable
	jmp	tim_hook_disable ; yes! disabled!
tim_hook_enable:

	call	gen_mkbkrep	; generate make/break keycode by int 1Ch
	jz	tim_hook_mbe	; not generated
	call	gen_mkbkkey	; if has more valid keycode then generate one.
	jz	tim_hook_mbe	; not generated
	call	gen_mkbkkey	; if has more valid keycode then generate one.
tim_hook_mbe:

	push	es
	push	bx
	xor	ax,ax
	mov	es,ax		; ES=0000h
	mov	bx,(SER_IRQ+8)*4 ; make INT vector offset.

	mov	ax,offset com_hook
	cmp	es:[bx],ax	; anyone re-hooked?
	jne	tim_hook_arh	; yes!
	mov	ax,cs
	cmp	es:[bx+2],ax	; anyone re-hooked?
	je	tim_hook_noarh	; no!

tim_hook_arh:
	mov	ax,es:[bx]
	mov	com_reh_off,ax	; save last re-hooked com1 vector offset.
	mov	ax,es:[bx+2]
	mov	com_reh_seg,ax	; save last re-hooked com1 vector segment.

	mov	ax,offset com_hook
	mov	es:[bx],ax	; force reset vector(Ha,Ha!)
	mov	ax,cs
	mov	es:[bx+2],ax

	mov	ax,0
	call	scan_ar		; get now tail ARENA structure segment.
	mov	now_last_ARENA,ax

;;;	mov	beepcnt, 3	; beep start.

tim_hook_noarh:
	pop	bx
	pop	es

	push	dx
	mov	dx,SER_PORT+SER_LC_REG
	in	al,dx
	jmp	short $+2
	and	al,(not SER_LC_DLAB)	; DLAB clear
	out	dx,al
	jmp	short $+2

	mov	dx,SER_PORT+SER_IE_REG
	in	al,dx
	jmp	short $+2
	cmp	al,00000101B	; enable receive intr and receiver line status
	jne	tim_hook_touched

	in	al,22h
	jmp	short $+2
	push	ax		; save index
	mov	al,51h		; select GPIO[7-0]
	out	22h,al
	jmp	short $+2
	in	al,23h		; get GPIO[7-0]
	jmp	short $+2
	mov	dl,al		; save GPIO[7-0]
	pop	ax
	out	22h,al		; restore index
	jmp	short $+2

	test	dl,00100000b	; now PON?
	jz	tim_hook_touched ; no! anyone clear PON bit!
	test	dl,00000001b	; now IRON3==1?
	jnz	tim_hook_touched ; yes! anyone set IRON3 bit!

	dec	potrstc		; count down
	jnz	tim_hook_02	; not reset yet!
	jmp	short tim_hook_reset

tim_hook_touched:
	call	resetLXkey

tim_hook_reset:
	mov	potrstc,rsttim	; reset timer and do reset port!
	call	compower_on	; COM power on
	call	init_com	; re-initialize!

tim_hook_02:
	pop	dx

	cmp	byte ptr comskip, 0 ; disable now?
	je	tim_hook_03	; no!
	dec	comskip
;;;	jne	tim_hook_03
;;;	mov	beepcnt, 3	; beep start.(DEBUG)
tim_hook_03:

tim_hook_disable:
	pop	ds
	pop	ax

	mov	sp,cs:org_sp
	mov	ss,cs:org_ss

	popf
	jmp	dword ptr cs:tt_org_off
tim_hook	endp
;
;---	*** CAUTION: in the following codes are purged after resident.
;
; Hook vectors
;
; IN:	none.
; OUT:	none.
;
	EVEN
vecthook	proc near
	pushf
	cli

	push	ax
	push	bx
	push	es

	mov	ax,0000h
	mov	es,ax

	mov	bx,ki_hook_vec * 4

	mov	ax,es:[bx]		; original vector offset value
	mov	ki_org_off,ax
	mov	ax,es:[bx+2]		; original vector segment value
	mov	ki_org_seg,ax

	mov	ax,offset key_hook
	mov	es:[bx],ax
	mov	ax,cs
	mov	es:[bx+2],ax

	mov	bx,tt_hook_vec * 4

	mov	ax,es:[bx]		; original vector offset value
	mov	tt_org_off,ax
	mov	ax,es:[bx+2]		; original vector segment value
	mov	tt_org_seg,ax

	mov	ax,offset tim_hook
	mov	es:[bx],ax
	mov	ax,cs
	mov	es:[bx+2],ax

	mov	bx,(SER_IRQ+8)*4	; make INT vector offset.

	mov	ax,es:[bx]
	mov	com_org_off,ax
	mov	com_reh_off,ax
	mov	ax,es:[bx+2]
	mov	com_org_seg,ax
	mov	com_reh_seg,ax

;;;	mov	ax,offset com_hook
;;;	mov	es:[bx],ax
;;;	mov	ax,cs
;;;	mov	es:[bx+2],ax

	pop	es
	pop	bx
	pop	ax

	popf

	ret
vecthook	endp
;
; Unhook vectors
;
; IN:	none.
; OUT:	AX	resident program segment
;
	EVEN
vectunhook	proc	near
	push	es
	push	ds
	push	bx

	xor	ax,ax
	mov	es,ax			; INT9 vector segment

	mov	bx,ki_hook_vec * 4	; INT9 vector offset
	mov	ax,es:[bx+2]		; get resident program segment.
	mov	ds,ax

	pushf
	cli

	mov	bx,ki_hook_vec * 4

	mov	ax,ki_org_off		; use resident program segment.
	mov	es:[bx],ax
	mov	ax,ki_org_seg		; use resident program segment.
	mov	es:[bx+2],ax

	mov	bx,tt_hook_vec * 4

	mov	ax,tt_org_off		; use resident program segment.
	mov	es:[bx],ax
	mov	ax,tt_org_seg		; use resident program segment.
	mov	es:[bx+2],ax

	mov	bx,(SER_IRQ+8)*4	; make INT vector offset.

	mov	ax,com_org_off		; use resident program segment.
	mov	es:[bx],ax
	mov	ax,com_org_seg		; use resident program segment.
	mov	es:[bx+2],ax

	popf

	mov	ax,ds			; save resident program segment.

	pop	bx
	pop	ds
	pop	es
	ret
vectunhook	endp
;
; Check command arguments 
;
; IN:	none.
; OUT:	If I have '-r' then CF=1 else CF=0
;
	EVEN
ccmdarg	proc	near
	push	ax
	push	bx
	push	cx
	xor	cx,cx
	mov	bx,0080h		; command line argument byte count
	mov	cl,[bx]

ccmdarg_01:
	jcxz	ccmdarg_02	; I want to jump to ccmdarg_noarg.
	inc	bx
	mov	al,[bx]
	dec	cx

	cmp	al,' '			; skip delimiter(SPACE)
	je	ccmdarg_01
	cmp	al,08h			; skip delimiter(TAB)
	je	ccmdarg_01

	or	byte ptr statf, has_opt ; has some option

	cmp	al,'-'			; argument start?
	je	ccmdarg_02		; yes!
	cmp	al,'/'			; argument start?
	jne	ccmdarg_01		; no!

ccmdarg_02:
	jcxz	ccmdarg_noarg
	inc	bx
	mov	al,[bx]
	dec	cx

	cmp	al,'A'			; alphabet option?
	jb	ccmdarg_noalph		; no!
	or	al, 00100000b		; A-Z -> a-z
ccmdarg_noalph:

	cmp	al,'c'			; swap caps & ctrl?
	jne	ccmdarg_noc		; no!
	or	byte ptr optionf, swap_cc ; set swap caps & ctrl flag
	jmp	short ccmdarg_02

ccmdarg_noc:
	cmp	al,'a'			; swap Right & Up?
	jne	ccmdarg_noa		; no!
	or	byte ptr optionf, swap_ar ; set swap Right & Up flag
	jmp	short ccmdarg_02

ccmdarg_noa:
	cmp	al,'k'			; make invert T cursor keys?
	jne	ccmdarg_nok		; no!
	or	byte ptr optionf, invt_ck ; set invert T cursor keys
	jmp	short ccmdarg_02

ccmdarg_nok:
	cmp	al,'t'			; make invert T cursor keys 2?
	jne	ccmdarg_nok2		; no!
	or	byte ptr optionf, invt_c2 ; set invert T cursor keys 2
	jmp	short ccmdarg_02

ccmdarg_nok2:
	cmp	al,'e'			; Ctrl+[ -> ESC?
	jne	ccmdarg_noces
	or	byte ptr optionf, esce_if ; set Ctrl+[ -> ESC
	jmp	short ccmdarg_02

ccmdarg_noces:
	cmp	al,'n'			; PowerBook like?
	jne	ccmdarg_nopbl
	or	byte ptr optionf, pb_like ; set PowerBook like key
	jmp	short ccmdarg_02

ccmdarg_nopbl:
	cmp	al,'1'			; x2.02 X'tal?
	jne	ccmdarg_no1		; no!
	mov	word ptr serbaud, SER_BAUD_X202
	or	byte ptr optionf, chg_clk ; change base clock.
	jmp	short ccmdarg_02

ccmdarg_no1:
	cmp	al,'2'			; x2.27 X'tal?
	jne	ccmdarg_no2		; no!
	mov	word ptr serbaud, SER_BAUD_X227
	or	byte ptr optionf, chg_clk ; change base clock.
	jmp	short ccmdarg_02

ccmdarg_no2:
	cmp	al,'r'			; TSR remove command?
	je	ccmdarg_remv		; yes!
	jmp	ccmdarg_01		; no!

ccmdarg_remv:
	stc				; I have a '-r'
	jmp	short ccmdarg_end

ccmdarg_noarg:
	test byte ptr statf,has_opt	; I has some option?
	jz ccmdarg_haveopt		; no!
	test byte ptr optionf,opt_msk	; has valid option?
	jnz ccmdarg_haveopt		; yes!
	or byte ptr optionf, help_if 	; set show help message flag

ccmdarg_haveopt:
	clc				; I have no '-r'.

ccmdarg_end:
	pop	cx
	pop	bx
	pop	ax
	ret

ccmdarg	endp
;
; Check TSR
;
; IN:	none.
; OUT:	If already resident then CF=1 else CF=0
;
	EVEN
chktsr	proc	near

	push	es
	push	ax
	push	si
	push	di

	xor	ax,ax
	mov	es,ax			; INT9 vector segment

	mov	di,ki_hook_vec * 4	; INT9 vector offset

	les	di,es:[di]		; es:di = INT9 handler address
	inc	di
	inc	di			; skip short jmp OP code
	mov	si,offset tsrmark	; ds:si = TSR mark

	cld
chktsr_next:
	cmpsb
	jne	chktsr_none
	cmp	byte ptr [si],00h	; mark end?
	je	chktsr_resident		; yes!
	jmp	short chktsr_next

chktsr_resident:
	stc				; resident now!
	jmp	short chktsr_end
chktsr_none:
	clc				; not resident yet!
chktsr_end:
	pop	di
	pop	si
	pop	ax
	pop	es
	ret
chktsr	endp
;
; Initialize when execute as a .COM command
;
; IN:	none.
; OUT:	none.
;
	EVEN
initcom	proc	near
	mov	my_cs,cs		; set my CS

	mov	ax,4DD4h		; HP type check.
	int	15h
	xchg	bl,bh
	mov	id_if,bx		; set ID(='HP')

	cmp	dh,00h			; 100LX?
	jne	initcom_no100		; no!
	mov	byte ptr type_if, '1'
	jmp	short initcom_s1m

initcom_no100:
	cmp	dh,02h			; 200LX?
	jne	initcom_s1m		; no! (What?)
	mov	byte ptr type_if,'2'
	or	byte ptr statf,hp20_if

initcom_s1m:
	mov	ah,09h
	mov	dx,offset msg
	int	21h			; show 1st message

	call	ccmdarg			; check command arguments
	jnc	initcom_noarg		; not '-r' option.
;-- Purge or not.
	call	chktsr			; check resident
	jnc	initcom_nores		; not resident yet!

;---- Purge...
	call	compower_off		; declare unuse COM
	call	rst_com			; reset COM port and INTR
	call	vectunhook		; vector unhook
	mov	es,ax			; set residented program segment.
	push	es			; save residented program segment.
	mov	es,es:[002Ch]		; set environment segment.
	mov	ah,49h
	int	21h			; purge environment segment.
	pop	es			; restore residented program segment.
	mov	ah,49h
	int	21h			; purge resident program

	mov	ah,09h
	mov	dx,offset msg_psp
	int	21h			; show 2nd message
	mov	al,00h			; return code == 00h
	jmp	short initcom_psp_end

;---- Cannot Purge...
initcom_nores:
	mov	ah,09h
	mov	dx,offset msg_nop
	int	21h			; show 2nd message
	mov	al,01h			; return code == 01h

initcom_psp_end:
	mov	ah,4Ch
	int	21h			; exit to dos

;-- Resident or not.
initcom_noarg:
	test	byte ptr optionf, help_if ; show help message?
	jz	initcom_nohelp		; no!
	mov	ah,09h
	mov	dx,offset msg_hlp
	int	21h			; show help message
	mov	ax,4C00h		; return code == 00h
	int	21h			; exit to dos

initcom_nohelp:
	call	chktsr			; check resident
	jnc	initcom_nores2		; not resident yet!

;---- Alerady residented...
	mov	ah,09h
	mov	dx,offset msg_are
	int	21h			; show 2nd message

	mov	ax,4C00h		; return code == 00h
	int	21h			; exit to dos

;---- To resident...
initcom_nores2:
	mov	ah,09h
	mov	dx,offset msg_res
	int	21h			; show 2nd message

	cmp	word ptr serbaud,SER_BAUD_X202 ; x2.02 X'tal?
	jne	initcom_nox202		; no!
	mov	ah,09h
	mov	dx,offset msg_202
	int	21h			; show x2.02 message

initcom_nox202:
	cmp	word ptr serbaud,SER_BAUD_X227 ; x2.27 X'tal?
	jne	initcom_nox227		; no!
	mov	ah,09h
	mov	dx,offset msg_227
	int	21h			; show x2.27 message

initcom_nox227:
	CALL	vecthook		; int vector hook

	cmp	ntk_mod, dis_ntk	; disable this driver?
	je	initcom_disadrv

	call	compower_on		; declare use COM
	call	init_com		; init COM port
	jmp	short initcom_enadrve

initcom_disadrv:
	call	compower_off		; declare unuse COM
	call	rst_com			; reset COM port and INTR
initcom_enadrve:

	test	byte ptr optionf, swap_cc	; swap caps & ctrl?
	jz	initcom_noscc		; no!
	mov	byte ptr NK_CapsLock, LX_Ctrl
	mov	byte ptr NK_Ctrl, LX_CapsLock
	mov	ah,09h
	mov	dx, offset msg_scc
	int	21h
initcom_noscc:

	test	byte ptr optionf, esce_if ; Ctrl+[ -> ESC ?
	jz	initcom_nescemu		; no!
	mov	ah,09h
	mov	dx, offset msg_eem
	int	21h
initcom_nescemu:

	test	byte ptr optionf, pb_like ; PowerBook like key?
	jz	initcom_npbl		; no!
	mov	nkesc_map,LX_BQ
	mov	ah,09h
	mov	dx, offset msg_pbl
	int	21h
initcom_npbl:

	test	byte ptr optionf, swap_ar	; swap Right & Up?
	jz	initcom_nosar		; no!
	mov	byte ptr nkright_map, NK_Up
	mov	byte ptr nkup_map, NK_Right
	mov	ah,09h
	mov	dx, offset msg_sar
	int	21h
	jmp	short initcom_modcue		; modify cursor key end.
initcom_nosar:

	test	byte ptr optionf, invt_ck ; make invert T cursor keys?
	jz	initcom_noick		; no!
	mov	byte ptr nkup_map, NK_Slash
	mov	byte ptr nkright_map, NK_Down
	mov	byte ptr nkdown_map, NK_Right
	mov	ah,09h
	mov	dx, offset msg_ick
	int	21h
	jmp	short initcom_modcue		; modify cursor key end.
initcom_noick:

	test	byte ptr optionf, invt_c2 ; make invert T cursor keys 2?
	jz	initcom_noic2		; no!
	mov	byte ptr nkup_map, NK_ShiftR
	mov	byte ptr nkright_map, NK_Up
	mov	byte ptr nkleft_map, NK_Right
	mov	ah,09h
	mov	dx, offset msg_ic2
	int	21h
	jmp	short initcom_modcue		; modify cursor key end.
initcom_noic2:

initcom_modcue:

	mov	ax,4801h		; set beep volume low
	int	15h

	mov	ax,offset vecthook
	add	ax,15
	shr	ax,1
	shr	ax,1
	shr	ax,1
	shr	ax,1
	mov	dx,ax
	mov	al,00h
	mov	ah,31h			; become a TSR and return to command.com
	int	21h

	EVEN
msg	DB	'Newton Keyboard support driver for '
id_if	DW	?
type_if	DB	'?'
	DB	'00LX Version '
	DB	VERSION
	DB	0Dh,0Ah
	DB	'Copyright (C) K.Adachi(GGB01541@niftyserve.or.jp) 1997',0Dh,0Ah
	DB	'Supported keyboard: X0035LL/A / Apple Computer,Inc.',0Dh,0Ah
	DB	'$'
msg_res	DB	'...Residented successfully.',0Dh,0Ah
	DB	"   To ENABLE....ALT+CTRL+','(Comma) on the HP-LX",0Dh,0Ah
	DB	"   To DISABLE...ALT+CTRL+'.'(Dot)",0Dh,0Ah,'$'
msg_are	DB	'...ERROR: ALREADY RESIDENTED.',0Dh,0Ah,'$'
msg_psp	DB	'...Residented program was removed successfully.',0Dh,0Ah,'$'
msg_nop	DB	'...ERROR: COULD NOT FIND RESIDENTED PROGRAM. REMOVE FAILED.',0Dh,0Ah,'$'
msg_202	DB	'...Identified clock speed as x2.02(32.00MHz).',0Dh,0Ah,'$'
msg_227	DB	'...Identified clock speed as x2.27(36.00MHz).',0Dh,0Ah,'$'
msg_scc	DB	'...[CapsLock] works as [CTRL] and '
	DB	'[Ctrl] works as [CAPSLOCK].',0Dh,0Ah,'$'
msg_sar	DB	'...[Right arrow] works as [UP] and '
	DB	'[Up arrow] works as [RIGHT].',0Dh,0Ah,'$'
msg_ick	DB	'...Make an inverted T-shape layout of cursor keys(K type).',0Dh,0Ah
	DB	'   [/(Slash)] works as [UP], '
	DB	'[Right arrow] works as [DOWN],',0Dh,0Ah
	DB	'   [Down arrow] works as [RIGHT] and '
	DB	'[Up arrow] works as [/(SLASH)].',0Dh,0Ah,'$'
msg_ic2	DB	'...Make an inverted T-shape layout of cursor keys(T type).',0Dh,0Ah
	DB	'   [ShiftR] works as [UP], '
	DB	'[Right arrow] works as [LEFT],',0Dh,0Ah
	DB	'   [Up arrow] works as [RIGHT] and '
	DB	'[Left arrow] works as [SHIFT R].',0Dh,0Ah,'$'
msg_eem	DB	'...Simulate [ESC] by Ctrl+[.',0Dh,0Ah,'$'
msg_pbl	DB	'...PowerBook like key-bind.',0Dh,0Ah
	DB	'   [`] works as [BACKQUOTE] and '
	DB	'only [Apple] on/off works as [ESC] on/off.',0Dh,0Ah,'$'

msg_hlp	DB	'...Usage: ntkey2lx [-1 | -2] [-cen] [-a | -k | -t]',0Dh,0Ah
	DB	'          ntkey2lx -r',0Dh,0Ah
	DB	'   -1   Identify clock speed as x2.02(32.00MHz).',0Dh,0Ah
	DB	'   -2   Identify clock speed as x2.27(36.00MHz).',0Dh,0Ah
	DB	'   -c   Swap CapsLock and Ctrl.',0Dh,0Ah
	DB	'   -e   Simulate [ESC] by Ctrl+[.',0Dh,0Ah
	DB	'   -n   PowerBook like key-bind.',0Dh,0Ah
	DB	'   -a   Swap Right arrow and Up arrow.',0Dh,0Ah
	DB	'   -k   Make an inverted T-shape layout of cursor keys([/] works as [UP]).',0Dh,0Ah
	DB	'   -t   Make an inverted T-shape layout of cursor keys([ShiftR] works as [UP]).',0Dh,0Ah
	DB	'   -r   Remove TSR driver program.',0Dh,0Ah
	DB	'$'

initcom	endp

CODE	ENDS
	END	start
