;name	WPGIF.INC	
;title	description
;
;  Copyright (C) 1987 WordPerfect Corp., All Rights Reserved
;  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
;------------------------------------------------------------
;description	equates for WPG file functions
;
;segments:
;
;revision history:
;name		date	description
;Bill Johnson	09Dec90	Merged DR and WP versions. (not code change)
;Alan Landes	07Nov90	Added n_eps2 record
;BrianS		22May90	Updated ps_data record
;Bill Johnson	30Mar90	added start2 subtype 3, removed subtype 2
;Perin		02Sep89	added ?wmirrx,?wmirry	
;Brian Salmond	31Aug89	changed comments on fill equates to 
;			be the same as draw
;			NOT A CODE CHANGE
;Brian Salmond	11Jul89	updated start_wpg2 record to stay
;		       	compatible with  WP 5.0
;Perin		03Jul89	added start_wpg2 and this header
;??		??     	creation

;Graphical Image Format (GIF) Specification


;Comments:
;  A graphic image is represented as an ordered sequence of drawing objects
;their associated attributes.  Each drawing object (line, polygon, 
;bitmap, etc.) has a specific record type, and data that describes the 
;position and size of the object.  Separate record types are provided for
;setting or changing attributes for the various objects (line styles, fill
;patterns, line colors, etc.)  The data associated with each record type may
;be fixed or variable length.  If it is fixed length, an equate with a
;"fx" prefix is provided that defines the length (in bytes) of the data
;record.
;
;  Each data record in the file is preceded by a 2 byte header indicating
;the record type.  Traversing the image file therefore involves getting the
;next 2 byte header, processing the fixed or variable length information
;associated with that record type, getting the next 2 byte header, etc.
;
;  When images conforming to the Graph Image Format are stored in a file
;with the same format, a standard WP file prefix header (version #'s, etc.)
;would precede the image data.
;
;  XY coordinates are stored in wpu's (1200's of an inch) and are relative
;to the image origin (lower left corner).  Information about the width and
;height of the image are communicate via the first record in the GIF data.
;
;  Color indices from 0 to 255 are supported, with a the index being an
;offset into the current color map, which would contain RGB densities for
;each color index.  Facilities would be provided for importing a color map
;(palette), and for setting and inquiring about the color palette in use.
;
;  Angles (for arcs, text baseline, etc.) are assumed to be stored as a
;number from 0 to 32K-1, where 0 = 0 degrees, and 32K-2 is equal to 359
;degrees.  This allows for greater accuracy in drawing arcs on high-resolution
;devices.

;The following is a list of record types for each of the possible drawing 
;objects in a graphic image file:

fill_attr	equ	1	;Fill Attributes
line_attr	equ	2	;Line Attributes
marker_attr	equ	3	;Marker Attributes
polymarker	equ	4	;PolyMarker
line		equ	5	;Line
polyline	equ	6	;PolyLine
rectangle	equ	7	;Rectangle
polygon		equ	8	;Polygon
ellipse		equ	9	;Ellipse
gif_noop	equ	10	;gif noop
bitmap		equ	11	;Bitmap
gtext		equ	12	;Graphic Text
gtext_attr	equ	13	;Graphic Text Attributes
color_map	equ	14	;Color Map (palette)
start_gif	equ	15	;Start of GIF data
end_gif		equ	16	;End of GIF data
ps_data		equ 	17	;Postscript data follows
out_attr	equ	18	;Output Attributes (not implemented)
curve		equ	19	;Curved polyline
bitmap2		equ	20	;Bitmap type 2 (with x,y location)
start_fig	equ	21	;Start figure
start_cht	equ	22	;Start chart
ppdata		equ	23	;PlanPerfect data
gtext2		equ	24	;Graphics Text type 2 (WP window editor)
start_wpg2	equ	25	;Start of WPG data (type 2)
gtext3		equ 	26	;Graphics Text: type 3 (ASCII screen text)
ps_data2	equ	27	;Postscript data (type 2)
lastgif		equ	27	;Make this equal to the last WPG record type.


;Each of the data records is described below, with equates to provide
;access to the data.  All sizes are listed in bytes
;===========================================================================
; fill_attr	equ 1		;Fill Attributes
fl_pat		equ 0		;(byte) Fill patterns (0..255)
				;0 = hollow
				;1 = solid	
				;2 = narrow spaced +45 degree lines
				;3 = medium spaced +45 degree lines
				;4 = widely spaced +45 degree lines
				;5 = narrow spaced +45 and -45 degree lines
				;6 = medium spaced +45 and -45 degree lines
				;7 = widely spaced +45 and -45 degree lines
				;8 = narrow spaced vertical lines (shaded)
				;9 = medium spaced vertical lines
				;10= widely spaced vertical lines
				;11= interspaced dots or density (least dense)
				;12= dots
				;13= dots
				;14= dots (medium density)
				;15= dots
				;16= dots
				;17= dots (most dense)
				;18= narrow spaced horizontal lines
				;19= medium spaced horizontal lines
				;20= widely spaced horizontal lines
				;21= narrow spaced vertical & horizontal lines
				;22= medium spaced vertical & horizontal lines
				;23= widely spaced vertical & horizontal lines
				;24= narrow spaced -45 degree lines
				;25= medium spaced -45 degree lines
				;26= widely spaced -45 degree lines
				;27= partial weave
				;28= weave
				;29= fine checker board 
				;30= zig zag (horizontal)
				;31= 45 degree wideline
				;32= wide checker board
				;33= fine 45 degree bricks
				;34= medium 45 degree bricks
				;35= wide 45 degree bricks
				;36= fine 45 degree bricks reversed
				;37= medium 45 degree bricks reversed
				;38= wide 45 degree bricks reversed
				;39= horizontal brick thin
				;40= horizontal brick medium
				;41= vertical brick thin
				;42= vertical brick medium
			     	;43= waves
				;44= wide vertical zig zag
				;45= medium vertical zig zag
				;46= movie pattern
				;47= skewed brick pattern
				;48= interconnected dot pattern
				;49= shadow squares horizontal
				;50= dot black vertical
				;51= vertical  slanted thick boxes
				;52= vertical cursive black
				;53= 45 degree shingle pattern
				;54= 45 degree wide black arrows
				;55= horizontal "T" lines
				;56= black box 45 degree dots
				;57= corner piece pattern
				;58= 45 degree triangles and dot lines
				;59= horizontal heartbeat monitor pattern
				;60= vertical lines/horizontal waves
				;61= light and dark wave patterns
				;62= 45 degree white umbrella pattern
				;63= 45 degree black umbrella pattern
				;255 = use background color for solid fill
fl_color	equ fl_pat+1	;(byte) fill color (0..255)
fx_fill		equ fl_color+1	;fixed length of fill_attr record
;===========================================================================
;line_attr	equ 2		;Line Attributes
ln_style	equ 0		;(byte) Line style (0..7)
				;0 = no line
				;1 = solid
				;2 = long dash
				;3 = dotted
				;4 = dash/dot
				;5 = medium dash
				;6 = dash/dot/dot
				;7 = short dash
				;8 = dash/dot/dash
				;9 = longer dash
				;10 = short dots
				;11 = short dots (large spread)
				;12 = medium dashes (large spread)
				;13 = medium/short/medium
				;14 = long/short/long
				;15 = dash/short dot/dash
ln_color	equ ln_style+1	;(byte) Line color (0..255)
ln_width	equ ln_color+1	;(word) Line width (wpu)
				;width defined as the "diameter" of the line,
				;with half of the line width on each side of
				;the center of the line
fx_lnattr	equ ln_width+2	;fixed length of line_attr record
;===========================================================================
;marker_attr	equ 3		;Marker Attributes
mk_style	equ 0		;(byte) Marker style (0..9)
				;0 = no markers
				;1 = dot
				;2 = +
				;3 = *
				;4 = circle
				;5 = square
				;6 = triangle
				;7 = upside-down triangle
				;8= diamond
				;9= X
				;Note:  High bit of mk_style set if marker
				;should be filled
mk_color	equ mk_style+1	;(byte) Marker color (0..255)
mk_size		equ mk_color+1	;(word) Marker size (wpu)
				;size is defined as height of the marker in wpu
				;marker is centered around the coordinates
fx_marker	equ mk_size+2	;fixed length of marker attribute record
;===========================================================================
;polymarker	equ 4		;PolyMarker -- uses current marker attributes
num_mks		equ 0		;(word) Number of points that follow
pmark_xy	equ num_mks+2	;beginning of list of marker points:
				;	dw	X coordinate (wpu)
				;	dw	Y coordinate (wpu)
;===========================================================================
;single line	equ 5		;Line -- uses current line attributes only
line_xy		equ 0		; endpoints for line
line_x1		equ 0		; (word) X1 coordinate
line_y1		equ line_x1+2	; (word) Y1 coordinate
line_x2		equ line_y1+2	; (word) X2 coordinate
line_y2		equ line_x2+2	; (word) Y2 coordinate
fx_line		equ line_y2+2	; fixed length of line record
;===========================================================================
;polyline	equ 6		;PolyLine -- uses current line attributes
num_pts		equ 0		;(word) Number of points that follow
pline_xy	equ num_pts+2	;beginning of list of points on line:
				;	dw	X coordinate (wpu)
				;	dw	Y coordinate (wpu)
;===========================================================================
;rectangle	equ 7		;Rectangle -- uses current line and fill
				;  attributes
rect_ax		equ 0		;(word) X coordinate, lower left of rectangle
rect_ay		equ rect_ax+2	;(word) Y coordinate, lower left
rect_wid	equ rect_ay+2	;(word) width of rectangle
rect_high	equ rect_wid+2	;(word) height of rectangle
fx_rect		equ rect_high+2	;fixed length of rectangle record
;===========================================================================
;polygon	equ 8		;Polygon -- uses current line and fill
				;  attributes
num_vrts	equ 0		;(word) Number of vertices that follow
vert_xy		equ num_vrts+2	;beginning of list of points on polygon:
				;	dw	X coordinate (wpu)
				;	dw	Y coordinate (wpu)
;===========================================================================
;ellipse	equ 9		;Ellipse -- uses current line & fill attributes
el_cen_x	equ 0		;(word) center x
el_cen_y	equ el_cen_x+2	;(word) center y
el_major	equ el_cen_y+2	;(word) x axis radius
el_minor	equ el_major+2	;(word) y axis radius
el_rot_ang	equ el_minor+2	;(word) rotation angle (horizontal)
el_beg_ang	equ el_rot_ang+2;(word) beginning angle
el_end_ang	equ el_beg_ang+2;(word) ending angle
el_flags	equ el_end_ang+2;(word) flags bit 0 = draw ends to center
				;	      bit 1 = draw ends to each other
flg_pie		equ	1	; connect ends to center
flg_chord	equ	2	; connect ends to each other
fx_ellipse	equ el_flags+2	; fixed length of ellipse record
;===========================================================================
;gif_noop	equ 10		;noop - record is skipped, if encountered
;===========================================================================
;bitmap		equ 11		;Bitmap (Pixel Array)
bit_wide	equ 0		;(word) Width - pixels wide as defined at
				;   source
bit_high	equ bit_wide+2	;(word) Height -pixels high as defined at 
				;   source
bit_deep	equ bit_high+2	;(word) Number of color bits per pixel
				;Must be one of the following:
				;	1 = mapped pixel array
				;	8 = byte pixel array
bit_resw	equ bit_deep+2	;(word) resolution of bitmap as created
				;   - pixels/inch across
bit_resh	equ bit_resw+2	;(word) resolution of bitmap as created
				;   - pixels/inch up & down
bit_data	equ bit_resh+2	;start of compressed bitmap data (Format below)
				;# bytes =   [width x height x deep]/8
;Compress Scheme: Bit 7 bits 6-0 | Next Byte(s) |    Meaning:
;		   1   count	 |  Data	| for count(1-7F); dup data
;		   0   count	 |  Data...	| Dump of data for count(1-7F)
;		   1     0	 |  count	| for count: dup FF's (1-FF)
;		   0     0       |  count	| for count(1-FF) dup last line
;===========================================================================
;gtext		equ 12		;Graphic Text -- uses Graphic Text attributes
gtxt_len	equ 0		;(word) length (in bytes) of text
gtxt_x		equ gtxt_len+2	;(word) X coordinate for positioning text (wpu)
gtxt_y		equ gtxt_x+2	;(word) Y coordinate for positioning text (wpu)
gtxt_str	equ gtxt_y+2	;start of ASCII string for graphic text
;===========================================================================
;gtext_attr	equ 13		;Graphic Text Attributes 
gt_width	equ 0		;(word) nominal char cell width (wpu)
				; a number here indicates a fixed pitch font
				; if -1 then, it is a proportional font
gt_height	equ gt_width+2	;(word) character cell height (wpu)
gt_caps		equ gt_height+2	;(word) caps height (wpu)
gt_x		equ gt_caps+2	;(word) x height (wpu)
gt_adj		equ gt_x+2	;(word) adjust factor
gt_attr		equ gt_adj+2	;(word) text attributes (underline,...like WP)
				;(byte) --- available ---
gt_wtsl		equ gt_attr+3	;(byte) weight and slant (each is -7 to +7)
				;       weight in hi-order nibble
				;	slant in lo-order nibble
gt_flags	equ gt_wtsl+1	;(word) font descriptor flags (see DRSBMD.INC)
  agt_cour	equ	0D50h	;courier font
  agt_helv	equ	1150h	;helvetica font
  agt_time	equ	1950h	;times roman font
gt_char		equ gt_flags+2	;(byte) character set # (not used at this now
gt_halign	equ gt_char+1	;(byte) horizontal alignment
  agt_left	equ	0	;0 = left
  agt_center	equ	1	;1 = center
  agt_right	equ	2	;2 = right
gt_base		equ gt_halign+1	;(byte) base alignment
  agt_base	equ	0	;0 = base align
  agt_x		equ	1	;1 = x (half) align
  agt_cap	equ	2	;2 = cap align
  agt_bottom	equ	3	;3 = bottom align
  agt_top	equ	4	;4 = top align
gt_color	equ gt_base+1	;(byte) color for graphic text
gt_rot		equ gt_color+1	;(word) rotation angle for baseline of text
fx_gtattr	equ gt_rot+2	;fixed length of graphics text attribute record
;===========================================================================
;color_map	equ 14		;Color Map (palette) -- variable length
cm_idx		equ 0		;(word) starting color #
cm_len		equ 0		;(word) length (replaced by idx above)
cm_num		equ cm_len+2	;(word) Number of entries in color map
cm_rgb		equ cm_num+2	;start of RGB density data in color map:
				;Each entry consists of 3 bytes as follows:
				;    db   Red
				;    db   Green
				;    db   Blue
;===========================================================================
;start_gif	equ 15		;Start of GIF data, data header record (6 bytes)
sg_majver	equ 0		;(byte) major version #, GIF data format
sg_wpflgs	equ sg_majver+1	;(byte) wpg flags bit 0 = Postscript follows
 sg_psb		equ 0001b	;  postscript flag (includes bitmap data)
 sg_psnb	equ 0010b	;  postscript flag (no bitmap data)
sg_wide		equ sg_wpflgs+1	;(word) width of image (wpu)
sg_high		equ sg_wide+2	;(word) height of image (wpu)
fx_start	equ sg_high+2	;fixed length of start record
;===========================================================================
;end_gif	equ 16		;End of GIF data marker, no associated data
;===========================================================================
;ps_data	equ 17		;Postscript data follows
eps_llx		equ 0		;(word) bounding box LLx in points
eps_lly		equ eps_llx+2	;(word) bounding box LLy in points
eps_urx		equ eps_lly+2	;(word) bounding box URx in points
eps_ury		equ eps_urx+2	;(word) bounding box URy in points
eps_data	equ eps_ury+2	;Postscript data follows
;===========================================================================
;out_attr	equ 18		;Output Attributes (not implemented)
;===========================================================================
;curve		equ 19		;Curve -- uses current line attributes
wpg_siz		equ 0		;(dword) Size of equivalent WPG data
num_cpts	equ wpg_siz+4	;(word) Number of points/CP that follow
cur_xy		equ num_cpts+2	;beginning of list of points on curve
				;	dw	X coordinate (wpu)
				;	dw	Y coordinate (wpu)
				;	dw	control point (X)
				;	dw	control point (Y)
				;  ... continued
;Wpg data when saved in wp5.0 compatible mode
;===========================================================================
?wangle		equ 0fffh	;angle bits of rotation
?wswap		equ 40h		;swap the bits flag
?wmirrx		equ 80h		;mirroring flag (in x)
?wmirry		equ 20h		;mirroring flag (in y)

;bitmap2	equ 20		;Bitmap: type 2 (with x1,y1,x2,y2 location)
bit2_rot	equ 0		;(word) Bitmap rotation angle (0-360deg)
				;bit 15 set means mirror in x
				;bit 13 set means mirror in y

bit2_x1		equ bit2_rot+2	;(word) Lower left x location of start of bit-
				; - map in WPU's, relative to start GIF record
bit2_y1		equ bit2_x1+2	;(word) Lower left y location (in WPU's)

bit2_x2		equ bit2_y1+2	;(word) Upper right x location 

bit2_y2		equ bit2_x2+2	;(word) Upper right y location (in WPU's)

bit2_wide	equ bit2_y2+2	;(word) Width - pixels wide as defined at
				;   source
bit2_high	equ bit2_wide+2	;(word) Height -pixels high as defined at 
				;   source
bit2_deep	equ bit2_high+2	;(word) Number of color bits per pixel
				;Must be one of the following:
				;	1 = mapped pixel array
				;	8 = byte pixel array
bit2_resw	equ bit2_deep+2	;(word) resolution of bitmap as created
				;   - pixels/inch across
bit2_resh	equ bit2_resw+2	;(word) resolution of bitmap as created
				;   - pixels/inch up & down
bit2_data	equ bit2_resh+2	;start of compressed bitmap data (Format below)
				;# bytes =   [width x height x deep]/8
				;Compress Scheme: same as type 1 bitmaps
;===========================================================================
;start_fig	equ 21		;Start figure
so_len		equ 0		;(dword) pointer to end of figure
so_rot		equ so_len+4	;(word)	rotation angle
so_x1		equ so_rot+2	;(word) X1 coordinate of object
so_y1		equ so_x1+2	;(word) Y1 coordinate of object
so_x2		equ so_y1+2	;(word) X2
so_y2		equ so_x2+2	;(word) Y2
so_strt		equ so_y2+2	;start of figure data (more GIF commands)
;===========================================================================
;start_cht	equ 22		;Start chart
so_len		equ 0		;(dword) pointer to end of figure
so_rot		equ so_len+4	;(word)	rotation angle
so_x1		equ so_rot+2	;(word) X1 coordinate of object
so_y1		equ so_x1+2	;(word) Y1 coordinate of object
so_x2		equ so_y1+2	;(word) X2
so_y2		equ so_x2+2	;(word) Y2
so_strt		equ so_y2+2	;start of chart data (more GIF commands)
;===========================================================================
;ppdata		equ 23		;PlanPerfect data
;(see mpdat2.asm)
;===========================================================================
;gtext2		equ 24		;Graphics Text: type 2 (WP window editor)
wpg_size	equ 0		;(dword) Size of equivalent WPG data
gtxt2_rot	equ wpg_size+4	;(word) baseline rotation angle
				;bit 15 set means mirror in x
				;bit 13 set means mirror in y
gtxt2_len	equ gtxt2_rot+2	;(word) length (in bytes) of text
gtxt2_x1	equ gtxt2_len+2	;(word) X1 coordinate for text (wpu)
gtxt2_y1	equ gtxt2_x1+2	;(word) Y1 coordinate for text (wpu)
gtxt2_x2	equ gtxt2_y1+2	;(word) X2
gtxt2_y2	equ gtxt2_x2+2	;(word) Y2
gtxt2_sx	equ gtxt2_y2+2	;(word) x scale factor (WPU) 100% = pt. size
gtxt2_sy	equ gtxt2_sx+2	;(word) y scale factor (WPU)
gtxt2_typ	equ gtxt2_sy+2	;(byte) text subtype (0-15)
	win_txt	equ	0	;window type
	lin_txt	equ	1	;single line type
	blt_txt	equ	2	;bullet text chart
	smp_txt	equ	3	;simple text chart
	ffm_txt	equ	4	;free-format text chart
gtxt2_str	equ gtxt2_typ+1	;start of formatted string for graphic text
;Wpg data when saved in wp5.0 compatible mode
;===========================================================================
;start_wpg2	equ 25		;Start of GIF data, data header record (6 bytes)
;    The start_wpg2 record consists of a series of subtype data records.
;    All records have an id byte and a length word.  The data follows these 3
;    bytes.
st_subid	equ 0		;(byte) offset of subtype id 
st_sublen	equ st_subid+1	;(word) offset of subtype length
st_subdat	equ st_sublen+2	;offset of start of subtype data
				;Subtypes:
st_pgcol	equ 0		;page colors subtype
stcbac		equ 0		;   (byte) page background color
stcfor		equ stcbac+1	;   (byte) page foreground color
stcend		equ stcfor+1	;end of page colors subtype data
ln_pgcol	equ stcend	;length of page color data
				;
;The following subtype is no longer used. The information is retained to allow
;the record to be processed when reading in a WPG file. At that time, however,
;it is converted to (a) newer subtype(s).
st_form		equ 1		;form information subtype
stfshdc		equ 0		;   (word) shade colors
stfshi		equ stfshdc+2	;   (byte) shade intensity
stftbs		equ stfshi+1	;   (byte) top to bottom shading flag
stfmar		equ stftbs+1	;   (4 words) margins (m_lf, m_rt, m_tp, m_bt)
stfbrds		equ stfmar+8	;   (word) border style
stfwdo		equ stfbrds+2	;   (byte) initial drawing options
stfgrx		equ stfwdo+1	;   (word) grid x size in wpu
stfgry		equ stfgrx+2	;   (word) grid y size in wpu
stfgrstp 	equ stfgry+2	;   (byte) grid display step size
stfobj		equ stfgrstp+1	;   (word)
stfchrt		equ stfobj+2	;   (word) bar chart
stflsty		equ stfchrt+2	;   (byte)
stflcol		equ stflsty+1	;   (byte)
stflwid		equ stflcol+1	;   (word)
stffpat		equ stflwid+2	;   (byte)
stffcol		equ stffpat+1	;   (byte)
stfsawid	equ stffcol+1	;   (word) arrow width
stfdspf		equ stfsawid+2	;   (byte) display flag
stfview		equ stfdspf+1	;   (byte) current view mode and preview flags for print preview
stfflne		equ stfview+1	;   (word) effective form length (1200ths) letter size default
stffwde		equ stfflne+2	;   (word) effective form width (1200ths) 8 1/2 inches
stfftye		equ stffwde+2	;   (byte) effective form type (1=blank)
stffnl		equ stfftye+1	;   (byte) effective form name length
stfnam		equ stffnl+1	;   (41 bytes) effective form name (40 max, null terminated)
stffore		equ stfnam+41	;   (byte) effective form orientation (0=portrait,1=landscape)
stfcop 		equ stffore+1	;   (word) number of copies
stfswid  	equ stfcop+2	;   (word) binding width
stfnnm  	equ stfswid+2	;   (byte) network - form number to use (1-31)
stfban  	equ stfnnm+1	;   (byte) network banners printed? (no)
stfdocfgs 	equ stfban+1	;   (byte) document flags
stfend		equ stfdocfgs+1	;end of form subtype data
ln_form		equ stfend	;length of form subtype data

st_pag		equ 2		;page information subtype
stptopclr	equ 0		;   (byte) shade colors
stpshi		equ stptopclr+1	;   (byte) shade intensity
stptbs		equ stpshi+1	;   (byte) top to bottom shading flag
stpmar		equ stptbs+1	;   (4 words) margins (m_lf, m_rt, m_tp, m_bt)
stpbrds		equ stpmar+8	;   (word) border style
stpflne		equ stpbrds+2	;   (word) effective form length (1200ths) letter size default
stpfwde		equ stpflne+2	;   (word) effective form width (1200ths) 8 1/2 inches
stpftye		equ stpfwde+2	;   (byte) effective form type (1=blank)
stpfnl		equ stpftye+1	;   (byte) effective form name length
stpnam		equ stpfnl+1	;   (41 bytes) effective form name (40 max, null terminated)
stpfore		equ stpnam+41	;   (byte) effective form orientation (0=portrait,1=landscape)
stpend		equ stpfore+1	;end of form subtype data
ln_pag		equ stpend	;length of form subtype data

st_shd		equ 3		;page shading information subtype
ststopclr	equ 0		;   (byte) shade colors
stsshi		equ ststopclr+1	;   (byte) shade intensity
ststbs		equ stsshi+1	;   (byte) top to bottom shading flag
stsend		equ ststbs+1	;end of shading subtype
ln_shd		equ stsend	;length of form subtype data

st_grid		equ 4		;grid information subtype
stgwdo		equ 0		;   (byte) options: ?grid and ?snap (see drwnd.inc)
stggrx		equ stgwdo+1	;   (word) grid x size in wpu
stggry		equ stggrx+2	;   (word) grid y size in wpu
stggrstp 	equ stggry+2	;   (byte) grid display step size
stgend		equ stggrstp+1	;end of grid subtype data
ln_grid		equ stgend	;length of grid subtype data


;===========================================================================
;gtext3		equ 26		;Graphics Text: type 3 (ASCII screen text)
gtxt3_str	equ 0		;start of data string for bitmapped text
				; This record typically contains an 80x25
				; ASCII screen grab from the shell. The
				; image only appears in DrawPerfect
				; presentations. Some control characters
				; are meaningful within this WPG record.
			; Character	Decimal		Action
			; ^R		18		Reverse video on
			; ^S		19		Reverse video off
			; ^T		20		Underline on
			; ^U		21		Underline off
			; ^]		29		Bold on
			; ^\		28		Bold off
			; ^^		30,n		Background color n on 
			; ^_		31,n		Foreground color n on
			;	where n is a letter from A to P.
			;	A means color 0 (black), B means
			;	color 1 (dark blue), etc. The colors
			;	follow the default colors for the
			;	IBM EGA/VGA palettes.
;===========================================================================
;ps_data2	equ 27		;Postscript data follows
eps2_bmlen	equ 0		; (dword) length of following bitmap2 record
eps2_rot	equ eps2_bmlen+4 ;(word) image rotation angle (0-360 deg)
eps2_x1		equ eps2_rot+2	;(word) Lower left x location (in WPU's)
eps2_y1		equ eps2_x1+2	;(word) Lower left y
eps2_x2		equ eps2_y1+2	;(word) Upper right x
eps2_y2		equ eps2_x2+2	;(word) Upper right y
eps2_fnam	equ eps2_y2+2	;(40 bytes) Original file name
eps2_bbx1	equ eps2_y2+40	;(word) Original bounding box: Lower left x
eps2_bby1	equ eps2_bbx1+2	;(word) Lower left y in WPU's
eps2_bbx2	equ eps2_bby1+2	;(word) Upper right x
eps2_bby2	equ eps2_bbx2+2	;(word) Upper right y
eps2_data	equ eps2_bby2+2	;start of EPS data
;===========================================================================
; end of gif equates
