;name	prefix
;title	definitions of file prefix data and structures
;
;  Copyright (C) 1987 WordPerfect Corp., All Rights Reserved
;  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
;------------------------------------------------------------
;
;segments:	cs = codeseg
;		ds = dataseg
;		es = 


pfwp	equ	1		;WordPerfect
pfshell	equ	2		;Shell
pfnb	equ	3		;Notebook
pfcalc	equ	4		;Calculator
pfsdir	equ	5		;File Manager (SDIR)
pfcl	equ	6		;Calendar
pfpe	equ	7		;P-Edit
pfme	equ	8		;Macro editor
pfmp	equ	9		;PlanPerfect (MathPlan)
pfdp	equ	10		;DataPerfect
pfml	equ	11		;Mail
pfpp	equ	12		;Printer Program (PTR)
pfsch	equ	13		;Scheduler Program
pfofc	equ	14		;WordPerfect Office
pfdr	equ	15		;DrawPerfect
;pflp	equ	16		;Letter Perfect
;	equ	17		;UNIX WPterm terminal resource file
;	equ	18		;UNIX GUI stuff
pfdm	equ	19		;Document Manager
;	equ	20		;Connections

;Below are the assignments for file types.

;The first 10 (0-9) are reserved for general purpose files.
;The naming convention for other file types is:  use the first 4
;characters from the product name's equate and add up to 3
;characters describing the file type.

pfmac	equ	1		;macro file
pfhelp	equ	2		;help file
pfkybd	equ	3		;keyboard definition file
pfvaxkb	equ	4		;vax specific keyboard definition file

;file types for WP
pfwpdoc	equ	10		;wordperfect document
pfwpdct	equ	11		;dictionary - wordlist
pfwpth	equ	12		;thesaurus
pfwpblk	equ	13		;block
pfwprb	equ	14		;rectangular block
pfwpclm	equ	15		;column block
pfwpprn	equ	16		;.prs file
pfwpsys	equ	17		;{wp}sys.fil
pfwpall	equ	19		;.all file
pfwpdrs	equ	20		;.drs file
pfwpfil	equ	21		;wp.fil file
pfwpgif	equ	22		;WPG graphics file
pfwphyc	equ	23		;hyphenation code module
pfwphyd	equ	24		;hyphenation data module
pfwpmrs	equ	25		;.mrs files
;	equ	26		;.wpd files (old graphics drivers, not in 5.1)
pfwphyl	equ	27		;hyphenation lex module
pfwppqc	equ	28		;printer Q codes (used by VAX/DG)
pfwpdcw	equ	29		;spell code module - wordlist
pfwpqrs	equ	30		;5.1 equation resource file (wp.qrs)
;	equ	32		;VAX .set
pfwpdca	equ	33		;spell code module - rules
pfwpdsa	equ	34		;dictionary - rules
pfwpvrs	equ	36		;.vrs files
;	equ	37		;rhymer word file
;	equ	38		;rhymer pronunciation file
pfwpdcf	equ	39		;spell code module - Microlytics rules based
pfwpdml	equ	40		;dictionary - Microlytics rules based
pfwpins	equ	41		;WP51.INS file  (install options file)
pfwpirs	equ	42		;.irs files
;	equ	43		;UNIX setup file
;	equ	44		;MAC WP 2.0 document
;	equ	45		;WP 4.2 document
pfwpspx	equ	46		;spell code module - created external to WPCORP
pfwpdsx	equ	47		;spell dictionary  - created external to WPCORP
;	equ	48		;MAC SOFT (Sequential Object FormaT) graphic files
;	equ	49		;WP 5.2 character mapping file
pfwpspf	equ	53		;spell .lex and .spf - for WP rules based
pfwpsps	equ	54		;spell .lex and .spf - for Socrates rules based

;file types for Shell
;	equ	1		;shell macro file
;	equ	2		;shell help file
pfshdef	equ	10		;shell definition file
;	equ	25		;shell .mrs file

;file types for notebook
;	equ	2		;notebook help file
pfnbsys	equ	10		;notebook system file

;file types for calendar
;	equ	2		;calendar help file
pfcldat	equ	10		;calendar data file

;file types for PlanPerfect
;	equ	1		;macro file
;	equ	2		;help file
;	equ	3		;keyboard definition file
pfmpdoc	equ	10		;planperfect worksheet
pfmpprn	equ	15		;printer definition file
pfmpsys	equ	17		;{mp}sys.fil
pfmpgdf	equ	18		;graphics definition files (.GDF)
;	equ	19		;UNIX system file for PlanPerfect
;	equ	20		;UNIX temporary print file
pfmpmrs equ	25		;.mrs macro resource file

;file types for DataPerfect
;	equ	2		;dataperfect help file

;file types for Mail
;	equ	2		;mail help file
;	equ	5		;mail distribution list
;	equ	10		;mail out box file
;	equ	11		;mail in box file
;	equ	15		;mail setup file
;	equ	16		;VAX/VMS mail setup file
;	equ	17		;mail netserver interface file
;	equ	30		;mail network status file

;file types for the printer program
pfpphlp	equ	10		;multi-screen context-sensitive help file
pfpptmp	equ	11		;temporary file.
pfppadd	equ	12		;file used to add fonts to all file

;file types for the scheduler
;	equ	2		;scheduler help file
pfschin	equ	10
pfschout equ	11
pfsorg	equ	20
pfsevnt	equ	21
pfsusr	equ	22
pfsset	equ	23

;file types for DrawPerfect
pfdrprs	equ	10		;presentation file
;File versions equates for major and minor file products/types
wpdocmjv equ	0		;WP document major version
wpdocmnv equ	1		;WP document minor version

wpmacmjv equ	1		;WP macro major version
wpmacmnv equ	1		;WP macro minor version

wp5stmjv equ	0		;5.0 set file major version
wpsetmjv equ	1		;WP set/system file major version
wpsetmnv equ	0		;WP set/system file minor version

wpvrsmjv equ	0		;.vrs file version
wpvrsmnv equ	0

wpirsmjv equ	0		;.irs file version
wpirsmnv equ	0

wpqrsmjv equ	1		;.qrs file version
wpqrsmnv equ	0

wpthsmjv equ	0		;thesarus file version
wpthsmnv equ	1

wpptrmjv equ	3		;ptr major version number
wpptrmnv equ	3		;ptr minor version number (after decimal)

wpdctmjv equ	1		;major dictionary version
wpdctmnv equ	0		;minor dictionary version

wpcodmjv equ	0		;major ver dictionary code module
wpcodmnv equ	0		;minor

wpmrsmjv equ	1		;WP .mrs file major version
wpmrsmnv equ	1		;WP .mrs file minor version (same as wpmacmnv)

wphyfmjv equ	0		;WP hyphenation major version
wphyfmnv equ	0		;WP hyphenation minor version

mpsetmjv equ	1		;PL set/system file major version
mpsetmnv equ	0		;PL set/system file minor version

mpmacmjv equ	1		;PL macro major version
mpmacmnv equ	1		;PL macro minor version

;The file prefix should be included on all WPC files.
;This is and always will be 16 BYTES long!
;
prefix	struc
pfid	db	-1,"WPC"	;file id (4 bytes)
pfleng	dd	16		;double word pointer to data
pfprod	db	pfwp		;product
pftype	db	pfwpdoc		;file type
pfmajv	db	0		;major version
pfminv	db	0		;minor version
pfcrpt	dw	0		;encryption key (0=not locked)
	dw	0		;reserved for future use
prefix	ends

;    Additional prefix information follows the 16 required bytes.  The product,
;file type, major and minor version numbers indicate what information will be
;in the additional prefix area and data area of the file.
;The data follows the additional prefix information.

;    The prefix data follows the first 16 bytes thus a prefixed document
;would be of the following format:

;   16 Byte Prefix Header.
;   The first Index Block consisting of Num_Of_Indicies (determined at
;        file creation time, indicated by caller) index structures each
;        consisting of a word type, dword length, and dword pointer to
;        it's data.  The first index of each Index Block is a pointer to
;        the next Index Block, and also indicates the number of indicies
;        per Index Block and the Index Block's size.
;   Data belonging to packets in the first Index Block.
;   [ The next Index Block.  Same format as first block. ]
;   [ Data belonging to packets in the next Index Block. ]
;   The actual document.  (Text for WP; calendar data for Calendar, etc.)

;And would appear as diagrammed:

;   Ŀ
;     ͻ
;     -1  W  P  C   Prefix Size  PrdFilMjVMnV Crypt   RFU  
;     Ķ
;     pfx_ndx# IndxsIB SizePtr To Next Blk Type   Dword Length  
;     Ķ
;      Ptr To Data1   Type   Dword Length   Ptr To Data2   . . . 
;     Ķ
;      . . .  Data1     Data1     Data1    Data1     Data2   Data2 
;     Ķ
;      Data2   Data2   Data2   Data2  . . .                         
;                                    
;     :                             Prefix                            :
;   >͹
;                                                                     
;      :                            Document                           :
;                                                                     
;      ͼ


;    The following is the structure of prefix index block indicies
pfxndx	struc
pfxtype	dw	0	;type of packet
pfxsize	dw	0	;length of packet data
	dw	0
pfxptr	dw	0	;offset in file of packet data
	dw	0
pfxndx	ends

;------ Equates for WordPerfect Documents' (& compatable) Index Blocks ------
pfibni	equ	5			;Number of indicies in Index Block
pfibsz	equ	(pfibni * type pfxndx)	;Size of index block (in bytes)
;----------------------------------------------------------------------------

;    The following is the structure of prefix Index Blocks parameter
;information control block (Index block Control Block - or ICB's)
pfxICB	struc
pfxiptr	dw	0	;ptr to user prefix Index Block buffer
pfxipsz	dw	0	;size of user prefix Index Block buffer
pfxinui	dw	0	;number of indicies per user Index Block buffer
pfxicin	dw	0	;current Index Block index number
pfxisiz	dw	0	;prefix Index Block size
pfxibin	dw	0	;number of indicies per prefix Index Block
pfxifpp	dw	0	;file position after last Index Block read
	dw	0
pfxicib	dw	0	;offset in file of start of current Index Block
	dw	0
pfxinib	dw	0	;offset in file of start of next Index Block
	dw	0
pfxICB	ends

;    The following is the structure of the new prefix routines' parameter
;information control block (Prefix routine Control Block - or PCB's)
pfxPCB	struc
pfxpoff	dw	0	;offset of buffer for packet data
pfxpseg	dw	0	;segment of buffer for packet data (0 for DATASEG)
pfxptyp	dw	0	;packet type
pfxpsiz	dw	0	;total size of info to read/write
	dw	0	;(high word of total size)
pfxplen	dw	0	;length of source/dest buffer
pfxpact	dw	0	;action to be performed (for write, find)
		;pfx_1st - Set for 1st write only!!!  (Writes packet index)
		;pfx_nxt - Force append of packet to be written, for 1st
		;           write only!!!  (Writes packet index)
pfxPCB	ends

;     Files can have additional prefix information.  This information will be
;  stored in packets.  Each packet consists of:
;             type (word), length of data (dword), data (length).

;*** Reserved type codes for use by all file types ***
pfx_end equ	00000h	;end of prefix information
pfx_del equ	0FFFFh	;marks packet for deletion
pfx_any equ	0FFFEh	;matches any packet
pfx_1st equ	0FFFDh	;find first
pfx_nxt	equ	0FFFCh	;find next (read) / force append (write)
pfx_ndx equ	0FFFBh	;next prefix index block ptr type
pfx_abs equ	0FFFAh	;search to an absolute packet number

;     Other type codes specific to particular file types will appear in their
;  own include file (??PREF.INC) using the two letter product codes.
;  E.G. types for WP 5.0 would be found in WPpref.inc
;
;     In addition, each type code will follow the nameing convention of:
;                   PFff_xxxx...
;  Where PF indicates this is a prefix code.
;        ff      = File type.
;        xxxx... = Unique identifier
;
;  E.G. An equate for WP 5.0 would look like PFWP_SUM (document summary)
