;ppsdrv.inc

;  Copyright (C) 1987 WordPerfect Corp., All Rights Reserved
;  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
;------------------------------------------------------------
;

;equates for printer def driver table

Horz	equ	0
Vert	equ	1
Bold	equ	2
Und	equ	3
DblUnd	equ	4
Redlin	equ	5
Stkout	equ	6
Italic	equ	7
	no_ital		equ	0
	und_ital	equ	1
	auto_ital	equ	2
Shadow	equ	8
Color	equ	9
Graphic	equ	10
RulBox	equ	11
outline	equ	12
subscpt	equ	13
supscpt	equ	14
dtblend	equ	15			;# of drivers; Next equate

;equates for pdef string table

   ;General questions
InitWP	equ	141		; Initialize printer: download fonts, etc.
InitPtr	equ	0		; Initialize printer: margins, perf skip, bi-direc, etc.
InitPg	equ	1		; Initialize page
ResetPg	equ	2		; Reset page/Advance to next page
ResetPtr	equ	3		; Reset printer at end of Document
AutoFF	equ	4		; Printer auto-advances to next page?
Mov2Cen	equ	7		; Move print head to center? (Shtfeed, handfed, ~continuous)
MFeedIn	equ	8		; Shift into manual feed mode
MFeedOut	equ	9		; Shift out of manual feed mode
PgLngth	equ	10		; Page (form) length code
TopBias	equ	11		; Print-head bias (top) (2's complement)
LftBias	equ	12		; Print-head bias (left) (2's complement)
RstPhO	equ	160		; Reset printhead on orientation change

SetDplx		equ	13	;Set duplex

   ;Horizontal Motion Drivers
     ;HMI
H1AutoLF	equ	21		; Auto LF on CR?
H1CR	equ	22		; Perform CR
H1SetHMI	equ	23		; Set HMI
H1MUnits	equ	24		; Maximum units
H1BS	equ	25		; Perform Backspace
H1Fwrd	equ	26		; Set forward printing
H1Bkwrd	equ	27		; Set reverse printing
     ;MSHMI
H2AutoLF	equ	28		; Auto LF on CR?
H2CR	equ	29		; Perform CR
H2SetHMI	equ	30		; Set HMI
H2MUnits	equ	31		; Maximum units
H2BS	equ	32		; Perform Backspace
H2RptHMI	equ	33		; Set HMI each character?
     ;Relative HS
H3AutoLF	equ	34		; Auto LF on CR?
H3CR	equ	35		; Perform CR
H3MUnits	equ	36		; Maximum units
H3MvRt	equ	37		; Forward microspace movement
H3MvLft	equ	38		; Reverse microspace movement
H3Attr	equ	41		; Send attribute byte
     ;Absolute 
H4MovTo	equ	42		;Move to horizontal position

   ;Vertical Motion Drivers
     ;VMI
V1LF	equ	43		;Perform line feed
V1RLF	equ	44		;Perform reverse line feed
V1MUnits	equ	45		;Maximum units
V1SetVMI	equ	46		;Set VMI
V1AutoCR	equ	47		;Auto CR on LF?
V1AutoRCR	equ	48		;Auto CR on Reverse LF?
     ;Relative VS
V2MUnits	equ	49		;Maximum units
V2MovUp	equ	50		;Move Up
V2MovDn	equ	51		;Move Down
     ;Absolute VS
V3MovTo	equ	52		;Move to position

   ;Bold drivers
     ;Auto on same pass
B1On	equ	53		;Bold On
B1Off	equ	54		;Bold Off
     ;Multiple passes
B2Passes	equ	55		;Number of passes
B2Offst	equ	56		;Initial Horizontal offset (1200ths)
B2Mov	equ	57		;Additional Horz amount to move each pass (1200ths)
     ;Triple Overstrike on same pass (true HMI only)
B3Mov	equ	58		;Horizontal shadow amount (1200ths)
     ;Double overstrike on same pass (true HMI only)
B4Mov	equ	59		;Horizontal shadow amount (1200ths)
     ;Backspace bolding
B5Ovrstks	equ	60		;Number of overstrikes

   ;Single underline
     ;Auto on same pass
U1On	equ	61		;Underline On
U1Off	equ	62		;Underline Off
     ;Auto on separate pass
U2On	equ	63		;Underline On
U2Off	equ	64		;Underline Off
U2Char	equ	65		;Character to use for movement (space or other, mapped)
U2Mov	equ	66		;Vertical movement (1200ths)
     ;WP's own on second pass
U3Char	equ	67		;Character to use for underline (mapped)
U3Mov	equ	68		;Vertical movement (1200ths)
U3Squeez	equ	69		;Adjustment between characters (1200ths)
U3LHang	equ	70		;Adjustment to Start of Underlining (1200ths)
U3RHang	equ	71		;Adjustment to End of Underlining (1200ths)
     ;Backspace underlining
U4Char	equ	72		;Char to use for underlining (mapped)
U4Ovstrks	equ	73		;Number of overstrikes

   ;Double Underline
     ;Same as single underline (driver #1)
     ;Auto on same pass
DU2On	equ	74		;Double Underline On
DU2Off	equ	75		;Double Underline Off
     ;Twin pass - auto single underline on separate passes
DU3On	equ	76		;Double Underline On
DU3Off	equ	77		;Double Underline Off
DU3Char	equ	78		;Character to use for movement (space or other, mapped)
DU3Mov1	equ	79		;Vertical Movement First Pass (1200ths)
DU3Mov2	equ	80		;Vertical Movement Second Pass (1200ths)
     ;Twin pass - WP's own on second pass
DU4Char	equ	81		;Character to use (mapped)
DU4Mov1	equ	82		;Vertical Movement First Pass (1200ths)
DU4Mov2	equ	83		;Vertical Movement Second Pass (1200ths)
DU4Squeez	equ	84		;Adjustment Between Characters (1200ths)",0
DU4LHang	equ	85		;Adjustment to Start of Double Underlining (1200ths)
DU4RHang	equ	86		;Adjustment to End of Double Underlining (1200ths)
     ;Single pass - WP's own on second pass
DU5Char	equ	87		;Character to use (mapped)
DU5Mov	equ	88		;Vertical movement (1200ths)
DU5Squeez	equ	89		;Adjustment Between Characters (1200ths)",0
DU5LHang	equ	90		;Adjustment to Start of Double Underlining (1200ths)
DU5RHang	equ	91		;Adjustment to End of Double Underlining (1200ths)
     ;Auto on separate pass
DU6On	equ	92		;Double Underline On
DU6Off	equ	93		;Double Underline Off
DU6Char	equ	94		;Character to use for movement (space or other, mapped)
DU6Mov	equ	95		;Vertical movement (1200ths)

   ;Outline drivers
     ;Auto on same pass
aolOn	equ	149		;Auto Outline On
aolOff	equ	150		;Auto Outline Off

   ;Redline drivers
     ;Auto on same pass
R1On	equ	96		;Redline On
R1Off	equ	97		;Redline Off
     ;Auto on 2nd pass
R2On	equ	98		;Redline On
R2Off	equ	128		;Redline Off
R2Char	equ	129		;Character to use for movement (space or other, mapped)
R2VMov	equ	130		;Vertical Adjustment
     ;WP's own on second pass
R3Char	equ	99		;Character to use (mapped)
R3Mov	equ	100		;Vertical movement (1200ths)
R3Squeez	equ	101		;Adjustment Between Characters (1200ths)
R3Lhang	equ	102		;Adjustment to Start of Redlining (1200ths)
R3RHang	equ	103		;Adjustment to End of Redlining (1200ths)
     ;Backspace redlining
R4Char	equ	104		;Character to use (mapped)
     ;Redline as color
;no strings -- will be done with the color driver

   ;Strikeout drivers
     ;Auto on same pass
Sk1On	equ	105		;Strikeout On
Sk1Off	equ	106		;Strikeout Off
     ;WP's own on second pass
Sk2Char	equ	107		;Character to use (mapped)
Sk2Mov	equ	108		;Vertical movement (1200ths)
Sk2Squeez	equ	109		;Adjustment Between Characters (1200ths)
Sk2Lhang	equ	110		;Adjustment to Start of Strikeout (1200ths)
Sk2RHang	equ	111		;Adjustment to End of Strikeout (1200ths)
     ;Backspace strikeout
Sk3Char	equ	112		;Character to use (mapped)
     ;Auto on 2nd pass
Sk4On	equ	131		;Strikeout On
Sk4Off	equ	132		;Strikeout Off
Sk4Char	equ	133		;Character to use for movement (space or other, mapped)
Sk4VMov	equ	134		;Vertical Adjustment

   ;Italics
     ;Same as single underline
     ;Auto on same pass
I2On	equ	113		;Italics On
I2Off	equ	114		;Italics Off

   ;Shadow
     ;Auto shadowing
Sh1On	equ	115		;Shadow On
Sh1Off	equ	116		;Shadow Off
   ;Shadow on 2nd pass
Sh2Passes	equ	135		;Number of passes
Sh2HOffst	equ	136		;Initial Horizontal offset (1200ths)
Sh2Mov	equ	137		;Additional Horz amount to move each pass (1200ths)
Sh2VOffst	equ	138		;Initial Vertical Offset (1200ths)
Sh2VMov	equ	139		;Additional Vert amount to move each pass (1200ths)

   ;Subscript
     ;Auto subscript
asubOn	equ	151		;subscript On
asubOff	equ	152		;subscript Off

   ;Superscript
     ;Auto superscript
asupOn	equ	153		;superscript On
asupOff	equ	154		;superscript Off

   ;Color
C1Set	equ	117		;Set color

   ;Graphics
    ;Graphics not supported
    
    ;Send vertical column of raster data (dot-matrix)
G1EXfer	equ	118		;End Graphics Data Transfer
G1Out	equ	119		;End graphics
G1Xfer	equ	121		;Transfer graphics data
G1VPA	equ	122		;Vertical position adjustment factor

    ;Send horizontal row of raster data (laser)
G2Out	equ	123		;End graphics 
G2DPI	equ	124		;Set graphics resolution (dpi)
G2In	equ	125		;Start graphics
G2Xfer	equ	126		;Transfer graphics data
G2EnCod	equ	140		;Data encoding type
G2EXfer	equ	120		;End Transer
G2Xcom	equ	5		;start graphics data transfer (compressed)

   ;Rules and Shaded Boxes
    ;Rules/Boxes not supported
    
    ;Single Intensity Shading (Rules)
R1Wd	equ	142		;Set rule width
R1Hgh	equ	143		;Set rule height
R1Drw	equ	144    		;Draw rule

    ;Multiple Intensity Shading
R2Wd	equ	145		;Set box width
R2Hgh	equ	146		;Set box height
R2Shd	equ	147		;Set box intensity
R2Drw	equ	148		;Draw box

KillJob	equ	127		;Flush printer's buffer (to kill print job)

gexcps	equ	155		;string to handle certain values in graphics
ejctpg	equ	156		;eject page, used iff no SF being used.

;;;;;;;;;;;Send color raster data
;	157		;not used
;	158		;not used
;	159		;not used
;AutoDup	equ	6		; not used
;H3Xpand	equ	39		; not used
;H3MDots	equ	40		; not used
;DplxOff	equ	14		; not used

;ThrInit	equ	15		; not used
;ThrReset	equ	16		; not used
;ThrBS	equ	17			; not used
;ThrCR	equ	18			; not used
;ThrNL	equ	19			; not used
;ThrFlush	equ	20		; not used

  ;End of string Table
stblend	equ	161		;end of string table; # of entries; 
				;next equate value - increment this value when
				; a new equate is added

;POSTSCRIPT Table

InitWP_P	equ	0	; Initialize printer when WP starts
InitPtr_P	equ	1	; Initialize printer: margins, perf skip, bi-direc, etc.
InitPg_P	equ	2	; Initialize page
ResetPg_P	equ	3	; Reset page/Advance to next page
ResetPtr_P	equ	4	; Reset printer at end of Document
KillJob_P	equ	5	; Flush printer's buffer (to kill print job)
MFeedIn_P	equ	6	; Shift into manual feed mode
MFeedOut_P	equ	7	; Shift out od manual feed mode
PgLngth_P	equ	8	; Page (form) length code
TopBias_P	equ	9	; Print-head bias (top) (2's complement)
LftBias_P	equ	10	; Print-head bias (left) (2's complement)
ejctpg_P	equ	11	; eject page, used iff no SF being used.
SetDplx_P	equ	12	; Set duplex
nofs_P		equ	13	; number of PostScript strings.

;PLOTTER Table

nofpen_G	equ	0	; Number of Pens
InitPtr_G	equ	1	; Initialize printer: margins, perf skip, bi-direc, etc.
InitPg_G	equ	2	; Initialize page
ResetPg_G	equ	3	; Reset page/Advance to next page
ResetPtr_G	equ	4	; Reset printer at end of Document
pnspd_G		equ	5	; Pen Speed
pnsel_g		equ	6	; Select Pen
pnup_g		equ	7	; Pen Up
pndn_g		equ	8	; Pen Down
pnmv_g		equ	9	; Move
argsep_g	equ	10	; Argument Separator
cmdtrm_g	equ	11	; Command Terminator
splyg_g		equ	12	; Start Polygon
eplyg_g		equ	13	; End Polygon
sfilp_g		equ	14	; Select Fill Pattern
nofs_G		equ	15	; number of Plotter strings.
;2ND PASS INFO PACKETS CONTAIN A BYTE TYPE, FOLLOWED BY A WORD BEGIN ATTRIBUTE
;OFFSET OF Q, FOLLOWED BY A WORD END ATTRIBUTE OFFSET OF Q.  THESE ARE USED
;IN THE P2ON, P2OFF, P2CHAR, AND P2MOVE ROUTINES
;FORMAT OF PACKETS
p2_pbeg	equ	0		;Packet begin (Type in 2nd pass attribute)
p2_beg	equ	1		;Q offset of start where underline starts
p2_end	equ	3		;Q offset of start where underline ends

;;;p2_nmpk	equ	1020/p2_size	;TOTAL NUMBER OF PACKETS (204).

