/************************************************************************
Name:	DBMDEMO.C
Title:	DBMDEMO program to show how to use Shared Code Calls

Tabs:	
Copyright (C) 1991 WordPerfect Corp., All Rights Reserved
COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
------------------------------------------------------------------------
************************************************************************
*	Rev 1.3 May 12, 1992	9:18	Ray Stringer
*		Added prototype file created for all prototypes for WPWin
*		code.  This file is MCRDBM.EXP.  Took out all prototype
*		references to functions in DBMdemo.h
*
*	Rev 1.2 Feb 25, 1992	10:20am	Ray Stringer
*		Modified SBARS dialog proc to return TRUE in the 
*		WM_INITDIALOG.  Also changed the Dialog file to have a 
*		border style around the edit control.
*
*	Rev 1.1 Feb 25, 1992	 10:00am	Ray Stringer
*		Added support for DBMMessageBox.
*
*    	Rev 1.0	November 1, 1991 2:30pm	Ray Stringer
* 		Initial creation.
* 
* 
************************************************************************/
/****************************************************************/
/* This is a sample program to show how to interface with the   */
/* WPSHAR1.DLL DBM function calls.                              */
/****************************************************************/

#include <windows.h>
#include "dbmdemo.h"
#include "dbm.h"
#include "mcrdbm.exp"

long 	FAR PASCAL WndProc 		(HWND, WORD, WORD, LONG);


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
	{
	static char szAppName[] = "DBMDemo";
	HWND          hwnd;
	MSG           msg;
	WNDCLASS      wndclass;

	if (!hPrevInstance)
        	{
              	wndclass.style              = CS_HREDRAW | CS_VREDRAW;
              	wndclass.lpfnWndProc        = WndProc;
             	wndclass.cbClsExtra         = 0;
              	wndclass.cbWndExtra         = 0;
              	wndclass.hInstance          = hInstance;
              	wndclass.hIcon              = LoadIcon (hInstance, szAppName);
              	wndclass.hCursor            = LoadCursor (NULL, IDC_ARROW);
              	wndclass.hbrBackground      = COLOR_WINDOW + 1;
              	wndclass.lpszMenuName       = szAppName;
              	wndclass.lpszClassName      = szAppName;

              	RegisterClass (&wndclass);
	      	}

	hwnd = CreateWindow (szAppName, "WPCorp DBM Sample",
				WS_OVERLAPPEDWINDOW,
                0, 0,
                GetSystemMetrics (SM_CXSCREEN),
                GetSystemMetrics (SM_CYSCREEN),
                NULL, NULL, hInstance, NULL);

		ShowWindow (hwnd, nCmdShow);
       	UpdateWindow (hwnd);

       while (GetMessage (&msg, NULL, 0, 0))
           	{
			if (!(DBMIsDialogMessage (&msg)))
				{
	       		TranslateMessage (&msg);
       			DispatchMessage  (&msg);
				}
			}
       return msg.wParam;
       }

BOOL FAR PASCAL StandardDlgProc (HWND hDlg,      /* aboutdbm.dlg & statics.dlg */
				WORD message, 
				WORD wParam, 
				LONG lParam)
	{
       	switch (message)
              	{
             	case WM_INITDIALOG:
                     	return TRUE;
              
              	case WM_COMMAND:
                     	switch (wParam)
                            	{
                            	case IDOK:
                            	case IDCANCEL:
                                   	DBMEndDialog (hDlg, 0);
                                   	return TRUE;
                            	}
                     	break;
              	}
       	return DBMDefDlgProc (hDlg, message, wParam, lParam);
       	}


BOOL FAR PASCAL PopupDlgProc (HWND hDlg,         /* popup.dlg */
				WORD message, 
				WORD wParam, 
				LONG lParam)
       {

	HWND hPopup;				/* Handle to dialog control*/
	static HMENU hResMainMenu, 
		     hResPopupMenu; 		/*Menu handles for popup menu*/

	switch (message)
       		{
         	case WM_INITDIALOG:

			hResMainMenu  = LoadMenu (GetWindowWord
						(hDlg, GWW_HINSTANCE), "POPUP");
			hResPopupMenu = GetSubMenu (hResMainMenu, 0); 
			hPopup = GetDlgItem (hDlg, PU_CONTROL);
			DBMSetPopupMenu (hPopup, hResPopupMenu);
			DBMCheckPopupMenuItem (hPopup, PU_1, MF_BYCOMMAND);
			return TRUE;

		case WM_COMMAND:
			switch (wParam)
				{
				case IDOK:
				case IDCANCEL:
					DBMEndDialog (hDlg, 0);
					DestroyMenu (hResMainMenu);
					return TRUE;
				}
			break;
		}
	return DBMDefDlgProc (hDlg, message, wParam, lParam);
       }

BOOL FAR PASCAL PopdownDlgProc (HWND hDlg,       /* popdown.dlg */
				WORD message, 
				WORD wParam, 
				LONG lParam)
       {
	static HMENU hPDMainMenu, hPDSubMenu; 	/* Used for loading menu for */
						/* popdown control           */
	HWND hPopdown;				/* Handle to popdown control */				

	switch (message)
       		{
         	case WM_INITDIALOG:
			hPDMainMenu = LoadMenu (GetWindowWord 
					(hDlg, GWW_HINSTANCE), "POPDOWN");
			hPDSubMenu = GetSubMenu (hPDMainMenu, 0);
			hPopdown = GetDlgItem (hDlg, PD1_CONTROL);
			DBMSetPopupMenu (hPopdown, hPDSubMenu);
			return TRUE;

		case WM_COMMAND:
			switch (wParam)
				{

				case PD_2000:
					SendDlgItemMessage (hDlg, PD1_SHADOW, 
							WM_SETTEXT, 
							NULL, 
							(LONG)((LPSTR)
							"Aug 7, 1991"));
					return TRUE;

				case PD_2001:
					SendDlgItemMessage (hDlg, PD1_SHADOW, 
							WM_SETTEXT, 
							NULL, 
							(LONG)((LPSTR)
							"Aug 07, 1991"));
					return TRUE;

				case PD_2002:
					SendDlgItemMessage (hDlg, PD1_SHADOW, 
							WM_SETTEXT, 
							NULL, 
							(LONG)((LPSTR)
							"August 7, 1991"));
					return TRUE;

				case PD_2003:
					SendDlgItemMessage (hDlg, PD1_SHADOW, 
							WM_SETTEXT, 
							NULL, 
							(LONG)((LPSTR)
							"Aug 7, 1991"));
					return TRUE;

				case PD_2004:
					SendDlgItemMessage (hDlg, PD1_SHADOW, 
							WM_SETTEXT, 
							NULL, 
							(LONG)((LPSTR)
							"Aug 7, '91"));
					return TRUE;

				case PD_2005:
					SendDlgItemMessage (hDlg, PD1_SHADOW, 
							WM_SETTEXT, 
							NULL, 
							(LONG)((LPSTR)
							"Aug 7, 1991"));
					return TRUE;

				case PD_2006:
					SendDlgItemMessage (hDlg, PD1_SHADOW, 
							WM_SETTEXT, 
							NULL, 
							(LONG)((LPSTR)
							"Wednesday, Aug 7, 1991"));
					return TRUE;

				case PD_2007:
					SendDlgItemMessage (hDlg, PD1_SHADOW, 
							WM_SETTEXT, 
							NULL, 
							(LONG)((LPSTR)
							"Wed, Aug 7, 1991"));
					return TRUE;

				case PD_2008:
					SendDlgItemMessage (hDlg, PD1_SHADOW, 
							WM_SETTEXT, 
							NULL, 
							(LONG)((LPSTR)
							"Aug 7, 1991"));
					return TRUE;

				case IDOK:
				case IDCANCEL:
					DBMEndDialog (hDlg, 0);
					DestroyMenu (hPDMainMenu);					return TRUE;

				}
			break;
		}
	return DBMDefDlgProc (hDlg, message, wParam, lParam);
       }

BOOL FAR PASCAL CounterDlgProc (HWND hDlg,       /* count.dlg */
				WORD message, 
				WORD wParam, 
				LONG lParam)
       {
	switch (message)
       		{
         	case WM_INITDIALOG:
			SendMessage (GetDlgItem (hDlg, IDD_COUNTER),   
					  CNT_SETFORMAT, 
					  CNT_DISP_WPU, 0L); /* display WPU's */

			SendMessage (GetDlgItem (hDlg, IDD_COUNTER),   
					  CNT_SETSTEPVALUE, NULL, 
					  (LONG)INC_VAL); /* increment 
									by 5 */
			return TRUE;

		case WM_COMMAND:
			switch (wParam)
				case IDOK:
				case IDCANCEL:
					DBMEndDialog (hDlg, 0);
					return TRUE;
		}
	return DBMDefDlgProc (hDlg, message, wParam, lParam);
       }

BOOL FAR PASCAL GroupsDlgProc (HWND hDlg,        /* groups.dlg */
				WORD message, 
				WORD wParam, 
				LONG lParam)
       	{
	switch (message)
       		{
         	case WM_INITDIALOG:
			CheckRadioButton (hDlg, L_FIRST, L_LAST, L_FIRST); 
			CheckRadioButton (hDlg, C_FIRST, C_LAST, C_MID); 
			CheckRadioButton (hDlg, R_FIRST, R_LAST, R_LAST); 
			return TRUE;

		case WM_COMMAND:
			switch (wParam)
				{
				case IDOK:
				case IDCANCEL:
					DBMEndDialog (hDlg, 0);
					return TRUE;
				}
			break;
		}
	return DBMDefDlgProc (hDlg, message, wParam, lParam);
       }
	
BOOL FAR PASCAL StatusBarDlgProc (HWND hDlg, 
					WORD message, 
					WORD wParam, 
					LONG lParam)
	{
	char szSBarText[SBARSIZE];

       	switch (message)
              	{
             	case WM_INITDIALOG:
                     	return TRUE;
              
              	case WM_COMMAND:
                     	switch (wParam)
                            	{
                            	case IDOK:
					SendDlgItemMessage (hDlg,  
						SBAR_EDIT, 
						WM_GETTEXT, 
						SBARSIZE, 
						(LONG)((LPSTR)szSBarText));

					SetDlgItemText (hDlg,    
						IDSBAR, szSBarText);
					return TRUE;

                            	case IDCANCEL:
                                   	DBMEndDialog (hDlg, 0);
                                   	return TRUE;
                            	}
                     	break;
              	}
       	return DBMDefDlgProc (hDlg, message, wParam, lParam);
       	}

BOOL FAR PASCAL PDComboDlgProc (HWND hDlg,       /* pdcombo.dlg */
				WORD message, 
				WORD wParam, 
				LONG lParam)
	{
	HANDLE hMainInstance;
	HWND hPDCombo;				/* Handle to dialog control*/
	static HMENU hResMainMenu, 
		     hResPDComboMenu; 		/*Menu handles for popup menu*/

       	switch (message)
              	{
             	case WM_INITDIALOG:
			hMainInstance = GetWindowWord (hDlg, GWW_HINSTANCE);
			DBMPositionWindow (hDlg, 
					hMainInstance, 
					DBMPOS_FROMDLG, FALSE);

			hResMainMenu = LoadMenu (hMainInstance, "CODES");

			hResPDComboMenu = GetSubMenu (hResMainMenu, 0);

			hPDCombo = GetWindowWord (GetDlgItem (hDlg, PDC_MENU), 
						DBM_POPDOWN_COMBO_POPDOWN);

			DBMSetPopupMenu (hPDCombo, hResPDComboMenu);
			return TRUE;

              
              	case WM_COMMAND:
                     	switch (wParam)
       	                    	{
				case PDC_1:
					SendMessage(GET_POPDOWN_COMBO_EDIT
						(GetDlgItem(hDlg,PDC_MENU)),
						WM_SETTEXT, 0, 
						(LONG)((LPSTR)"[BOLD] [bold]"));
					return TRUE;
				case PDC_2:
					SendMessage(GET_POPDOWN_COMBO_EDIT
						(GetDlgItem(hDlg,PDC_MENU)),
						WM_SETTEXT, 0, 
						(LONG)((LPSTR)"[UND] [und]"));
					return TRUE;
				case PDC_3:
					SendMessage(GET_POPDOWN_COMBO_EDIT
						(GetDlgItem(hDlg,PDC_MENU)),
						WM_SETTEXT, 0, 
						(LONG)((LPSTR)"[DBL UND] [dbl und]"));
					return TRUE;
				case PDC_4:
					SendMessage(GET_POPDOWN_COMBO_EDIT
						(GetDlgItem(hDlg,PDC_MENU)),
						WM_SETTEXT, 0, 
						(LONG)((LPSTR)"[ITAL] [ital]"));
					return TRUE;
				case PDC_5:
					SendMessage(GET_POPDOWN_COMBO_EDIT
						(GetDlgItem(hDlg,PDC_MENU)),
						WM_SETTEXT, 0, 
						(LONG)((LPSTR)"[OUTLINE] [outline]"));
					return TRUE;
					
                            	case IDOK:
                            	case IDCANCEL:
                                   	DBMEndDialog (hDlg, 0);
					DestroyMenu (hResMainMenu);
                                   	return TRUE;
                            	}
                     	break;
              	}
       	return DBMDefDlgProc (hDlg, message, wParam, lParam);
       	}




long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
	{
	static FARPROC  lpfnStandardDlgProc, lpfnPopupDlgProc, 
			lpfnPopdownDlgProc, lpfnCounterDlgProc, 
			lpfnGroupsDlgProc, lpfnStatusBarDlgProc, 
			lpfnPDComboDlgProc;
						/* all instance thunks for */
						/* dialog init. procs      */
	static HANDLE   hInstance;
	WORD		wLanguage = WLANGUAGE;	/* US hex value        */
	WORD		wExpectedVersion;	/* DLL Version         */
	int 		nDLLEntryOk = 0; 	/* This variable will  */
						/* be set to non-zero  */
						/* value if entry into */
						/* DLL was successful. */

       	switch (message)
		{
              	case WM_CREATE:
			wExpectedVersion = DLLVersion(); /* Get DLL version*/
			nDLLEntryOk = DLLEntry (wLanguage, wExpectedVersion); /* Entry point */
										 /* for DBM DLL */
			hInstance = ((LPCREATESTRUCT) lParam) -> hInstance;
			lpfnStandardDlgProc 	 = MakeProcInstance 
						(StandardDlgProc, hInstance);
			lpfnPopupDlgProc 	 = MakeProcInstance 
						(PopupDlgProc, hInstance);
			lpfnPopdownDlgProc 	 = MakeProcInstance 
						(PopdownDlgProc, hInstance);
			lpfnCounterDlgProc 	 = MakeProcInstance 
						(CounterDlgProc, hInstance);
			lpfnGroupsDlgProc 	 = MakeProcInstance 
						(GroupsDlgProc, hInstance);
			lpfnStatusBarDlgProc 	 = MakeProcInstance 
						(StatusBarDlgProc, hInstance);
			lpfnPDComboDlgProc 	 = MakeProcInstance 
						(PDComboDlgProc, hInstance);
			return 0;

		case WM_SYSKEYDOWN: /* Unload DLL's if Alt+F4 is pressed. */
			switch (wParam)
				{
				case VK_F4: 
					DLLExit ();
                                   	SendMessage (hwnd, WM_CLOSE, 0, 0L);
                                   	return 0;
				}
			break;

		case WM_NCLBUTTONDBLCLK: /* Unload DLL's if Alt+F4 is pressed. */
			switch (wParam)
				{
				case HTSYSMENU: 
					DLLExit ();
                                   	SendMessage (hwnd, WM_CLOSE, 0, 0L);
                                   	return 0;
				}
			break;
					
		case WM_SYSCOMMAND: /* Unload DLL's if System Close is clicked. */
			switch (wParam)
				{
				case SC_CLOSE: 
					DLLExit ();
                                   	SendMessage (hwnd, WM_CLOSE, 0, 0L);
                                   	return 0;
				}
			break;

              	case WM_COMMAND:
                    	switch (wParam)
				{
				case IDM_POPUPTEST: /* Call Popup Dialog */
					DBMDialogBoxParam (hInstance, 
							POPUP1, 
							hwnd, 
							lpfnPopupDlgProc, 
							0L);
					return 0;

				case IDM_POPDOWNTEST: /* Call Popdown Dialog */

					DBMDialogBoxParam (hInstance, 
							PDONE, 
							hwnd, 
							lpfnPopdownDlgProc, 
							0L);
					return 0;

				case IDM_STATICTEST: /* Call Standard Dialog */

					DBMDialogBoxParam (hInstance, 
							STATIC_CONTROLS, 
							hwnd, 
							lpfnStandardDlgProc, 
							0L);
					return 0;

				case IDM_COUNTTEST: /* Call Counter Dialog */

					DBMDialogBoxParam (hInstance, 
							COUNTER, 
							hwnd, 
							lpfnCounterDlgProc, 
							0L);
					return 0;

                        	case IDM_GROUPTEST: /* Call Group Box Dialog */

                                   	DBMDialogBoxParam (hInstance, 
							GROUPS, 
							hwnd, 
							lpfnGroupsDlgProc, 
							0L);
                                   	return 0;

				case IDM_SBARS: /* Call Status Bar Dialog */

					DBMDialogBoxParam (hInstance, 
							SBARS, 
							hwnd, 
							lpfnStatusBarDlgProc, 
							0L);
					return 0;

                        	case IDM_ABOUT:	/* Call Standard Dialog */

                                   	DBMDialogBoxParam (hInstance, 
							ABOUTDBMDEMO, 
							hwnd, 
							lpfnStandardDlgProc, 
							0L);
                                   	return 0;

				case IDM_PDCOMBO: /* Call PopdownCombo Dialog */

					DBMDialogBoxParam (hInstance, 
							PDCOMBO, 
							hwnd, 
							lpfnPDComboDlgProc, 
							0L);
					return 0;

				case IDM_MSGBOX:

					DBMMessageBox (hwnd, 
						"This is a WPCorp MessageBox!", 
						"DBMMessageBox", 
						MB_OK | MB_ICONEXCLAMATION);
					return 0;

				case IDM_EXIT:	
					DLLExit (); /* Exit WPC DLL's */
                                   	SendMessage (hwnd, WM_CLOSE, 0, 0L);
					FreeProcInstance 
						((FARPROC) lpfnPopupDlgProc);
					FreeProcInstance 
						((FARPROC) lpfnPopdownDlgProc);
					FreeProcInstance 
						((FARPROC) lpfnStandardDlgProc);
					FreeProcInstance 
						((FARPROC) lpfnCounterDlgProc);
					FreeProcInstance 
						((FARPROC) lpfnGroupsDlgProc);
					FreeProcInstance 
						((FARPROC) lpfnStatusBarDlgProc);
					FreeProcInstance 
						((FARPROC) lpfnPDComboDlgProc);
                                   	return 0;
				}
			break;

              	case WM_DESTROY:
                     	PostQuitMessage (0);
                     	return 0;
              	}
       	return DefWindowProc (hwnd, message, wParam, lParam);
       	}

/**************************************************************************
30-70	Standard Windows code.  Please refer to Windows 
	programming manual or your SDK manual for explanation.
	The only exception is on line 67.  The function DBMIsDialogMessage
	checks to see if the message coming into the loop
	is a Dialog Message.  This function is required for all
	Modeless dialogs in a program that use DBM function calls.
	There are no Modeless Dialogs in this program.  This is 
	only here to show the function's use.

114-116	Loads the menu POPUP and grab the submenu (which is the whole menu). 

117-119 Get the handle for the popup control,
	set the menu to the popup control, and check the
	first item on the menu.                           

148-150 This initialization section is the same as in  
	the popup initialization section.  It doesn't  
	have a CheckMenuItem call because the popdown  
	control doesn't have a state.                  

151-152 Get the handle for the popup control,
	set the menu to the popup control, and check the
	first item on the menu.                           

159-229 Each of the PD_# cases correspond    
	to each item on the popdown menu.              
	All the SendDlgItemMessage call does is set    
	the static Shadow box text to what is in lParam.

249-256 These SendMessage calls send DBM messages 
	to the counter control.     

279 	Set 1st button as default in first groupbox.
280	Set Mid. button as default in second groupbox.
281	Set last button as default in third groupbox.

312-317 Get text from the edit control.

319-320 Set status bar text to edit control text.               

350	Load the attribute codes menu.

352 	Get the submenu (same as above).

354-355 Get the handle to the popup control.

357 	Set the popup menu to the popup control.

364-393 Each one of the PDC_# cases will send a  
	WM_SETTEXT message to the handle of the edit    
	control portion of the popdown combo control    
	using the GET_POPDOWN_COMBO_EDIT macro supplied 
	in the DBM.H file sent with the Toolkit.        

535	This call demonstrates the use of DBMMessageBox API.
	It is available for use in WPWin macros also.
	The parameters are similar to the Windows API MessageBox.
	The only difference is lParam.  It is a DWORD instead of a WORD.

*******************************************************************/