/*---------------------------
   calldemo.h header file
  ---------------------------*/

/* defines for the dialog box */
#define 	CHOICEDLG	200
#define 	EX_OPENDLG	100
#define 	EX_TABLEDLG	101
#define 	EX_STYLEDLG	102

/* defines for product types */
#define   WPWP			0x50575057

/* defines for tokens */
#define   CHRCTR_TKN	585
#define   STRING_TKN	709
#define   HRD_RTRN_TKN	270
#define   FIL_OPN_DLG_TKN	224
#define   TBLE_CRT_DLG_TKN	49
#define   STY_DLG_TKN	196
#define   NULL_TKN		577

typedef unsigned int WPTokenType;

typedef enum
{
	WP_BOOL,					// boolean - unsigned int
	WP_ENUMERATION,			// enumeration - unsigned int
	WP_FLOAT,					// double precision floating point number
	WP_SIGNED_CHAR,			// signed char integer (1 byte)
	WP_SIGNED_LONG,			// signed long integer (4 bytes)
	WP_SIGNED_SHORT,			// signed short integer (2 bytes)
	WP_UNSIGNED_CHAR,			// unsigned char integer (1 byte)
	WP_UNSIGNED_LONG,			// unsigned long integer (4 bytes)
	WP_UNSIGNED_SHORT,			// unsigned short integer (2 bytes)
	WP_STRING,				// null terminated string
	WP_ANSI_STRING,			// null terminated string, no wp chars
	WP_WPUS,					// measurement in WPU's
	WP_INCHES,				// measurement in inches
	WP_CENTIMETERS,			// measurement in centimeters
	WP_POINTS,				// measurement in points
	WP_OEM_STRING,				// null terminated string, oem chars only
	WP_SIGNED_WPUS,			// measurement in signed WPU's
	WP_VARIABLE,				// handle to MACROVAR structure
	WP_DONT_CARE
} WPTokenParameterType;

typedef struct
{
	WPTokenParameterType	ParmType;
	LPVOID			lpData;
} WPDataDescriptor;

typedef struct
{
	unsigned short int	cParmCount;
	WPDataDescriptor FAR 	*lpDataArray;
} WPDataBlock, FAR *LPWPDataBlock;

#define MSF_NO_ERROR			0
#define MSF_BASE_GENERAL_ERRORS	(-99)
#define MSF_TOP_APP_ERROR		(MSF_BASE_GENERAL_ERRORS-1)

typedef enum {
	MSF_FUNCTION_UNKNOWN = MSF_BASE_GENERAL_ERRORS,	// Unknown token
	MSF_FUNCTION_NOTFOUND,							// Function resulted in not found
	MSF_FUNCTION_CANCEL,							// Function resulted in cancel
	MSF_FUNCTION_ERROR,								// Function resulted in error
	MSF_FUNCTION_INVALID_PARM,						// Invalid parameter on function
	MSF_FUNCTION_INVALID,							// Function invalid at this time
	MSF_FUNCTION_NOT_HANDLED						// Function not handled
} WPTokenErrorType;

BOOL FAR PASCAL ChoiceDlgProc 	(HWND, WORD, WORD, LONG);
int FAR PASCAL DBMDialogBoxParam	(HANDLE, WORD, HWND, FARPROC, LONG);
DWORD FAR PASCAL DBMQueryDlgULong	(HWND);
BOOL FAR PASCAL DBMSetDlgULong	(HWND, DWORD);
int FAR PASCAL DBMMessageBox		(HWND, LPSTR, LPSTR, DWORD);
long FAR PASCAL MacroWndProc 		(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL DBMDefDlgProc 	(HWND, WORD, WORD, LONG);
VOID FAR PASCAL DBMEndDialog       (HWND, int);

typedef int ( FAR PASCAL *WPTokenEngine)( WPTokenType TokenID, WPDataBlock FAR *pData );
