/**********************************************************
   CALLDEMO.C - Library module for Command-Level Interface
 **********************************************************/
  
#include <windows.h>
#include "calldemo.h"

typedef struct _tagMACROVAR {
	WPTokenParameterType	eVarType;

	union {
		BOOL	bValue;
		LONG	lnValue;
		double	ldValue;
		struct {
			WORD	usStrLen;
			HANDLE	hStrValue;
		} stStrValue;
	} uValue;

} MACROVAR, *NPMACROVAR, FAR *LPMACROVAR;

/*** Global declarations ***/

HANDLE	hInstance;
WORD		DialogValue;
BOOL		bFirstFlag = TRUE; // true until after the first token is sent

/****************************************
	Initialization Function - required
	Called by Windows
 ****************************************/

int FAR PASCAL LibMain (HANDLE hInst,
					WORD   wDataSeg,
					WORD   wHeapSize,
					LPSTR  lpszCmdLine)
{
	hInstance = hInst;

	if (wHeapSize > 0)               // If DLL data seg is moveable 
		UnlockData (0);
	
	return 1;         	             // Initialization successful 	   
}


/************************************
	'Version' Function - required
*************************************/

DWORD FAR PASCAL Cli_Version (VOID)
{
	/* The version needs to be non-zero, otherwise will fail */

	return MAKELONG ( 1, hInstance);
}


/************************************************
	'Entry' Function - required
    Called once for every app that uses this DLL
*************************************************/

int FAR PASCAL Cli_Entry (WORD wLanguage, BOOL bNotCalledFromDLL)
{
	return 1;
}


/************************************************
	'Exit' Function - required
	Called once for every app that uses this DLL 
*************************************************/

int FAR PASCAL Cli_Exit (BOOL bNotCalledFromDLL)
{
	return 1;
}	
	

/***********************************
	WEP Routine (required)
	Called by Windows
************************************/

VOID FAR PASCAL WEP (int nParameter)
{
	return;
}


/*************************************************************
	Tokenhandler Function - required
	function that receives and sends tokens	to and from WPWin
 *************************************************************/

int FAR PASCAL tokenhandler( WPTokenType 	   TokenID, 
					 	WPDataBlock FAR * pData,
						WPTokenEngine	   lpfnWPTokenEngine,
						DWORD		   AppID )
{
	int			iRetVal = MSF_FUNCTION_NOT_HANDLED;
	int	 		temp_char;
	char			temp_str[20], szTemp[25];
	WPDataBlock	temp_pData;
	WPDataDescriptor data[3];
	MACROVAR		 var;
	DWORD		varAddr;

	if (AppID == WPWP)  // checks if product is WPWin (defined in calldemo.h) 

	if ( bFirstFlag && ( TokenID == NULL_TKN ))  //if first token received
	{
		DBMMessageBox (GetFocus(), 
				    "3rd-Party DLL successfully loaded", 
				    "WPWin Startup Box", 
				    MB_OK);
		bFirstFlag = FALSE;
	}
	
	if (( TokenID == CHRCTR_TKN)   // looking for character token
		&& ( pData->lpDataArray )   // If there exists a DataDescriptor
		&& ( pData->lpDataArray->ParmType == WP_UNSIGNED_SHORT )
		&& ( pData->lpDataArray->lpData ))  // If the data exists
		
		switch (*(LPWORD)pData->lpDataArray->lpData )
		{
			case 0x31:		// '1' - Replace character token 
				temp_char = 'a';

				/* Build new WPDataBlock */
				temp_pData.cParmCount = 3;
				temp_pData.lpDataArray = &data[0];

				/* Add parameters to WPDataBlock */
				data[0].ParmType = WP_UNSIGNED_SHORT;
				data[0].lpData = &temp_char;
				  /* the following parameters are for extended 
				     characters (see documentation) */ 
				data[1].ParmType = WP_UNSIGNED_SHORT; 
				data[1].lpData = NULL;  /* No parameter 2 */
				data[2].ParmType = WP_UNSIGNED_SHORT;
				data[2].lpData = NULL;  /* No parameter 3 */

				/* Send token through token engine */
				iRetVal = lpfnWPTokenEngine( TokenID, &temp_pData );
				break;
				
			case 0x32:		// '2' - Replace character token with string 
				lstrcpy( temp_str, "This is a string" );

				/* Build new WPDataBlock */
				temp_pData.cParmCount = 1;
				temp_pData.lpDataArray = &data[0];

				/* Add parameter to WPDataBlock */
				data[0].ParmType = WP_STRING;
				data[0].lpData = &temp_str[0];

				/* Send token through token engine */
				lpfnWPTokenEngine( STRING_TKN, &temp_pData );      
				iRetVal = lpfnWPTokenEngine( HRD_RTRN_TKN, NULL );  
				break;
		
			case 0x33:		// '3' - WPWin dialog box call 
				/* Send new token through token engine */
				iRetVal = lpfnWPTokenEngine( FIL_OPN_DLG_TKN, NULL );
  				break;    
	
			case 0x34:		// '4' - Windows message box 
				MessageBox (GetFocus(), 
						    "You pressed the number 4 key!", 
						    "Windows Message Box", 
						    MB_OK);
				iRetVal = MSF_NO_ERROR;
				break;

			case 0x35:		// '5' - Windows dialog box with DBM 
				iRetVal = DBMDialogBoxParam (hInstance, CHOICEDLG, GetFocus(), 
							ChoiceDlgProc, (LONG)lpfnWPTokenEngine);
   				break;

			case 0x36:
				varAddr = (DWORD)(LPVOID)&var;

				temp_pData.cParmCount = 2;
				temp_pData.lpDataArray = &data[0];

				data[0].ParmType = WP_VARIABLE;
				data[0].lpData = (LPVOID)&varAddr;

				data[1].ParmType = WP_ENUMERATION;
				data[1].lpData = &temp_char;

				temp_char = 14; /* Current Page */

				iRetVal = lpfnWPTokenEngine( 679, &temp_pData );

				wsprintf( szTemp, "Current Page = %d", 
					 LOWORD(var.uValue.lnValue));
				MessageBox( GetFocus(),
						szTemp,
						"Message Box",
						MB_OK );
				break;

			default:
				return iRetVal;  // token was ignored

		}  					// end switch stmt
	else 					// if NOT a char token
		return iRetVal;          // ignored  

}  // end TokenHandler function
		
		
/****************************************************************
	CHOICEDLGPROC - Procedure for dialog box with menu choices
 ****************************************************************/
 
BOOL FAR PASCAL ChoiceDlgProc (HWND hDlg, WORD message, WORD wParam, 
							   LONG lParam)
{
	WPTokenEngine	lpfnWPTokenEngine;
	int	iRValue;
	switch (message)
	{
		case WM_INITDIALOG:
			DBMSetDlgULong( hDlg, lParam );	// required for DBM Dlg
			return TRUE;
			
		case WM_COMMAND:
			lpfnWPTokenEngine = (WPTokenEngine)DBMQueryDlgULong( hDlg );
										// required for DBM Dlg
			switch (wParam)
			{
				case EX_OPENDLG:
				case EX_TABLEDLG:
				case EX_STYLEDLG:
					if (wParam == EX_OPENDLG)
						DialogValue = FIL_OPN_DLG_TKN;
					else if (wParam == EX_TABLEDLG)
						DialogValue = TBLE_CRT_DLG_TKN;
					else if (wParam == EX_STYLEDLG)
						DialogValue = STY_DLG_TKN;
					DBMEndDialog (hDlg, 1);
					iRValue = lpfnWPTokenEngine( DialogValue, NULL );
					return iRValue;
					
				case IDCANCEL:
					DBMEndDialog (hDlg, 0);
					iRValue = MSF_NO_ERROR;
					return iRValue;
			}
			
			break;
	}
	return DBMDefDlgProc (hDlg, message, wParam, lParam);
}

				/********************
				*	End of file	*
				*********************/	   
