#!/bin/sh

# One-script  OS X solution to create a build-environment for DOSBox
# by downloading and installing the required libraries, then building
# dynamic-linked or static linked-versions (or both) and creating
# an OS X application containing the unix executable. 
# All details and knowledge provided by Dominus at vogons.org!!

# specify default folder containing DOSBox source below:
# this option only used when getting source or building executables
DOSBOXFOLDER="$HOME/Development/dosbox"

# set BUILDENV to 1 to be prompted to create the build envionment
BUILDENV=1
# set DOWNLOAD to 1 to download the installers for the build environment
DOWNLOAD=1
# set GETDOSBOX to 1 to download DOSBox source
GETDOSBOX=1
# set BUILDDOSBOX to 1 to enable the option to build executables
BUILDDOSBOX=1

# If your system does not have Mercurial/hg installed, you will be
# prompted to open a download page. Download and extract the version
# for your OS version; open a terminal in a folder with the files,
# and install hg by entering: sudo make install

###--------------------------------- # Storage for things to do later
 
### Example of block to copy files from one directory-tree into another
### To use for copying Wengier modified source code into dosbox source
### From: http://stackoverflow.com/questions/3331348

#download="/folder/of/extracted/zip/archive"
#target="$DOSBOXFOLDER"
#find "${download}" -name "*" | while read -r file
#do
#    mv "${file}" "${target}"
#done

###--------------------------------- # Parameters for directory or uninstall 

UNINST=0
PATHPARAM=0

if [[ $# -eq 0 ]] ; then
    echo  # Save for future use
else
	# Test for "uninstall" or path hame
    if [ $1 = "uninstall" ] || [ $1 = "--uninstall" ] || [ $1 = "-uninstall" ] || [ $1 = "-u" ] ; then
	    UNINST=1
		BUILDENV=1			# override setting to 0 above
	elif [ $1 = "help" ] || [ $1 = "--help" ] || [ $1 = "-help" ] || [ $1 = "-h" ] || [ $1 = "-?" ] ; then
		echo '----------------------------------------------------------------' 
		echo 'OneStopDOSBoxOX.sh downloads libraries to create a build environment'
		echo 'for DOSBox, then downloads and/or builds DOSBox from source code'
		echo 'Optional parameters:'
		echo '  /path/to/folder/for/dosbox (non-existent directory will be created)'
		echo '  uninstall (uninstalls previously-installed libraries)'
		echo '----------------------------------------------------------------'  
		exit
    else
		PATHPARAM=1
    fi
fi
# echo $FOLDER
#exit

if [ $UNINST = 0 ] ; then
	INSTSTR="Install"
else
	INSTSTR="Uninstall"
fi

###--------------------------------- #  Functions 

# error handling from Dominus
DIE=0
function error_quit
{
echo -e "\033[1;31m **Error** line #${1:-"Unknown Error"}\033[0m" 1>&2
exit 1
}

mfile="Makefile"
function distclean () {
	if [ -f "$mfile" ] ; then
		make distclean >/dev/null
	fi
}

###--------------------------------- # Test for Xcode and Xcode command line tools

if [ $UNINST != 1 ] ; then

if open -Ra "Xcode" ; then
	echo "Xcode found."
	echo "If you have not already run Xcode at least once, exit and do so now."
else
	echo
	echo "Xcode must be installed from the App Store and run once. Exiting."
	exit
fi

if type xcode-select >&- && xpath=$( xcode-select --print-path ) &&
   test -d "${xpath}" && test -x "${xpath}" ; then
   		echo "Xcode command line tools installed"
else
		echo "Xcode command-line tools not found. Exiting."
		echo "To install the tools, enter the following command at the terminal:"
		echo "xcode-select --install" 
		echo 
		exit 
fi

fi

###--------------------------------- #  Required options and exports

OPT=' -w -arch i386 -m32 -O2 -msse -msse2 -force_cpusubtype_ALL '
SDK=' -mmacosx-version-min=10.7 '                                   
export MACOSX_DEPLOYMENT_TARGET=10.7
export PATH=$HOME/Development/i386/bin/:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin
export CC="/Applications/Xcode.app/Contents/Developer/usr/bin/gcc -arch i386"
export CXX="/Applications/Xcode.app/Contents/Developer/usr/bin/g++ -arch i386"
export CPPFLAGS='-I'$HOME'/Development/i386/include'$SDK
export CFLAGS='-I'$HOME'/Development/i386/include '$SDK' '$OPT
export CXXFLAGS='-I'$HOME'/Development/i386/include '$SDK' '$OPT
export LDFLAGS='-L'$HOME'/Development/i386/lib '$SDK' '$OPT

###--------------------------------- # Start prompting

echo
echo In the prompts below, you must type y or Y to choose Yes
echo You may skip any step by pressing Enter or n or N.
if [ $BUILDENV = 1 ] ; then 							## this begins the show env block prompt
	if [ $UNINST != 1 ] ; then
		echo You should only need to create the build environment once.
	fi 
###--------------------------------- # To build or not to build the environment

echo
# which prompt to use: create or remove?
if [ $UNINST != 1 ] ; then 
	BUILDSTR="Create the build environment (skip this step after creating) (y/N)? "
else
	BUILDSTR="Uninstall the libraries installed in the build environment (y/N)? "
fi
#ask the question defined above
read -p "$BUILDSTR" -n 1 -r
echo   
if [[ $REPLY =~ ^[Yy]$ ]] ; then		## this begins the create-environment block

###--------------------------------- #  Create Development folder when needed 

if [ $UNINST != 1 ] ; then

echo "Making ~/Development (if it doesn't exist)"
mkdir -p $HOME/Development
echo "Changing to ~/Development"
cd $HOME/Development

###--------------------------------- # Test for Mercurial/hg for installing latest SDL 1.2

if [ $DOWNLOAD=1 ] ; then
    echo
    command -v hg >/dev/null 2>&1 || { 
    echo
    echo "Mercurial/hg required but not installed. Opening its web page, then aborting." >&2; 
    echo
    read -p "Press Enter to open the Mercurial/hg web page."; 
    open https://www.mercurial-scm.org/downloads; 
    exit 1; }
fi
echo && echo

fi

###--------------------------------- # Install autoconf

read -p "$INSTSTR autoconf (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items
ACVER="2.69"
if [ $UNINST != 1 ] ; then
	mkdir -p $HOME/Development/autoconf-$ACVER
	if [ $DOWNLOAD = 1 ] ; then
	    curl -OL http://gnu.mirror.globo.tech/autoconf/autoconf-$ACVER.tar.gz
	    tar -xzf autoconf-$ACVER.tar.gz -C $HOME/Development/
	    rm autoconf-$ACVER.tar.gz
	fi
	cd $HOME/Development/autoconf-$ACVER
	distclean
	./configure -q --prefix=$HOME/Development/i386
	make >/dev/null && make install >/dev/null && make clean  >/dev/null
else
	cd $HOME/Development/autoconf-$ACVER
	make uninstall >/dev/null
	cd ..
	rm -rf $HOME/Development/autoconf-$ACVER
    rmdir $HOME/Development/i386/share/autoconf/m4sugar
    rmdir $HOME/Development/i386/share/autoconf/autotest
    rmdir $HOME/Development/i386/share/autoconf/autoscan
    rmdir $HOME/Development/i386/share/autoconf/Autom4te
    rmdir $HOME/Development/i386/share/autoconf/autoconf
    rmdir $HOME/Development/i386/share/autoconf
fi
echo && echo

fi

###--------------------------------- # Install automake

read -p "$INSTSTR automake (y/N)? " -n 1 -r
echo  
if [[ $REPLY =~ ^[Yy]$ ]] ; then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items
AMVER="1.15"
if [ $UNINST != 1 ] ; then
mkdir -p $HOME/Development/automake-$AMVER
if [ $DOWNLOAD = 1 ] ; then
    curl -OL http://ftpmirror.gnu.org/automake/automake-$AMVER.tar.gz
    tar -xzf automake-$AMVER.tar.gz -C $HOME/Development
    rm automake-$AMVER.tar.gz
fi
cd $HOME/Development/automake-$AMVER
distclean
./configure -q --prefix=$HOME/Development/i386
make >/dev/null && make install >/dev/null && make clean >/dev/null 
else
	cd $HOME/Development/automake-$AMVER
	make uninstall >/dev/null
	cd ..
	rm -rf $HOME/Development/automake-$AMVER
    rmdir $HOME/Development/i386/share/automake-$AMVER/am
    rmdir $HOME/Development/i386/share/automake-$AMVER/Automake
    rmdir $HOME/Development/i386/share/automake-$AMVER
    rmdir $HOME/Development/i386/share/share/doc/automake
fi
echo && echo

fi

###--------------------------------- # Install libtool

### can't uninstall libtool, so not offering the option yet...
if [ $UNINST != 1 ] ; then
read -p "$INSTSTR libtool (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items
LTVER="2.4.6"
mkdir -p $HOME/Development/libtool-$LTVER
if [ $DOWNLOAD = 1 ] ; then
    curl -OL http://ftpmirror.gnu.org/libtool/libtool-$LTVER.tar.gz
    tar -xzf libtool-2.4.6.tar.gz -C $HOME/Development
    rm libtool-$LTVER.tar.gz
fi
cd $HOME/Development/libtool-$LTVER
distclean
./configure -q --prefix=$HOME/Development/i386 --program-prefix=g F77=no FC=no GCJ=no
make >/dev/null && make install >/dev/null && make clean >/dev/null
echo && echo
fi

fi

###--------------------------------- # Install pkgconfig

read -p "$INSTSTR pkgconfig (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items
PCVER="0.29.1"
if [ $UNINST = 0 ] ; then
mkdir -p $HOME/Development/pkg-config-$PCVER
if [ $DOWNLOAD = 1 ] ; then
    curl -OL https://pkg-config.freedesktop.org/releases/pkg-config-$PCVER.tar.gz
    tar -xzf pkg-config-$PCVER.tar.gz -C $HOME/Development
    rm pkg-config-$PCVER.tar.gz
fi
cd $HOME/Development/pkg-config-$PCVER
mkdir -p $HOME/Development/i386/lib/pkgconfig
mkdir -p $HOME/Development/i386/share/pkgconfig
distclean
./configure -q --prefix=$HOME/Development/i386 --with-pc-path=$HOME/Development/i386/lib/pkgconfig:$HOME/Development/i386/share/pkgconfig --with-internal-glib --disable-host-tool
make >/dev/null && make install >/dev/null && make clean >/dev/null 
export PKG_CONFIG_PATH="$HOME/Development/i386/lib/pkgconfig"
else
	cd $HOME/Development/pkg-config-$PCVER
	make uninstall >/dev/null
	cd ..
	rm -rf $HOME/Development/pkg-config-$PCVER
    # rmdir $HOME/Development/i386/lib/pkgconfig
    rmdir $HOME/Development/i386/share/pkgconfig
    rmdir $HOME/Development/i386/share/doc/pkg-config
fi

echo && echo

fi

###--------------------------------- # Install lzib

## belongs here?
export PKG_CONFIG_PATH="$HOME/Development/i386/lib/pkgconfig"

read -p "$INSTSTR zlib (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]]
then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items
ZLVER="1.2.11" 
if [ $UNINST != 1 ] ; then
mkdir -p $HOME/Development/zlib-$ZLVER
if [ $DOWNLOAD = 1 ] ; then
    curl -OL http://zlib.net/zlib-$ZLVER.tar.gz
    tar -xzf zlib-$ZLVER.tar.gz -C $HOME/Development
    rm zlib-$ZLVER.tar.gz
fi
cd $HOME/Development/zlib-$ZLVER
distclean
./configure --prefix=$HOME/Development/i386
make >/dev/null && make install >/dev/null && make clean >/dev/null 
else
	cd $HOME/Development/zlib-$ZLVER
	make uninstall >/dev/null
	cd ..
	rm -rf $HOME/Development/zlib-$ZLVER
fi
echo && echo

fi

###--------------------------------- # Install libogg

read -p "$INSTSTR libogg (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items
LOVER="1.3.2"
if [ $UNINST != 1 ] ; then
mkdir -p $HOME/Development/libogg-$LOVER
if [ $DOWNLOAD = 1 ] ; then
    curl -OL http://downloads.xiph.org/releases/ogg/libogg-$LOVER.tar.gz
    tar -xzf libogg-$LOVER.tar.gz -C $HOME/Development
    rm libogg-$LOVER.tar.gz
fi
cd $HOME/Development/libogg-$LOVER
distclean
./configure -q --prefix=$HOME/Development/i386
make >/dev/null && make install >/dev/null && make clean >/dev/null 
else
	cd $HOME/Development/libogg-$LOVER
	make uninstall >/dev/null
	cd ..
	rm -rf $HOME/Development/libogg-$LOVER
    rmdir $HOME/Development/i386/include/ogg
    rmdir $HOME/Development/i386/share/doc/libogg/libogg
    rmdir $HOME/Development/i386/share/doc/libogg
fi
echo && echo

fi

###--------------------------------- # Install libvorbis


read -p "$INSTSTR libvorbis (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items
LVVER="1.3.5"
if [ $UNINST != 1 ] ; then
mkdir -p $HOME/Development/libvorbis-$LVVER
if [ $DOWNLOAD = 1 ] ; then
    curl -OL http://downloads.xiph.org/releases/vorbis/libvorbis-$LVVER.tar.gz
    tar -xzf libvorbis-$LVVER.tar.gz -C $HOME/Development
    rm libvorbis-$LVVER.tar.gz
fi
cd $HOME/Development/libvorbis-$LVVER
distclean
./configure -q --prefix=$HOME/Development/i386 --disable-oggtest
make >/dev/null && make install >/dev/null && make clean >/dev/null 
else
	cd $HOME/Development/libvorbis-$LVVER
	make uninstall >/dev/null
	cd ..
	rm -rf $HOME/Development/libvorbis-$LVVER
    rmdir $HOME/Development/i386/include/vorbis
fi
echo && echo

fi

###--------------------------------- # Install SDL 1.2

read -p "$INSTSTR SDL 1.2 (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items

if [ $UNINST != 1 ] ; then
# test for Mercurial/hg for installing latest SDL 1.2
if [ $DOWNLOAD=1 ] ; then 
    command -v hg >/dev/null 2>&1 || { 
    echo
    echo "Mercurial/hg required but not installed. Opening its web page, then aborting." >&2; 
    echo
    read -p "Press Enter to open the Mercurial/hg web page."; 
    open http://mercurial.selenic.com; 
    exit 1; }
fi

mkdir -p $HOME/Development/SDL-1.2
cd $HOME/Development/SDL-1.2
if [ $DOWNLOAD=1 ] ; then 
    echo
    # read -p "Press Enter to download or update SDL 1.2"
    hg clone -u SDL-1.2 https://hg.libsdl.org/SDL $HOME/Development/SDL-1.2
    
    # hg update 
    echo "Downloading patch file"
    curl -o CoreAudio-SDL-1.2.diff -L https://bugzilla-attachments.libsdl.org/attachment.cgi?id=2272
    echo "Patching SDL-1.2"
    # patch -p1 -N < CoreAudio-SDL-1.2.diff ||  error CoreAudio patch
    patch -p1 -N < CoreAudio-SDL-1.2.diff 
fi

distclean
./autogen.sh >/dev/null
./configure -q --prefix=$HOME/Development/i386 --enable-static --enable-joystick --enable-cdrom --enable-video-cocoa --enable-video-opengl --disable-nasm --disable-video-x11 --without-x
make clean >/dev/null && make >/dev/null && make install >/dev/null && make clean >/dev/null 
cd $HOME/Development
else
	cd $HOME/Development/SDL-1.2
	make uninstall >/dev/null
	cd ..
	rm -rf $HOME/Development/SDL-1.2
    rmdir $HOME/Development/i386/include/SDL
fi

echo && echo

fi

###--------------------------------- # Install SDL_Sound

read -p "$INSTSTR SDL_sound (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items
SSVER="1.0.3"
if [ $UNINST != 1 ] ; then
mkdir -p $HOME/Development/SDL_sound-$SSVER
if [ $DOWNLOAD = 1 ] ; then
    curl -OL http://icculus.org/SDL_sound/downloads/SDL_sound-$SSVER.tar.gz
    tar -xzf SDL_sound-$SSVER.tar.gz -C $HOME/Development
    rm SDL_sound-$SSVER.tar.gz
fi
cd $HOME/Development/SDL_sound-$SSVER
distclean
./configure -q --prefix=$HOME/Development/i386 --disable-smpeg --disable-mikmod --disable-modplug --disable-flac --disable-speex --disable-physfs --disable-sdltest
make >/dev/null && make install >/dev/null && make clean >/dev/null 
else
	cd $HOME/Development/SDL_sound-$SSVER
	make uninstall >/dev/null
	cd ..
	rm -rf $HOME/Development/SDL_sound=$SSVER
    # rmdir $HOME/Development/i386/include/SDL
fi
echo && echo

fi

###--------------------------------- # Install SDL_net

read -p "$INSTSTR SDL_net (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items
SNVER="1.2.8"
if [ $UNINST != 1 ] ; then
mkdir -p $HOME/Development/SDL_net-$SNVER
if [ $DOWNLOAD = 1 ] ; then
    curl -OL https://www.libsdl.org/projects/SDL_net/release/SDL_net-$SNVER.tar.gz
    tar -xzf SDL_net-$SNVER.tar.gz -C $HOME/Development
    rm SDL_net-$SNVER.tar.gz
fi
cd $HOME/Development/SDL_net-$SNVER
distclean
./configure -q --prefix=$HOME/Development/i386
make >/dev/null && make install >/dev/null && make clean >/dev/null 
else
	cd $HOME/Development/SDL_net-$SNVER
	make uninstall >/dev/null
	cd ..
	rm -rf $HOME/Development/SDL_net-$SNVER
    rmdir $HOME/Development/i386/include/SDL
fi
echo && echo

fi

###--------------------------------- # Install libpng

read -p "$INSTSTR libpng (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then

DOWNLOAD=$DOWNLOAD  #change to 1 or 0 to change download control for remaining items
LPVER="1.6.21"
if [ $UNINST != 1 ] ; then
mkdir -p $HOME/Development/libpng-$LPVER
if [ $DOWNLOAD = 1 ] ; then
    cd $HOME/Development
    curl -OL http://prdownloads.sourceforge.net/libpng/libpng-$LPVER.tar.gz
    tar -xzf libpng-$LPVER.tar.gz -C $HOME/Development
    rm libpng-$LPVER.tar.gz
fi
cd $HOME/Development/libpng-$LPVER
unset CFLAGS
./configure -q --prefix=$HOME/Development/i386
make >/dev/null && make install >/dev/null && make clean >/dev/null
export CFLAGS='-I'$HOME'/Development/i386/include '$SDK' '$OPT 
else
	cd $HOME/Development/libpng-$LPVER
	make uninstall >/dev/null
	cd ..
	rm -rf $HOME/Development/libpng-$LPVER
    rmdir $HOME/Development/i386/include/libpng16
fi
echo && echo

fi

fi 	# this ends Create environment block

fi 	# this ends the show option to create environment block

###--------------------------------- # Download dosbox source code?

if [ $UNINST != 1 ] ; then    # start not uninst block that contains get and build

if [ $PATHPARAM = 1 ] ; then

	if [ -d $1 ] ; then 
		FOLDER=$(cd $1; pwd)
		read -p "Download and/or build dosbox in $FOLDER (y/N)? " -n 1 -r
		echo 
			if [[ $REPLY =~ ^[Yy]$ ]] ; then
				DOSBOXFOLDER=$1
    		else
    			exit
    		fi
    else
    	 read -p "Create directory $1 (y/N)?" -n 1 -r
    	 	if [[ $REPLY =~ ^[Yy]$ ]] ; then
				DOSBOXFOLDER=$1
                mkdir -p "$1"
                FOLDERNEW=1
                echo
			else
				exit
			fi
    fi

fi # end path param

if [ $GETDOSBOX = 1 ] ; then
	echo
	read -p "Download latest dosbox source to $DOSBOXFOLDER (y/N)? " -n 1 -r
	echo 
	
	if [[ $REPLY =~ ^[Yy]$ ]] ; then
		if [ -d "$DOSBOXFOLDER" ] ; then
            if [ $FOLDERNEW !=1 ] ; then
                echo
                read -p "First delete existing $DOSBOXFOLDER and its contents (y/N)? " -n 1 -r
                echo 
                if [[ $REPLY =~ ^[Yy]$ ]] ; then
                    rm -rf $DOSBOXFOLDER
                fi
            fi
		fi  # end test folder is directory block
        
		mkdir -p $DOSBOXFOLDER
		rm -rf $TMPDIR/dosboxsource >/dev/null 2>&1
		mkdir -p $TMPDIR/dosboxsource/
		curl -OL http://source.dosbox.com/dosboxsvn.tgz
		tar -xzf dosboxsvn.tgz -C $TMPDIR/dosboxsource/
		rm dosboxsvn.tgz
		ditto $TMPDIR/dosboxsource/dosbox $DOSBOXFOLDER        # ditto not available on linux
		echo && echo
		
	fi # end test for reply yes

fi # end test getdosbox block

###-------------------------- # build dosbox, dynamic and/or static

if [ $BUILDDOSBOX = 1 ] ; then		# starts overall build block

echo
read -p "Build dynamic-linked dosbox in $DOSBOXFOLDER (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then

if [ -f "$DOSBOXFOLDER/src/dosbox.cpp" ] ; then	## checking for at least one source file
		echo Source folder seems to be correct.
	else
		echo
		echo Could not find source files in $DOSBOXFOLDER. Aborting.
		exit
fi

distclean

export CFLAGS='-I'$HOME'/Development/i386/include '$SDK' '$OPT
cd $DOSBOXFOLDER
### autoheader -f 
### autoconf -f
### automake -f 
./autogen.sh
chmod +x ./configure
./configure --prefix=$HOME/Development/i386

make clean && make -j9 -s || {
DIE=1
error_quit "$(( $LINENO -2 )) : make failed."
}
echo && echo Dynamic-linked dosbox built in $DOSBOXFOLDER/src
echo

read -p "Run dynamic-linked dosbox in $DOSBOXFOLDER/src (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then
	cd ./src
    echo '[cpu]'>testdosbox.conf
    echo 'core=dynamic'>>testdosbox.conf
    echo '[autoexec]'>>testdosbox.conf
    echo 'config -get cpu'>>testdosbox.conf
    ./dosbox -conf ./testdosbox.conf
	cd ..
fi

read -p "Open folder $DOSBOXFOLDER/src (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then
	open ./src
fi

fi  ## this ends build dynamic-linked block

###--------------------------------- # Build static-linked dosbox

echo
read -p "Build static-linked dosbox in $DOSBOXFOLDER? (y/N) " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then			# start build-static-linked block

if [ -f "$DOSBOXFOLDER/src/dosbox.cpp" ] ; then	# checking for at least one source file
		echo Source folder seems to be correct.
	else
		echo
		echo Could not find source files in $DOSBOXFOLDER. Aborting.
		exit
fi

distclean

cd $DOSBOXFOLDER
# autoheader -f 	## uncomment in case of errors
# autoconf -f
# automake -f 
./autogen.sh 
chmod +x ./configure
./configure -q --prefix=$HOME/Development/i386 --disable-sdltest --disable-alsatest   || {    
DIE=1
error_quit "$(( $LINENO -2 )) : configure failed."
}

make clean >/dev/null

rm temporary.patch

echo "Creating temporary patch file ..."

echo '--- ./Makefile' >temporary.patch
echo '+++ ./Makefile' >>temporary.patch
echo '@@ -238,7 +238,7 @@' >>temporary.patch
echo  ' INSTALL_STRIP_PROGRAM = $(install_sh) -c -s' >>temporary.patch
echo ' LDFLAGS = -L'$HOME'/Development/i386/lib  -mmacosx-version-min=10.7   -arch i386 -m32 -O2 -msse -msse2 -force_cpusubtype_ALL ' >>temporary.patch
echo ' LIBOBJS = ' >>temporary.patch
echo '-LIBS = -lSDL_sound  -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa -lpng -lz -lSDL_net -framework OpenGL -framework CoreMIDI -framework AudioUnit -framework AudioToolbox' >>temporary.patch
echo '+LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit -framework CoreMIDI '$HOME'/Development/i386/lib/libpng.a '$HOME'/Development/i386/lib/libz.a '$HOME'/Development/i386/lib/libSDL_net.a '$HOME'/Development/i386/lib/libSDL_sound.a '$HOME'/Development/i386/lib/libogg.a '$HOME'/Development/i386/lib/libvorbis.a '$HOME'/Development/i386/lib/libvorbisfile.a '$HOME'/Development/i386/lib/libvorbisenc.a' >>temporary.patch
echo ' LTLIBOBJS = ' >>temporary.patch
echo ' MAKEINFO = ${SHELL} '$HOME'/Development/dosbox-svn-3982/missing makeinfo' >>temporary.patch
echo ' MKDIR_P = ./install-sh -c -d' >>temporary.patch
echo '@@ -254,7 +254,7 @@' >>temporary.patch
echo ' RANLIB = ranlib' >>temporary.patch
echo ' SDL_CFLAGS = -I'$HOME'/Development/i386/include/SDL -D_GNU_SOURCE=1 -D_THREAD_SAFE' >>temporary.patch
echo ' SDL_CONFIG = '$HOME'/Development/i386/bin//sdl-config' >>temporary.patch
echo '-SDL_LIBS = -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa' >>temporary.patch
echo '+SDL_LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit' >>temporary.patch
echo ' SET_MAKE = ' >>temporary.patch
echo ' SHELL = /bin/sh' >>temporary.patch
echo ' STRIP = ' >>temporary.patch
echo '' >>temporary.patch
echo '--- ./src/Makefile' >>temporary.patch
echo '+++ ./src/Makefile' >>temporary.patch
echo '@@ -242,7 +242,7 @@' >>temporary.patch
echo ' INSTALL_STRIP_PROGRAM = $(install_sh) -c -s' >>temporary.patch
echo ' LDFLAGS = -L'$HOME'/Development/i386/lib  -mmacosx-version-min=10.7   -arch i386 -m32 -O2 -msse -msse2 -force_cpusubtype_ALL ' >>temporary.patch
echo ' LIBOBJS = ' >>temporary.patch
echo '-LIBS = -lSDL_sound  -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa -lpng -lz -lSDL_net -framework OpenGL -framework CoreMIDI -framework AudioUnit -framework AudioToolbox' >>temporary.patch
echo '+LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit -framework CoreMIDI '$HOME'/Development/i386/lib/libpng.a '$HOME'/Development/i386/lib/libz.a '$HOME'/Development/i386/lib/libSDL_net.a '$HOME'/Development/i386/lib/libSDL_sound.a '$HOME'/Development/i386/lib/libogg.a '$HOME'/Development/i386/lib/libvorbis.a '$HOME'/Development/i386/lib/libvorbisfile.a '$HOME'/Development/i386/lib/libvorbisenc.a' >>temporary.patch
echo ' LTLIBOBJS = ' >>temporary.patch
echo ' MAKEINFO = ${SHELL} '$HOME'/Development/dosbox-svn-3982/missing makeinfo' >>temporary.patch
echo ' MKDIR_P = .././install-sh -c -d' >>temporary.patch
echo '@@ -258,7 +258,7 @@' >>temporary.patch
echo ' RANLIB = ranlib' >>temporary.patch
echo ' SDL_CFLAGS = -I'$HOME'/Development/i386/include/SDL -D_GNU_SOURCE=1 -D_THREAD_SAFE' >>temporary.patch
echo ' SDL_CONFIG = '$HOME'/Development/i386/bin//sdl-config' >>temporary.patch
echo '-SDL_LIBS = -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa'>>temporary.patch
echo '+SDL_LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit' >>temporary.patch
echo ' SET_MAKE = ' >>temporary.patch
echo ' SHELL = /bin/sh' >>temporary.patch
echo ' STRIP = ' >>temporary.patch

echo && echo

echo "Applying temporary makefile patch ..."
patch -p1 -i temporary.patch ||  error dosbox patch
if [ "$?" = "0" ]; then
    echo "Makefile patch succeeded."
else
	echo "Makefile patch failed. Exiting"
    exit
fi

make clean && make -j9 -s || {
DIE=1
error_quit "$(( $LINENO -2 )) : make failed."
}

echo && echo Dynamic-linked dosbox built in $DOSBOXFOLDER/src
echo

read -p "Run static-linked dosbox in $DOSBOXFOLDER/src (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then
	cd ./src
    echo '[cpu]'>testdosbox.conf
    echo 'core=dynamic'>>testdosbox.conf
    echo '[autoexec]'>>testdosbox.conf
    echo 'config -get cpu'>>testdosbox.conf
    ./dosbox -conf ./testdosbox.conf
	cd ..
fi

read -p "Open folder $DOSBOXFOLDER/src (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]]
then
	open ./src
fi

fi		# end build-static-linked block

###--------------------------------- # Create MyDOSBox.app

echo
read -p "Create OS X MyDOSBox.app in $DOSBOXFOLDER/src? (y/N) " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then	# start build-static-linked block

if [ -f "$DOSBOXFOLDER/src/dosbox" ] ; then
		echo
	else
		echo Cannot build app in $DOSBOXFOLDER/src. Dosbox executable not found.
		echo
		exit
fi

cd $DOSBOXFOLDER/src

if [ -f "$DOSBOXFOLDER/src/MyDOSBox.app/Contents/PkgInfo" ] ; then
	read -p "Delete existing MyDOSBox.app in $DOSBOXFOLDER/src? (y/N) " -n 1 -r
		echo 
		if [[ $REPLY =~ ^[Yy]$ ]] ; then	
			rm -rf $DOSBOXFOLDER/src/MyDOSBox.app/*
			rmdir $DOSBOXFOLDER/src/MyDOSBox.app
		else
			echo "Existing MyDOSBox.app not deleted. Aborting."
			exit
		fi
fi

echo "Creating MyDOSBox.app ..."
mkdir -p MyDOSBox.app/Contents/MacOS
cp dosbox MyDOSBox.app/Contents/MacOS/DOSBox
echo 'APPL????' >MYDOSBox.app/Contents/PkgInfo
mkdir -p MyDOSBox.app/Contents/Resources
## uncomment next when you have an icon file
## cp dosbox.icns MyDOSBox.app/Contents/Resources/dosbox.icns		
cd MyDOSBox.app/Contents

echo '<?xml version="1.0" encoding="UTF-8"?>' >> Info.plist
echo '<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">' >> Info.plist
echo '<plist version="1.0">' >> Info.plist
echo '<dict>' >> Info.plist
echo '	<key>CFBundleDevelopmentRegion</key>' >> Info.plist
echo '	<string>English</string>' >> Info.plist
echo '	<key>CFBundleDisplayName</key>' >> Info.plist
echo '	<string>DOSBox</string>' >> Info.plist
echo '	<key>CFBundleExecutable</key>' >> Info.plist
echo '	<string>DOSBox</string>' >> Info.plist
echo '	<key>CFBundleGetInfoString</key>' >> Info.plist
echo '	<string>SVN, Copyright 2002-2014 The DOSBox Team</string>' >> Info.plist
echo '	<key>CFBundleIconFile</key>' >> Info.plist
echo '	<string>dosbox.icns</string>' >> Info.plist
echo '	<key>CFBundleInfoDictionaryVersion</key>' >> Info.plist
echo '	<string>6.0</string>' >> Info.plist
echo '	<key>CFBundleName</key>' >> Info.plist
echo '	<string>DOSBox</string>' >> Info.plist
echo '	<key>CFBundlePackageType</key>' >> Info.plist
echo '	<string>APPL</string>' >> Info.plist
echo '	<key>CFBundleShortVersionString</key>' >> Info.plist
echo '	<string>SVN</string>' >> Info.plist
echo '	<key>CFBundleVersion</key>' >> Info.plist
echo '	<string>SVN</string>' >> Info.plist
echo '	<key>NSHumanReadableCopyright</key>' >> Info.plist
echo '	<string>Copyright 2002-2014 The DOSBox Team</string>' >> Info.plist
echo '	<key>NSPrincipalClass</key>' >> Info.plist
echo '	<string>NSApplication</string>' >> Info.plist
echo '	<key>CGDisableCoalescedUpdates</key>' >> Info.plist
echo '	<true/>' >> Info.plist
echo '</dict>' >> Info.plist
echo '</plist>' >> Info.plist

cd ../..

# echo && echo
read -p "Run MyDOSBox.app in $DOSBOXFOLDER/src (y/N)? " -n 1 -r
echo 
if [[ $REPLY =~ ^[Yy]$ ]] ; then
	open ./MyDOSBox.app
fi

fi

fi			# ends overall build block

###--------------------------------- # Finish up

fi	# ends test not uninst block

echo
exit
