;name	VGAP.ASM
;title	Presence test for vga
;
;  Copyright (C) 1993 WordPerfect Corp., All Rights Reserved
;  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
;------------------------------------------------------------
;
;********************
;  EQUATES
;	equates for resolution, colors, etc.
;********************

;Setup mode dependent equates
;These are equates are based on a mode value.

;mode 12H	640x480 16 colors
M12_MODE	equ	12h		;video mode
M12_MAX_X	equ	639		;max number in x
M12_MAX_Y	equ	479		;max number in y
M12_COLWP	equ	16		;# colors to report to WP
M12_MEMMODEL	equ	3		;memory model - 4-plane planar

CSEG2	SEGMENT PARA PUBLIC 'CODE'
ASSUME	cs:cseg2,ds:nothing,es:nothing
	ORG	0
	jmp	short start

gray		db	0	;gray modes flag

;standp
;desc:	presence test for standard video modes
;in:	wpparm from .ctl
;out:	al = -1 if not ibm standard mode, else ibm standard mode number
;	ah = bitmapped flags
;		bits 0-2	number of video pages supported
;		bits 3-5	Reserved (must be 0)
;		bit  6		1 - Alternate pages may be made active
;				0 - Alternate pages may not be made active
;		bit  7		indicates shades of gray rather than colors
;	bx = number of colors (shades)
;	cx = x resolution
;	dx = y resolution
;ret:	jc	detection failed
;	jnc	passed detection
;notes:
start	label	near
public	standp
standp	proc	far
	push	bp
	mov	bp,sp
	push	ax			;bp-2,  ah = bp-1
.ah	equ	byte ptr [bp-1]
	push	bx			;bp-4
.bx	equ	word ptr [bp-4]
	push	cx			;bp-6
.cx	equ	word ptr [bp-6]
	push	dx			;bp-8
.dx	equ	word ptr [bp-8]
	push	si			;bp-10
	push	di			;bp-12
.di	equ	word ptr [bp-12]
	push	es			;bp-14
	push	ds			;bp-16



	push	cs			;set up ds to point at internal vars
	pop	ds
assume	ds:cseg2	
	mov	gray,0			;assume not gray mode
	or	ah,ah			;check if gray mode
	 jz	std10			; no, skip
	mov	gray,80h		;set shades of gray bit 
std10:	cmp	al,M12_MODE		;video mode 12h?
	 jne	std93			;  no, error
	mov	cx,M12_MAX_X		;max number in x
	mov	dx,M12_MAX_Y		;max number in y
	mov	bx,M12_COLWP		;# colors to report to WP
	mov	di,M12_MEMMODEL		;memory model
	jmp	short std95

std93:	stc
	jmp	short std99

std95:	mov	.bx,bx			;save return values
	mov	.cx,cx
	mov	.dx,dx
	mov	.di,di
	call	detect			;check for required graphics card
	 jc	std99			;exit if error (carry flag still set)
	mov	al,1			;graphics pages supported
	or	al,gray
	mov	.ah,al
	clc
std99:	pop	ds
	pop	es
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	bp
	ret
standp	endp
;detect
;desc:	detect presence of graphics boards
;in:	none
;out:	none
;ret:	jc - required board not supported board
;notes:	
;	All registers will be preserved.

detect	proc near
	push	ax
	push	cx
	push	dx
	mov	ax,1A00h		;get display combination code
	int	10h			;video interrupt
	cmp	al,1Ah			;function supported?
	 jne	de97			;jump if not
	cmp	bl,07h			;is active display VGA monochrome?
	 je	de10			;jump if so
	cmp	bl,08h			;is active display VGA color?
	 je	de10			;jump if so
	cmp	bh,07h			;is inactive display VGA monochrome?
	 je	de10			;jump if so
	cmp	bh,08h			;is inactive display VGA color?
	 jne	de97			;nope, error
de10:	clc				;indicate VGA installed
	jmp	short de99		;jump to exit point

de97:	stc				;indicate VGA not installed
de99:	pop	dx
	pop	cx
	pop	ax
	ret

detect	endp
cseg2	ends
	end
