;name	TIBM.ASM 
;title	 Text drivers for IBM
;
;  Copyright (C) 1991,1993 WordPerfect Corp., All Rights Reserved
;------------------------------------------------------------
; 
;-----
;includes
include tfrs.inc		;vrs temp file prefix numbers

;*** 
;Equates 
;*** 
MODE1	equ	103h		;VGA 80x28 mode save font
MODE2	equ	203h		;VGA 80x50 mode save font
MODE3	equ	303h		;VGA 80x43 mode save font
MODE4	equ	403h		;EGA 80x43 mode save font
MODE5	equ	503h		;VGA 80x50 mode
MODE6	equ	603h		;EGA 80x43 mode
				;ega and vga are the same for this mode
				;except for the dcc test in mopen_td.
				;The code which ditinguishes vga from ega
				;(seting to 350 line resolution) is no
				;recognized by a true ega.  This allows the
				;code to be shared.
MODE7	equ	703h		;EGA clone (cursor problems) 80x43 mode
MODE8	equ	803h		;EGA 80x25 mode
MODE9	equ	903h		;EGA clone (cursor) 80x43 mode save font
;misc. equates
fnlen	equ	80		;max length for path\filename
wzro	equ	0feh		;use as zero argument for wpos
ATT_SPC		equ (30 * 5)	;Attribute table space set by WP
wpp	equ	ds:[di]		;WordPerfect pointer to WP parameter block
WO	equ	word ptr 
BY	equ	byte ptr 
ofs	equ	offset

;***
;Equates for screen types 
;****
MON_SC		equ	0		;Monochrome
CGA_SC		equ	1		;Color Graphics Adapter
PC3270_SC	equ	2		;PC3270
EGACO64_SC	equ	3		;EGA (CO40 or CO80, 64K memory)
EGACO128_SC	equ	4		;EGA (CO40 or CO80, 128K memory)
EGAMO64_SC	equ	5		;EGA (MONO, 64K memory)
EGAMO128_SC	equ	6		;EGA (MONO, 128K memory)
EGAEM64_SC	equ	7		;EGA (EMULATION, HI-RES, 64K)
EGAEM128_SC	equ	8		;EGA (EMULATION, HI-RES, 128K)
VGA_SC		equ	9		;VGA
MCGA_SC		equ	10		;MCGA
D8514_SC	equ	11		;8514/A
HGC_SC		equ	12		;Hercules Graphics Card (Vanilla)
HRF_SC		equ	13		;Hercules Graphics Card (Ramfont)
HIC_SC		equ	14		;Hercules Graphics Card (In_Color)
MAX_SC		equ	15		;Always the maximum number

;DCC equates.  Documented p. 486 of Video Systems.
;Display combination code valid for MCGA and VGA only.
DCC_NOR		equ	0ffh		;Video system not recognized
DCC_NO		equ	0		;No display
DCC_MDA		equ	1		;MDA w/ mono display
DCC_CGA		equ	2		;CGA w/ color display
DCC_EGAC	equ	4		;EGA w/ color display
DCC_EGAM	equ	5		;EGA w/ mono display
DCC_PGC		equ	6		;Professional Graphics Controller
DCC_VGAM	equ	7		;VGA w/ analog mono display
DCC_VGAC	equ	8		;VGA w/ analog color display
DCC_MCDC	equ	0ah		;MCGA w/ digital color display
DCC_MCAM	equ	0bh		;MCGA w/ analog mono display
DCC_MCAC	equ	0ch		;MCGA w/ analog color display

;****
; Bit equates for tdparm
;	bits 15-12 used by WP
;		15 - T_INT 	set = internal driver 
;				clear = external driver
;	bits 11-8 used by external driver
;***
T_INT	equ	8000h	;internal text driver bit - tdparm
T_FONT	equ	800h	;Preserve dos font flag
T_PAL	equ	400h	;preserve dos palette flag

;****
; Bit equates for tdbflg
;bit 7 - set if driver has preserved dos font
;bit 6 - set if driver has preserved dos palette
;***
TDF_FONT	equ	80h
TDF_PAL		equ	40h

;equates for show
wbell	equ	7h	;				bell
whom	equ	8h	;home key			position upper left
wtab	equ	9h	;tab
wnl	equ	0ah	;enter key			new line
wceol	equ	0bh	;clear to end of line key	clear to end of line
wcpag	equ	0ch	;clear to end of page		clear screen, go home
wcr	equ	0dh	;				carriage return
watt_on	equ	0eh	;				attr on
watt_of	equ	0fh	;				attr off
wpos	equ	10h	;				position -- col,row
wcatt	equ	11h	;				clear all attributes
wron	equ	12h	;				reverse video on
wrof	equ	13h	;				reverse video off
wuon	equ	14h	;				underline on
wuof	equ	15h	;				underline off
wmnem	equ	16h	;control v			mnemonic attribute
wua	equ	17h	;up arrow			up arrow
wra	equ	18h	;right arrow			right arrow
wla	equ	19h	;left arrow			left arrow
wda	equ	1ah	;down arrow			down arrow
wesc	equ	1bh	;escape key
wdim	equ	1ch	;				bold off
whi	equ	1dh	;				bold on
wspc	equ	20h	;space				space
wallat	equ	0ffh	;				all attributes when used with watt_of
wxx	equ	-1	;dummy code

;*** 
; Structures 
;*** 
;parameter block structure used to locate variables on WP side 
WP	STRUC 
cclim	dw 0		;Number of colums on the screen
cllim	dw 0		;current display limit (number of lines)
cclft	dw 0		;leftmost display column
zrtcl	dw 0		;column number of rightmost column
zbtln	dw 0		;Row number of bottom line
cltop	dw 0		;top of display offset (window)
ht	db ?		;height of a row in pixels
wdcol	db ?		;width of a screen char in pixels
vmode	db	?			;Initial video mode
veqf	db 	?			;initial video equipment flag
vpage	db	?			;Initial active page
vattr	db	?			;Initial default attribute
vscol	db	?			;Initial cols reported by bios
vsrow	db	?			;Initial rows reported by bios
vcur	dw	?			;Initial cursor state

dispoff	dw -1		;Offset into dispseg -- if -1, not flash
dispseg	dw 0b000h	;Display regen buffer segment
ptdparm	dw ?		;pointer to tdparm stored in set{wp}.wp
			;Low byte mode.  High byte bit flag
gwpc	dd ?		;address to get a WP char (WP - incar_f)
pwpc	dd ?		;address to put a WP char (WP - conot_f)
tdbflg	db 0		;text driver bit flag byte.  
			;bit 7 - set if dos font saved on entry to WP
			;bit 6 - set if dos palette saved on entry to WP
attr	db 0		;set up in wpstart
nattr	db 0		;set up in wpstart
ppck1	dw ?		;pointer to packet 1
ppck2	dw ?		;pointer to packet 2
pcmap	dw ?		;pointer to char_map
	dw ?		;segment for data
chars	dw ?
pcmap2	dw ?		;pointer to char_map2
	dw ?
chars2	dw ?

sc_type		db 0			;Physical screen type
sc_logic	db 0			;Logical screen type
			;The logical screen type is always one of these:
			;CGA_SC
			;EGACO128_SC
			;MON_SC
			;HRF_SC
			;HIC_SC
sync		db 0			;Flash/sync flag
			;bit 0 = 1 (NO_SYNC) if it doesn't wait for sync
			;bit 1 = 1 (NO_FLSH) if no flash of any kind or used /nf
			;bit 2 = 1 (NVRSYNC) if sync does not work or used /ns
monitor		db 0			;Holds monitor type returned by inishw
					;(not used by WP)
			;0 means monochrome
			;1 means color
			;2 means b&w
usr_mt		db ?			;User specified monitor type on cmdline
usr_mono	db 0
in_strt		db 0			;Non-zero if we are in startup code
fixflgs		db 0			;/f1 and /f2 flags
					;  bit 0 = 1: /f1 used (if they tell
					;		us cursor is at 6,7
					;		then believe them
					;  bit 1 = 1: /f2 used (preserved text
					;		modes better)
;The following info is used to keep track of which attributes are hardware.
;The attributes like blink have the bit set which it uses as that bit.
;If an attribute is a 0, it is not available in hardware.
hd_mskh		dw	0
hd_mskl		dw	0

intens		db	0
blink		db	0
overstk		db	0
undrln		db	0
revers		db	0
att_lo		dw	0
att_hi		dw	0
chrs512		db	0

;The following is used to keep track of what the attributes map to.
;The map (lookup table) looks like the following:
;		+------------------------------------------------+
;		|        (BYTE)          |    (DOUBLE WORD)      |
;		| Displayable attributes |    WP attributes      |
;		+------------------------+-----------------------+
;		|        01000110        |    0100100100010100   |
;		+------------------------+-----------------------+
;		|        01000010        |    0001100101000000   |
;		+------------------------+-----------------------+
;		|        00000010        |    0100100000000000   |
;		+------------------------+-----------------------+
;		...
;The table is created by IN_EGA or IN_XXX and to find what to use
;WP searches down the WP attributes to find the Displayable attributes.
;If the WP attribute is not found, the default (last entry) is used.
;First though, the hardware bits are masked off and saved, and then
;the search is done, and then the harware bits are ORed back in (since
;they can be displayed no matter what).

;The following lines must stay together!!!
ent		db 0
att_tbl		db ATT_SPC dup(0)
hdw_lo		dw 0
hdw_hi		dw 0
clrschnam	dw 40 dup(0)		;color scheme name
egafindx	db ?			;ega font index
hrffindx	db ?			;hercules font index
		dw ?			;filler word so packet stuff works
;Variables for getting the correct font and character map combination.

;Each of the below font names must be 13 bytes in length.
;ega_fnt_indx indexes into the appropriate font.
hrf_fnt_nms	db "hrf12.frs",0,0,0,0
		db "hrf6.frs",0,0,0,0,0
hrf_ch_nms	db "hrf12.chm",0,0,0,0
		db "hrf6.chm",0,0,0,0,0
ega_fnt_nms	db "egaital.frs",0,0
		db "egaund.frs",0,0,0
		db "egasmc.frs",0,0,0
		db "ega512.frs",0,0,0
ega_ch_nms	db "ega512.chm",0,0,0
vga_fnt_nms	db "vgaital.frs",0,0
		db "vgaund.frs",0,0,0
		db "vgasmc.frs",0,0,0
		db "vga512.frs",0,0,0
vga_ch_nms	db "vga512.chm",0,0,0
pinit_sc	dd 0
psetatt		dd 0
pvdhk1_f	dd 0			;pointer to WP hook 1
pvdhk2_f	dd 0			;pointer to WP hook 2
dis_off		dw	0		;save dispoff returned from vinit
dis_seg		dw	0		;save dispseg returned from vinit
pftpck		dd	0	;pointer to ftpck_f routine in wpcach
torg	db	0		;text or graphic bit flag
				;used in external video driver code
vd_jtp	dd	0		;ptr to video driver jump table
				;this pointer holds floating segment
vd_add	dd	0		;video driver routine address in cache
mse_tmsk db	0		;mouse text cursor mask
pcvnam	dw	0		;pointer to cvnam = "WP}WP{.CHK",0
				;this is used as template for font file
				;names
puwplen	dw	0		;pointer to unshared wordperfect path

;End parameter block
WP	ENDS 

;packet 1 structure
PCK1	STRUC
ega_fnt_indx	db 0
hrf_fnt_indx	db 0
hic_for		db 0
hic_bac		db 0
hic_cur		db 0
hic_und		db 0
hic_stk		db 0
hic_hig		db 0
sv_sync		db 0
PCK1	ENDS
;Segment 2
;	This segment contain code and data.

CSEG2	SEGMENT PARA PUBLIC 'CODE' 
ASSUME	cs:cseg2;ds:cseg2 
ORG	0 
	jmp	start
;***** 
; JUMP TABLES 
;***** 
				 
;------ Low level driver routines (all should be implemented) 
				 
;WOPEN_TD	equ	0	;open text driver (wp dos)
;WCLOS_TD	equ	2	;close text driver (wp dos)
;MOPEN_TD	equ	4	;open text driver (menu)
;GOPEN_TD	equ	6	;open text driver (after graphic)
;CLOS_TD	equ	8	;close text driver (menu graphic)
;MONT_TD	equ	10	;get monitor type func
;PFA_TD		equ	12	;program, fonts, attribute func
;CFM_TD		equ	14	;color font 'normal' menu overide func

jtab1	DW	wopen_td	;open text driver (wp dos)
	DW	wclos_td	;close text driver (wp dos)
	DW	mopen_td 	;open text driver (menu)
	DW	gopen_td	;open text driver (after graphic)
	DW	clos_td		;close text driver (menu graphic)
	DW	mont_td		;return monitor type
	DW	pfa_td		;program, fonts, attribute func
;	DW	cfm_td		;color font last menu overide func
	DW	-1		;color font last menu overide func
jtab1sz	equ	($-jtab1)/2

;DATA VARIABLES
wpparm	dw	0	;pointer in WP dataseg to parameter block 
oldint10 dd	0	;save old int 10h vector
scur	dw	0	;save cursor
file1	db	'ibm{wp}.frs'
	db	fnlen-11 dup(0)	;path 
	db	13 dup(0)	;file name
suffix	db	IBMFRS,'.FRS',0	;IBM font file is 00
;font stuff
points	dw	?
;format: reg,value    sequencer registers                 graphics controllers
;                     map mask   memory mode  mode reg    misc   read map select
access_a000h   db     2,4,        4,7,        5,0,        6,4,        4,2
protect_a000h  db     2,3,        4,3,        5,10h,      6,0eh,      4,0
file_handle	dw	?
font_buff	db 32 dup(0)
fseg		dw	0		;font segment
color_regs	db	16*3	dup(0)

saveht	db	?		;save variable for character height
savewd	db	?		;save variable for character width
szbtln	dw	?		;save variable for bottom line
szrtcl	dw	?		;save variable for right column
;initjt_f
;desc:	setup the jump table
;in:	es:di -> location to fill in the jump table
;out:	jump table loaded into memory
;ret:	none
;notes:	each jump table entry is a dword
start	label	near
initjt_f	proc	far
	push	ax
	push	bx
	push	cx
	push	di
	mov	cx,jtab1sz		;number of entries in jtab1
	mov	bx,ofs jtab1		;cs:bx -> jtab1
ijt10:	mov	ax,cs:[bx]		;get offset of routine
	stosw				;save offset at es:di
	mov	ax,cs			;get segment of routine
	stosw				;save segment at es:di
	inc	bx			;next entry in table
	inc	bx			;	/
	loop	ijt10			;get next routine
	pop	di
	pop	cx
	pop	bx
	pop	ax
	ret
initjt_f	endp
;wopen_wp
;desc:	This routine is called at a start up time and on return from
;	an exit to dos command.  
;in:	ds:di = WP parameter block
;out:
;ret:	cy = 1	error.  Invalid text driver.  Usually set when driver
;		does not pass validity test.
; 
wopen_td	proc	far 
	push	si
	mov	wpparm,di	;save ptr to WP parameter block
	mov	si,wpp.ptdparm	;pointer to tdparm
	mov	ax,[si]		;load tdparm into ax
	and	wpp.tdbflg,not TDF_FONT	
				;default font not loaded
	cmp	ax,MODE5	;mode5
	 je	wpn10		;yes - don't save font
	cmp	ax,MODE6	;mode6
	 je	wpn10		;yes - don't save font
	cmp	ax,MODE7	;mode7
	 je	wpn10		;yes - don't save font
	cmp	ax,MODE8	;mode8
	 je	wpn10		;yes - don't save font
	call	save_font
	or	wpp.tdbflg,TDF_FONT	;tell tdbflg that font was saved
wpn10:	mov	al,wpp.ht		;save character height
	mov	cs:saveht,al		;	\
	mov	al,wpp.wdcol		;save character width
	mov	cs:savewd,al		;	\
	mov	ax,wpp.zbtln		;save current bottom line
	mov	cs:szbtln,ax		;	\
	mov	ax,wpp.zrtcl		;save current right column
	mov	cs:szrtcl,ax		;	\
	mov	wpp.mse_tmsk,077h	;set mouse text cursor mask
	clc
	pop	si
	ret 
wopen_td	endp 
;wclos_td
;desc:	This routine is called in 2 places within WP.  After an 'exit to dos'
;	function.  At the end of WP.
;in:
;out:
;ret:	none 
; 
wclos_td		proc	far 
	push	di
	push	bx
	mov	di,wpparm
	mov	ah,5
	mov	al,wpp.vpage
	int	10h		;set page
	mov	ah,0
	mov	al,wpp.vmode
	int	10h		;set mode
     	mov	al,cs:saveht	;restore character height
	mov	wpp.ht,al	;	\
	mov	al,cs:savewd	;restore character width
	mov	wpp.wdcol,al	;	\
	mov	ax,cs:szbtln	;restore bottom line
	mov	wpp.zbtln,ax	;	\
	mov	ax,cs:szrtcl	;restore right column
	mov	wpp.zrtcl,ax	;	\
	test	wpp.tdbflg,TDF_FONT	;restore font ?
	 je	wcls10			;no
	call	rest_font
	and	wpp.tdbflg,not TDF_FONT	;turn font flag off
	mov	ax,1202h		;restore to 400 lines
	mov	bl,30h
	int	10h			;400 lines
wcls10:	mov	ax,wpp.vcur
	call	setcur			;restore cursor to vcur value
	pop	bx
	pop	di
	ret 
wclos_td	endp 
;mopen_td
;desc:	Initialize text driver from a menu selection.  This code is called
;	after a user has made a text driver selection from the setup graphic
;	text driver selection menu within WP.
;in:	ds:di = WP parameter block
;out:
;ret:	cy = 1	error.  Invalid text driver.  Usually set when driver
;		does not pass validity test.
; 
mopen_td	proc	far 
	push	si
	mov	wpparm,di	;save ptr to WP parameter block
	mov	al,wpp.ht		;save character height
	mov	cs:saveht,al		;	\
	mov	al,wpp.wdcol		;save character width
	mov	cs:savewd,al		;	\
	mov	ax,wpp.zbtln		;save current bottom line
	mov	cs:szbtln,ax		;	\
	mov	ax,wpp.zrtcl		;save current right column
	mov	cs:szrtcl,ax		;	\
	mov	si,wpp.ptdparm	;pointer to tdparm
	mov	ax,[si]		;load tdparm into ax
	cmp	ax,MODE4	;is this ega mode 4?
	 je	mpn10		;yes - skip vga test save code
	cmp	ax,MODE6	;is this ega mode 6
	 je	mpn10		;yes
	cmp	ax,MODE7	;is this ega mode 7
	 je	mpn10		;yes
	cmp	ax,MODE8	;is this ega mode 8
	 je	mpn10		;yes
	cmp	ax,MODE9	;is this ega mode 9
	 je	mpn10		;yes
	mov	ax,1a00h	;see if vga color or mono
	int	10h
	cmp	al,1ah		;valid return
	 jne	mpn80		;not vga mcga - return error
	cmp	bl,DCC_VGAC	;is active display vga color
	 je	mpn10		;yes so jmp
	cmp	bh,DCC_VGAC	;is inactive display vga color
	 je	mpn10		;yes so jmp
	cmp	bl,DCC_VGAM	;is active display vga mono
	 je	mpn10		;yes
	cmp	bh,DCC_VGAM	;is inactive display vga mono
	 je	mpn10		;yes
	jmp short	mpn80		;not vga color or mono so 
				;return with error

mpn10:	and	wpp.tdbflg,not TDF_FONT	;okay - tell tdbflg no font was saved
	clc				;clear carry
	jmp short	mpn90

mpn80:	stc				;error return - set carry
mpn90:	pop	si
	mov	wpp.mse_tmsk,077h	;set mouse text cursor mask
	ret 
mopen_td	endp 
;;gopen_td
;desc:	Initialize text driver after a graphic function.
;in:	ds:di = WP parameter block
;out:
;ret:	cy = 1	error.  Invalid text driver.  Usually set when driver
;		does not pass validity test.
; 
gopen_td	proc	far 
	mov	wpparm,di	;save ptr to WP parameter block
	mov	al,wpp.ht		;save character height
	mov	cs:saveht,al		;	\
	mov	al,wpp.wdcol		;save character width
	mov	cs:savewd,al		;	\
	mov	ax,wpp.zbtln		;save current bottom line
	mov	cs:szbtln,ax		;	\
	mov	ax,wpp.zrtcl		;save current right column
	mov	cs:szrtcl,ax		;	\
	clc
	ret 
gopen_td	endp 
;clos_td
;desc:	Close down text driver within WP.  This routine is called in two 
;	places.  
;	1.  	A text driver from the menu options is successfully 
;		selected and the current text driver must be closed down.  
;	2.	A graphics function (print preview, figure edit) is going 
;		to be loaded over the exiting text driver.
;in:
;out:
;ret:	none 
; 
clos_td	proc	far 
	push	bx
	mov	ax,1202h		;restore to 400 lines
	mov	bl,30h
	int	10h			;400 lines
	mov	di,wpparm	;get wp parameter pointer
	mov	al,cs:saveht	;restore character height
	mov	wpp.ht,al	;	\
	mov	al,cs:savewd	;restore character width
	mov	wpp.wdcol,al	;	\
	mov	ax,cs:szbtln	;restore bottom line
	mov	wpp.zbtln,ax	;	\
	mov	ax,cs:szrtcl	;restore right column
	mov	wpp.zrtcl,ax	;	\
	pop	bx
	ret
clos_td	endp 
;mont_td 
;desc:	Return monitor type to WordPerfect.  This routine take place of
;	WP routine 'monitor_type' in wpsio.asm when the external driver
;	is active.
;in:	 
;out:	al = monitor type 
;ret:	none 
; 
mont_td	proc	far 
	mov	ax,1A00h	;do DCC test for VGA
	int	10h
	cmp	al,1Ah
	 jne	mtd10			;Not a VGA
	mov	al,VGA_SC
	jmp short	mtd90

mtd10:	mov	al,EGAEM128_SC		;Default to EGA
mtd90:	ret 
mont_td	endp 
;pfa_td
;desc:	This routine is called before WordPerfect programs the video card.
;	(in_xxx routines internal to WP).
;in:	 ds = dataseg in WordPerfect
;out:
;ret:	cy = 1 skip wp hardware programming
; 
pfa_td	proc	far 
	push	di
	push	si
	mov	di,wpparm		;save ptr to WP parameter block
	call	set_tmode		;program mode
	clc				;let wp do hardware programming
	pop	si
	pop	di
	ret 
pfa_td	endp 
;cfm_td
;desc:	This routine is called when the first colors/fonts screen is
;	displayed.  The cursor is positioned to the beginning of the last
;	entry.  It can be used to modify the menu.
;in:	 
;out:
;ret:	none 
; 
cfm_td	proc	far 
	ret 
cfm_td	endp 
;set_tmode 
;desc:	Initialize text mode.
;
;in:	ds:di = points to WP parameter block 
;out:
;ret:	cy = error if set 
; 
set_tmode	proc	near 
;check modes 
	push	si
	mov	ax,wpp.vcur	;default cursor for all modes except
	mov	cs:scur,ax	;mode7 and mode9 - force cursor
	mov	si,wpp.ptdparm	;pointer to tdparm
	mov	ax,[si]		;load tdparm into ax
	pop	si
	cmp	ax,MODE8	;mode8
	 jne	intd05		;no 
	xor	ah,ah		;set the mode
	int	10h
	mov	bx,25-1		;set # rows
	jmp short	intd50 
				 
intd05:	cmp	ax,MODE1	;mode1
	jne	intd10		;no 
	xor	ah,ah		;set the mode
	int	10h
	mov	ax,1111h	;load 8x14 ROM Monochrome font
	xor	bl,bl		;font block 0
	int	10h		;load font with crt programming so that
				;character height is set
	mov	bx,28-1		;set # rows
	jmp short	intd50 
				 
intd10:	cmp	ax,MODE2	;mode2
	 je	intd15		;yes
	cmp	ax,MODE5	;mode5 vga 80x50 no font save
	 jne	intd20		;no - continue
intd15:	xor	ah,ah		;set the mode
	int	10h
	mov	ax,1112h	;load 8x8 double dot ROM font
	xor	bl,bl		;font block 0
	int	10h		;load font with crt programming so that
				;character height is set
	mov	bx,50-1		;set # rows
	jmp short	intd50 

intd20:	cmp	ax,MODE3	;mode3
	je	intd30		;yes
	cmp	ax,MODE6	;mode6
	je	intd30		;yes
	cmp	ax,MODE7	;mode7
	je	intd30		;yes
	cmp	ax,MODE9	;mode9
	je	intd30		;yes
	cmp	ax,MODE4	;mode4
	jne	intd90		;no - error return 
intd30:	push	ax
	xor	ah,ah		;set the mode
	int	10h
	mov	ax,1201		;set line resolution to 350
	mov	bl,30
	int	10h		;350 lines
	mov	ax,1112h	;load 8x8 double dot ROM font
	xor	bl,bl		;font block 0
	int	10h		;load font with crt programming so that
				;character height is set
	pop	ax
	cmp	ax,MODE7	;mode7
	 je	intd33		;yes
	cmp	ax,MODE9	;mode9
	 jne	intd35		;no
intd33:	mov	cs:scur,405h		;force cursor definition
intd35:	mov	bx,43-1		;set # rows
	
intd50:	push	ax
	push	es			;set equipment flag for color 80x25
	xor	ax,ax			;clear ax
	mov	es,ax			;es -> bios segment
	and	by es:[0410h],0cfh	;set video mode bits in 40:10 to
	or	by es:[0410h],20h	;10
	pop	es			;restore registers
	pop	ax
	mov	wpp.wdcol,8		;default for all modes
	mov	wpp.zrtcl,79		;default for all modes 
	mov	wpp.zbtln,bx		;set # rows
	mov	wpp.dispseg,0b800h	;video frame buffer segment address 
	mov	wpp.dispoff,0		;flash mode 
	mov	ax,cs:scur		;get scur
	call	setcur			;set the cursor
	push	ax
	push	es
	xor	ax,ax			;clear ax
	mov	es,ax			;es -> bios segment
	mov	ax,es:[0485h]		;get rasters per character
	mov	wpp.ht,al		;put in ht
	pop	es
	pop	ax
	mov	ax,1003h		;make sure blink is disabled
	xor	bx,bx			;	\
	int	10h			;	\
	clc
	jmp short	intd95

intd90:	stc			;error default
intd95:	ret 
set_tmode	endp 
;save_font
;desc:	Get font 0 from VGA board and store in file 'file1'.
;in:	ds:di = WP parameter block
;out:
;ret:	none 
; 
save_font	proc	near
	push	ax
	push	bx
	push	cx
	push	dx
	push	es
	push	ds
	push	bp
	push	di
	push	si
	call	lfilen		;load correct ushared product path and 
				;name (may be network version)

;get color registers
	mov	ax,1017h	;Read block of color registers
	mov	bx,0		;starting at 0
	mov	cx,16		;sixteen registers
	push	cs
	pop	es		;es = cs
	mov	dx,offset color_regs
	int 	10h

;open file
	mov	ax,cs
	mov	ds,ax		;ds = cs
	mov	dx,offset file1
	xor	cx,cx
	mov	ah,3ch
	int	21h		;open file
	 jc	sfnt80		;error forget it
	mov	bx,ax		;bx = file handle

;write out color registers
	mov	ah,40h
	mov	cx,3*16
	mov	dx,offset color_regs
	int	21h
	 jc	sfnt70		;if error forget it

;get points of character cell -- assume font 0
	xor	ax,ax
	mov	es,ax		;es = segment 0
	mov	ax,es:[485h]
	mov	points,ax	;get points from bios
	mov	dx,offset points
	mov	cx,2
	mov	ah,40h
	int	21h		;write out points to file
	 jc	sfnt70		;if error forget it
;set registers so font can be read
	mov     si,offset access_a000h	;point to access parameters.
        call    set_regs		;set the registers.

	mov     cx,points               ;retrieve bytes/character.
	mov     ax,0a000h               ;point to font segment.
	mov     ds,ax
	mov     bp,256                  ;256 characters.
	xor     dx,dx                   ;source starting offset of zero.

next_char:
					;cx = points character cell
					;bx = file handle
					;dx = offset into font ram
					;ds = a000h
	mov	ah,40h			;write to file
					;ds:dx point to font character
	int	21h
	 jc	sfnt70			;if error forget it
	add     dx,20h                  ;next character two paragraphs.
	dec     bp                      ;do all 256 characters.
	 jnz     next_char

	push	cs
	pop	ds			;ds = cs
	mov     si,offset protect_a000h ;point to normal parameters.
	call	set_regs

sfnt70: mov	ah,3eh		;close file handle
				;bx = file handle
	int	21h		;close it

sfnt80:	pop	si
	pop	di
	pop	bp
	pop	ds
	pop	es
	pop	dx
	pop	cx
	pop	bx
	pop	ax
sfnt90:	ret
save_font	endp
;rest_font
;desc:	Restore font from file that was saved on entry.
;in:	ds:di = WP parameter block
;out:
;ret:	none 
; 
rest_font	proc	near
	push	ax
	push	bx
	push	cx
	push	dx
	push	es
	push	ds
	push	bp
	push	di
	push	si
	mov	wpparm,di

	call	lfilen		;load correct ushared product path and 
				;name (may be network version)

;open file
	mov	ax,cs
	mov	ds,ax		;ds = cs
	mov	es,ax		;es = cs
	mov	dx,offset file1
	mov	ax,3d00h
	int	21h		;open file read only
	 jnc	rfnt10		;okay continue
	 jmp	rfnt80		;error forget it

rfnt10:	mov	file_handle,ax	;save file handle

;get color registers info
	mov	ah,3fh
	mov	bx,file_handle
	mov	dx,offset color_regs
	mov	cx,16*3
	int	21h			;retrieve color regs

;load color register 
	mov	ax,1012h	;Set block of color registers
	mov	bx,0		;starting at 0
	mov	cx,16		;sixteen registers
	mov	dx,offset color_regs
	int 	10h

;go get font
	mov	ah,3fh
	mov	bx,file_handle		;bx = filehandle
	mov	dx,offset points
	mov	cx,2
	int	21h			;get points

;set registers so font can be written
	mov     si,offset access_a000h	;point to access parameters.
        call    set_regs		;set the registers.
	mov	fseg,0a000h
	mov	di,256			;# characters
	xor	si,si
popf10:	mov	ah,3fh
	mov	bx,file_handle		;bx = filehandle
	mov     cx,points               ;retrieve bytes/character.
	mov	dx,offset font_buff
	int	21h			;get a character from file
	 jc	rfnt70			;error jump
	push	si			;prepare to load font into
	push	di			;font memory
	push	es
	mov	cx,points		;# bytes per character
	mov	si,offset font_buff	;where char font is stored	
	mov	ax,fseg			;destination segment 
	mov	es,ax
	xor 	di,di
	rep	movsb			;move font
	add	ax,2			;inc segment by 2 paragraphs
	mov	fseg,ax			;save segment
	pop	es
	pop	di
	pop	si
	inc	si			;point to next 
	dec	di
	 jne	popf10

rfnt70: mov	ax,1110h		;setup for user alpha load of font
	mov	cx,points		;set correct # lines per char
	mov	bh,cl			;get points
	mov	bl,0			;target block
	mov	cx,1			;1 character
	dec	si			;si points to previous character
					;0 - 255
	mov	dx,si			;offset into target table
	mov	bp,offset font_buff	;es:bp = font_buff
	int	10h			;load the character
	mov     si,offset protect_a000h	;point to access parameters.
        call    set_regs	;set the registers.
	mov	ah,3eh		;close file handle
	mov	bx,file_handle	;bx = file handle
	int	21h		;close it

rfnt80:	pop	si
	pop	di
	pop	bp
	pop	ds
	pop	es
	pop	dx
	pop	cx
	pop	bx
	pop	ax
rfnt90:	ret
rest_font	endp
set_regs	proc	near

	mov     cx,2                    ;two sequencer registers.
	mov     dx,3c4h                 ;indexing register.
	call    next_register

	mov     cx,3                    ;three graphics controller regs.
	mov     dl,0ceh                 ;indexing registers.

next_register: 
	lodsb                           ;get index.
	out     dx,al
	inc     dx
	lodsb                           ;get value.
	out     dx,al
	dec     dx
	loop    next_register
	ret
set_regs	endp
;lfilen
;desc:	Load file name from wp unshared directory.
;in:	ds:di = WP parameter block
;out:	al - # rows
;	     
;ret:	none 
; 
lfilen	proc	near
	push	es
	push	di
	push	ds
	push	si
	mov	al,1		;do function 1
	call	dword ptr [di.pvdhk1_f]	;call vdhk1_f on wp side
	 jc	lfil90			;not implemented
				;success - bx pts to ushared wp
				;	   dx pts to check file
	push	cs
	pop	es		;es = cs
	mov	si,bx		;pointer ushared wp path len
	lodsw	
	mov	cx,ax		;put len of ushared wp path into cx
	mov	ax,di		;save di
	mov	di,ofs file1	;dest is file buffer
	rep	movsb		;load path
	push	di		;save pointer in buffer
	mov	di,ax		;restore ds:di = wp parameter block
	mov	si,dx		;source is now "WP}WP{.CHK" check filename
				;string
	pop	di		;restore pointer to buffer
	mov	cx,6
	rep	movsb		;load product prefix and possible network
				;initials into buffer
	mov	si,ofs suffix
	mov	cx,7
	push	cs
	pop	ds		;ds = cs
	rep	movsb		;load suffix

lfil90:	pop	si
	pop	ds
	pop	di
	pop	es
	ret
lfilen	endp
;setcur
;desc:	Set the cursor as defined by save variable scur.
;in:	ax = cursor definition
;out:	none
;ret:	none
;type:	
;notes:	
;
setcur	proc	near
	push	ax
	push	cx
	push	bx
	mov	cx,ax
	mov	ah,1
	mov	bh,wpp.vpage	;make sure video page is correct
	int	10h		;call BIOS
	pop	bx
	pop	cx
	pop	ax
	ret
setcur	endp
CSEG2	ENDS 
END 
