;name	wpsft.inc
;title	WordPerfect Scaleable Font Technology Driver Structure
;
;  Copyright (C) 1987,1992 WordPerfect Corp., All Rights Reserved
;SFT prefix
drvr_nearjmp	equ	0		;(3 bytes) near jump to init routine
drvr_majver	equ	drvr_nearjmp+3	;(byte) major version number
drvr_minver	equ	drvr_majver+1	;(byte) minor version number
drvr_wpcindex	equ	drvr_minver+1	;(byte) WP call index (routine specifier)



;WordPerfect to Driver Parameter Data Block

WP_drvr1_param	equ	drvr_wpcindex+1	;(word) parameter data block entry 1
WP_drvr2_param	equ	WP_drvr1_param+2	;(word) parameter data block entry 2
WP_drvr3_param	equ	WP_drvr2_param+2	;(word) parameter data block entry 3
WP_drvr4_param	equ	WP_drvr3_param+2	;(word) parameter data block entry 4
WP_drvr5_param	equ	WP_drvr4_param+2	;(word) parameter data block entry 5
WP_drvr6_param	equ	WP_drvr5_param+2	;(word) parameter data block entry 6
WP_drvr7_param	equ	WP_drvr6_param+2	;(word) parameter data block entry 7
WP_drvr8_param	equ	WP_drvr7_param+2	;(word) parameter data block entry 8
WP_drvr9_param	equ	WP_drvr8_param+2	;(word) parameter data block entry 9
WP_drvr10_param	equ	WP_drvr9_param+2	;(word) parameter data block entry 10

;Driver to WordPerfect Parameter Data Block
drvr_WP1_param	equ	WP_drvr10_param+2	;(word) parameter data block entry 1
drvr_WP2_param	equ	drvr_WP1_param+2	;(word) parameter data block entry 2
drvr_WP3_param	equ	drvr_WP2_param+2	;(word) parameter data block entry 3
drvr_WP4_param	equ	drvr_WP3_param+2	;(word) parameter data block entry 4
drvr_WP5_param	equ	drvr_WP4_param+2	;(word) parameter data block entry 5
dr_pfxsz	equ	drvr_WP5_param+2	;------ fixed size of driver prefix
;Character Map Data Block Structure
;The fields in this data block are defined to be whatever the specific font
;manufacturer decided to put in the character map GMAP(value,string,value)
;function.
cm_1val		equ	0		;(word) Integer
cm_2val		equ	cm_1val+2	;(word) Integer
cm_str		equ	cm_2val+2	;(62 bytes) String
cm_end		equ	cm_str+62	;----- Fixed length Char Map Var block
;Output Mode Types
WPBitmap	equ	1	;WP Bitmap Format
WPVec		equ	2	;WP Vectors (Lines, PolyLines, No Curves)
WPBez		equ	4	;WP Curves (Lines, PolyLines, Curves, PolyCurves)

;WP format for header
bchrw	equ	0		;(byte) character width              (pixels)
bchrh	equ	bchrw+1		;(byte) character height             (pixels)
bchrx	equ	bchrh+1		;(word) signed character x offset in cell   (pixels)
bchry	equ	bchrx+2		;(word) signed character y offset in cell   (pixels)
;graphic context structure
trm11	equ	0		;(dword)
trm12	equ	trm11+4		;(dword)
trm13	equ	trm12+4		;(dword)
trm21	equ	trm13+4		;(dword)
trm22	equ	trm21+4		;(dword)
trm23	equ	trm22+4		;(dword)
trm31	equ	trm23+4		;(dword)
trm32	equ	trm31+6		;(hiword + dword fixed point)
trm33	equ	trm32+6		;(dword)
scalex	equ	trm33+4		;(dword)
scaley	equ	scalex+4	;(dword)
omode	equ	scaley+4	;(word) output mode
gcsiz	equ	omode+2		;size of graphic context structure
;Driver Routine Call Numbers
call_sft_nfont		equ	0
call_sft_bsize		equ	1
call_sft_mbit		equ	2
call_sft_close		equ	3
call_sft_width		equ	4
call_sft_otype		equ	5
;WP Routines Call Numbers
call_wp_alloc_float	equ	0
call_wp_dealloc_float	equ	1
call_wp_size_float	equ	2
call_wp_locate_float	equ	3
call_wp_alloc_fixed	equ	4
call_wp_dealloc_fixed	equ	5
call_wp_file_open	equ	6
call_wp_file_close	equ	7
call_wp_file_read	equ	8
call_wp_file_seek	equ	9
call_wp_conc_matrix	equ	10
call_wp_path_get	equ	11
call_wp_lock_float	equ	12
call_wp_unlock_float	equ	13
;--------I/O Defines
SEEK_SET	equ	0	;set from files beginning
SEEK_CUR	equ	1	;set relative from current position
SEEK_END	equ	2	;set from end of file (file size)

O_RDONLY equ	01h
O_WRONLY equ	02h
O_CREAT  equ	0100h

;*************** Additional Data Area ***************
pfbufsz	equ	258			;size of font file prefix area
stksz	equ	650			;size of driver stack

ffname		equ	dr_pfxsz	; font filename
bostk		equ	ffname+13	; bottom of stack
tostk		equ	bostk+stksz	; top of stack
oldss		equ	tostk		; old stack segment
oldsp		equ	oldss+2		; old stack pointer
gcont		equ	oldsp+2		;graphic context buffer
dataend		equ	gcont+gcsiz	; end of this data
?wpok	equ	0
?wperr	equ	1
;*********************** End Data Area **********************
;DOS errors
er_invf		equ	1	;invalid function number
er_notf		equ	2	;file not found
er_path		equ	3	;path not found
er_fhan		equ	4	;no handles left
er_accd		equ	5	;access denied
er_invfh	equ	6	;invalid handle
er_memcb	equ	7	;memory control blocks destroyed
er_nomem	equ	8	;insufficient memory
er_memba	equ	9	;invalid memory block address
er_env		equ	10	;invalid environment
er_format	equ	11	;invalid format
er_accod	equ	12	;invalid access code
er_invdt	equ	13	;invalid data
;14 reserved
er_drive	equ	15	;invalid drive specified
er_cdir		equ	16	;attempt to remove the current directory
er_nsdev	equ	17	;not same device
er_nofils	equ	18	;no more files
er_inver	equ	148h	;wrong version (generic)