/* File EXAMPLE6.C
   Title Example of a DOAPI Program that uses the WP 5.x DOAPI Library

        Copyright (C) 1990 WordPerfect Corp., All Rights Reserved 
        COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION 
----------------------------------------------------------- */ 
/***************************************************************************
 * PROGRAM: Example6.C                                                     *
 *                                                                         *
 * PURPOSE:                                                                *
 * To deminstrate how to hook your own C program into the WordPerfect      *
 * Corp. product, 6.0 level DOAPI using the WPLIB60.OBJ library.           *
 *                                                                         *
 * FUNCTIONS:  main                                                        *
 *               Initalize variables and spawn WP.COM.                     *
 *             KeyHandler                                                  *
 *               Called (through the WPLIB60.OBJ translation layer) by     *
 *               WP 6.0.  This routine does all the manipulation of WP     *
 *               keys in WP6.0 dialog boxes only.                          *
 *             TokenHandler                                                *
 *               Called (through the WPLIB60.OBJ translation layer) by     *
 *               WP 6.0.  This routine does all token manipulation.        *
 *             RecordHandler                                               *
 *               Called (through the WPLIB60.OBJ translation layer) by     *
 *               WP 6.0.  This routine allows DOAPI program to see what    *
 *               tokens and assocated parameters were actually executed    *
 *               by WP 6.0.                                                *
 *               Currently this function is inactive.  To use this         *
 *               function you must have a dot matrix printer connected to  *
 *               your PC.  Make sure the printer is on and online.         *
 *               To activate the RecordHandler statement, find the program *
 *               statement "RecordH=0;".  Replace the zero with            *
 *               "RecordHandler" and recomplile and link the program.      *
 *                                                                         *
 * GLOBAL VARIABLES:                                                       *
 *    fp: This is the file pointer used by RecordHandler function (if      *
 *        RecordHandler function is activated).                            *
 *    bufA: This array represents the parameters for a "Type" token to     *
 *          send the upper case letter 'A' to WP.                          *
 *    bufc: This array represents the parameters for a "Type" token to     *
 *          send the lower case letter 'c' to WP.                          *
 *    bufName: This array is used to hold the file name of the current     *
 *             document.  Then it is used as the parameters to a "Type"    *
 *             token to return the file name to WP.                        *
 *    printflag: This variable is used to see if the DOAPI program received*
 *               valid data back from a merge variable.                    *
 *    MergeVarName: WP word string that represents the name of a merge     *
 *                  variable.                                              *
 *    MrgPtr: A far pointer used to insure that when "MergeVarName is      *
 *            passed to a function, it is passed as a far pointer and not  *
 *            a near pointer.                                              *
 *    MergeData: Variable used to hold the data received from a merge      *
 *               variable for later printing to the screen.                *
 ***************************************************************************/

#include <stdio.h>
#include <process.h>
#include <io.h>
#include <sys\stat.h>
#include <sys\types.h>
#include <fcntl.h>
#include "doswp60.h"	/* Required .h file for external definitions */

/***********************
 * Function Prototypes *
 ***********************/
unsigned int far KeyHandler (unsigned int wpkey);
unsigned int far TokenHandler (unsigned int far *Token,
						unsigned char far *(far *Parm));
int far RecordHandler (unsigned int Token,
						unsigned char far *Parm);

/********************
 * Global Variables *
 ********************/
FILE *fp;

unsigned char bufA[5]={1,'A',0,0,0},bufc[5]={1,'c',0,0,0};
unsigned char bufName [27]={1},printflag;
unsigned int MergeVarName [8]={'T','e','s','t','V','a','r',0},far *MrgPtr;
int MergeData=0;

/**************************************************************************
 * FUNCTION: main                                                         *
 *    Does all program setup before WP is spawned and all clean up after  *
 *    WP terminates.                                                      *
 *                                                                        *
 * SUPPORTING SUBFUNCTIONS:                                               *
 *    OpenInterface: Create and set up translation layer between C and WP *
 *    CloseInterface: Does final cleanup and closeing of translation      *
 *                    layer.                                              *
 *                                                                        *
 * LOCAL VARIABLES:                                                       *
 *    KeyH: A far pointer used to point to the KeyHandler function.       *
 *    TokenH: A far pointer used to point to the TokenHandler function.   *
 *    RecordH: A far pointer used to point to the RecordHandler function. *
 *    arg: An array used to setup the arguments in the Spawnlp function.  *
 **************************************************************************/

void main ()
{
 unsigned int (far *KeyH)(),(far *TokenH)();
 int (far *RecordH)();
 char *arg[2]={"WP.COM",0};

 KeyH=KeyHandler;	/* put addresses in pointers to assure they're... */
 TokenH=TokenHandler;	/*...passed as far pointers and not near pointers */
 RecordH=0;		/* change zero to RecordHandler to activate */
 OpenInterface (WordPerfect,KeyH,TokenH,RecordH);
 if (spawnlp (P_WAIT,arg[0],arg[0],arg[1]))
	printf ("ERROR -- WP.COM not found!\n");	
 CloseInterface ();
 if (printflag) printf ("TestVar=%d\n",MergeData);
}

/*****************************************************************************
 * FUNCTION: KeyHandler                                                      *
 *    Called by WP NOT BY FUNCTION main.  This function looks for key        *
 *    commands that have been typed by the user from within a dialog box.    *
 *    Specificlly, the function looks for the '1' character and replaces it  *
 *    with the '3' character.  It looks for the '3' character and replaces   *
 *    it with the '1' character.  All other WP keys are passed on with no    *
 *    change.                                                                *
 *                                                                           *
 * SUPPORTING SUBFUNCTIONS:                                                  *
 *    None                                                                   *
 *                                                                           *
 * PARAMETERS:                                                               *
 *    IN:                                                                    *
 *        wpkey: This is the key code from the WP program.  It will either   *
 *               have some key code or it will be a zero value.              *
 *    OUT:                                                                   *
 *         key code: This is either the same key code WP passed to you, or   *
 *                   the key code you want WP to use instead                 *
 *                                                                           *
 * LOCAL VARIABLES:                                                          *
 *    None                                                                   *
 *****************************************************************************/

unsigned int far KeyHandler (unsigned int wpkey)

{
 switch (wpkey)
 {
 	case '1':
 		return '3';
 	
 	case '3':
 		return '1';
 	default:
 		return wpkey;
 }
}

/*****************************************************************************
 * FUNCTION: TokenHandler                                                    *
 *    Called by WP NOT BY FUNCTION main.  This function does serveral        *
 *    deminstrations of the DOAPI based on "Type" tokens                     *
 *    generated by the user.  For example, when the user types the upper     *
 *    case letter 'A' from the keyboard, the Type token with 'A' as one of   *
 *    its parameters is passed to this function.  When this function         *
 *    receives this token it will return the same token to WP with the 'A'   *
 *    being replaced by the lower case letter 'c'.  Here is a short summary  *
 *    of the type token parameters that are looked for by this function and  *
 *    its reaction to them.                                                  *
 *       Shift+A = send back a lower case 'c'.                               *
 *       c       = send back an upper case 'A'.                              *
 *       Shift+G = If the WP merge variable exists, its data is extracted    *
 *                 loaded into a variable for later printing at the end of   *
 *                 the program.                                              *
 *       Shift+N = Requests WP to send the file name of the current document *
 *                 and then places this name into the Type token to be       *
 *                 displayed on WP's screen.                                 *
 *       Shift+S = Commands WP to create a merge variable called TESTVAR and *
 *                 places data (the integer -15) into TESTVAR.               *
 *       Shift+X = Terminates WP without going through any dialogs.          *
 *                                                                           *
 * SUPPORTING SUBFUNCTIONS:                                                  *
 *    SystemVariable: This function from the WPLIB60.OBJ library is used to  *
 *                    request the file name of the current document.         *
 *    SetMergeVariable: This function from the WPLIB60.OBJ library is used   *
 *                      to create and fill the merge variable TESTVAR.       *
 *    GetMergeVariable: This function from the WPLIB60.OBJ library is used   *
 *                      to read out the data contained in the merge variable *
 *                      TESTVAR.                                             *
 *                                                                           *
 * PARAMETERS:                                                               *
 *    IN:                                                                    *
 *        Token: This is a token value passed by reference.                  *
 *        Parm: This is a far pointer passed by reference.  It points to 1   *
 *              or more parameters assocated with the current token.         *
 *    OUT:                                                                   *
 *        Size: If you change parameters, the size of the new parameter area *
 *              is returned.                                                 *
 *                                                                           *
 * LOCAL VARIABLES:                                                          *
 *    i,j: Used as array indexes                                             *
 *    BufType: Used to detect or to determine the type of data stored in the *
 *             special 8 byte buffer used between WP and your program.  See  *
 *             ReadmeC6.WP for more information.                             *
 *                                                                           *
 * LOCAL CONSTANTS:                                                          *
 *    -15: This is just some value to be put into the TESTVAR variable.      *
 *         Outside of this context it has no special meaning.                *
 *    WP_Type: Token value for the Type token                                *
 *    _DATA_PRESENT_: Token parameter constant represents an indicator that  *
 *                    there is data in the parameter area.                   *
 *    Wp_ExitWordPerfect: WP token to command WP program to terminate.       *
 *    T3Integer: Value indicates that data in special 8 byte buffer is in    *
 *               signed short integer format.  See READMEC6.WP for more info *
 *    WP_NullToken: Value used to block an existing token so that WP does    *
 *                  nothing.                                                 *
 *    T0DataError: Value indcates that there was an error in trying to get   *
 *                 the data that was to go into the special 8 byte buffer.   *
 *                 See READMEC6.WP for more information.                     *
 *****************************************************************************/


unsigned int far TokenHandler (unsigned int far *Token,
						unsigned char far *(far *Parm))
{
 int i,j,BufType;
 
 DataRequested=&WPRequestedData;
 MrgPtr=MergeVarName;
 if (*Token==WP_Type)
 {
 	if (**Parm==1)			/* if there's only one group (see SDK) */
 	{
 		switch (*(*Parm+1))	/* check 1st char in "Type" parm, char buffer */
 		{
 			case ('A'):
 				*Parm=bufc;
 				return 5;

			case ('c'):
	 			*Parm=bufA;
	 			return 5;
			case ('X'):
 				*Token=WP_ExitWordPerfect;
 				return 0;

			case ('N'):
 				BufType=SystemVariable (WPSYS_Name,DataRequested);
 				j=1;
 				i=0;
				while (WPRequestedData.Type5[i])
				{
					bufName[j]=WPRequestedData.Type5[i];
					j++;
					i++;
					bufName[j]=0;
					j++;
				}
				bufName[j]=0;
				j++;
				bufName[j]=0;
				j++;
 				*Parm=bufName;
 				return j;

			case ('S'):
 				WPRequestedData.Type3=(-15);
 				BufType=T3Integer;
 				SetMergeVariable (MrgPtr,DataRequested,BufType);
 				*Token=WP_NullToken;
 				return 0;

			case ('G'):
 				WPRequestedData.Type3=0;
				BufType=GetMergeVariable (MrgPtr,DataRequested);
				if (BufType != T0DataError)
				{
					printflag=1;
					MergeData=WPRequestedData.Type3;
					*Token=WP_NullToken;
					return 0;
				}
				printflag=0;
				return 0;

			default:
				return 0;
		}
 	}
 }
 return 0;
}

/*****************************************************************************
 * FUNCTION: RecordHandler                                                   *
 *    Called by WP NOT BY FUNCTION main.  This function shows the DOAPI      *
 *    what token and corrisponding token parameters actually made it through *
 *    the DOAPI chain to be executed by WP.  In this example, if you have a  *
 *    dot matrix printer connected to your PC, and it is on and online, and  *
 *    if you have made the code change in the "main" function, this function *
 *    will print the value (in decimal) of each token that passes through    *
 *    this routine.  If you try to activate this function without a printer, *
 *    or the printer is turned off, you will get the "1 Retry  2 Cancel"     *
 *    error when the first token comes through this routine.                 *
 *                                                                           *
 * SUPPORTING SUBFUNCTIONS:                                                  *
 *    None                                                                   *
 *                                                                           *
 * PARAMETERS:                                                               *
 *    IN:                                                                    *
 *        Token: This is is the token value passed by value.                 *
 *        Parm: This is a far pointer passed by value.                       *
 *    OUT:                                                                   *
 *         None                                                              *
 *                                                                           *
 * LOCAL VARIABLES:                                                          *
 *    None                                                                   *
 *****************************************************************************/

int far RecordHandler (unsigned int Token,
						unsigned char far *Parm)
{
 fp = fopen( "lpt1", "w" );
 fprintf (fp,"Token: %u\n",Token);
 fclose(fp);
 return 0;
}
