/* name	DOSWP60.H
   title	WP 6.0 Interface Definitions

   Copyright (C) 1992 WordPerfect Corp., All Rights Reserved
   COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
 ------------------------------------------------------------ */

/****************************************************************************
 * PURPOSE                                                                  *
 *    This file contains all of the definitions, and declarations that are  *
 * necessary and/or may be useful for a C program that is using the         *
 * WPLIB60.OBJ library to hook into a DOS WordPerfect 6.0 level             *
 * WordPerfect Corp. product's DOAPI.                                       *
 *                                                                          *
 * CONTENTS                                                                 *
 *    Tokens  (See WPMRS.WP for info on their parameter structure [if any]) *
 *    Token Parameter Constants                                             *
 *    Key Codes                                                             *
 *    System Variables                                                      *
 *    System/Merge Variable Buffer Data Types                               *
 *    OpenInterface Product Types                                           *
 *    Data Buffer Union Definition                                          *
 *    Lib60.OBJ 'Library' Function External Definitions                     *
 ****************************************************************************/

/*==========================================================================================*
 *                              Tokens                                                      *
 *		 -name-				-value-		-meaning-                   *
 *==========================================================================================*/
#define		WP_NullToken			0
#define		WP_UserFunction			1
#define		WP_HomeKey			8
#define		WP_TabKey			9
#define		WP_EnterKey			10
#define		WP_DeleteToEndOfLine		11
#define		WP_DeleteToEndOfPageDlg		12
#define		WP_UpArrow			23
#define		WP_RightArrow			24
#define		WP_LeftArrow			25
#define		WP_DownArrow			26
#define		WP_RepeatDlg			27
#define		WP_EndClass			31		/* EndClass */
#define		WP_CancelKey			32
#define		WP_SearchDlg			33
#define		WP_Help				34
#define		WP_Indent			35
#define		WP_ListKey			36
#define		WP_BoldKey			37
#define		WP_ExitDlg			38
#define		WP_UnderlineKey			39
#define		WP_EndFieldKey			40
#define		WP_FileSaveDlg			41
#define		WP_SetupKey			44
#define		WP_SearchBackwardDlg		45
#define		WP_SwitchKey			46
#define		WP_IndentLeftRight		47
#define		WP_DateDlg			48
#define		WP_Center			49
#define		WP_PrintDlg			50
#define		WP_FormatDlg			51
#define		WP_MergeCodesDlg		52
#define		WP_FileOpenDlg			53
#define		WP_ColumnDefinition		54		/* column definition */
#define		WP_WritingToolsDlg		56
#define		WP_ReplaceDlg			57
#define		WP_RevealCodesKey		58
#define		WP_BlockKey			59
#define		WP_MarkTextDlg			60
#define		WP_FlushRight			61
#define		WP_ColumnsTablesDlg		62
#define		WP_StyleDlg			63
#define		WP_GraphicsDlg			64
#define		WP_MacroPlayDlg			65
#define		WP_ShellDlg			68
#define		WP_SpellerDlg			69
#define		WP_RewriteKey			70
#define		WP_MoveDlg			71
#define		WP_OutlineDlg			72
#define		WP_TabDecimal			73		/* waln (Decimal Tab, was Tab Align) */
#define		WP_NotesDlg			74
#define		WP_FontDLG			75	/* watrb (Font Key) */
#define		WP_MergeSortDlg			76
#define		WP_MacroRecordDlg		77
#define		WP_DeleteCharPrevious		80
#define		WP_DeleteCharNext		81
#define		WP_DeleteWord			82
#define		WP_PosWordNext			83		/* Ctrl-Right */
#define		WP_PosWordPrevious		84		/* Ctrl-Left */
#define		WP_HomeHomeRight		85		/* whhr (End Key) */
#define		WP_HomeHomeLeft			86		/* whhl (Begin Key) */
#define		WP_MacroControlDlg		87
#define		WP_GoToKey			88
#define		WP_PageUp			89
#define		WP_PageDown			90
#define		WP_ScreenDown			91		/* wscdn (Screen Down) */
#define		WP_ScreenUp			92		/* wscup (Screen Up) */
#define		WP_TypeOver			93		/* wrplc (Typeover) */
#define		WP_ShiftTabKey			94
#define		WP_HardPageBreakKey		95		/* Ctrl-Enter (NewPage) */
#define		WP_SoftHyphen			96
#define		WP_MinusSign			97
#define		WP_HardSpace			98
#define		WP_ParagraphUp			99
#define		WP_ParagraphDown		100
#define		WP_ItemLeft			101
#define		WP_ItemRight			102
#define		WP_ItemUp			103
#define		WP_ItemDown			104
#define		WP_AltHome			105
#define		WP_CtrlNumPlus			106
#define		WP_AltEqual			107
#define		WP_CtrlDelKey			109
#define		WP_CtrlInsKey			110
#define		WP_ConvertCaseDlg		119
#define		WP_Move				121		/* bmwmov (Block Move) */
#define		WP_ComposeDlg			124
#define		WP_Copy				126
#define		WP_QuickFind			129		/*  Find QuickMark (uses the CTRL+F) */
#define		WP_ItalicsKey			132
#define		WP_OutlineEditKey		138
#define		WP_QuickmarkSet			140
#define		WP_SoundClipRecordDlg		141		/* record sound clip */
#define		WP_SoundClipPlayNextDlg		142		/* find sound clip and play while editing */
#define		WP_OutLineTog			143		/* wctlt  outline toggle */
#define		WP_Paste			145		/* paste block file (CTRL+V) */
#define		WP_WPCharDlg			146
#define		WP_Cut				147
#define		WP_Undo				149

#define		WP_WindowMinimize		155		/*  window minimize */
#define		WP_WindowMaximize		156		/*  window maximize */
#define		WP_WindowFrame			157		/*  window normalize */
#define		WP_WindowTile			158		/*  windows tile */
#define		WP_WindowCascade		159		/*  windows cascade */
#define		WP_WindowNext			160		/*  window next */
#define		WP_WindowPrevious		161		/*  window previous */
#define		WP_PrinterControlGo		162		/*  printer control, go */
#define		WP_PrinterControlStop		163		/*  printer control, stop */
#define		WP_PrinterControlCancelImmediate	164		/*  printer control, cancel immediately */
#define		WP_PrinterControlRushImmediate	165		/*  printer control, rush immediately */
#define		WP_MarginLeft			166		/* Left Margin Set */
#define		WP_MarginRight			167		/* Right Margin Set */
#define		WP_Justification		168		/* Justification Set */
#define		WP_PosCharacter			169		/* Goto Character */
#define		WP_Type				170		/* Type 1 Character */
#define		WP_TableCreate			171		/* Table Create */
#define		WP_StyleOn			172		/* Insert a style */
#define		WP_StyleOff			173		/* Turn a style off */
#define		WP_StyleDelete			174		/* delete a style */
#define		WP_StyleCopy			175		/* copy a style */
#define		WP_StyleSave			176		/* save styles */
#define		WP_StyleRetrieve		177		/* retrieve styles */
#define		WP_StyleCreate			178		/* Create a style */
#define		WP_StyleEditBegin		179		/* Edit a style */
#define		WP_StyleCodes			180		/* Edit a style's codes */
#define		WP_OutlineStyleCreate		181		/* Create an outline style */
#define		WP_OutlineStyleEditBegin	182		/* Edit an outline style */
#define		WP_OutlineStyleNumberFormat	183		/* Edit outline style number format */
#define		WP_OutlineStyleLevel		184		/* Assign an outline level style */
#define		WP_MarginTop			185		/* Top Margin Set */
#define		WP_MarginBottom			186		/* Bottom Margin Set */
#define		WP_ForcePage			187		/* Force odd/even/new */
#define		WP_Suppress			188		/* Page suppress */
#define		WP_PageNumberPosition		189		/* Page number position */
#define		WP_BoxCaptionWidth		190			/* BoxCaptionFormatting */
#define		WP_CenterCurrentPage		191		/* Center current page */
#define		WP_CenterPages			192		/* Center pages */
#define		WP_WidowOrphan			193		/* Widow/orphan */
#define		WP_FootnotesSpaceBetween	194		/* Space between footnotes */
#define		WP_EndnotesSpaceBetween		195		/* Space between endnotes */
#define		WP_FootnoteMinimum		196		/* Footnote minimum amount to keep together */
#define		WP_EndnoteMinimum		197		/* Endnote minimum amount to keep together */
#define		WP_FootnoteRestartEachPage	198		/* Footnote number restarts each page */
#define		WP_FootnoteContinuedMessage	199		/* Footnote continued message */
#define		WP_FootnotePosition		200		/* Footnote text position */
#define		WP_FootnoteSeparatorLine	201		/* Footnote separator line */
#define		WP_LineNumbering		202		/* Line Numbering */
#define		WP_DocSummarySave		203		/* document summary save */
#define		WP_Binding			204		/* binding information */
#define		WP_DocSummaryPrint		205		/* document summary print */
#define		WP_RepeatValue			206		/* repeat */
#define		WP_RepeatSet			207		/* set repeat */
#define		WP_TableBorder			208		/* Table Border */
#define		WP_ToADefinitionStyle		209		/* edit toa def style */
#define		WP_ListDefinitionStyle		210		/* edit list def style */
#define		WP_ToCDefinition		211		/* toc definition */
#define		WP_IndexDefinition		212		/* index definition */
#define		WP_ToADefinition		213		/* toa definition (select) */
#define		WP_IndexMark			214		/* mark index */
#define		WP_Fax				215		/* Main Fax dialog */
#define		WP_FileDelete			216		/* delete file */
#define		WP_DirectoryRemove		217		/* remove directory */
#define		WP_DirectoryDefault		218		/* other directory */
#define		WP_DirectoryCreate		219		/* make directory */
#define		WP_PrintDocOnDisk		220		/* disk print */
#define		WP_OutlineStyleSelect		221		/* outline define */
#define		WP_OutlineSetParagraphNumber	222		/* outline starting paragraph number */
#define		WP_FileMoveRename		223		/* move/rename file */
#define		WP_FileCopy			224		/* copy file */
#define		WP_TablePosition		225		/* table position */
#define		WP_FormatCharacterDlg		226		/* format character dialog */
#define		WP_ToADefinitionCreate		227		/* toa def prefix */
#define		WP_ToADefinitionDelete		228		/* toa def delete */
#define		WP_ToADefinitionRename		229		/* toa def rename */
#define		WP_CreateSummaryOnSaveExit	230		/* setup: doc mgmt/summ create summ on save/exit */
#define		WP_SubjectSearchText		231		/* setup: doc mgmt/summ subject search text */
#define		WP_FileManagerSortBySetup	232		/* setup: doc mgmt/summ sort list files by */
#define		WP_WPDocsOnly			233		/* setup: doc mgmt/summ wp documents only */
#define		WP_DisplayListMode		234		/* setup: doc mgmt/summ display list mode */
#define		WP_CompressedPrintForList	235		/* setup: doc mgmt/summ compress print list */
#define		WP_DocSummaryDescriptiveTypeSetup	236		/* setup: doc mgmt/summ default desc type */
#define		WP_PrinterControlCancel		237		/* printer control, cancel */
#define		WP_PrinterControlRush		238		/* printer control, rush */
#define		WP_TableHeader			239		/* table options, header */
#define		WP_TableNameChange		240		/* table change name, (usually through names list) */
#define		WP_DecimalAlignmentCharacter	241		/* decimal/alignment char */
#define		WP_ThousandsSeparator		242		/* thousands separator */
#define		WP_UnderlineSpaces		243		/* underline spaces */
#define		WP_UnderlineTabs		244		/* underline tabs */
#define		WP_DotLeader			245		/* dot leader character */
#define		WP_OverstrikeCreate		246		/* overstrike create */
#define		WP_OverstrikeEdit		247		/* overstrike edit */
#define		WP_BoxImageDitherMethod		248		/* BoxImageDitherMethod */
#define		WP_BoxContentType		249		/* BoxContentType */
#define		WP_PrintFullDoc			250		/* print full document */
#define		WP_PrintPage			251		/* print single page */
#define		WP_PrintMultiplePages		252		/* print multiple pages */
#define		WP_PrinterInitialize		253		/* printer initialize */
#define		WP_PrintTextQuality		254		/* print text quality */
#define		WP_PrintGraphicsQuality		255		/* print graphics quality */
#define		WP_PrintCopies			256		/* print number of copies */
#define		WP_PrintCopiesBy		257		/* print copies by */
#define		WP_PrintNetworkForm		258		/* network form number */
#define		WP_PrintNetworkBanner		259		/* network banner (yes/no) */
#define		WP_TableSplitColumn		260		/* table split, columns */
#define		WP_TableSplitRow		261		/* table split, rows */
#define		WP_TableInsertColumn		262		/* table insert, columns */
#define		WP_TableInsertRow		263		/* table insert, rows */
#define		WP_TableDeleteColumn		264		/* table delete, columns */
#define		WP_TableDeleteRow		265		/* table delete, rows */
#define		WP_Hyphenation			266		/* hyphenation on/off */
#define		WP_LineHeight			267		/* line height */
#define		WP_FileRetrieve			268		/* retrieve */
#define		WP_GraphicsLineDlg		269		/* graphics line create/edit dialog */
#define		WP_PrintTextQualitySetup	270		/* setup, text quality */
#define		WP_PrintGraphicsQualitySetup	271		/* setup, graphics quality */
#define		WP_PrintCopiesSetup		272		/* setup, number of copies */
#define		WP_PrintCopiesBySetup		273		/* setup, copies by */
#define		WP_PrintNetworkFormSetup	274		/* setup, network form number */
#define		WP_PrintNetworkBannerSetup	275		/* setup, network banner (yes/no) */
#define		WP_AttributeSizeRatios		276		/* setup, attribute size */
#define		WP_RedlineMethodSetup		277		/* setup, redline method */
#define		WP_RedlineCharacterSetup	278		/* setup, redline character */
#define		WP_LineNumberingMethod		279		/* line numbering method */
#define		WP_LineNumberSet		280		/* starting line number */
#define		WP_PrintInkColorSetup		281		/* setup, ink color */
#define		WP_PrintInkColor		282		/* print, ink color */
#define		WP_HeaderA			283		/* header A */
#define		WP_HeaderB			284		/* header B */
#define		WP_FooterA			285		/* footer A */
#define		WP_FooterB			286		/* footer B */
#define		WP_WatermarkA			287		/* watermark A */
#define		WP_WatermarkB			288		/* watermark B */
#define		WP_LineSpacing			289		/* line spacing */
#define		WP_BoxContentEdit		290		/* BoxContentEdit */
#define		WP_ToADefinitionRetrieve	291		/* toa definition retrieve */
#define		WP_PrinterCommand		292		/* printer command */
#define		WP_PrinterPause			293		/* printer pause */
#define		WP_DisplayPitch			294		/* display pitch */
#define		WP_TableCellAttributeOff	295		/* table cell attributes off */
#define		WP_TableCellAttributeOn		296		/* table cell attributes on */
#define		WP_TableCellJustification	297		/* table cell justification */
#define		WP_TableCellUseColumnAttribute	298		/* table cell use column attributes */
#define		WP_TableCellUseColumnJust	299		/* table cell use column justification */
#define		WP_TableCellVerticalAlignment	300		/* table cell vertical alignment */
#define		WP_TableCellLock		301		/* table cell lock */
#define		WP_TableCellIgnoreCalculation	302		/* table cell ignore (treat as text only) */
#define		WP_MouseAccelerationFactor	303		/* setup, mouse acceleration */
#define		WP_ParagraphSpacing		304		/* set spacing below paragraph */
#define		WP_MouseDoubleClick		305		/* setup, mouse double click time */
#define		WP_SearchInSelection		306		/* search in selection (c-engine only) */
#define		WP_MouseLeftHanded		307		/* setup, left-handed mouse */
#define		WP_FootnoteNumberMethod		308		/* footnote numbering method */
#define		WP_EndnoteNumberMethod		309		/* endnote numbering method */
#define		WP_MousePort			310		/* setup, mouse port */
#define		WP_MergeFieldDelimiter		311		/* Delimited Text: field delimiter */
#define		WP_MergeRecordDelimiter		312		/* Delimited Text: record delimiter */
#define		WP_MergeFieldEncapsulateCharacter	313		/* Delimited Text: encapsulate char */
#define		WP_MergeStripCharacters		314		/* Delimited Text: strip chars */
#define		WP_ColorPaletteCreate		315		/* setup, new palette */
#define		WP_ColorPaletteDelete		316		/* setup, delete palette */
#define		WP_ColorPaletteRename		317		/* setup, rename palette */
#define		WP_ColorAdd			318		/* setup, add color */
#define		WP_ColorDelete			319		/* setup, delete color */
#define		WP_ColorModify			320		/* setup, modify color */
#define		WP_CursorSpeed			321		/* cursor speed */
#define		WP_FastSave			322		/* fast save */
#define		WP_GraphicsLineEdit		323		/* graphics line edit */
#define		WP_HyphenationPrompt		324		/* hyphenation prompt */
#define		WP_WP51Keyboard			325		/* alternate keyboard */
#define		WP_QuickmarkSetOnSave		326		/* set quickmark on save */
#define		WP_Backup			327		/* backup on/off */
#define		WP_BackupMinutes		328		/* backup minutes */
#define		WP_BackupOriginalDoc		329		/* backup original document */
#define		WP_BeepOnError			330		/* beep on error */
#define		WP_BeepOnSearchFailure		331		/* beep on search failure */
#define		WP_BeepOnHyphenation		332		/* beep on hyphenation */
#define		WP_DocSummaryField		333		/* set ext doc smy field data */
#define		WP_DocSummaryFieldOrder		334		/* set ext doc smy field order */
#define		WP_DocSummarySelectDlg		335		/* dialog, document summary select */
					/*	336		** Reserved **/
					/*	337		** Reserved **/
					/*	338		** Reserved **/
					/*	339		** Reserved **/
					/*	340		** Reserved **/
#define		WP_AltKeySelectsMenuBar		341		/* setup menu, Alt-key selects menu bar */
#define		WP_CloseDlg			342		/* CloseDlg (Close from pdm) */
#define		WP_MenuBarRemainsVisible	343		/* setup menu, menu bar remains visible */
#define		WP_PreviewTextInBlackWhite	344		/* setup view, view text in black & white */
#define		WP_PreviewGraphicsInBlackWhite	345		/* setup view, view graphics in black & white */
#define		WP_GoToMail			346		/* goto mail, mail current doc as message */
#define		WP_PrinterOtherDirectory	347		/* Other disk token for printer selection */
#define		WP_CommentsDisplaySetup		348		/* setup edit scrn, display comments */
#define		WP_DisplayOnStatusLine		349		/* setup edit scrn, filename on status line */
#define		WP_MergeCodesDisplaySetup	350		/* setup edit scrn, merge codes display */
#define		WP_BorderStyleDlg		351		/* border style list dialog */
#define		WP_RevealCodesDisplayDetail	352		/* setup edit scrn, reveal codes detail */
#define		WP_LocationOfGraphicsFontsFiles	353		/* setup, SFT screen font data path */
#define		WP_GraphicsFontsActivate	354		/* setup, SFT activate screen font type */
#define		WP_TableUseDefaultLinesColor	355		/* table use default lines color */
#define		WP_DisplayUnits			356		/* units of measure, entry/display */
#define		WP_StatusLineUnits		357		/* units of measure, status line */
#define		WP_HardReturnDisplayCharacter	358		/* setup, HRT display character */
#define		WP_RevealCodesWindowSizeSetup	359		/* setup, Reveal codes window size */
#define		WP_SwitchDlg			360		/* document list dialog (Home-0) */
#define		WP_TabLeft			361		/* Hard Left Tab (Home-Tab) */
#define		WP_TabCenter			362		/* Hard Center Tab (Home-Center) */
#define		WP_TableNameTableDlg		363		/* Name the table */
#define		WP_TabRight			364		/* Hard Right Tab (Home-FlshRit) */
#define		WP_DeleteToBeginningOfWord	365		/* Delete to Beg of Word (Home-Backspace) */
#define		WP_DeleteToEndOfWord		366		/* Delete to End of Word (Home-Del) */
#define		WP_PosScreenLeft		367		/* Screen Left (Home-Left) */
#define		WP_PosScreenRight		368		/* Screen Right (Home-Right) */
#define		WP_HyphenationSoftReturn	369		/* Invisible Sort Return (Home-Enter) */
#define		WP_HyphenationIgnore		370		/* Cancel Hyphenation (Home-/) */
#define		WP_PosDocTop			371		/* Top of Doc (H-H-Up) */
#define		WP_PosDocBottom			372		/* Bottom of Doc (H-H-Down) */
#define		WP_CounterEditLevelName		373		/* user counter edit level name */
#define		WP_CounterEditLevelMethod	374		/* user counter edit level method */
#define		WP_PosDocVeryTop		375		/* Very Top of Doc (H-H-H-Up) */
#define		WP_PosLineVeryBeg		376		/* Very Beg of Line (H-H-H-Left) */ */
#define		WP_DocSummaryDelete		377		/* document summary delete */
#define		WP_FirstLineIndent		378		/* first line indent (format margin) */
#define		WP_MarginAdjustLeft		379		/* left margin adjust (format margin) */
#define		WP_MarginAdjustRight		380		/* right margin adjust (format margin) */
#define		WP_AttributeAppearanceOn	381		/* attribute on */
#define		WP_AttributeAppearanceOff	382		/* attribute off */
#define		WP_TableColumnAttributeOff	383		/* table column attributes off */
#define		WP_TableColumnAttributeOn	384		/* table column attributes on */
#define		WP_TableColumnJustification	385		/* table column justification */
#define		WP_TableColumnWidth		386		/* table column width */
#define		WP_TableColumnFixedWidth	387		/* table column lock width */
#define		WP_TableColumnDecimalAlignDigits	388		/* table column DAlign using # of digits */
#define		WP_TableColumnDecimalAlignDist	389		/* table column DAlign using position */
#define		WP_TableColumnMarginLeft	390		/* table column left gutter spacing */
#define		WP_TableColumnMarginRight	391		/* table column right gutter spacing */
#define		WP_PosPage			392		/* GotoPage# (Goto-<num>) */
#define		WP_PosTableCell			393		/* GotoCell (Goto-<cell#>) */
#define		WP_PosBlockBeg			394		/* Beginning of Block (Goto-Block) */
#define		WP_PosPageTop			395		/* Top of Page (Goto-Up) */
#define		WP_PosPageBottom		396		/* Bottom of Page (Goto-Down) */
#define		WP_PosColTop			397		/* Top of Column (Goto-Up) */
#define		WP_PosColBottom			398		/* Bottom of Column (Goto-Down) */
#define		WP_PosColPrevious		399		/* Previous Column (Goto-Left) */
#define		WP_PosColNext			400		/* Next Column (Goto-Right) */
#define		WP_PosColFirst			401		/* First Column (Goto-Home-Left) */
#define		WP_PosColLast			402		/* Last Column (Goto-Home-Right) */
#define		WP_PosTableCellTop		403		/* Top of Cell (Goto-Up) */
#define		WP_PosTableCellBottom		404		/* Bottom of Cell (Goto-Down) */
#define		WP_PosGoPrevious		405		/* Last Position (Goto-Goto) */
#define		WP_PosTableCellNext		406		/* Next Cell (Goto-Right) */
#define		WP_PosTableCellPrevious		407		/* Previous Cell (Goto-Left) */
#define		WP_PosTableCellUp		408		/* Row Up (Up) */
#define		WP_PosTableCellDown		409		/* Row Down (Down) */
#define		WP_PosTableColTop		410		/* Table Col Top (Goto-Home-Up) */
#define		WP_PosTableColBottom		411		/* Table Col Bottom (Goto-Home-Down) */
#define		WP_PosTableRowBeg		412		/* Table First Col (Goto-Home-Left) */
#define		WP_PosTableRowEnd		413		/* Last Column of Table (Goto-Home-Right) */
#define		WP_PosTableBeg			414		/* Table Begin (Goto-H-H-Up) */
#define		WP_PosTableEnd			415		/* Table End (Goto-H-H-Down) */
#define		WP_PrinterSelect		416		/* select printer */
#define		WP_PrinterCopy			417		/* select printer copy */
#define		WP_PrinterDelete		418		/* select printer delete */
#define		WP_PrinterSelectPrs		419		/* list .prs select */
#define		WP_PrinterAdd			420		/* add printer */
#define		WP_LocationOfBackupFiles	421		/* setup, backup files location */
#define		WP_LocationOfMacroKeyboardFiles	422		/* setup, keyboard/macro files location */
#define		WP_LocationOfDocFiles		423		/* setup, document files location */
#define		WP_LocationOfGraphicsFiles	424		/* setup, graphics files location */
#define		WP_LocationOfSprFiles		425		/* setup, spreadsheet files location */
#define		WP_LocationOfPrinterFiles	426		/* setup, printer files location */
#define		WP_LocationOfWritingTools	427		/* setup, speller files location */
#define		WP_LocationOfSupWritingTools	428		/* setup, supplemental speller files */
#define		WP_MatchWithAttributes		429		/* match attributes (c-engine only) */
#define		WP_FormatForDefaultPrinter	430		/* setup, format document for default printer */
#define		WP_ConvertCodePage		431		/* conversion code page */
#define		WP_ColumnsOff			432		/* columns off */
#define		WP_TabDlg			433		/* tabset dialog */
#define		WP_FloatingCellCreate		434		/* create a floating cell */
#define		WP_PrinterColorConfigured	435		/* Confige printer for color */
#define		WP_DocSummaryExtract		436		/* document summary capture */
#define		WP_GraphicsFontsPathsDlg	437		/* dialog, edit screen font paths dialog */
#define		WP_PrinterControlDlg		438		/* dialog, printer control */
#define		WP_EnvironmentSetupDlg		439		/* dialog, environment */
#define		WP_BackupDlg			440		/* dialog, backup options */
#define		WP_BeepOptionsDlg		441		/* dialog, beep options */
#define		WP_DocSummarySetupDlg		442		/* dialog, document summary setup */
#define		WP_TableLinesDlg		443		/* table lines dialog */
#define		WP_PrintSetupDlg		444		/* dialog, setup print options */
#define		WP_GraphicsScreenOptionsDlg	445		/* setup graphics screen dialog */
#define		WP_InitialCodesDoc		446		/* document initial codes */
#define		WP_InitialCodesSetup		447		/* setup, initial codes */
#define		WP_DocCharacterMapDefault	448		/* setup, character map */
#define		WP_DocCharacterMap		449		/* document character map */
#define		WP_Sort				450		/* sort */
#define		WP_PrinterUpdate		451		/* Update printer */
#define		WP_PrinterDescription		452		/* Edit Printer Description */
#define		WP_PrinterFontDirectory		453		/* Edit Printer Path for Downloadable Fonts */

/******** --- start of box tokens ************/
#define		WP_BoxStyleCreate		454		/* Box template create */
#define		WP_BoxStyleDelete		455		/* Box template delete */
#define		WP_BoxStyleEdit			456		/* Box template select */
#define		WP_BoxStyleEnd			457		/* Box template select end */
#define		WP_BoxCreate			458		/* Box create */
#define		WP_BoxDelete			459		/* Box delete */
#define		WP_BoxEdit			460		/* Box select */
#define		WP_BoxEnd			461		/* Box select end */
#define		WP_MathDefinitionStart		462		/* Start math definition */
#define		WP_MathDefinitionEnd		463		/* End math definition */
#define		WP_MathColumn			464		/* Math - define a column */
#define		WP_EndnotePlacement		465		/* Endnote placement */
#define		WP_MathCalculate		466		/* Math calculate */
#define		WP_BoxStaysOnPage		467		/* Box page offset (function only) */
#define		WP_BoxAttachTo			468		/* Box type */
#define		WP_BoxCaptionPosition		469		/* Box caption position */
#define		WP_BoxContentPosition		470		/* Box content position */
#define		WP_TableDefaultLineColor	471		/* Table default line color */
#define		WP_BoxHorizontalPosition	472		/* Box horizontal position */
#define		WP_BoxVerticalPosition		473		/* Box vertical position */
#define		WP_BoxWidth			474		/* Box width */
#define		WP_BoxHeight			475		/* Box height */
#define		WP_BoxHorizontalAlignment	476		/* Box horizontal alignment */
#define		WP_BoxVerticalAlignment		477		/* Box vertical alignment */
#define		WP_TableDefaultLine		478		/* Table default line */
#define		WP_BoxCaptionRotation		479		/* Box caption rotation */
#define		WP_AttributeAppearanceToggle	480		/* Toggle Text Attribute */
#define		WP_TableCellUseColumnNumberType	481		/* Table Cell Use Number Type */
#define		WP_WordSpacingJustificationLimits	482		/* word spacing justification limits */
#define		WP_BoxChangeStyle		483		/* Box change template */
#define		WP_ListDefinition		484		/* list definition (select) */
#define		WP_ListDefinitionRename		485		/* list rename definition */
#define		WP_ListDefinitionCreate		486		/* list create definition */
#define		WP_ListDefinitionDelete		487		/* list delete definition */
#define		WP_PosTableTopCellNext		488		Top Next Cell in tables	/* (Tab) */
#define		WP_PosTableTopCellPrevious	489		Top Previous Cell in tables	/* (Shft-Tab) */
#define		WP_TableCellUseLineColor	490		/* Cell use lines color */
#define		WP_BoxBorderStyle		491		/* Box border */
#define		WP_BoxFillStyle			492		/* Box fill */
#define		WP_SecondaryPageNumber		493		/* Set new secondary page number */
#define		WP_SecondaryPageNumberMethod	494		/* Secondary page number method */
#define		WP_SecondaryPageNumberIncrement	495		/* Increment secondary page number */
#define		WP_SecondaryPageNumberDecrement	496		/* Decrement secondary page number */
#define		WP_SecondaryPageNumberDisplay	497		/* Display secondary page number */
#define		WP_DisplaySetupDlg		498		/* Setup Display Dialog */
#define		WP_KeyboardLayoutDlg		499		/* Setup Keyboard Dialog */
#define		WP_LocationOfFilesDlg		500		/* Setup Location of Files Dialog */
#define		WP_MouseSetupDlg		501		/* Setup Mouse dialog */
#define		WP_BoxImageRetrieve		502		/* BoxImageRetrieve */
#define		WP_BoxTextFlow			503		/* Box wrapping */
#define		WP_BoxTextFlowSquare		504		/* Box wrap square */
#define		WP_BoxImageFill			505		/* Box image content fill modifier */
#define		WP_BoxImageInvertColors		506		/* Box image content color invert */
#define		WP_BoxImageMonochrome		507		/* Box image content print in b&w */
#define		WP_BoxImageFlipX		508		/* Box image content mirror in x */
#define		WP_BoxImageFlipY		509		/* Box image content mirror in y */
#define		WP_BoxImageScaling		510		/* Box image content scaling */
#define		WP_BoxImageMove			511		/* Box image content translation */
#define		WP_BoxImageRotate		512		/* Box image content rotation */
#define		WP_BoxImageBlackWhiteThreshold	513		/* Box image content black & white threshold */
#define		WP_BoxImageBrightness		514		/* Box image content lightness */
#define		WP_BoxImageContrast		515		/* Box image content contrast */
#define		WP_BoxImageHalftoneOptions	516		/* Box image content halftone */
#define		WP_EnvelopeDlg			517		/* Envelope Dialog */
#define		WP_BoxTextAngle			518		/* Box text content rotation */
#define		WP_BoxTextContentTranslation	519		/* Box text content translation */
/************ --- end of box tokens *********/

#define		WP_ToCMark			520		/* mark for table of contents */
#define		WP_CounterCreate		521		/* counter create definition */
#define		WP_CounterEditName		522		/* counter edit name */
#define		WP_CounterEditLevel		523		/* counter edit # levels */
#define		WP_CounterDelete		524		/* counter delete */
#define		WP_CounterEditMethod		525		/* counter edit num method */
#define		WP_CounterSetValue		526		/* counter instance set value */
#define		WP_CounterSetMethod		527		/* counter instance set method */
#define		WP_CounterIncrement		528		/* counter instance increment */
#define		WP_CounterDecrement		529		/* counter instance decrement */
#define		WP_CounterDisplay		530		/* counter instance display */
#define		WP_CrossRefMarkTarget		531		/* mark cross ref target */
#define		WP_CrossRefMarkReference	532		/* mark cross ref reference */
#define		WP_ListDefinitionRetrieve	533		/* list retrieve definition */
#define		WP_MacroAssignVariableDlg	534		/* Assign Macro Variable Dialog */
#define		WP_MacroCommandsDlg		535		/* Macro Commands Dialog */
#define		WP_ClearDoc			536		/* ClearDocument (Restart) */
#define		WP_Close			537		/* Close current document */
#define		WP_ExitWordPerfect		538		/* Exit WP */
#define		WP_FileSave			539		/* save */
#define		WP_DateText			540		/* Insert Date Text */
#define		WP_DateCode			541		/* Insert Date Code */
#define		WP_DateFormat			542		/* Insert Date Format code */
#define		WP_BarcodePOSTNET		543		/* Barcode type 0 (POSTNET) */
#define		WP_ColorPaletteSelect		544		/* select setup palette */
#define		WP_BoxCaptionEdit		545		/* BoxCaptionEdit */
#define		WP_ConditionalEndOfPage		546		/* conditional end of page */
#define		WP_BlockProtect			547		/* block protect */
#define		WP_ColorPaletteDlg		548		/* Setup Color Palette Dialog */
#define		WP_SubstructureExit		549		/* exit substructure */
#define		WP_CommentEdit			550		/* edit comment */
#define		WP_CommentCreate		551		/* create comment */
#define		WP_Advance			552		/* advance */
#define		WP_SpecificDeleteStringBegin	553		/* specific search and delete string */
#define		WP_Language			554		/* language */
#define		WP_Font				555		/* base font */
#define		WP_PrinterFont			556		/* initial font */
#define		WP_DocInitialFont		557		/* document font */
#define		WP_TableRowMarginTop		558		/* table row top gutter spacing */
#define		WP_TableRowMarginBottom		559		/* table row bottom gutter spacing */
#define		WP_TableRowHeight		560		/* table row height */
#define		WP_TableRowNumberOfLines	561		/* table row number of lines */
#define		WP_PaperSizeSelect		562		/* paper size/type select */
#define		WP_ListMark			563		/* mark text for list */
#define		WP_MergeCode			564		/* insert merge codes */
#define		WP_FootnoteCreate		565		/* footnote create */
#define		WP_EndnoteCreate		566		/* endnote create */
#define		WP_WordLetterSpacing		567		/* word and letter spacing */
#define		WP_DoubleSidedPrint		568		/* double sided printing */
#define		WP_Kerning			569		/* kerning on/off */
#define		WP_Leading			570		/* leading adjustment */

/********** ---- border, fill, line style tokens ***********/
#define		WP_LineStyleCreate		571		/* line template create */
#define		WP_LineStyleDelete		572		/* line template delete */
#define		WP_LineStyleEdit		573		/* line template edit */
#define		WP_LineStyleEnd			574		/* line template end edit */
#define		WP_LineSegmentCreate		575		/* line segment create */
#define		WP_LineSegmentEdit		576		/* line segment edit */
#define		WP_LineSegmentEnd		577		/* line segment end edit */
#define		WP_FillColors			578		/* fill colors */
#define		WP_BorderColor			579		/* border color */
#define		WP_LineSegmentWidth		580		/* line segment width */
#define		WP_LineSegmentSpacing		581		/* line segment spacing */
#define		WP_LineSegmentSetUser		582		/* line segment set user style data start */
#define		WP_LineSegmentSetUserData	583		/* line segment set user styte data word */
#define		WP_LineSegmentSetUserEnd	584		/* line segment set user style data end */
#define		WP_FillStyleCreate		585		/* fill template create */
#define		WP_FillStyleDelete		586		/* fill template delete */
#define		WP_FillStyleEdit		587		/* fill template edit */
#define		WP_FillStyleEnd			588		/* fill template end edit */
#define		WP_TypeChar			589		/* type character (compose) */
#define		WP_FillSetWPG2			590		/* fill set WPG2 pre-defined pattern */
#define		WP_BoxCaptionInitialStyle	591		/* BoxCaptionInitialStyle */
#define		WP_BoxTextDefaultStyle		592		/* BoxTxtDefaultStyle */
#define		WP_MatchWithFont		593		/* match font (c-engine only) */
#define		WP_FillSetGradient		594		/* fill set gradient  */

#define		WP_BorderStyleCreate		595		/* border template create */
#define		WP_BorderStyleDelete		596		/* border template delete */
#define		WP_BorderStyleEdit		597		/* border template edit */
#define		WP_BorderStyleEnd		598		/* border template end edit */
#define		WP_BorderCornerRadius		599		/* border corner radius */
#define		WP_BorderInsideSpacing		600		/* border inside spacing */
#define		WP_BorderOutsideSpacing		601		/* border outside spacing */
#define		WP_TextBorderEdit		602		/* border edit */
#define		WP_BorderDropShadow		603		/* border drop shadow */
#define		WP_ColorUnits			604		/* set color display units */
#define		WP_BorderLeftLine		605		/* border left line */
#define		WP_BorderRightLine		606		/* border right line */
#define		WP_BorderTopLine		607		/* border top line */
#define		WP_BorderBottomLine		608		/* border bottom line */
#define		WP_BorderSeparatorLine		609		/* border separator line */
/********* ---- end border, fill, line style tokens *****/

#define		WP_FontMatchTable		610		/* Edit Font Matching Table */
#define		WP_FontSize			611		/* BaseFont point size */
#define		WP_TextBorderCreate		612		/* Border Create */
#define		WP_PaperSize			613		/* Papersize add/edit */
#define		WP_PaperSizeDelete		614		/* Papersize delete */
#define		WP_GenerateDoc			615		/* Generate doc */
#define		WP_MergeRun			616		/* run a merge */
#define		WP_BoxChangeLineHeight		617		/* character box affect line height */
#define		WP_BookmarkMove			618		/* Move Bookmark */
#define		WP_TextColor			619		/* insert text color */
#define		WP_TextShade			620		/* insert text shade */
#define		WP_BookmarkCreate		621		/* Set BookMark */
#define		WP_BookmarkDelete		622		/* Delete BookMark */
#define		WP_BookmarkFind			623		/* Goto BookMark */
#define		WP_BookmarkBlock		624		/* Block BookMark */
#define		WP_BookmarkRename		625		/* Rename BookMark */
#define		WP_BoxStyleName			626		/* BoxTemplateName */
#define		WP_LineStyleName		627		/* LineTemplateName */
#define		WP_FillStyleName		628		/* FillTemplateName */
#define		WP_BorderStyleName		629		/* BorderTemplateName */
#define		WP_BaselinePlacementSetup	630		/* setup: baseline placement */
#define		WP_BaselinePlacement		631		/* document: baseline placement */
#define		WP_BoxStyleCopy			632		/* BoxTemplateCopy */
#define		WP_LineStyleCopy		633		/* LineTemplateCopy */
#define		WP_FillStyleCopy		634		/* FillTemplateCopy */
#define		WP_BorderStyleCopy		635		/* BorderTemplateCopy */
#define		WP_ToAMark			636		/* mark toa full form */
#define		WP_ToAEditFullForm		637		/* edit toa full form */
#define		WP_PageNumber			638		/* set new page number */
#define		WP_PageNumberMethod		639		/* page number method */
#define		WP_TableCalculateAll		640		/* tables - calc all in document */
#define		WP_ToAEditShortForm		641		/* edit toa short form */
#define		WP_ToAEditSection		642		/* edit toa section */

#define		WP_MatchWithFontSize		643		/* match font size (c-engine only) */
#define		WP_MatchExtendSelection		644		/* match extend selection (c-engine only) */
#define		WP_LineSegmentSetWPG2		645		/* line segment set WPG2 line style */
#define		WP_LineSegmentDelete		646		/* line segment delete */

#define		WP_ToAMarkShortForm		647		/* mark toa short form */
#define		WP_SubdocInclude		648		/* include subdoc */
#define		WP_ColorSchemeSelect		649		/* setup: select color scheme */
#define		WP_ColorSchemeDelete		650		/* setup: delete color scheme */

#define		WP_ListDefinitionMode		651		/* edit list def # mode */
#define		WP_ToADefinitionMode		652		/* edit toa def # mode */
#define		WP_MasterDocExpand		653		/* expand master doc */
#define		WP_MasterDocCondense		654		/* condense master doc */
#define		WP_ColorSchemeCreate		655		/* setup: create color scheme */
#define		WP_ColorSchemeCopy		656		/* setup: copy color scheme */
#define		WP_MergeFileType		657		/* merge: file type */
#define		WP_MergeDataFile		658		/* merge: associated data file */
#define		WP_MergeCodesDisplayEdit	659		/* merge: change code display */

#define		WP_SortType			660		/* sort: type */
#define		WP_SortAction			661		/* sort: action (sort/select only) */
#define		WP_SortCaseOrder		662		/* sort: case order (upper case first) */
#define		WP_SortKeys			663		/* sort: keys */
#define		WP_SortSelectString		664		/* sort: select string */

#define		WP_LabelsFileCreate		665		/* Label File Create */
#define		WP_LabelsFileDescription	666		/* Label File Description */
#define		WP_LabelsFileSelect		667		/* Label File Select */
#define		WP_LabelsDefine			668		/* Label Define */
#define		WP_LabelsSelect			669		/* Label Select */
#define		WP_LabelsDelete			670		/* Label Delete */
#define		WP_LabelsDisplay		671		/* Label List Options */

#define		WP_TextBorderEnd		672		/* border end */
#define		WP_TextBorderFillStyle		673		/* border fill template */
#define		WP_TextBorderStyle		674		/* border border template */
#define		WP_PrinterSheetFeeder		675		/* Select Sheet Feeder */
#define		WP_PrinterPortLPT		676		/* Select LPT Port */
#define		WP_PrinterPortCOM		677		/* Select COM port */
#define		WP_PrinterPortFilename		678		/* select filename for port */
#define		WP_PrinterPortNetworkQueue	679		/* select device for port */
#define		WP_PrinterPortHardware		680		/* Hardware Port */
#define		WP_HardPageBreak		681		/* hard page */
#define		WP_HardColumnBreak		682		/* hard column */
#define		WP_TableHardRow			683		/* table hard row */
#define		WP_ToADefinitionCombine		684		/* toa run flag edit */
#define		WP_TableHardColumnBreak		685		/* table hard row, hard column */
#define		WP_TableDeleteBlock		686		/* delete block */
#define		WP_SubdividePage		687		/* logical pages */
#define		WP_MergeSelect			688		/* define merge selection conditions */
#define		WP_SearchString			689		/* search string */
#define		WP_ReplaceString		690		/* replace string */
#define		WP_SpecificSearchStringBegin	691		/* specific search string */
#define		WP_SpecificReplaceStringBegin	692		/* specific replace string */
#define		WP_SearchCaseSensitive		693		/* match case (for search/replace) */
#define		WP_SearchFindWholeWordsOnly	694		/* match word (for search/replace) */
#define		WP_ReplaceLimitNumberOfMatches	695		/* match limit (for replace) */
#define		WP_ReplaceConfirm		696		/* confirm replacement (for replace) */
#define		WP_TableCellsJoin		697		/* table join */
#define		WP_TableMove			698		/* Table move */
#define		WP_TableCopy			699		/* Table copy */
#define		WP_TableMoveModeEnd		700		/* Table end move */
#define		WP_OutputOption			701		/* Output Options (sort, group, bin) */
#define		WP_OutputOptionsOffsetJogger	702		/* Offset Jogger */
#define		WP_MergeCondition		703		/* merge conditions */
#define		WP_MergeMark			704		/* merge marked records */
#define		WP_MergeCodesDisplayRun		705		/* merge display at runtime */
#define		WP_GraphicsLineDelete		706		/* GraphicsLineDelete */
#define		WP_MergeBlankField		707		/* merge blank fields */
#define		WP_MergePageBreak		708		/* merge page breaks */
#define		WP_MergeRepeat			709		/* merge repeat */
#define		WP_SearchNext			710		/* search for next occurrence */
#define		WP_SearchPrevious		711		/* search for previous occurrence */
#define		WP_ReplaceForward		712		/* search/replace going forward */
#define		WP_ReplaceBackward		713		/* search/replace going backward */
#define		WP_SearchWrap			714		/* search wrap (c-engine only) */
#define		WP_ReplaceAll			715		/* replace all (c-engine only) */
#define		WP_ReplaceCurrent		716		/* replace current (c-engine only) */
#define		WP_MatchPositionBefore		717		/* match position before (c-engine only) */
#define		WP_KeyboardSelect		718		/* Keyboard Select */
#define		WP_KeyboardDelete		719		/* Keyboard Delete */
#define		WP_KeyboardRename		720		/* Keyboard Rename */
#define		WP_KeyboardCreate		721		/* Keyboard Create */
#define		WP_KeyboardCopy			722		/* Keyboard Copy */
#define		WP_KeyboardOriginal		723		/* Keyboard Original */
#define		WP_PageNumberIncrement		724		/* increment page number */
#define		WP_PageNumberDecrement		725		/* decrement page number */
#define		WP_PageNumberDisplayFormat	726		/* Page Number Display Format String */
#define		WP_PageNumberFormat		727		/* Page Number Format string */
#define		WP_DateFormatDlg		728		/* bring up date format dialog */
#define		WP_SortDlg			729		/* bring up sort dialog */
#define		WP_FormatLineDlg		730		/* bring up format line dialog */
#define		WP_FormatPageDlg		731		/* bring up format page dialog */
#define		WP_FormatDocDlg			732		/* bring up format doc dialog */
#define		WP_FormatOtherDlg		733		/* bring up format other dialog */
#define		WP_PrintBlock			734		/* block print (same as T_PRSELECTION) */
#define		WP_ColorDlg			735		/* print color dlg */
#define		WP_MergeRunDlg			736		/* bring up merge dialogs */
#define		WP_LineDrawDlg			737		/* bring up line draw dialog */
#define		WP_AppendToFile			738		/* append to specified file or default block */
#define		WP_BoxTextFlowContour		739		/* box wrap irregular */
#define		WP_MergeFileAssociate		740		/* associate merge file names */
#define		WP_DocSummaryDlg		741		/* bring up document summary dialog */
#define		WP_DelayCodesDlg		742		/* bring up delay codes dialog */
#define		WP_ColumnsDefinitionDlg		743		/* bring up column def dialog */
#define		WP_IndexMarkDlg			744		/* bring up mark index dialog */
#define		WP_ToCMarkDlg			745		/* bring up mark ToC dialog */
#define		WP_ListMarkDlg			746		/* bring up mark list dialog */
#define		WP_GenerateDlg			747		/* bring up generate dialog */
#define		WP_SubdocDlg			748		/* bring up mark subdoc dialog */
#define		WP_CrossRefMarkReferenceDlg	749		/* bring up mark ref dialog */
#define		WP_CrossRefMarkTargetDlg	750		/* bring up mark target dialog */
#define		WP_CrossRefMarkBothDlg		751		/* bring up mark both dialog */
#define		WP_ToAMarkShortFormDlg		752		/* bring up mark short form dialog */
#define		WP_ToAMarkFullFormDlg		753		/* bring up mark full form dialog */
#define		WP_ToAEditFullFormDlg		754		/* bring up edit full form dialog */
#define		WP_IndexDefinitionDlg		755		/* bring up define index dialog */
#define		WP_ToCDefinitionDlg		756		/* bring up define ToC dialog */
#define		WP_ListDefinitionDlg		757		/* bring up define list dialog */
#define		WP_ToADefinitionDlg		758		/* bring up define ToA dialog */
#define		WP_MasterDocExpandDlg		759		/* bring up expand master doc dialog */
#define		WP_MasterDocCondenseDlg		760		/* bring up condense master doc dialog */
#define		WP_BoxEditByCounter		761		/* BoxEditByCounter */
#define		WP_DocCompareRemoveRedline	762		/* remove redline, strikeout */
#define		WP_OutlineTop			763		/* go to top of outline */
#define		WP_OutlineBottom		764		/* go to bottom of outline */
#define		WP_TableNameListDlg		765		/* table names list */
#define		WP_BoxImageSave			766		/* BoxImageSave */
#define		WP_TableFormatDlg		767		/* table format */
#define		WP_TableBlockOn			768		/* table block on */
#define		WP_TableBlockOff		769		/* table block off */
#define		WP_PosDocVeryBottom		770		/* Very Bottom of Doc (H-H-H-Down) */
#define		WP_PosLineVeryEnd		771		/* Very End of Line (H-H-H-Right) */
#define		WP_StyleRename			772		/* style rename */
#define		WP_StyleDescription		773		/* style description */
#define		WP_StyleType			774		/* style type */
#define		WP_StyleEnterKeySetting		775		/* style "enter key" setting */
#define		WP_StyleLinkTo			776		/* style "link to" */
#define		WP_StyleEditEnd			777		/* style edit end */
#define		WP_SubstructureCancel		778		/* substructure cancel */
#define		WP_AppendFilenameDlg		779		/* append filename dialog */
#define		WP_TableAutoFormulaEntry	780		/* set the trigon (auto formula parsing) flag */
#define		WP_TableReformatAll		781		/* reformat all table (& floating cell) numbers */
#define		WP_ConvertCaseUppercase		782		/* uppercase block */
#define		WP_ConvertCaseLowercase		783		/* lowercase block */
#define		WP_ConvertCaseInitialCaps	784		/* initial capitalize block */
#define		WP_PasswordAddChange		785		/* add/change password */
#define		WP_PasswordRemove		786		/* remove password */
#define		WP_SpreadsheetImportDlg		787		/* spreadsheet import dialog */
#define		WP_SpreadsheetCreateLinkDlg	788		/* spreadsheet create dialog */
#define		WP_SpreadsheetEditLinkDlg	789		/* spreadsheet edit dialog */
#define		WP_SpreadsheetLinkOptionsDlg	790		/* spreadsheet options dialog */
#define		WP_ExtendedSearchDlg		791		/* extended forward search dialog */
#define		WP_ExtendedBackwardSearchDlg	792		/* extended backward search dialog */
#define		WP_BoxImageShowBackground	793		/* BoxImagePageBackground */
#define		WP_TextScreenOptionsDlg		794		/* setup text screen dialog */
#define		WP_ExtendedReplaceDlg		795		/* extended search/replace dialog */
#define		WP_TableCreateDlg		796		/* create table dialog */
#define		WP_TableDlg			797		/* table dialog */
#define		WP_Math				798		/* math off/on */
#define		WP_TableRetrieve		799		/* table retrieve */
#define		WP_MathDefinitionDlg		800		/* math define */
#define		WP_FileManagerSetupDlg		801		/* file manager setup dialog */
#define		WP_GraphicsColorsSelect		802		/* select graphics color scheme */
#define		WP_GraphicsColorsDelete		803		/* delete graphics color scheme */
#define		WP_GraphicsColorsCopy		804		/* copy graphics color scheme */
#define		WP_GraphicsColorsCreate		805		/* create graphics color scheme */
#define		WP_OutlineUp			806		/* outline up */
#define		WP_OutlineDown			807		/* outline down */
#define		WP_OutlineRight			808		/* outline right (expose children if hidden) */
#define		WP_OutlineFamilyUp		809		/* outline family up */
#define		WP_OutlineFamilyDown		810		/* outline family down */
#define		WP_OutlineFamilyLeft		811		/* outline family left */
#define		WP_OutlineFamilyRight		812		/* outline family right */
#define		WP_OutlineFamilyDragUp		813		/* outline family drag up */
#define		WP_OutlineFamilyDragDown	814		/* outline family drag down */
#define		WP_OutlineFamilyPromote		815		/* outline family promote */
#define		WP_OutlineFamilyDemote		816		/* outline family demote */
#define		WP_OutlineFamilyMove		817		/* outline family move */
#define		WP_OutlineFamilyCopy		818		/* outline family copy */
#define		WP_OutlineFamilyCut		819		/* outline family delete */
#define		WP_OutlineFamilyHide		820		/* outline family hide */
#define		WP_OutlineFamilyShow		821		/* outline family show */
#define		WP_OutlineShow			822		/* outline hide levels greater than "n" */
#define		WP_OutlineBodyText		823		/* outline body text (hide/show) */
#define		WP_OutlineHideShowingBodyText	824		/* outline hide showing body text */
#define		WP_ClipboardSetNumber		825		/* set the clipboard number */
#define		WP_OutlineParagraphDragUp	826		/* outline paragraph drag up */
#define		WP_OutlineParagraphDragDown	827		/* outline paragraph drag down */
#define		WP_OutlineParagraphMove		828		/* outline paragraph move */
#define		WP_OutlineParagraphCopy		829		/* outline paragraph copy */
#define		WP_OutlineParagraphDelete	830		/* outline paragraph delete */
#define		WP_QuickFinderMarkAll		831		/* quickfinder mark all */
#define		WP_OutlineEnd			832		/* outline mark end */
#define		WP_OutlineParagraphNumber	833		/* outline paragraph number */
#define		WP_GraphicsColorsAssign		834		/* graphics color scheme update */
#define		WP_HardReturn			835		/* hard end of line (HardReturn) */
#define		WP_UndeleteDlg			836		/* undelete dialog */
#define		WP_MoveModeEnd			837		/* Movemode End */
#define		WP_MoveModeCancel		838		/* Movemode Cancel */
#define		WP_Tab				839		/* Insert a SoftTab */
#define		WP_ColorSchemeAssign		840		/* Setup, text color assign */
#define		WP_CartridgesAndFontsBegin	841		/* Begin Cartidges and Fonts */
#define		WP_CartridgesAndFontsMarkFont	842		/* Mark font */
#define		WP_CartridgesAndFontsEnd	843		/* End Cartridges and fonts */
#define		WP_CartridgesAndFontsQuantity	844		/* Cartriges and Fonts quantity */
#define		WP_SwitchDoc			845		/* Switch Documents */
#define		WP_GraphicsFontsSelectBegin	846		/* Beging editing DRS fonts */
#define		WP_GraphicsFontsSelectMarkFont	847		/* Mark or Unmark DRS Font */
#define		WP_GraphicsFontsSelectEnd	848		/* End marking DRS fonts */
#define		WP_AFCEditBegin			849		/* Begin Editing AFC Fonts */
#define		WP_AFCEditFont			850		/* Mark or Unmark AFC font */
#define		WP_AFCEditEnd			851		/* End Editing AFC Fonts */
#define		WP_EnvelopeBegin		852		/* Envelope Begin */
#define		WP_EnvelopeEnd			853		/* Envelope End */
#define		WP_EnvelopeReturnAddressBegin	854		/* Envelope Return Address Begin */
#define		WP_EnvelopeAddressEnd		855		/* Envelope Address End */
#define		WP_EnvelopeMailingAddressBegin	856		/* Envelope Mailing Address Begin */
#define		WP_EnvelopeSize			857		/* Envelope Size */
#define		WP_EnvelopeBarcode		858		/* Envelope Barcode */
#define		WP_EnvelopeOmitReturnAddress	859		/* Envelope Return Address Omit */
#define		WP_EnvelopeSaveAddressAsDefault	860		/* Envelope Save Return Address as Default */
#define		WP_EnvelopeAddressPosition	861		/* Envelope Address Position */
#define		WP_EnvelopeSizeSetup		862		/* Envelope Setup Size */
#define		WP_EnvelopeBarcodeSetup		863		/* Envelope Setup Omit Barcode Option */
#define		WP_StartProgram			864		/* Start a new process */
#define		WP_EndCenterOrAlignment		865		/* Hard End Centering/Alignment */
#define		WP_InsertFilename		866		/* Print Filename */
#define		WP_OutlineParagraphPromote	867		/* Outline paragraph number promote */
#define		WP_OutlineParagraphDemote	868		/* Outline paragraph number demote */
#define		WP_HelpIndex			869		/* Help: index */
#define		WP_HelpContents			870		/* Help: contents */
#define		WP_AttributePosition		871		/* Position Attribute (super/subscript) */
#define		WP_HelpMacros			872		/* Help: macros */
#define		WP_HelpCoaches			873		/* Help: coaches */
#define		WP_HelpHow			874		/* Help: how do i */
#define		WP_HelpTutorial			875		/* Help: tutorial */
#define		WP_WPHelpDlg			876		/* Help: wp info */
#define		WP_ButtonBar			877		/* Button Bar: toggle on/off */
#define		WP_BBarEdit			878		/* Button Bar: edit */
#define		WP_BBarSelect			879		/* Button Bar: select */
#define		WP_BBarOPTS			880		/* Button Bar: options */
#define		WP_TableFill			881		/* Table Fill Style */
#define		WP_LocationOfQuickFinderFiles	882		/* Setup: Location of Files: Personal Index Path */
#define		WP_LocationOfSharedQFinderFiles	883		/* Setup: Location of Files: Shared Index Path */
#define		WP_DocCompare			884		/* document compare */
#define		WP_AutoCodePlacement		885		/* setup: auto code placement */
#define		WP_SoundPlayDlg			886		/* Sound Play (Main) Dialog */
#define		WP_SoundRecordDlg		887		/* Sound Record Dialog */
#define		WP_SoundAddDlg			888		/* Sound Retrieve Dialog */
#define		WP_SoundSetupDlg		889		/* Sound Hardware Setup Dialog */
#define		WP_TextBorderDlg		890		/* border function dialog */
#define		WP_TableCellLine		891		/* Table Cell Line */
#define		WP_WindowDlg			892		/* Window dlg */
#define		WP_ScreenSetupDlg		893		/* Screen Setup dlg */
#define		WP_DocInformation		894		/* document information */
#define		WP_TableCellFillStyle		895		/* Table Cell Fill Style */
#define		WP_TableCellFillColors		896		/* Table Cell Fill Colors */
#define		WP_FileRetrieveDlg		897		/* Retrieve Dlg */
#define		WP_TableCellLineColor		898		/* Table Cell Line Color */
#define		WP_SpreadsheetEditLinkPerform	899		/* Edit link and perform import */
#define		WP_SpreadsheetEditLink		900	 	/* Edit link do not import */
#define		WP_SpreadsheetCreateLinkPerform	901	 	/* Create link and import */
#define		WP_SpreadsheetCreateLink	902	 	/* Create link do not import */
#define		WP_SpreadsheetImportPerform	903		/* Import spreadsheet */
#define		WP_SpreadsheetImportFilename	904	 	/* Change file name for import */
#define		WP_SpreadsheetImportRange	905	 	/* Change Range/Name for import */
#define		WP_SpreadsheetImportType	906	 	/* Change Type of import (Table/Text) */
#define		WP_SpreadsheetUpdateLinks	907		/* Update all links */
#define		WP_BorderFillColor		908		/* Border fill override colors */
#define		WP_MergeEnvelopeDefinitionBegin	909		/* Begin merge envelope definition */
#define		WP_MergeEnvelopeDefinitionEnd	910		/* End merge envelope definition */
#define		WP_MergeEnvelope		911		/* Turn merge envelope feature off/on */
#define		WP_SpreadsheetUpdateOnRetrieve	912		/* Update link on retrieve */
#define		WP_SpreadsheetShowLinkCode	913		/* Show links  */
#define		WP_MergePrintText		914		/* print a merge text file */
#define		WP_BoxContentPreserveAspectRatio	915		/* BoxContentPreserveAspectRatio */
#define		WP_ExitWordPerfectDlg		916		/* Exit all docs Dlg (Home-Exit) */
#define		WP_WP51CursorMovement		917		/* Setup: 5.1 cursor movement */
#define		WP_MergeCodesListDlg		918		/* Merge codes list */
#define		WP_TableNameCellDlg		919		/* Name a table cell */
#define		WP_TableNameBlockDlg		920		/* Name a table block */
#define		WP_TableNameCellsDlg		921		/* Name block dialog */
#define		WP_TableNameAdd			922		/* Add Name */
#define		WP_TableCalculate		923		/* table recalc */
#define		WP_CrossRefBothReference	924		/* Cross ref state begin */
#define		WP_CrossRefBothTarget		925		/* Cross ref state end */
#define		WP_TableFormula			926		/* table formula edit */
#define		WP_RedlineMethod		927		/* redline method */
#define		WP_RedlineCharacter		928		/* redline character */
#define		WP_TableCellFormatDlg		929	 	/* format a table cell */
#define		WP_TableColumnFormatDlg		930	 	/* format a table col */
#define		WP_FileSaveDefaultFormat	931		/* Default save type */
#define		WP_PrintSelection		932	 	/* print selection (same as T_PRBLOCK) */
#define		WP_BoxStyleSave			933		/* box template save */
#define		WP_BoxStyleRetrieve		934		/* box template retrieve */
#define		WP_BorderStyleSave		935		/* border template save */
#define		WP_BorderStyleRetrieve		936		/* border template retrieve */
#define		WP_LineStyleSave		937		/* line template save */
#define		WP_LineStyleRetrieve		938		/* line template retrieve */
#define		WP_FillStyleSave		939		/* fill template save */
#define		WP_FillStyleRetrieve		940		/* fill template retrieve */
#define		WP_PageNumberDisplay		941		/* display page number */
#define		WP_PrintPreviewFullPage		942		/* full page view */
#define		WP_PrintPreviewFacingPages	943		/* facing pages */
#define		WP_PrintPreviewReferencePage	944		/* reference window (zoom) */
#define		WP_PrintPreviewGoToPage		945		/* goto page */
#define		WP_PrintPreviewPreviousPage	946		/* previous page */
#define		WP_PrintPreviewNextPage		947		/* next page */
#define		WP_PrintPreviewThumbnails1	948		/* 1 page thumbnail */
#define		WP_PrintPreviewThumbnails2	949		/* 2 page thumbnail */
#define		WP_PrintPreviewThumbnails4	950		/* 4 page thumbnail */
#define		WP_PrintPreviewThumbnails8	951		/* 8 page thumbnail */
#define		WP_PrintPreviewThumbnails32	952		/* 32 page thumbnail */
#define		WP_PrintPreviewThumbnailsOther	953		/* other (1-255) page thumbnail */
#define		WP_PrintPreviewZoom100		954		/* 100% zoom */
#define		WP_PrintPreviewZoom200		955		/* 200% zoom */
#define		WP_PrintPreviewZoomIn		956		/* zoom in */
#define		WP_PrintPreviewZoomOut		957		/* zoom out */
#define		WP_PrintPreviewZoomArea		958		/* zoom area */
#define		WP_PrintPreviewZoomReset	959		/* zoom reset */
#define		WP_PrintPreviewButtonBar	960		/* ButtonBar */
#define		WP_PrintPreviewButtonBarEdit	961		/* ButtonBar Edit */
#define		WP_PrintPreviewButtonBarOptions	962		/* ButtonBar Options */
#define		WP_PrintPreviewSetup		963		/* Preferences */
#define		WP_PrintPreviewExit		964		/* Exit */
#define		WP_PrintPreviewHelpMenu		965		/* Help */
#define		WP_LocationOfStyleFiles		966		/* setup: personal style libraries */
#define		WP_LocationOfSharedStyleFiles	967		/* setup: shared style libraries */
#define		WP_StyleDefaultPersonalLibrary	968		/* setup: default personal library */
#define		WP_StyleDefaultSharedLibrary	969		/* setup: default shared library */
#define		WP_StylePersonalLibrary		970		/* set new personal style library for doc */
#define		WP_StyleSharedLibrary		971		/* set new shared style library for doc */
#define		WP_MatchPositionAfter		972		/* match position after (c-engine only) */
#define		WP_MatchSelection		973		/* match select (c-engine only) */
#define		WP_ReplaceWithCase		974		/* affect case (c-engine only) */
#define		WP_ReplaceWithAttributes	975		/* affect attributes (c-engine only) */
#define		WP_ReplaceWithFont		976		/* affect font (c-engine only) */
#define		WP_ReplaceWithFontSize		977		/* affect font size (c-engine only) */
#define		WP_GoToShell			978		/* go to shell */
#define		WP_GoToDos			979		/* go to DOS */
#define		WP_ClipboardSaveTo		980		/* save to clipboard */
#define		WP_ClipboardAppendTo		981		/* append to clipboard */
#define		WP_ClipboardRetrieve		982		/* retrieve clipboard */
#define		WP_DOSCommand			983		/* DOS command */
#define		WP_MouseAutoselect		984		/* autoselect mouse */
#define		WP_GraphicsScreenAutoselect	985		/* autoselect graphics driver */
#define		WP_TextScreenAutoselect		986		/* autoselect text driver */
#define		WP_ColumnsDefinitionSimple	987		/* simple column definition */
#define		WP_FloatingCellCreateDlg	988		/* Single cell create dialog */
#define		WP_FloatingCellDlg		989		/* Single cell edit dialog */
#define		WP_EquationDisplay		990		/* display equation in window */
#define		WP_EuationCommandList		991		/* switch to command window */
#define		WP_CancelMouseSelect		992		/* cancel mouse select */
#define		WP_EquationPreviousWindow	993		/* preveious window */
#define		WP_EquationNextWindow		994		/* next window */
#define		WP_EquationPullDowns		995		/* equation pull downs */
#define		WP_PrintPreviewCancel		996		/* cancel view document */
#define		WP_BoxOverlap			997		/* BoxOverlap */
#define		WP_FileNew			998		/* New Document (get an empty/free doc) */
#define		WP_EditAll			999		/* edit all */
#define		WP_PrintParameters		1000		/* print parameters */
#define		WP_ResetAll			1001		/* reset all */
#define		WP_BWToggle			1002		/* bw toggle */
#define		WP_BWThreshold			1003		/* bw threshold */
#define		WP_InvertColors			1004		/* invert colors */
#define		WP_MirrorHorizontally		1005		/* mirror horizontally */
#define		WP_MirrorVertically		1006		/* mirror vertically */
#define		WP_Contrast			1007		/* contrast */
#define		WP_Lightness			1008		/* lightness */
#define		WP_FillNormal			1009		/* fill normal */
#define		WP_FillOpaque			1010		/* fill opaque */
#define		WP_FillTransparent		1011		/* fill transparent */
#define		WP_TableNameDlg			1012		/* Table Name Dialog */
#define		WP_Rotate			1013		/* rotate */
#define		WP_EnlargeArea			1014		/* enarea */
#define		WP_Enlarge			1015		/* enlarge */
#define		WP_Reduce			1016		/* reduce */
#define		WP_ResetSize			1017		/* reset size */
#define		WP_GFCancel			1018		/* cancel */
#define		WP_GFClose			1019		/* close */
#define		WP_GFSaveAs			1020		/* save as */
#define		WP_BBar				1021		/* Button Bar */
#define		WP_GVBBarEdit			1022		/* Button Bar Edit */
#define		WP_BBarOptions			1023		/* Button Bar Options */
#define		WP_StatusBoxToggle		1024		/* status box toggle */
#define		WP_PrintPreview			1025		/* View Document */
#define		WP_PrintPreviewFileMenu		1026		/* VDOC file pull-down */
#define		WP_PrintPreviewViewMenu		1027		/* view pulldown */
#define		WP_PrintPreviewPagesMenu	1028		/* pages pulldown */
#define		WP_Save				1029		/* save (not "Save as") */
#define		WP_PrintPreviewUpArrow		1030		/* uparrow */
#define		WP_PrintPreviewDownArrow	1031		/* down arrow */
#define		WP_PrintPreviewLeftArrow	1032		/* left arrow */
#define		WP_PrintPreviewRightArrow	1033		/* right arrow */
#define		WP_PrintPreviewPageUp		1034		/* page up */
#define		WP_PrintPreviewPageDown		1035		/* page down */
#define		WP_PrintPreviewScreenUp		1036		/* screen up */
#define		WP_PrintPreviewScreenDown	1037		/* screen down */
#define		WP_HeaderSeparationDistance	1038		/* header separator distance */
#define		WP_FooterSeparationDistance	1039		/* footer separator distance */
#define		WP_LineDrawArrow		1040		/* Line draw arrow (UP,DOWN,LEFT,RIGHT) */
#define		WP_LineDrawChange		1041		/* Line draw change mode and context type */
#define		WP_LineDrawSolidCharacter	1042		/* Line draw change solid character */
#define		WP_BookmarkDlg			1043		/* Full Bookmark dialog (for the pull downs) */
#define		WP_PrintPreviewHome		1044		/* View Doc. Home key */
#define		WP_BoxTextFilename		1045		/* BoxTextFilename */
#define		WP_BoxEquationFilename		1046		/* BoxEquationFilename */
#define		WP_FootnoteNumberIncrement	1047		/* footnote number increment */
#define		WP_FootnoteNumberDecrement	1048		/* footnote number decrement */
#define		WP_FootnoteNumberDisplay	1049		/* footnote number display */
#define		WP_GraphicsLineSpacing		1050		/* graphics line spacing */
#define		WP_GraphicsLineColor		1051		/* graphics line color */
#define		WP_GraphicsLineStyle		1052		/* graphics line border line style */
#define		WP_GraphicsLineUseColor		1053		/* graphics line use color */
#define		WP_SaveCheck			1054		/* check for "Save" or "Save as" */
#define		WP_GraphicsLineType		1055		/* graphics line type */
#define		WP_GraphicsLineLength		1056		/* graphics line length */
#define		WP_GraphicsLineThickness	1057		/* graphics line thickness */
#define		WP_GraphicsLineHorizontalPosition	1058		/* graphics line horizontal position */
#define		WP_GraphicsLineVerticalPosition	1059		/* graphics line vertical position */
#define		WP_BackTab			1060		/* margin release */
#define		WP_LineSegmentColor		1061		/* border line segment color */
#define		WP_BorderUseBorderColor		1062		/* border use border color */
#define		WP_EquationSaveGraphically	1063		/* save equation graphically */
#define		WP_StartEquationEditor		1064		/* start equation editor */
#define		WP_BoxCounter			1065		/* box counter */
#define		WP_SaveTempDoc			1066		/* save current doc in a temporary file */
#define		WP_ToAUnderlining		1067		/* ToA, underlining allowed */
#define		WP_ToACombinePageNumbers	1068		/* ToA, combine sequential pg #'s */
#define		WP_TableCellNumberFormat	1069		/* table cell number type - standard format */
#define		WP_TableCellNumberDecimalDigits	1070		/* table cell number type - # digits */
#define		WP_TableCellNumberDateFormat	1071		/* table cell number type - date format */
#define		WP_TableCellNumberRound		1072		/* table cell number type - round for calc */
#define		WP_TableCellNumberUseCommas	1073		/* table cell number type - use commas */
#define		WP_TableCellNumberNegativeNumber	1074		/* table cell number type - negative numbers display */
#define		WP_TableCellNumberUseCurrency	1075		/* table cell number type - use currency */
#define		WP_TableCellNumberAlignCurrency	1076		/* table cell number type - align currency */
#define		WP_TableCellNumberSelectCurrency	1077		/* table cell number type - international currency */
#define		WP_FormatMarginsDlg		1078		/* Margins Dlg */
#define		WP_TableBorderEditBegin		1079		/* start table border edit */
#define		WP_TableBorderEditEnd		1080		/* end table border edit */
#define		WP_SetupSave			1081		/* save Setup */
#define		WP_PosBlockTop			1082		/* move insertion point to beginning of block */
#define		WP_PosBlockBottom		1083		/* move insertion point to end of block */
#define		WP_ReselectLastBlock		1084		/* reselect last thing selected */
#define		WP_SelectTabularColumn		1085		/* make selection a tab column block (compatability) */
#define		WP_SelectRectangle		1086		/* make selection a rectangle block (compatability) */
#define		WP_BlockOn			1087		/* turn selection on */
#define		WP_BlockOff			1088		/* turn selection off */
#define		WP_CopyAndPaste			1089		/* copy block/col/rect */
#define		WP_CutAndPaste			1090		/* move block/col/rect */
#define		WP_BlockDelete			1091		/* delete block/col/rect */
#define		WP_PasteSpecial			1092		/* special paste last block */
#define		WP_TextBorderCustomizeDlg	1093		/* border function customize dialog */
#define		WP_TableColumnNumberFormat	1094		/* table col number type - standard format */
#define		WP_TableColumnNumberDecimalDigits	1095		/* table col number type - # digits */
#define		WP_TableColumnNumberDateFormat	1096		/* table col number type - date format */
#define		WP_TableColumnNumberRound	1097		/* table col number type - round for calc */
#define		WP_TableColumnNumberUseCommas	1098		/* table col number type - use commas */
#define		WP_TableColumnNumberNegNumber	1099		/* table col number type - negative numbers display */
#define		WP_TableColumnNumberUseCurrency	1100		/* table col number type - use currency */
#define		WP_TableColumnNumberAlignCurrency	1101		/* table col number type - align currency */
#define		WP_TableColumnNumberSelCurrency	1102		/* table col number type - international currency */
#define		WP_BorderSetSpacing		1103		/* BorderSetSpacing */
#define		WP_FloatingCellFormula		1104		/* Floating cell formula */
#define		WP_LabelsOff			1105		/* Labels off */
#define		WP_DelayCodes			1106		/* page delay */
#define		WP_DeleteToEndOfPage		1107		/* delete to end of page (no confirm) */
#define		WP_TableConvertFrom		1108		/* table convert from */
#define		WP_InsertFilenameWithPath	1109		/* print path\filename (see T_FILENAME) */
#define		WP_HeaderFooterWatermarkDlg	1110		/* Header/Footer/Watermark Dlg */
#define		WP_HypertextDlg			1111		/* Hypertext Dlg */
#define		WP_EquationSettings		1112		/* equation settings */
#define		WP_EquationView100		1113		/* equation 100% view */
#define		WP_EquationView200		1114		/* equation 200% view */
#define		WP_EquationBBarToggle		1115		/* equation bbar toggle */
#define		WP_EquationBBarEdit		1116		/* equation bbar edit */
#define		WP_BoxEquationPositionToError	1117		/* equation position to error */
#define		WP_EquationRedisplay		1118		/* equation redisplay */
#define		WP_EquationZoomArea		1119		/* equation zoom area */
#define		WP_EquationZoomFill		1120		/* equation zoom fill */
#define		WP_EquationZoomIn		1121		/* equation zoom in */
#define		WP_EquationZoomOut		1122		/* equation zoom out */
#define		WP_EquationBBarOptions		1123		/* equation bbar options */
#define		WP_FootnoteNewNumber		1124		/* footnote new number */
#define		WP_EndnoteNewNumber		1125		/* endnote new number */
#define		WP_FootnoteEdit			1126		/* footnote edit */
#define		WP_EndnoteEdit			1127		/* endnote edit */
#define		WP_Undelete			1128		/* undelete (no confirm) */
#define		WP_FaxError			1129		/* Fax Error */
#define		WP_FaxBegin			1130		/* Fax Begin */
#define		WP_FaxRasterize			1131		/* Rasterize document */
#define		WP_FaxScheduleBegin		1132		/* Start Schedule process */
#define		WP_FaxDestination		1133		/* Destination Record (multiple) */
#define		WP_FaxFile			1134		/* Filename Record (multiple) */
#define		WP_FaxParameters		1135		/* Set sched params */
#define		WP_FaxScheduleEnd		1136		/* End schedule (fax it) */
#define		WP_FaxEnd			1137		/* End fax session */
#define		WP_FootnoteEditDlg		1138		/* Footnote Edit Dlg */
#define		WP_EndnoteEditDlg		1139		/* Endnote Edit Dlg */
#define		WP_FootnoteSetNumberDlg		1140		/* Footnote New Number Dlg */
#define		WP_EndnoteSetNumberDlg		1141		/* Endnote New Number Dlg */
#define		WP_FootnoteOptionsDlg		1142		/* Footnote Options Dlg */
#define		WP_EndnoteOptionsDlg		1143		/* Endnote Options Dlg */
#define		WP_EndnotePlacementDlg		1144		/* Endnote Placement Dlg */
#define		WP_GraphicsLineCreate		1145		/* graphics line function create */
#define		WP_GraphicsLineEnd		1146		/* graphics line function end */
#define		WP_AttributeNormal		1147		/* change attributes to normal */
#define		WP_TableColumnWidthGrow		1148		/* grow a table column width */
#define		WP_TableColumnWidthShrink	1149		/* shrink a table column width */
#define		WP_CGAFastText			1150		/* fast text display */
#define		WP_DisplayMode			1151		/* display mode */
#define		WP_TableNameColumnDlg		1152		/* Name a table column */
#define		WP_TableNameRowDlg		1153		/* Name a table row */
#define		WP_DisplayRewrite		1154		/*  display mode, rewrite screen */
#define		WP_PrintPreviewEnd		1155		/*  view docucment end key */
#define		WP_TableEdit			1156		/* table edit */
#define		WP_SpellerGrammatikDisable	1157		/* disable Speller/Grammatik */
#define		WP_PrintPCL4PointSize		1158		/* setup, PCL4 print max point size */
#define		WP_HyphenationZoneLeft		1159		/*  left hyphenation hot zone */
#define		WP_HyphenationZoneRight		1160		/*  right hyphenation hot zone */
#define		WP_WindowMove			1161		/*  document window move */
#define		WP_WindowSize			1162		/*  document window size */
#define		WP_ListDefinitionEditBox	1163		/* list--edit graphic style include */
#define		WP_BoxEquationColorSet		1164		/* set equation color */
#define		WP_EndnoteNumberDisplay		1165		/* endnote number display */
#define		WP_LocationOfSharedPrinterFiles	1166		/* setup, printer shared files location */
#define		WP_BoxEquationDefaultFont	1167		/* box equation font size */
#define		WP_BoxEquationRotation		1168		/* box equation rotation */
#define		WP_BoxEquationFont		1169		/* box equation typeface */
#define		WP_LocationOfSharedMacroKbdFiles	1170		/* setup, keyboard/macro files location */
#define		WP_TableJoin			1171		/* join tables */
#define		WP_TableSplit			1172		/* split a table */
#define		WP_TabSet			1173		/* tabset all */
#define		WP_TabAdd			1174		/* tabset add */
#define		WP_TabDelete			1175		/* tabset delete */
#define		WP_TableDecimalAlignmentDistance	1176		/* table DAlgn using position */
#define		WP_TableDecimalAlignmentDigits	1177		/* table DAlgn using digits */
#define		WP_TableMarginLeft		1178		/* table left gutter spacing */
#define		WP_TableMarginRight		1179		/* table right gutter spacing */
#define		WP_TableColumnsFixedWidth	1180		/* table lock width */
#define		WP_TableFormatWidths		1181		/* table width */
#define		WP_DocCompareRemoveRedlineDlg	1182		/* Remove Redline/Strikeout Dlg */
#define		WP_TableFormatJustification	1183		/* table justification */
#define		WP_TableAttributeOff		1184		/* table attributes off */
#define		WP_TableAttributeOn		1185		/* table attributes on */
#define		WP_FileManagerSortDescending	1186		/* setup: doc mgmt/summ descending sort */
#define		WP_LocationOfSharedGraphicsFiles	1187		/* setup, graphics files shared location */
#define		WP_BlockSave			1188		/* block save */
#define		WP_LocationOfSharedSprFiles	1189		/* setup, shared spreadsheet files location */
#define		WP_ToAEditPageFormat		1190		/* edit toa format string */
#define		WP_ListEditPageFormat		1191		/* edit list format string */
#define		WP_PosFunction			1192		/* goto function with block on */
#define		WP_HiddenText			1193		/* hidden text (on/off) */
#define		WP_HiddenTextShowAll		1194		/* show all hidden text (on/off) */
#define		WP_CommentConvert		1195		/* convert comment to text */
#define		WP_BoxEditNext			1196		/* box edit next */
#define		WP_BoxEditPrevious		1197		/* box edit previous */
#define		WP_GraphicsLineEditNext		1198		/* rule edit next */
#define		WP_GraphicsLineEditPrevious	1199		/* rule edit previous */
#define		WP_SoundRecordingQualityDlg	1200		/* Sound Clip: Record Options Dialog */
#define		WP_ButtonBarSelect		1201		/* Button Bar: select (switch) */
#define		WP_BoxTextSettingsDlg		1202		/* Box: text render settings dialog */
#define		WP_BoxImageSettingsDlg		1203		/* Box: image render setting dialog */
#define		WP_SoundSetIOAddress		1204		/* Sound Setup: I/O address */
#define		WP_SoundSetInterrupt		1205		/* Sound Setup: Interrupt Request */
#define		WP_BoxEquationSettingsDlg	1206		/* Box: equation render settings dialog */
#define		WP_SoundSetSynthesizerPort	1207		/* Sound Setup: Set synthesizer port */
#define		WP_SoundRecordingQuality	1208		/* Sound Setup: Define Quality */
#define		WP_SoundSetMasterVolume		1209		/* Sound Setup: Master Volume */
#define		WP_StyleSystemOn		1210		/* System Style ON */
#define		WP_SoundClipCreate		1211		/* Sound Clip: Create (in prefix) */
#define		WP_SoundClipAddInstance		1212		/* Sound Clip: Instantiate (in doc) */
#define		WP_SoundClipDelete		1213		/* Sound Clip: Delete */
#define		WP_SoundClipEditDescription	1214		/* Sound Clip: Change Description */
#define		WP_SoundClipSave		1215		/* Sound Clip: Save to External File */
#define		WP_Thesaurus			1216		/* Thesaurus */
#define		WP_Grammatik			1217		/* Launch Grammatik */
#define		WP_SoundClipPlay		1218		/* Sound Clip: Play Clip */
#define		WP_SoundFilePlay		1219		/* Sound Clip: Play External File */
#define		WP_CrossRefEnterSubstructure	1220		/* Cross Ref command editor (mark both) */
#define		WP_SubdividePageOff		1221		/* Logical Pages: Off */
#define		WP_SoundStopPlay		1222		/* Sound Clip: Stop Play */
#define		WP_DisplayZoom			1223		/* zoom on document display window */
#define		WP_HypertextCreate		1224		/* hypertext create */
#define		WP_HypertextEdit		1225		/* hypertext edit */
#define		WP_HypertextDelete		1226		/* hypertext delete */
#define		WP_HypertextJumpRun		1227		/* hypertext execute */
#define		WP_HypertextReturnFrom		1228		/* hypertext return */
#define		WP_HypertextNext		1229		/* hypertext next */
#define		WP_HypertextPrevious		1230		/* hypertext previous */
#define		WP_Hypertext			1231		/* hypertext active mode (on/off) */
#define		WP_TableTextToFormula		1232		/* Scan a cell for a formula  */
#define		WP_BoxCaptionNumberStyle	1233		/* BoxCaptionNumberStyle */
#define		WP_ChapterNumber		1234		/* set new chapter number */
#define		WP_ChapterNumberMethod		1235		/* chapter number method */
#define		WP_ChapterNumberDisplay		1236		/* chapter number display */
#define		WP_ChapterNumberIncrement	1237		/* chapter number increment */
#define		WP_ChapterNumberDecrement	1238		/* chapter number decrement */
#define		WP_VolumeNumber			1239		/* set new volume number */
#define		WP_VolumeNumberMethod		1240		/* volume number method */
#define		WP_VolumeNumberDisplay		1241		/* volume number display */
#define		WP_VolumeNumberIncrement	1242		/* volume number increment */
#define		WP_VolumeNumberDecrement	1243		/* volume number decrement */
#define		WP_BoxResetCounter		1244		/* box counter override reset */
#define		WP_BoxResetPosition		1245		/* box position override reset */
#define		WP_BoxResetContent		1246		/* box content override reset */
#define		WP_BoxResetCaption		1247		/* box caption override reset */
#define		WP_BoxResetBorder		1248		/* box border override reset */
#define		WP_BoxResetFill			1249		/* box fill override reset */
#define		WP_BoxResetTextFlow		1250		/* box wrap override reset */
#define		WP_EndnoteNumberIncrement	1251		/* endnote number increment */
#define		WP_EndnoteNumberDecrement	1252		/* endnote number decrement */
#define		WP_QuickmarkDelete		1253		/* Delete Quickmark */
#define		WP_QuickmarkMove		1254		/* Move QuickMark */
#define		WP_QuickmarkBlock		1255		/* Find and Block QuickMark */
#define		WP_TableNumberFormat		1256		/* table number type - standard format */
#define		WP_TableNumberDecimalDigits	1257		/* table number type - # digits */
#define		WP_TableNumberDateFormat	1258		/* table number type - date format */
#define		WP_TableNumberRound		1259		/* table number type - round for calc */
#define		WP_TableNumberUseCommas		1260		/* table number type - use commas */
#define		WP_TableNumberNegativeNumber	1261		/* table number type - negative numbers display */
#define		WP_TableNumberUseCurrency	1262		/* table number type - use currency */
#define		WP_TableNumberAlignCurrency	1263		/* table number type - align currency */
#define		WP_TableNumberSelectCurrency	1264		/* table number type - international currency */
#define		WP_OutlineFamilySelect		1265		/* outline family select */
#define		WP_OutlineParagraphSelect	1266		/* outline paragraph select */
#define		WP_FloatingCellNumberFormat	1267		/* single cell number type - standard format */
#define		WP_FloatingCellNumberDecDigits	1268		/* single cell number type - # digits */
#define		WP_FloatingCellNumberDateFormat	1269		/* single cell number type - date format */
#define		WP_FloatingCellNumberRound	1270		/* single cell number type - round for calc */
#define		WP_FloatingCellNumberUseCommas	1271		/* single cell number type - use commas */
#define		WP_FloatingCellNumberNegNumber	1272		/* single cell number type - negative numbers display */
#define		WP_FloatingCellNumberUseCurrency	1273		/* single cell number type - use currency */
#define		WP_FloatingCellNumAlignCurrency	1274		/* single cell number type - align currency */
#define		WP_FloatingCellNumSelectCurrency	1275		/* single cell number type - international currency */
#define		WP_ToADefinitionUnderline	1276		/* toa def edit underlining allowed */
#define		WP_PosTableScreenRight		1277		/* position table screen right */
#define		WP_PosTableScreenLeft		1278		/* position table screen left */
#define		WP_PosTableScreenUp		1279		/* position table screen up */
#define		WP_PosTableScreenDown		1280		/* position table screen down */
#define		WP_OutlineBeginNew		1281		/* outline - begin new outline */
#define		WP_OutlineChangeToBodyText	1282		/* outline - change to body text */
#define		WP_OutlineBeginNewDlg		1283		/* outline dialog - begin new outline */
#define		WP_OutlineStyleDlg		1284		/* outline dialog - outline style */
#define		WP_PosColUp			1285		/* column up */
#define		WP_PosColDown			1286		/* column down */
#define		WP_DocCompareDlg		1287		/* CompareDoc Dlg */
#define		WP_PosTableGoPrevious		1288		/* table go-goto */
#define		WP_PosTableBlockBeg		1289		/* table goto block */
#define		WP_BoxCreateDlg			1290		/* graphic box create dlg */
#define		WP_BoxEditDlg			1291		/* graphic box edit dlg */
#define		WP_CounterDlg			1292		/* graphic box numbering dlg (Counter Dlg) */
#define		WP_BoxStyleDlg			1293		/* graphic box styles dlg */
#define		WP_LineCreateDlg		1294		/* graphic line create dlg */
#define		WP_LineEditDlg			1295		/* graphic line edit dlg */
#define		WP_LineStyleDlg			1296		/* graphic line styles dlg */
#define		WP_FillStyleDlg			1297		/* graphic fill styles dlg */
#define		WP_GraphicsFontsUpdate		1298		/* Update .DRS file (New Afcs) */
#define		WP_FileOpen			1299		/* open (retrieve) */
#define		WP_RevealCodes			1300		/* reveal codes */
#define		WP_Typeover			1301		/* replace insert */
#define		WP_SowImageBackground		1302		/* show image background */
#define		WP_SelectOn			1303		/* turn selection on */
#define		WP_SelectOff			1304		/* turn selection off */
#define		WP_SubtitleTOASort		1305		/* sort on subtitles for TOA */
#define		WP_SpaceDisplayCharacter	1306		/* space/tab display char */
#define		WP_TableCellCopyDlg		1307		/* table cell copy dialog */
#define		WP_TableMoveCopyDlg		1308		/* table move/copy dialog */
#define		WP_TableCellCopy		1309		/* table cell copy */
					/*	1310		Reserved */
#define		WP_RibbonSetup			1311		/* setup ribbon, current mode */
#define		WP_OutlineBarSetup		1312		/* setup outline */
#define		WP_HorizontalBarSetup		1313		/* setup horz scroll bar, current mode */
#define		WP_VerticalBarSetup		1314		/* setup vert scroll bar, current mode */
#define		WP_QuickListUpdate		1315		/* setup lof update quick lists */
#define		WP_FramedWindowSetup		1316		/* setup framed window */
#define		WP_FramedWindowSize		1317		/* size window */
#define		WP_FramedWindowMove		1318		/* move window */
#define		WP_TableMoveModeCancel		1319		/* Table cancel move */
#define		WP_TableUndelete		1320		/* Table undelete */
#define		WP_FontMatchBegin		1321		/* Font Match Begin token */
#define		WP_FontMatchEnd			1322		/* Font Match End Token */
#define		WP_TableNameDelete		1323		/* Table name delete */
#define		WP_BlockRectangle		1324		/* select rectangle from PDMs */
#define		WP_BlockColumn			1325		/* select column from PDMs */
#define		WP_DoubleWideBlock		1326		/* convert block to double-wide */
#define		WP_SingleWideBlock		1327		/* convert block to single-wide */
#define		WP_HiraganaBlock		1328		/* convert block to hiragana */
#define		WP_KatakanaBlock		1329		/* convert block to katakana */
#define		WP_LocationOfDRSFile		1330		/* setup, DRS file location */
#define		WP_ParagraphBorderDlg		1331		/* paragraph border dialog */
#define		WP_PageBorderDlg		1332		/* page border dialog */
#define		WP_ColumnBorderDlg		1333		/* column border dialog */
#define		WP_RetrieveImage		1334		/* Retrieve image command */
#define		WP_PrintPreviewMenu		1335		/* Preview main menu pull-down */
#define		WP_PrintGraphicsJob		1336		/* graphic print job */
#define		WP_BoxDlg			1337		/* graphics box create/edit dialog */
#define		WP_BoxCaptionOptionsDlg		1338		/* graphics box caption options dialog */
#define		WP_BoxContentOptionsDlg		1339		/* graphics box content options dialog */
#define		WP_BoxBorderDlg			1340		/* graphics box border dialog */
#define		WP_BoxCharPositionDlg		1341		/* graphics box character position dialog */
#define		WP_BoxParagraphPositionDlg	1342		/* graphics box paragraph position dialog */
#define		WP_BoxPagePositionDlg		1343		/* graphics box page position dialog */
#define		WP_BoxExactPositionDlg		1344		/* graphics box simple position dialog */
#define		WP_BoxSizeDlg			1345		/* graphics box size dialog */
#define		WP_BorderStyleEditDlg		1346		/* border style edit dialog */
#define		WP_BoxStyleEditDlg		1347		/* box style edit dialog */
#define		WP_FillStyleEditDlg		1348		/* fill style edit dialog */
#define		WP_LineStyleEditDlg		1349		/* line style edit  */
#define		WP_PrintPreviewInvert		1350		/* View document invert */
#define		WP_OutlineStyleRename		1351		/* outline style rename */
#define		WP_OutlineStyleDescription	1352		/* outline style description */
#define		WP_OutlineStyleNumbersOnly	1353		/* outline style numbers only */
#define		WP_OutlineStyleEditEnd		1354		/* outline style edit end */
#define		WP_OverstrikeCreateDlg		1355		/* overstrike create dlg */
#define		WP_HangingIndent		1356		/* Hanging Indent (Indent and Left Mar Release) */
#define		WP_OverstrikeEditDlg		1357		/* overstrike edit dlg */
#define		WP_QuickFinderDefine		1358		/* qf index define */
#define		WP_QuickFinderDirectoryPattern	1359		/* qf index dir pattern */
#define		WP_QuickFinderGenerate		1360		/* qf index generate marked indexes */
#define		WP_QuickFinderMark		1361		/* qf index mark */
#define		WP_QuickFinderDelete		1362		/* qf index delete */
#define		WP_QuickFinderDirPatternDelete	1363		/* qf index delete dir pattern */
#define		WP_QuickFinderRename		1364		/* qf index rename */
#define		WP_ScreenMatchBegin		1365		/* Screen Match begin */
#define		WP_ScreenMatchTable		1366		/* Screen Match table */
#define		WP_ScreenMatchEnd		1367		/* Screen Match End */
#define		WP_EquationDisplayMoveUp	1368		/* move equation display up */
#define		WP_EquationDisplayMoveDown	1369		/* move equation display down */
#define		WP_EquationDisplayMoveRight	1370		/* move equation display right */
#define		WP_EquationDisplayMoveLeft	1371		/* move equation display left */
#define		WP_EquationDisplayFit		1372		/* fit equation in display */
#define		WP_EquationDisplayScaleUp	1373		/* scale display up */
#define		WP_EquationDisplayScaleDown	1374		/* scale display down */
#define		WP_DeleteAppendFilenameDlg	1375		/* append with delete filename dialgo */
#define		WP_DeleteAppend			1376		/* append with delete to file or default block */
#define		WP_InitialCodesDocDlg		1377		/* initial codes dialog */
#define		WP_InitialCodesSetupDlg		1378		/* setup initial codes dialog */
#define		WP_QuickFinderDlg		1379		/* quickfinder dialog */
#define		WP_QuickFinderOptions		1380		/* quickfinder index options */
#define		WP_QuickFinderSelect		1381		/* quickfinder select index */
#define		WP_UndoAllow			1382		/* allow undo */
#define		WP_FloatingCellEdit		1383		/* single cell edit */
#define		WP_ReselectLastSelection	1384		/* reselect last thing selected (compatability) */
#define		WP_BlockTabularColumn		1385		/* change block to column */
#define		WP_BlockToRectangle		1386		/* change block to rectangle */
#define		WP_SelectDelete			1387		/* select delete  (compatability) */
#define		WP_PosSelectTop			1388		/* move insertion point (compatability) */
#define		WP_PosSelectBottom		1389		/* move insertion point (compatability) */
#define		WP_FileManagerDlg		1390		/* wsys token */
#define		WP_SetupDlg			1391		/* wset token */
#define		WP_ScreenDlg			1392		/* wrws token */
#define		WP_PullDownDlg			1393		/* wpdm token */
#define		WP_EndField			1394		/* wmrr token */
#define		WP_PosLineUp			1395		/* wua token */
#define		WP_PosCharNext			1396		/* wra token */
#define		WP_PosCharPrevious		1397		/* wla token */
#define		WP_PosLineDown			1398		/* wda token */
#define		WP_PosPagePrevious		1399		/* wpp token */
#define		WP_PosPageNext			1400		/* wnp token */
#define		WP_GoToDlg			1401		/* wgo token */
#define		WP_GoForShell			1402		/* go to shell */
#define		WP_BoxImagePresentations	1403		/* go to presentations */
#define		WP_AttributeRelativeSize	1404		/* Attribute Relative size (large,xlarge,etc) */
#define		WP_EquationCancel		1405		/* cancel equation */
#define		WP_EquationExit			1406		/* exit equation */
#define		WP_EquationRetrieve		1407		/* retrieve equation */
#define		WP_BoxEquationSave		1408		/* output equation text */
#define		WP_AttributeRelativeSizeToggle	1409		/* Attribute Relative size Toggle */
#define		WP_AttributePositionToggle	1410		/* Attribute Position Toggle */
#define		WP_BoxEquationSaveAsGraphic	1411		/* save equation as graphic */
#define		WP_CounterBoxNumberingDlg	1412		/* box numbering counter dialog */
#define		WP_GraphicBoxGeneralEdit	1413		/* graphics box edit general */
#define		WP_GraphicLineGeneralEdit	1414		/* graphics line edit general */
#define		WP_GraphicsBoxSelectEdit	1415		/* graphics box edit selected */
#define		WP_GraphicsLineSelectEdit	1416		/* graphics line edit selected */
#define		WP_OutlineParagraphNumberDrag	1417		/* outlineleveldrag */
#define		WP_TableEditDlg			1418		/* table edit and dialog */
#define		WP_FloatingCellEditDlg		1419		/* single cell edit and dialog */
#define		WP_TableCreateDlg2		1420		/* table create and edit dialog */
#define		WP_BoxResetContentRender	1421		/* BoxContentRenderReset */
#define		WP_SubdocRename			1422		/* Subdoc rename */
#define		WP_PosColNextWP51		1423		/* goto next text column or table column */
#define		WP_PosColPreviousWP51		1424		/* goto previous text column or table column */
#define		WP_OutlineStyleDelete		1425		/* outline style delete */
#define		WP_OutlineStyleSave		1426		/* outline style save */
#define		WP_OutlineStyleRetrieve		1427		/* outline style retrieve */
#define		WP_ButtonBarPosition		1428		/* button bar position */
#define		WP_ButtonBarStyle		1429		/* button bar style */
#define		WP_MouseSelect			1430		/* mouse driver select */
#define		WP_SoundSelect			1431		/* sound driver select */
#define		WP_GraphicsScreenSelect		1432		/* video driver select */
#define		WP_TextScreenSelect		1433		/* text driver select */
#define		WP_MouseInitialize		1434		/* mouse driver init */
#define		WP_SpellerEditSupDictionary	1435		/* speller - edit sup dictionary */
#define		WP_SpellerWord			1436		/* speller - check word */
#define		WP_SpellerPage			1437		/* speller - check page */
#define		WP_SpellerDoc			1438		/* speller - check document */
#define		WP_LanguageSelectDlg		1439		/* select language dialog */
#define		WP_MouseUnselect		1440		/* unselect mouse driver */
#define		WP_SoundUnselect		1441		/* unselect sound driver */
#define		WP_FloatingCellEnd		1442		/* move the cursor just past the floating cell */
#define		WP_FloatingCellBegin		1443		/* move the cursor just before the floating cell */
#define		WP_AdvanceDlg			1444		/* advance dialog */
#define		WP_OutlineStyleCopy		1445		/* outline style copy */
#define		WP_HiddenTextDlg		1446		/* hidden text dialog */
#define		WP_FootnoteStyleDocDlg		1447		/* footnote style in document dlg */
#define		WP_EndnoteStyleDocDlg		1448		/* endnote style in document dlg */
#define		WP_FootnoteStyleDlg		1449		/* footnote style dlg */
#define		WP_EndnoteStyleDlg		1450		/* endnote style dlg */
#define		WP_PrinterControlNetworkQueue	1451		/* network queue display */
#define		WP_FaxStatusBegin		1452		/* Begin fax status dialog */
#define		WP_FaxStatusEnd			1453		/* End fax status dialog */
#define		WP_DisplayZoomSetup		1454		/* set default zoom */
#define		WP_SpecificStringEnd		1455		/* specific search/replace/delete string end */
#define		WP_BoxImageClipboardSave	1456		/* save image to clipboard */
#define		WP_BoxImageClipboardRetrieve	1457		/* read image from clipboard */
#define		WP_RevealCodesWindowSize	1458		/* set document reveal codes window percentage */

#define		WP_RibbonSetupText		1459		/* setup ribbon in text mode */
#define		WP_HorizontalBarSetupText	1460		/* setup hsb in text mode */
#define		WP_VerticalBarSetupText		1461		/* setup vsb in text mode */
#define		WP_ButtonBarSetupText		1462		/* setup button bar in text mode */
#define		WP_RibbonSetupGraphics		1463		/* setup ribbon in graphics mode */
#define		WP_HorizontalBarSetupGraphics	1464		/* setup hsb in graphics mode */
#define		WP_VerticalBarSetupGraphics	1465		/* setup vsb in graphics mode */
#define		WP_ButtonBarSetupGraphics	1466		/* setup button bar in graphics mode */
#define		WP_FileListDlg			1467		/* show the listfiles dialog */
#define		WP_OutlineFamilyHideNonrecordable	1468		/* non-recordable outline family hide */
#define		WP_OutlineFamilyShowNonrecordable	1469		/* non-recordable outline family show */
#define		WP_SpecialCodesDlg		1470		/* special codes dlg */
#define		WP_RequireHyphen		1471		/* required hyphen */
#define		WP_DocCharacterMapDlg		1472		/* document character map dialog */
#define		WP_DocCharacterMapDefaultDlg	1473		/* setup character map dialog */
#define		WP_Append			1474		/* append to clipboard (compatability) */
#define		WP_FootnoteMouseEdit		1475		/* edit footnote via mouse */
#define		WP_EndnoteMouseEdit		1476		/* edit endnote via mouse */
#define		WP_FootnoteMouseDelete		1477		/* delete footnote via mouse */
#define		WP_EndnoteMouseDelete		1478		/* delete endnote via mouse */

#define		WP_AND				4096		/* Macro command only */
#define		WP_APPLICATION			4097		/* Macro command only */
#define		WP_ASSERT			4098		/* Macro command only */
#define		WP_ASSIGN			4099		/* (T_ASSIGN) Macro command only */
#define		WP_BEEP				4100		/* Macro command only */
#define		WP_BREAK			4101		/* Macro command only */
#define		WP_CALL				4102		/* Macro command only */
#define		WP_CANCEL			4103		/* Macro command only */
#define		WP_SWITCH			4104		/* Macro command only */
#define		WP_CASEOF			4105		/* Macro command only */
#define		WP_MacroFilePlay		4106		/* Play macro file (see CHAIN in WPMRS for format) */
#define		WP_CHAIN			4106		/* (T_CHAIN) Macro command only */
#define		WP_DEFAULTAPP			4107		/* Macro command only */
#define		WP_ELSE				4108		/* Macro command only */
#define		WP_ENDAPP			4109		/* Macro command only */
#define		WP_ENDSWITCH			4110		/* Macro command only */
#define		WP_ENDFOR			4111		/* Macro command only */
#define		WP_ENDFUNC			4112		/* Macro command only */
#define		WP_ENDIF			4113		/* Macro command only */
#define		WP_ENDPROC			4114		/* Macro command only */
#define		WP_ENDWHILE			4115		/* Macro command only */
#define		WP_EXISTS			4116		/* Macro command only */
#define		WP_FORNEXT			4117		/* Macro command only */
#define		WP_FOREACH			4118		/* Macro command only */
#define		WP_FRACTION			4119		/* Macro command only */
#define		WP_FUNCTION			4120		/* Macro command only */
#define		WP_GLOBAL			4121		/* Macro command only */
#define		WP_GO				4122		/* Macro command only */
#define		WP_IF				4123		/* Macro command only */
#define		WP_INTEGER			4124		/* Macro command only */
#define		WP_LABEL			4125		/* Macro command only */
#define		WP_LOCAL			4126		/* Macro command only */
#define		WP_MENULIST			4127		/* Macro command only */
#define		WP_DIV				4128		/* Macro command only */
#define		WP_NEXT				4129		/* Macro command only */
#define		WP_NOT				4130		/* Macro command only */
#define		WP_NUMSTR			4131		/* Macro command only */
#define		WP_ONCANCEL			4132		/* Macro command only */
#define		WP_ONERROR			4133		/* Macro command only */
#define		WP_ONNOTFOUND			4134		/* Macro command only */
#define		WP_OR				4135		/* Macro command only */
#define		WP_PAUSE			4136		/* Macro command only */
#define		WP_PROCEDURE			4137		/* Macro command only */
#define		WP_PRODUCT			4138		/* Macro command only */
#define		WP_QUIT				4139		/* Macro command only */
#define		WP_REPEAT			4140		/* Macro command only */
#define		WP_RETURN			4141		/* Macro command only */
#define		WP_NEST				4142		/* (T_NEST) Play macro2 during macro1 */
#define		WP_SPEED			4143		/* Macro command only */
#define		WP_STRLEN			4144		/* Macro command only */
#define		WP_STRNUM			4145		/* Macro command only */
#define		WP_SUBSTR			4146		/* Macro command only */
#define		WP_STRPOS			4147		/* Macro command only */
#define		WP_UNTIL			4148		/* Macro command only */
#define		WP_USE				4149		/* Macro command only */
#define		WP_WAIT				4150		/* Macro command only */
#define		WP_WHILE			4151		/* Macro command only */
#define		WP_XOR				4152		/* Macro command only */
#define		WP_STEP				4153		/* Macro command only */
#define		WP_DEFAULT			4154		/* Macro command only */
#define		WP_CONTINUE			4155		/* Macro command only */
#define		WP_PERSIST			4156		/* Macro command only */
#define		WP_GETNUMBER			4157		/* Macro command only */
#define		WP_GETUNITS			4158		/* Macro command only */
#define		WP_GETSTRING			4159		/* Macro command only */
#define		WP_DLGCREATE			4160		/* Macro command only */
#define		WP_DLGCONTROL			4161		/* Macro command only */
#define		WP_DLGEND			4162		/* Macro command only */
#define		WP_TOUPPER			4163		/* Macro command only */
#define		WP_TOLOWER			4164		/* Macro command only */
#define		WP_CTON				4165		/* Macro command only */
#define		WP_NTOC				4166		/* Macro command only */
#define		WP_UNITSTR			4167		/* Macro command only */
#define		WP_STRUNIT			4168		/* Macro command only */
#define		WP_DEFAULTUNITS			4169		/* Macro command only */
#define		WP_DLGINPUT			4170		/* Macro command only */
#define		WP_DISPLAY			4171		/* Macro command only */
#define		WP_CHAR				4172		/* Macro command only */
#define		WP_LOOK				4173		/* Macro command only */
#define		WP_PAUSEKEY			4174		/* Macro command only */
#define		WP_STATUSPROMPT			4175		/* Macro command only */
#define		WP_SHELLMACRO			4176		/* Macro command only */
#define		WP_PROMPT			4177		/* Macro command only */
#define		WP_INPUT			4178		/* Macro command only */
#define		WP_DISCARD			4179		/* Macro command only */
//						4180
#define		WP_NOTFOUND			4181		/* Macro command only */
#define		WP_PAUSESET			4182		/* Macro command only */
#define		WP_SHELLASSIGN			4183		/* Macro command only */
#define		WP_SHELLVARIABLE		4184		/* Macro command only */
#define		WP_SAVESTATE			4185		/* Macro command only */
#define		WP_SHOWTEXT			4186		/* Macro command only */
#define		WP_SHOWPOSITION			4187		/* Macro command only */
#define		WP_SHOWCODE			4188		/* Macro command only */
#define		WP_SHOWATTRON			4189		/* Macro command only */
#define		WP_SHOWATTROFF			4190		/* Macro command only */
#define		WP_INDIRECT			4191		/* Macro command only */
#define		WP_VARERRCHK			4192		/* Macro command only */
#define		WP_ERROR			4193		/* Macro command only */
#define		WP_PAUSECOMMAND			4194		/* Macro command only */
#define		WP_PERSISTALL			4195		/* Macro command only */
#define		WP_SHOWCOLOR			4196		/* Macro command only */
#define		WP_PRESSKEY			4197		/* Macro command only */
#define		WP_RUNUNATTENDED		4198		/* Macro command only */
#define		WP_RUN				4199		/* duplicate of NEST */
#define		WP_IFPLATFORM			4200		/* (IFPLATFORM(DOS)) Macro command only */
#define		WP_ENDIFPLATFORM		4201		/* (ENDIFPLATFORM [(DOS)]) Macro command only */
#define		WP_FOR				4202		/* (FOR(var;Init;Test;Inc)) Macro command only */
#define		WP_DECLARE			4203		/* (duplicate of LOCAL (for WPWin)) Macro command only */

#define		WP_Comment			65535		/* Macro comment, never passed */

/*========================================================================*
 *                   Token Parameter Constants                            *
 *		 -name-				-value-                   *
 *========================================================================*/
#define		_OFF_				0
#define		_ON_				1

#define		_NO_				0
#define		_YES_				1

#define		_CANCEL_			0
#define		_SAVE_				1

#define		_ABSOLUTE_			0
#define		_RELATIVE_			1

#define		_DO_NOT_PRINT_			0
#define		_DRAFT_				1
#define		_MEDIUM_			2
#define		_HIGH_				3

#define		_BLACK_				0
#define		_FULL_COLOR_			1
#define		_SOLID_COLOR_			2

#define		_NUMBERS_			0
#define		_LOWER_LETTERS_			1
#define		_UPPER_LETTERS_			2
#define		_LOWER_ROMAN_			3
#define		_UPPER_ROMAN_			4

#define		_CHARACTERS_			5

#define		_DEF_NONE_			0
#define		_DEF_FOLLOWS_			1
#define		_DEF_PARENTHESES_		2
#define		_DEF_FLUSH_RIGHT_		3
#define		_DEF_LEADER_			4

#define		_EXTRA_LARGE_			0
#define		_VERY_LARGE_			1
#define		_LARGE_				2
#define		_SMALL_				3
#define		_FINE_				4
#define		_SUPERSCRIPT_			5
#define		_SUBSCRIPT_			6
#define		_OUTLINE_			7
#define		_ITALICS_			8
#define		_SHADOW_			9
#define		_REDLINE_			10
#define		_DOUBLEUNDERLINE_		11
#define		_BOLD_				12
#define		_STRIKEOUT_			13
#define		_UNDERLINE_			14
#define		_SMALLCAPS_			15
#define		_EVERY_				16

#define		_NORMAL_SIZE_			5

#define		_NORMAL_POSITION_		7

#define		_LEFT_				0
#define		_FULL_				1
#define		_CENTER_			2
#define		_RIGHT_				3
#define		_FULL_ALL_			4
#define		_DEC_ALLIGN_			5	/* only used for table tokens */

#define		_TOP_				1
#define		_BOTTOM_			4

#define		_SPEEDO_			134
#define		_INTELLIFONT_			135
#define		_TYPE1_				138
#define		_TRUETYPE_			139

#define		_INCHES_			0
#define		_INCHES_I_			1
#define		_CENTIMETERS_			2
#define		_MILLIMETERS_			3
#define		_POINTS_			4
#define		_WP_1200THS_			5
#define		_WP42_UNITS_			6

#define		_NORMAL_			0
#define		_DOT_LEADER_			1

#define		_NONE_				0
#define		_DEGREES90_			1
#define		_DEGREES180_			2
#define		_DEGREES270_			3

#define		_FIGURE_BOX_			0
#define		_TABLE_BOX_			1
#define		_TEXT_BOX_			2
#define		_USER_BOX_			3
#define		_EQUATION_BOX_			4
#define		_BUTTON_BOX_			5
#define		_WATERMARK_IMAGE_BOX_		6
#define		_INLINE_EQUATION_BOX_		7
#define		_NO_BOX_			127

#define		_NO_COMBINE_			0
#define		_COMBINE_			1

#define		_NO_TOA_UNDERLINE_		0
#define		_TOA_UNDERLINE_			1

#define		_FULL_ALLIGN_			7

#define		_BASELINE_			6

#define		_SPACING_ONLY_			0
#define		_SINGLE_BORDER_			1
#define		_DOUBLE_BORDER_			2
#define		_DASHED_BORDER_			3
#define		_DOTTED_BORDER_			4
#define		_THICK_BORDER_			5
#define		_EXTRA_THICK_BORDER_		6
#define		_THIN_THICK_BORDER_		7
#define		_THICK_THIN_BORDER_		8
#define		_THICK_TOP_BOTTOM_BORDER_	9
#define		_BUTTON_BORDER_			10
#define		_COLUMN_BORDER_BETWEEN_		11
#define		_COLUMN_BORDER_ALL_		12
#define		_NO_BORDER_			127

#define		_SINGLE_LINE_			0
#define		_DOUBLE_LINE_			1
#define		_DASHED_LINE_			2
#define		_DOTTED_LINE_			3
#define		_THICK_LINE_			4
#define		_ExtraThickLine_		5
#define		_THIN_THICK_LINE_		6
#define		_THICK_THIN_LINE_		7
#define		_BUTTON_TOP_LEFT_LINE_		8
#define		_BUTTON_BOTTOM_RIGHT_LINE_	9
#define		_TABLE_DEFAULT_LINE_		126
#define		_NO_LINE_			127

#define		_FILL10_			0
#define		_FILL20_			1
#define		_FILL30_			2
#define		_FILL40_			3
#define		_FILL50_			4
#define		_FILL60_			5
#define		_FILL70_			6
#define		_FILL80_			7
#define		_FILL90_			8
#define		_FILL100_			9
#define		_FILL_BUTTON_			10
#define		_NO_FILL_			127

#define		_NO_SHADOW_			0
#define		_UPPER_LEFT_			1
#define		_LOWER_LEFT_			2
#define		_LOWER_RIGHT_			3
#define		_UPPER_RIGHT_			4

#define		_TEXT_				1
#define		_LINKED_TEXT_			2
#define		_IMAGE_				3
#define		_EQUATION_			4
#define		_PRESENTATION_			5
#define		_VIDEO_				6
#define		_MACRO_				7
#define		_EXTERNAL_			8
#define		_EMPTY_				127

#define		_LINEAR_GRADIENT_		0
#define		_RADIAL_GRADIENT_		1
#define		_RECTANGULAR_GRADIENT_		2

#define		_WPG2_SOLID_			0
#define		_WPG2_50GRAY_			1
#define		_WPG2_25GRAY_			2
#define		_WPG2_12GRAY_			3
#define		_WPG2_CROSSHATCH1_		4
#define		_WPG2_CROSSHATCH2_		5
#define		_WPG2_CROSSHATCH3_		6
#define		_WPG2_CROSSHATCH4_		7
#define		_WPG2_LINES1_			8
#define		_WPG2_LINES2_			9
#define		_WPG2_LINES3_			10
#define		_WPG2_LINES4_			11
#define		_WPG2_LINES5_			12
#define		_WPG2_LINES6_			13
#define		_WPG2_LINES7_			14
#define		_WPG2_LINES8_			15
#define		_WPG2_CHECKBOARD1_		16
#define		_WPG2_CHECKBOARD2_		17
#define		_WPG2_BRICKS1_			18
#define		_WPG2_BRICKS2_			19
#define		_WPG2_FISH_SCALE_		20
#define		_WPG2_HONYCOMB_			21
#define		_WPG2_PATIO_			22
#define		_WPG2_CHAINLINK_		23
#define		_WPG2_WEAVE_			24
#define		_WPG2_PLAID_			25
#define		_WPG2_BALLS_			26
#define		_WPG2_MESH_			27
#define		_WPG2_CROSSES_			28
#define		_WPG2_TRIANGLES_		29
#define		_WPG2_WAVES_			30
#define		_WPG2_ARCH_			31

#define		_WORDPERFECT_GRAPHIC_10_	725
#define		_WORDPERFECT_GRAPHIC_20_	726
#define		_TAGGED_IMAGE_FILE_FORMAT_	727
#define		_PC_PAINTBRUSH_X_		728
#define		_WINDOWS_METAFILE_		729
#define		_BITMAP_			730
#define		_CGM_				731
#define		_AUTO_CAD_DXF_			732
#define		_ENCAPSULATED_POSTSCRIPT_	733
#define		_HEWLETTPACKARD_GRAPHIC_PLOTTER_	734
#define		_MACINTOSH_PICT_		736
#define		_MICROGRAFX_			737
#define		_PRESENTATIONS_20_		738
#define		_TARGA_				741	/* Cannot save in this format */
#define		_LOTUS_PIC_			739	/* Cannot save in this format */

#define		_WORDPERFECT_50_		2
#define		_WORDPERFECT_51_52_		3
#define		_WORDPERFECT_60_		4
#define		_WORDPERFECT_MAC_20_		20	/* Cannot save in this format */
#define		_WORDPERFECT_MAC_21_		21	/* Cannot save in this format */
#define		_WORDSTAR_33_			30
#define		_WORDSTAR_331_			31
#define		_WORDSTAR_34_			32
#define		_WORDSTAR_40_			33
#define		_WORDSTAR_50_			34
#define		_WORDSTAR_55_			35
#define		_WORDSTAR_60_			36
#define		_WORDSTAR2000_10_		50
#define		_WORDSTAR2000_20_		51
#define		_WORDSTAR2000_30_		52
#define		_MICROSOFT_WORD_40_		62
#define		_MICROSOFT_WORD_50_		63
#define		_MICROSOFT_WORD_55_		64
#define		_WORD_FOR_WINDOWS_10_		70
#define		_WORD_FOR_WINDOWS_11_		71
#define		_WORD_FOR_WINDOWS_1A_1B_	72
#define		_WORD_FOR_WINDOWS_20_		73
#define		_WORD_FOR_WINDOWS_2A_		74
#define		_WORD_FOR_WINDOWS_2B_		75
#define		_RFT_				80
#define		_FFT_				81
#define		_DISPLAY_WRITE_40_		82	/* Cannot save in this format */
#define		_DISPLAY_WRITE_42_		83	/* Cannot save in this format */
#define		_DISPLAY_WRITE_50_		84	/* Cannot save in this format */
#define		_MULTIMATE_33_			100
#define		_MULTIMATE_ADVANTAGE_36_	101
#define		_MULTIMATE_ADVANTAGE_II_10_	102
#define		_MULTIMATE_40_			103
#define		_OFFICEWRITER_60_		120
#define		_OFFICEWRITER_61_		121
#define		_OFFICEWRITER_611_		122
#define		_OFFICEWRITER_62_		123
#define		_WORDPERFECT_MERGE_		130	/* Cannot save in this format */
#define		_RTF_				150
#define		_ASCII_STANDARD_		160
#define		_DELIMITED_TEXT_		163
#define		_ASCII_STRIPPED_		165
#define		_ASCII_SRT_			166	/* Cannot save in this format */
#define		_KERMIT_			173
#define		_NAVY_DIF_			175
#define		_AMIPRO_12_			311	/* Cannot save in this format */
#define		_AMIPRO_12A_			312	/* Cannot save in this format */
#define		_AMIPRO_12B_			313	/* Cannot save in this format */
#define		_AMIPRO_20_			314	/* Cannot save in this format */
#define		_AMIPRO_30_			315	/* Cannot save in this format */
#define		_MS_WINDOWS_WRITE_		70	/* Cannot save in this format */
#define		_SPREADSHEET_DIF_		800
#define		_EXCEL_21_			805	/* Cannot save in this format */
#define		_EXCEL_30_			806	/* Cannot save in this format */
#define		_EXCEL_40_			807	/* Cannot save in this format */
#define		_LOTUS123_1A_			815	/* Cannot save in this format */
#define		_LOTUS123_20_			816	/* Cannot save in this format */
#define		_LOTUS123_23_			817	/* Cannot save in this format */
#define		_LOTUS123_24_			818	/* Cannot save in this format */
#define		_LOTUS123_30_			825	/* Cannot save in this format */
#define		_LOTUS123_31_			826	/* Cannot save in this format */
#define		_QUATTROPRO_30_			836	/* Cannot save in this format */
#define		_QUATTROPRO_40_			837	/* Cannot save in this format */
#define		_PLANPERFECT_30_		845	/* Cannot save in this format */
#define		_PLANPERFECT_50_		846	/* Cannot save in this format */
#define		_PLANPERFECT_51_		847	/* Cannot save in this format */

#define		_AUTO_				0
#define		_FIXED_				1

#define		_MULTIPLE_			0
#define		_SINGLE_			1

#define		_HIDE_				0
#define		_SHOW_				1
#define		_ICON_				2

#define		_ALIGN_LEFT_			0
#define		_ALIGN_RIGHT_			1
#define		_ALIGN_CENTER_			2
#define		_ALIGN_FULL_			3
#define		_ALIGN_ABSOLUTE_		4

#define		_NORMAL_STYLE_			0
#define		_FOOTNOTE_NUMBER_IN_DOC_STYLE_	16
#define		_ENDNOTE_NUMBER_IN_DOC_STYLE_	17
#define		_FIGURE_NUMBER_STYLE_		18
#define		_TABLE_BOX_NUMBER_STYLE_	19
#define		_TEXT_BOX_NUMBER_STYLE_		20
#define		_USER_BOX_NUMBER_STYLE_		21
#define		_EQUATION_NUMBER_STYLE_		22
#define		_HYPERTEXT_STYLE_		23
#define		_TOC1_STYLE_			24
#define		_TOC2_STYLE_			25
#define		_TOC3_STYLE_			26
#define		_TOC4_STYLE_			27
#define		_TOC5_STYLE_			28
#define		_INDEX1_STYLE_			29
#define		_INDEX2_STYLE_			30
#define		_LIST_STYLE_			31
#define		_TOA_STYLE_			32
#define		_INITIAL_CODES_STYLE_		33
#define		_BOX_TEXT_STYLE_		34
#define		_CAPTION_STYLE_			35
#define		_FOOTNOTE_STYLE_		36
#define		_ENDNOTE_STYLE_			37
#define		_COMMENT_STYLE_			38
#define		_HEADER_A_STYLE_		39
#define		_HEADER_B_STYLE_		40
#define		_FOOTER_A_STYLE_		41
#define		_FOOTER_B_STYLE_		42
#define		_WATERMARK_A_STYLE_		43
#define		_WATERMARK_B_STYLE_		44
#define		_PARAGRAPH_OUT_IN_STYLE_	45
#define		_OUTLINE_STYLE_			46
#define		_LEGAL_OUT_IN_STYLE_		47
#define		_BULLETS_OUT_IN_STYLE_		48
#define		_HEADINGS_OUT_IN_STYLE_		49
#define		_LEGAL_2_OUT_IN_STYLE_		50
#define		_NUMBERS_OUT_IN_STYLE_		51
#define		_LEVEL1_STYLE_			52
#define		_LEVEL2_STYLE_			53
#define		_LEVEL3_STYLE_			54
#define		_LEVEL4_STYLE_			55
#define		_LEVEL5_STYLE_			56
#define		_LEVEL6_STYLE_			57
#define		_LEVEL7_STYLE_			58
#define		_LEVEL8_STYLE_			59
#define		_LEGAL1_STYLE_			60
#define		_LEGAL2_STYLE_			61
#define		_LEGAL3_STYLE_			62
#define		_LEGAL4_STYLE_			63
#define		_LEGAL5_STYLE_			64
#define		_LEGAL6_STYLE_			65
#define		_LEGAL7_STYLE_			66
#define		_LEGAL8_STYLE_			67
#define		_HEADING1_STYLE_		68
#define		_HEADING2_STYLE_		69
#define		_HEADING3_STYLE_		70
#define		_HEADING4_STYLE_		71
#define		_HEADING5_STYLE_		72
#define		_HEADING6_STYLE_		73
#define		_HEADING7_STYLE_		74
#define		_HEADING8_STYLE_		75

#define		_CURRENT_DOC_			0
#define		_PERSONAL_LIBRARY_		1
#define		_SHARED_LIBRARY_		2

#define		_CREATE_			1
#define		_EDIT_				2

#define		_ODD_PAGES_			1
#define		_EVEN_PAGES_			2
#define		_ALL_PAGES_			3

#define		_UP_ARROW_			23
#define		_RIGHT_ARROW_			24
#define		_LEFT_ARROW_			25
#define		_DOWN_ARROW_			26
#define		_END_				85	/* end key (extend half cell to full) */
#define		_HOME_UP_ARROW_			87	/* add 0x40 for home key */
#define		_HOME_RIGHT_ARROW_		88
#define		_HOME_LEFT_ARROW_		89
#define		_HOME_DOWN_ARROW_		90
#define		_HOME_HOME_UP_ARROW_		151	/* add 0x80 for home-home keys */
#define		_HOME_HOME_RIGHT_ARROW_		152
#define		_HOME_HOME_LEFT_ARROW_		153
#define		_HOME_HOME_DOWN_ARROW_		154

#define		_PAGE_BORDER_			0
#define		_PARAGRAPH_BORDER_		1
#define		_COLUMN_BORDER_			2

#define		_NONE_				0
#define		_FIGURE_COUNTER_		1
#define		_TABLE_BOX_COUNTER_		2
#define		_TEXT_BOX_COUNTER_		3
#define		_USER_BOX_COUNTER_		4
#define		_EQUATION_COUNTER_		5

#define		_FAMILY_ITC_BENGUIAT_		256
#define		_FAMILY_TIMES_ROMAN_		2304
#define		_FAMILY_ITC_GRAMOND_		4352
#define		_FAMILY_CENTURY_SCHOOLBOOK_	6400
#define		_FAMILY_BODONI_			8448
#define		_FAMILY_ITC_LUBALINGRAPH_	10496
#define		_FAMILY_ALBERTUS_		12544
#define		_FAMILY_COURIER_		14592
#define		_FAMILY_HELVETICA_		16640
#define		_FAMILY_ITC_RONDA_		18688
#define		_FAMILY_MICROSTYLE_		20736
#define		_FAMILY_OPTIMA_			22784
#define		_FAMILY_LETTER_GOTHIC_		24832
#define		_FAMILY_BRUSH_			26880
#define		_FAMILY_PARK_AVENUE_		28928
#define		_FAMILY_SIGNET_ROUNDHAND_	30976
#define		_FAMILY_TEKTON_			33024
#define		_FAMILY_UNCIAL_			35072
#define		_FAMILY_OLD_ENGLISH_		37120
#define		_FAMILY_ITC_ZAPF_DINGBATS_	39168
#define		_FAMILY_BROADWAY_		41216
#define		_FAMILY_COMPUTER_		43264
#define		_FAMILY_PT_BARNUM_		45312
#define		_FAMILY_PONDEROSA_		47360
#define		_FAMILY_MADRONE_		49408
#define		_FAMILY_HOBO_			51456
#define		_FAMILY_REVUE_			53504
#define		_FAMILY_AESTHETIC_ORNAMENTED_	55552

#define		_FONT_MATCH_NORMAL_		0
#define		_FONT_MATCH_ITALIC_		1
#define		_FONT_MATCH_OUTLINE_		2
#define		_FONT_MATCH_SHADOW_		4
#define		_FONT_MATCH_SMALL_CAPS_		8

#define		_WEIGHT_UNKNOWN_		0
#define		_WEIGHT_ULTRA_THIN_		1
#define		_WEIGHT_ULTRA_LIGHT_		8
#define		_WEIGHT_EXTRA_THIN_		16
#define		_WEIGHT_THIN_			24
#define		_WEIGHT_EXTRA_LIGHT_		32
#define		_WEIGHT_LIGHT_			48
#define		_WEIGHT_DEMI_LIGHT_		64
#define		_WEIGHT_SEMI_LIGHT_		80
#define		_WEIGHT_BOOK_			88
#define		_WEIGHT_REGULAR_		96
#define		_WEIGHT_ROMAN_			104
#define		_WEIGHT_MEDIUM_			112
#define		_WEIGHT_DEMI_BOLD_		128
#define		_WEIGHT_SEMI_BOLD_		136
#define		_WEIGHT_BOLD_			144
#define		_WEIGHT_EXTRA_BOLD_		160
#define		_WEIGHT_HEAVY_			176
#define		_WEIGHT_EXTRA_HEAVY_		192
#define		_WEIGHT_BLACK_			208
#define		_WEIGHT_EXTRA_BLACK_		224
#define		_WEIGHT_ULTRA_HEAVY_		240
#define		_WEIGHT_ULTRA_BLACK_		248
#define		_WEIGHT_MAXIMUM_		254

#define		_WIDTH_UNKNOWN_			0
#define		_WIDTH_ULTRA_CONDENSED_		16
#define		_WIDTH_EXTRA_COMPRESSED_	32
#define		_WIDTH_COMPRESSED_		48
#define		_WIDTH_EXTRA_CONDENSED_		64
#define		_WIDTH_CONDENSED_		80
#define		_WIDTH_SEMI_CONDENSED_		96
#define		_WIDTH_NORMAL_			112
#define		_WIDTH_SEMI_EXPANDED_		128
#define		_WIDTH_EXPANDED_		144
#define		_WIDTH_EXTRA_EXPANDED_		160
#define		_WIDTH_ULTRA_EXPANDED_		176
#define		_WIDTH_DOUBLE_WIDE_		192
#define		_WIDTH_TRIPLE_WIDE_		224

#define		_FONT_MATCH_ASCII_		0
#define		_FONT_MATCH_MULTINATIONAL1_	1
#define		_FONT_MATCH_MULTINATIONAL2_	2
#define		_FONT_MATCH_BOX_DRAWING_	3
#define		_FONT_MATCH_TYPOGRAPHIC_SYMBOLS_	4
#define		_FONT_MATCH_ICONIC_SYMBOLS_	5
#define		_FONT_MATCH_MATH_		6
#define		_FONT_MATCH_MATH_EXTENSION_	7
#define		_FONT_MATCH_GREEK_		8
#define		_FONT_MATCH_HEBREW_		9
#define		_FONT_MATCH_CYRILLIC_		10
#define		_FONT_MATCH_JAPANESE_KANA_	11
#define		_FONT_MATCH_USER_DEFINED_	12
#define		_FONT_MATCH_ARABIC_		13
#define		_FONT_MATCH_ARABIC_SCRIPT_	14

#define		_GENERAL_			0
#define		_INTEGER_			1
#define		_FIXED2_			2
#define		_PERCENT_			3
#define		_CURRENCY_			4
#define		_ACCOUNTING_			5
#define		_COMMAS_			6
#define		_SCIENTIFIC_			7
#define		_DATE_FORMAT_			8
#define		_TEXT_ONLY_			9

#define		_MINUS_				0
#define		_PARENTHESES_			1
#define		_CRDR_				2

#define		_DEFAULT_CURRENCY_		0
#define		_DOLLAR_			1
#define		_PESO_				2
#define		_FRENCH_CANADA_			3
#define		_CANADA_			4
#define		_BRAZIL_			5
#define		_DENMARK_			6
#define		_PESETA_			7
#define		_CROATIA_			8
#define		_CZECH_REPUBLIC_		9
#define		_SLOVAK_REPUBLIC_		10
#define		_FINLAND_			11
#define		_FINLAND_INTL_			12
#define		_FRANCE_			13
#define		_GERMANY_			14
#define		_GREECE_			15
#define		_HUNGARY_			16
#define		_ICELAND_			17
#define		_ITALY_				18
#define		_JAPAN_				19
#define		_NETHERLANDS_			20
#define		_NORWAY_			21
#define		_NORWAY_INTL_			22
#define		_RUBLE_				23
#define		_RUSSIAN_RUBLE_			24
#define		_SOTH_AFRICA_			25
#define		_SWEDEN_			26
#define		_TURKEY_			27
#define		_UNITED_KINGDOM_		28
#define		_SWITZERLAND_			29
#define		_AUSTRIA_			30
#define		_BELGIUM_			31
#define		_ECUADOR_			32
#define		_EL_SALVADOR_			33
#define		_GUATEMALA_			34
#define		_HONDURAS_			35
#define		_PARAGUAY_			36
#define		_VENEZUELA_			37
#define		_POLAND_			38
#define		_SLOVENIA_			39

#define		_NONE_				0
#define		_LONG_EDGE_			1
#define		_SHORT_EDGE_			3

#define		_PRS_FILE			16
#define		_DRS_FILE			20

#define		_ABSTRACT_			1
#define		_ACCOUNT_			2
#define		_ADDRESS_			3
#define		_ATTACHMENTS_			4
#define		_AUTHOR_			5
#define		_AUTHORIZATION_			6
#define		_BILL_TO_			7
#define		_BLIND_COPY_			8
#define		_CARBON_COPY_			9
#define		_CATEGORY_			10
#define		_CHECKED_BY_			11
#define		_CLIENT_			12
#define		_COMMENTS_			13
#define		_CREATION_DATE_			14
#define		_DATE_COMPLETED_		15
#define		_DEPARTMENT_			16
#define		_DESCRIPTIVE_NAME_		17
#define		_DESCRIPTIVE_TYPE_		18
#define		_DESTINATION_			19
#define		_DISPOSITION_			20
#define		_DIVISION_			21
#define		_DOC_NUMBER_			22
#define		_EDITOR_			23
#define		_FORWARD_TO_			24
#define		_GROUP_				25
#define		_KEYWORDS_			26
#define		_LANGUAGE_			27
#define		_MAIL_STOP_			28
#define		_MATTER_			29
#define		_OFFICE_			30
#define		_OWNER_				31
#define		_PROJECT_			32
#define		_PUBLISHER_			33
#define		_PURPOSE_			34
#define		_RECEIVED_FROM_			35
#define		_RECORDED_BY_			36
#define		_RECORDED_DATE_			37
#define		_REFERENCE_			38
#define		_REVISION_DATE_			39
#define		_REVISION_NOTES_		40
#define		_REVISION_NUMBER_		41
#define		_SECTION_			42
#define		_SECURITY_			43
#define		_SOURCE_			44
#define		_STATUS_			45
#define		_SUBJECT_			46
#define		_TELEPHONE_NUMBER_		47
#define		_TYPIST_			48
#define		_VERSION_DATE_			49
#define		_VERSION_NOTES_			50
#define		_VERSION_NUMBER_		51

#define		_PERSONAL_			1
#define		_SHARED_			2

#define		_ZOOM_MARGIN_WIDTH_		0
#define		_ZOOM_PAGE_WIDTH_		1
#define		_ZOOM_FULL_PAGE_		2

#define		_TEXT_				1
#define		_GRAPHICS_			2
#define		_FULL_PAGE_			3

#define		_BOTH_				3

#define		_EVEN_				0
#define		_ODD_				1
#define		_NEW_				2

#define		_PAGE_NUMBERING_		0
#define		_PAGE_NUMBER_BOTTOM_CENTER_	1
#define		_HEADER_A_			2
#define		_HEADER_B_			3
#define		_FOOTER_A_			4
#define		_FOOTER_B_			5
#define		_WATERMARK_A_			6
#define		_WATERMARK_B_			7

#define		_LEFT_EDGE_			0
#define		_RIGHT_EDGE_			1
#define		_TOP_EDGE_			2
#define		_BOTTOM_EDGE_			3

#define		_AUTOMATIC_			0
#define		_MANUAL_			1

#define		_FILENAME_			1
#define		_EXTENSION_			2
#define		_DATE_TIME_			3
#define		_SIZE_				4
#define		_DESCR_NAME_			5
#define		_DESCR_TYPE_			6
#define		_NO_SORT_			7

#define		_DOS_FILENAMES_			1
#define		_DESCRIPTIVE_NAMES_		2

#define		_WORDPERFECT_			0
#define		_PRINTER_			1
#define		_NETWORK_			2

#define		_PRINTER_DEPENDENT_		0
#define		_LEFT_MARGIN_			1
#define		_ALTERNATING_			2
#define		_RIGHT_				3

#define		_FILE_				0
#define		_COMMAND_			1

#define		_RGB_				0
#define		_HLS_				1

#define		_CPS15_				1
#define		_CPS20_				2
#define		_CPS30_				3
#define		_CPS40_				4
#define		_CPS50_				5

#define		_NEVER_				0
#define		_WHEN_REQUIRED_			1
#define		_ALWAYS_			2

#define		_NOTHING_			0
#define		_FONT_				2

#define		_DONT_DELETE_PRS_		0
#define		_DELETE_PRS_			1

#define		_COLOR_OFF_			0	/* Not configured for color */
#define		_COLOR_ON_			1	/* configured for color */

#define		_REMOVE_MARK_			0	/* unmark font */
#define		_HOME_STAR_			1	/* Home "*" */
#define		_HOME_PLUS_			2	/* Home "+" */
#define		_PLUS_MARK_			128	/* mark with "+" */
#define		_STAR_PLUS_MARK_		152	/* mark with "*+" */
#define		_STAR_MARK_			176	/* mark with "*" */

#define		_LPT1_				0
#define		_LPT2_				1
#define		_LPT3_				2

#define		_NON_NETWORK_			0
#define		_NETWORK_PRINTER_		1

#define		_SUPPRESS_TOP_OF_FORM_OFF_	0
#define		_SUPPRESS_TOP_OF_FORM_ON_	1

#define		_COM1_				4
#define		_COM2_				5
#define		_COM3_				6
#define		_COM4_				7

#define		_BAUD110_			0
#define		_BAUD150_			1
#define		_BAUD300_			2
#define		_BAUD600_			3
#define		_BAUD1200_			4
#define		_BAUD2400_			5
#define		_BAUD4800_			6
#define		_BAUD9600_			7
#define		_BAUD19200_			8

#define		_PARITY_EVEN_			0
#define		_PARITY_ODD_			1
#define		_PARITY_NONE_			2

#define		_STOP_BIT1_			0
#define		_STOP_BIT2_			1

#define		_CHARACTER_LENGTH7_		0
#define		_CHARACTER_LENGTH8_		1

#define		_NO_XONOFF_			0
#define		_XONOFF_			1

#define		_NO_PROMPT_			0	/* Don't prompt for file name */
#define		_PROMPT_FOR_FILENAME_		1

#define		_HARDWARE_OFF_			1
#define		_HARDWARE_ON_			2
#define		_HARDWARE_ADVANCE_		4

#define		_IRQ2_				4
#define		_IRQ3_				8
#define		_IRQ4_				16
#define		_IRQ5_				32
#define		_IRQ6_				64
#define		_IRQ7_				128

#define		_DRS_MARK_			0	/* Mark Font */
#define		_DRS_UNMARK_			1	/* Unmark Font */

#define		_ASCII_				16
#define		_BOX_DRAWING_			17
#define		_MULTINATIONAL_			18
#define		_PHONETIC_			19
#define		_TYPOGRAPHIC_SYMBOLS_		20
#define		_ICONIC_SYMBOLS_		21
#define		_MATH_SCIENTIFIC_		22
#define		_MATH_SCIENTIFIC_EXTENSIONS_	23
#define		_GREEK_				24
#define		_HEBREW_			25
#define		_CYRILLIC_			26
#define		_JAPANESE_			27
#define		_ARABIC_			28	/* Arabic 1 */
#define		_ARABIC_SCRIPT_			29	/* Arabic Script */
#define		_USER_DEFINED_			30

#define		_PORTRAIT_			31
#define		_LANDSCAPE_			32
#define		_REVERSE_PORTRAIT_		33
#define		_REVERSE_LANDSCAPE_		34

#define		_PRS_AFC			0	/* Editing PRS afcs */
#define		_DRS_AFC			1	/* Editing DRS afcs */

#define		_PREVIOUS_			1
#define		_NEXT_				15

#define		_ADVANCE_LEFT_			0
#define		_ADVANCE_RIGHT_			1
#define		_ADVANCE_FROM_LEFT_EDGE_	2
#define		_ADVANCE_UP_			3
#define		_ADVANCE_DOWN_			4
#define		_ADVANCE_FROM_TOP_		5

#define		_PHRASE_			0
#define		_WORD_				1
#define		_SENTANCE_			2
#define		_PARAGRAPH_			3	/* parag = 3 because style used it 1s */

#define		_OPTIMAL_			100

#define		_NEWSPAPER_			0
#define		_NEWSPAPER_BALANCED_		1
#define		_PARALLEL_			2
#define		_PARALLEL_BLOCK_PROTECT_	3

#define		_NOT_FIXED_			0
#define		_FIXED_				1

#define		_TABULAR_COLUMNS_		0
#define		_PARALLEL_COLUMNS_		1

#define		_INSIDE_			2
#define		_OUTSIDE_			5

#define		_BEFORE_			0
#define		_AFTER_				1

#define		_BLOCK_				1
#define		_ROW_				2
#define		_COLUMN_			3
#define		_CELL_				4

#define		_DOWN_				0

#define		_TABLE_				5
#define		_FLOATING_CELL_			6
#define		_CELLS_DOWN_			7
#define		_CELLS_RIGHT_			8

#define		_GO_TO_BOOKMARK_		0
#define		_RUN_MACRO_			1

#define		_HIGHLIGHTED_TEXT		0
#define		_BUTTON_			1

#define		_INACTIVE_			0
#define		_ACTIVE_			1

#define		_INCLUDING_CODES_		4	/* delete including codes */
#define		_LEAVING_CODES_			5	/* delete leaving codes */

#define		_USER_STYLES_			1	/* save only user styles */
#define		_SYSTEM_STYLES_			2	/* save only system styles */
#define		_ALL_STYLES_			3	/* save all styles */

#define		_OPEN_STYLE_			1
#define		_CHARACTER_STYLE_		2
#define		_PARAGRAPH_STYLE_		3

#define		_CREATE_FROM_CURRENT_		1
#define		_CREATE_BULLET_STYLE_		2
#define		_CREATE_NUMBER_STYLE_		3

#define		_WITHOUT_OFF_CODES_		0
#define		_WITH_OFF_CODES_		1

#define		_HARD_RETURN_			0
#define		_STYLE_OFF_			4
#define		_STYLE_OFF_ON_			12

#define		_HIDE_BODY_TEXT_		1
#define		_SHOW_BODY_TEXT_		0

#define		_PARAGRAPH_SORT_		0
#define		_LINE_SORT_			1
#define		_COLUMN_SORT_			2
#define		_TABLE_SORT_			3
#define		_MERGE_SORT_			4

#define		_SORT_				0
#define		_SELECT_ONLY_			1

#define		_LOWERCASE_FIRST_		0
#define		_UPPERCASE_FIRST_		1

#define		_ALPHANUMERIC_			0
#define		_NUMERIC_			1

#define		_ASCENDING_			0
#define		_DESCENDING_			1

#define		_CURRENT_DOCUMENT_		1
#define		_NEW_DOCUMENT_			2
#define		_BOTH_				3

#define		_APPEND_			0
#define		_REPLACE_			1

#define		_SUBDOCS_			1

#define		_PRINT_ALL_			0
#define		_PRINT_ODD_			2
#define		_PRINT_EVEN_			4

#define		_NO_DOC_SUMMARY_		0
#define		_DOC_SUMMARY_			1

#define		_NO_BOOKLET_			0
#define		_BOOKLET_			1

#define		_FORWARD_			0
#define		_BACKWARD_			1

#define		_NO_GEN_			0	/* unmark */
#define		_GENERATE_INDEX_		1	/* full generate */
#define		_UPDATE_INDEX_			2	/* incremental update */

#define		_UPDATE_AUTO_INDEX_		3	/* incremental update (except manual) */

#define		_DONT_INCLUDE_NUMBERS_		0
#define		_INCLUDE_NUMBERS_		1	/* index numbers */

#define		_INDEX_ALL_FILES_		0
#define		_INDEX_WP_DOC_ONLY_		1
#define		_AUTO_UPDATE_			0
#define		_MANUAL_UPDATE_ONLY_		1	/* manual update only */

#define		_INCLUDE_DOC_TEXT_		1
#define		_INCLUDE_DOC_SUMMARY_		2
#define		_INCLUDE_DOC_TEXT_AND_SUM_	3

#define		_LEVEL_LINE_			1
#define		_LEVEL_SENTENCE_		2
#define		_LEVEL_PARA_			3
#define		_LEVEL_PAGE_			4
#define		_LEVEL_HARD_PAGE_		5
#define		_LEVEL_FIELD_			6
#define		_LEVEL_RECORD_			7
#define		_LEVEL_DOCUMENT_		8

#define		_BOTTOM_OF_PAGE_		0
#define		_AFTER_TEXT_			1

#define		_SET_POSITION_			4

#define		_NO_BOOKLET_			0
#define		_BOOKLET_			1

#define		_OUTPUT_TO_SORT_		1	/* Sort ON */
#define		_OUTPUT_TO_PUT_GROUP_		2	/* Grouping ON */
#define		_OUTPUT_TO_BINS_		16	/* Output to bins */

#define		_JOGGER_ON_			8	/* Offset Jogger ON */
#define		_JOGGER_OFF_			10	/* Offset Jogger OFF */
          
#define		_FIRST_JOB_			0
#define		_ALL_JOBS_			-1

#define		_LAST_JOB_			0

#define		_FINISH_PAGE_			1

#define		_TOP_LEFT_			1
#define		_TOP_CENTER_			2
#define		_TOP_RIGHT_			3
#define		_TOP_ALTERNATING_		4
#define		_BOTTOM_LEFT_			5
#define		_BOTTOM_CENTER_			6
#define		_BOTTOM_RIGHT_			7
#define		_BOTTOM_ALTERNATING_		8

#define		_DONT_USE_DEFAULT_VALUES_	1

#define		_DONT_RESTART_NUMBERS_EACH_PAGE_	0
#define		_RESTART_NUMBERS_EACH_PAGE_	1

#define		_DONT_COUNT_BLANK_LINES_	0
#define		_COUNT_BLANK_LINES_		1

#define		_DONT_NUMBER_ALL_NEWSPAPER_COLUMNS_	0
#define		_NUMBER_ALL_NEWSPAPER_COLUMNS_	1

#define		_POS_NUMBER_FROM_LEFT_EDGE_OF_PAGE_	0
#define		_POS_NUMBER_FROM_LEFT_MARGIN_	1

#define		_USE_DEFAULT_VALUES_		0

#define		_MODE_INSERT_			0
#define		_MODE_MOVE_			2}      

#define		_EREASE_			0
#define		_SINGLE_			1	/* single line */
#define		_DOUBLE_			2	/* double line */
#define		_SOLID_				255	/* solid character */

#define		_STANDARD_			1
#define		_BOND_				2
#define		_LETTERHEAD_			3
#define		_LABELS_			4
#define		_ENVELOPE_			5
#define		_TRANSPARENCY_			6
#define		_CARDSTOCK_			7
#define		_GLOSSY_			8
#define		_SPECIAL_			9
#define		_OTHER_				255

#define		_CONTINUOUS_			0
#define		_BIN1_				1
#define		_BIN2_				2
#define		_BIN3_				3
#define		_BIN4_				4
#define		_BIN5_				5
#define		_BIN6_				6
#define		_BIN7_				7
#define		_BIN8_				8
#define		_BIN9_				9
#define		_BIN10_				10
#define		_BIN11_				11
#define		_BIN12_				12
#define		_BIN13_				13
#define		_BIN14_				14
#define		_BIN15_				15
#define		_BIN16_				16
#define		_BIN17_				17
#define		_BIN18_				18
#define		_BIN19_				19
#define		_BIN20_				20
#define		_BIN21_				21
#define		_BIN22_				22
#define		_BIN23_				23
#define		_BIN24_				24
#define		_BIN25_				25
#define		_BIN26_				26
#define		_BIN27_				27
#define		_BIN28_				28
#define		_BIN29_				29
#define		_BIN30_				30
#define		_BIN31_				31
#define		_MANUAL_FEED_			32

#define		_PORTRAIT_FONT_			0
#define		_WIDE_FORM_LANDSCAPE_FONT_	1
#define		_LANDSCAPE_FONT_		2
#define		_WIDE_FORM_PORTRAIT_FONT_	3

#define		_LASER_				1
#define		_TRACTOR_FED_			2
#define		_LASER_AND_TRACTER_FED_		3

#define		_BEEP_				0
#define		_BREAK_				1
#define		_CANCEL_OFF_			2
#define		_CANCEL_ON_			3
#define		_CONTINUE_			4
#define		_DATE_				5
#define		_DEFAULT_			6
#define		_DISPLAY_STOP_			7
#define		_ELSE_				8
#define		_END_SWITCH_			9
#define		_END_FIELD_			10
#define		_END_FOR_			11
#define		_END_IF_			12
#define		_END_RECORD_			13
#define		_END_WHILE_			14
#define		_NEXT_				15
#define		_NEXT_RECORD_			16
#define		_PAGE_OFF_			17
#define		_PAGE_ON_			18
#define		_PRINT_				19
#define		_QUIT_				20
#define		_PROCESS_ON_			21
#define		_RETURN_			22
#define		_RETURN_CANCEL_			23
#define		_RETURN_ERROR_			24
#define		_REWRITE_			25
#define		_STEP_OFF_			26
#define		_STEP_ON_			27
#define		_STOP_				28
#define		_PROCESS_OFF_			29
#define		_ASSIGN_			48
#define		_CALL_				50
#define		_CAPS_				52
#define		_SWITCH_			54
#define		_CASE_OF_			56
#define		_CHAIN_MACRO_			58
#define		_CHAIN_DATA_			60
#define		_CHAIN_FORM_			62
#define		_CHAR_				64
#define		_CODES_				66
#define		_COMMENT_			68
#define		_C_TO_N_			70
#define		_DOCUMENT_			72
#define		_EMBED_MACRO_			74
#define		_FIELD_				76
#define		_FIELD_NAMES_			78
#define		_FIRST_CAP_			80
#define		_FOR_NEXT_			82
#define		_FOR_EACH_			84
#define		_GET_STRING_			86
#define		_GO_				88
#define		_IF_				90
#define		_IF_BLANK_			92
#define		_IF_EXISTS_			94
#define		_IF_NOT_BLANK_			96
#define		_INSERT_			98
#define		_KEYBOARD_			100
#define		_LABEL_				102
#define		_ASSIGN_LOCAL_			104
#define		_LOOK_				106
#define		_MRG_CMND_			108
#define		_NEST_DATA_			110
#define		_NEST_FORM_			112
#define		_NEST_MACRO_			114
#define		_N_TO_C_			116
#define		_ON_CANCEL_			118
#define		_ON_ERROR_			120
#define		_PROMPT_			122
#define		_STATEUS_PROMPT_		124
#define		_STR_LEN_			126
#define		_STR_POS_			128
#define		_SUBST_DATA_			130
#define		_SUBST_FORM_			132
#define		_SUB_STR_			134
#define		_SYSTEM_			136
#define		_TO_LOWER_			138
#define		_TO_UPPER_			140
#define		_VARIABLE_			142
#define		_WAIT_				144
#define		_WHILE_				146
#define		_POSTNET_			148

#define		_CURRENT_DOC_			0
#define		_CLIPBOARD_			1
#define		_FORM_FILE_			2

#define		_NO_DATA_			0
#define		_DATA_FILE_			2

#define		_TO_CURRENT_DOC_		0
#define		_TO_NEW_DOC_			1
#define		_TO_FILE_			2
#define		_TO_PRINTER_			3

#define		_ALL_				0
#define		_MARKED_			1
#define		_RANGE_				2

#define		_FORM_				1
#define		_TABLE_DATA_			2
#define		_TEXT_DATA_			4

#define		_LEAVE_				0
#define		_REMOVE_			1

#define		_ACTION				0
#define		_TEXT				1
#define		_MACRO				7

#define		_REGULAR_			0
#define		_EXTENDED_			1

#define		_ENVELOPE_CANCEL_		0
#define		_ENVELOPE_CLOSE_		1
#define		_ENVELOPE_INSERT_		2
#define		_ENVELOPE_PRINT_		3

#define		_MANUALLY_ENTER_BARCODE_	0
#define		_AUTOMATICALLY_CREATE_BARCODE_	1
#define		_REMOVE_BARCODE_OPTION_		2

#define		_MATH_TEXT_			1
#define		_MATH_NUMERIC_			2
#define		_MATH_TOTAL_			3
#define		_MATH_CALCULATE_		4

#define		_MINUS_SIGN_			0
#define		_PARENTHESES_			1

#define		_SKIP_SUB_			0
#define		_SAVE_SUB_			2

#define		_REF_PAGE_			0
#define		_REF_SECONDARY_PAGE_		1
#define		_REF_CHAPTER_			2
#define		_REF_VOLUME_			3
#define		_REF_PARAGRAPH_			4
#define		_REF_FOOTNOTE_			5
#define		_REF_ENDNOTE_			6
#define		_REF_BOX_			7
#define		_REF_COUNTER_			8

#define		_NO_LEVEL_WRAP_			0
#define		_LEVEL_WRAP_			1

#define		_DONT_SAVE_			0	/* don't save subdoc's */
#define		_SAVE_				1	/* save subdoc's */

#define		_TAB_LEFT_			0
#define		_TAB_CENTER_			1
#define		_TAB_RIGHT_			2
#define		_TAB_DECIMAL_			3
#define		_TAB_LEFT_DOT_			16
#define		_TAB_CENTER_DOT_		17
#define		_TAB_RIGHT_DOT_			18
#define		_TAB_DECIMAL_DOT_		19

#define		_ON_DISK_			0
#define		_IN_DOC_			1

#define		_MIDI_				0
#define		_DIGITAL_AUDIO_			1

#define		_IRQ10_				1024
#define		_IRQ15_				32768

#define		_MIDIOFF_			3
#define		_SOUND_CARD_			8
#define		_SOUND_CARD_MIDI_PORT_		9

#define		_OTHER_QUALITY_			0
#define		_GOOD_QUALITY_			64
#define		_BETTER_QUALITY_		192

#define		_AT5513HZ_			5513
#define		_AT7350HZ_			7350
#define		_AT8000HZ_			8000
#define		_AT11025HZ_			11025
#define		_AT16000HZ_			16000
#define		_AT22050HZ_			22050
#define		_AT32000HZ_			32000
#define		_AT44100HZ_			44100

#define		_EIGHT_BIT_			8
#define		_SIXTEEN_BIT_			16

#define		_MONO_				0
#define		_STEREO_			1

#define		_FX_STANDARD_			0	/* Standard Res (204 x 98 dpi) */
#define		_FX_FINE_			1	/* Fine Res (204 x 196 dpi) */
#define		_FX300_DPI_			2	/* 300 x 300 dpi */
#define		_FX400_DPI_			3	/* 400 x 400 dpi */

#define		_FAX_ONLY_			0	/* Send as a FAX Only */
#define		_BFT_ONLY_			1	/* Send as Binary File Only */
#define		_PEER_FAX_			2	/* Send as BFT if error send as FAX */

#define		_NONE_SPECIFIED_		0

#define		_HARD_SPACE_			129
#define		_HARD_HYPHEN_			132
#define		_CANCEL_HYPHENATION_		144
#define		_HARD_END_OF_LINE_		204
#define		_SOFT_END_OF_LINE_		207
#define		_TAB_				225

#define		_CANCEL_CONDITION_		0
#define		_ERROR_CONDITION_		1
#define		_NOT_FOUND_CONDITION_		2

#define		_CTRL_LABEL_			0
#define		_CTRL_OPTION_			1
#define		_CTRL_PUSH_BUTTON_		2
#define		_CTRL_CHECK_BOX_		3
#define		_CTRL_RADIO_BUTTON_		4
#define		_CTRL_NUMBER_			5
#define		_CTRL_MEASURE_			6
#define		_CTRL_TEXT_			7
#define		_CTRL_FILENAME_			8
#define		_CTRL_LIST_			9
#define		_CTRL_DROP_LIST_		10
#define		_DLG_NO_OK_			1
#define		_DLG_NO_CANCEL_			2
#define		_DLG_NO_BORDER_			4
#define		_DLG_NO_SHADOW_			8
#define		_DLG_EXIT_			16
#define		_DLG_NO_CLEAR_			32
#define		_DLG_INACTIVE_			64
#define		_STY_OK_			1
#define		_STY_CANCEL_			2
#define		_STY_SIGNED_			4
#define		_STY_COUNTER_			8
#define		_STY_NO_SPACES_			16
#define		_STY_NO_BOX_			32
#define		_STY_NO_SORT_			64
#define		_STY_CHILD_			128
#define		_STY_NO_SCROLL_			256
#define		_STY_NO_NUMBER_			512
#define		_STY_DANCING_			1024
#define		_STY_NO_PERIOD_			2048
#define		_STY_GRAY_			4096
#define		_STY_MNEMONIC_			8192
#define		_STY_INITIAL_			16384
#define		_STY_DEFAULT_			32768

#define		_POS_HOME_			0	/* Home */
#define		_POS_NEXT_LINE_			1	/* NewLine */
#define		_POS_BEG_LINE_			2	/* CR */
#define		_POS_LEFT_			3
#define		_POS_RIGHT_			4
#define		_POS_UP_			5
#define		_POS_DOWN_			6
#define		_CLR_LINE_			7	/* Clear EOL */
#define		_CLR_SCREEN_			8	/* Clear EOP */
#define		_ATTR_NORMAL_			9	/* Clear All Attrs */
#define		_ATTR_MNEMONIC_			10	/* Mnemonic Attr */
#define		_REVERSE_ON_			11	/* ReverseVideo ON */
#define		_REVERSE_OFF_			12	/* ReverseVideo OFF */
#define		_SAVE_SCREEN_			13	/* Save Screen */
#define		_RESTORE_SCREEN_		14	/* Restore Screen */

#define		_PAGE_				2
#define		_PARAGRAPH_			3
#define		_CHARACTER_			64

#define		_OUTSIDE_BORDER_		0
#define		_INSIDE_BORDER_			1
#define		_ON_BORDER_			2

#define		_AUTO_WIDTH_			2

#define		_AUTO_HEIGHT_			2

#define		_ALIGN_MARGINS_			1
#define		_ALIGN_COLUMNS_			2

#define		_LEAVE_EXTERNAL_		0
#define		_MAKE_INTERNAL_			1
#define		_USE_INTERNAL_			2

#define		LARGEST_SIDE_			0
#define		_LEFT_SIDE_			1
#define		_RIGHT_SIDE_			2
#define		_NEITHER_SIDE_			3
#define		_BOTH_SIDES_			8
#define		_COLUMNAR_			9
#define		_NO_WRAPPING_			15

#define		_TRANSPARENT_			1
#define		_WHITE_				2

#define		_DEFAULT_VALUES_		0
#define		_SET_VALUES_			1

#define		_HALFTONING_			1
#define		_ORDERED_DITHER_		2
#define		_ERROR_DIFFUSION_DITHER_	3
#define		_DEFAULT_			6

#define		_DEFAULT_SIZE_			0

#define		_CALCULATE_STEPS_		0

#define		_FULL_ALIGN_			7
#define		_SET_				8

#define		_BETWEEN_COLUMNS_		9

#define		_DLG_BACKGROUND_		0
#define		_DLG_BORDER_			1
#define		_DLG_UPPER_LIGHT_REFLECTION_	2
#define		_DLG_DARK_SHADOW_		3
#define		_DLG_LIGHT_SHADOW_		4
#define		_DLG_ACTIVE_TITLE_		5
#define		_DLG_INACTIVE_TITLE_		6
#define		_CHECK_BOX_BACKGROUND_		7
#define		_CHECK_BOX_ACTIVE_		8
#define		_COMBO_BUTTON_BACKGROUND_	9
#define		_SCROLL_BAR_FILL_		10
#define		_DLG_TEXT_COLOR_		11
#define		_DLG_BOLD_TEXT_COLOR_		12
#define		_DLG_INACTIVE_TEXT_COLOR_	13
#define		_PULL_DOWN_BACKGROUND_		14
#define		_PULL_DOWN_BORDER_		15

#define		_CHAR_MODE_			1
#define		_WORD_MODE_			2
#define		_SENTENCE_MODE_			4
#define		_PARAGRAPH_MODE_		8
#define		_PAGE_MODE_			16
#define		_RECTANGLE_MODE_		32
#define		_TABULAR_COLUMNS_MODE_		64
#define		_DOC_MODE_			128
#define		_CHAR_NO_CELL_MODE_		256

#define		_ONLY_SELECTION_		0
#define		_ONLY_TEXT_			1
#define		_ONLY_FUNCTION_			2

#define		_BLOCKED_TEXT_			0

#define		_EXIST_OPT_			1
#define		_NOEXIST_OPT_			0

/*==========================================================================*
 *                        Key Codes                                         *
 *==========================================================================*
 *                    CONTROL CHARACTER COMMANDS                            *
 *==========================================================================*
 		CODE NAME	HEX VALUE	DESCRIPTION
 =========================================================================
*/
#define		_Ctrl_A		0xE07C		/* ^A */
#define		_Ctrl_B		0xE07D		/* ^B */
#define		_Ctrl_C		0xE07E		/* ^C */
#define		_Ctrl_D		0xE07F		/* ^D */
#define		_Ctrl_E		0xE080		/* ^E */
#define		_Ctrl_F		0xE081		/* ^F */
#define		_Ctrl_G		0xE082		/* ^G */
#define		_Ctrl_H		0xE083		/* ^H */
#define		_Ctrl_I		0xE084		/* ^I */
#define		_Ctrl_J		0xE085		/* ^J */
#define		_Ctrl_K		0xE086		/* ^K */
#define		_Ctrl_L		0xE087		/* ^L */
#define		_Ctrl_M		0xE088		/* ^M */
#define		_Ctrl_N		0xE089		/* ^N */
#define		_Ctrl_O		0xE08A		/* ^O */
#define		_Ctrl_P		0xE08B		/* ^P */
#define		_Ctrl_Q		0xE08C		/* ^Q */
#define		_Ctrl_R		0xE08D		/* ^R */
#define		_Ctrl_S		0xE08E		/* ^S */
#define		_Ctrl_T		0xE08F		/* ^T */
#define		_Ctrl_U		0xE090		/* ^U */
#define		_Ctrl_V		0xE091		/* ^V */
#define		_Ctrl_W		0xE092		/* ^W */
#define		_Ctrl_X		0xE093		/* ^X */
#define		_Ctrl_Y		0xE094		/* ^Y */
#define		_Ctrl_Z		0xE095		/* ^Z */

#define		_Ctrl_LeftBrace	0xE096		/* ^[ */
#define		_Ctrl_Backslash	0xE097		/* ^\ */
#define		_Ctrl_RightBrace	0xE098	/* ^] */
#define		_Ctrl_Underscr	0xE099		/* ^_ */

#define		_Ctrl_End	0xE00B
#define		_Ctrl_PgDn	0xE00C
#define		_Ctrl_Backspace	0xE052
#define		_Ctrl_Right	0xE053
#define		_Ctrl_Left	0xE054
#define		_Ctrl_PgUp	0xE057
#define		_Ctrl_Home	0xE058
#define		_Ctrl_Enter	0xE05F
#define		_Ctrl_Up	0xE063
#define		_Ctrl_Down	0xE064
#define		_Ctrl_NumPlus	0xE06A
#define		_Ctrl_Delete	0xE06D
#define		_Ctrl_Insert	0xE06E


/*                 FUNCTION KEY COMMANDS
 =========================================================================
 		CODE NAME	HEX VALUE	DESCRIPTION
 =========================================================================
*/
#define		_F1		0xE022
#define		_F2		0xE021
#define		_F3		0xE168
#define		_F4		0xE023
#define		_F5		0xE024
#define		_F6		0xE025
#define		_F7		0xE026
#define		_F8		0xE027
#define		_F9		0xE028
#define		_F10	0xE029

#define		_F11	0xE03A
#define		_F12	0xE03B

/******** Shift+Function Keys *******/
#define		_SF1	0xE02C
#define		_SF2	0xE02D
#define		_SF3	0xE02E
#define		_SF4	0xE02F
#define		_SF5	0xE030
#define		_SF6	0xE031
#define		_SF7	0xE032
#define		_SF8	0xE033
#define		_SF9	0xE034
#define		_SF10	0xE035

#define		_SF11	0xE092
#define		_SF12	0xE413

/********** Alt+Function Keys *******/
#define		_AF1	0xE038
#define		_AF2	0xE039
#define		_AF3	0xE03A
#define		_AF4	0xE03B
#define		_AF5	0xE03C
#define		_AF6	0xE03D
#define		_AF7	0xE03E
#define		_AF8	0xE03F
#define		_AF9	0xE040
#define		_AF10	0xE041

#define		_AF11	0xE58A
#define		_AF12	0xE205

/******* Ctrl+Function Keys ******/
#define		_CF1	0xE044
#define		_CF2	0xE045
#define		_CF3	0xE046
#define		_CF4	0xE047
#define		_CF5	0xE048
#define		_CF6	0xE049
#define		_CF7	0xE04A
#define		_CF8	0xE04B
#define		_CF9	0xE04C
#define		_CF10	0xE04D

#define		_CF11	0xE1B1
#define		_CF12	0xE405


/*                          KEY COMMANDS
 =========================================================================
 		CODE NAME	HEX VALUE	DESCRIPTION
 =========================================================================
*/
#define		_HOME		0xE008
#define		_TAB		0xE009
#define		_ENTER		0xE00A
#define		_UP		0xE017
#define		_RIGHT		0xE018
#define		_LEFT		0xE019
#define		_DOWN		0xE01A
#define		_ESC		0xE020
#define		_BACKSPACE	0xE050
#define		_DELETE		0XE051
#define		_END		0xE055
#define		_PGUP		0XE059
#define		_PGDN		0XE05A
#define		_SCREEN_DOWN	0xE05B
#define		_SCREEN_UP	0xE05C
#define		_INSERT		0xE05D

#define		_MouseEvent	0xFD00


/*                     Alt Key Commands
 =========================================================================
		CODE NAME	HEX VALUE	DESCRIPTION
 =========================================================================
*/
#define		_Alt_A		0xFDDC
#define		_Alt_B		0xFDDD
#define		_Alt_C		0xFDDE
#define		_Alt_D		0xFDDF
#define		_Alt_E		0xFDE0
#define		_Alt_F		0xFDE1
#define		_Alt_G		0xFDE2
#define		_Alt_H		0xFDE3
#define		_Alt_I		0xFDE4
#define		_Alt_J		0xFDE5
#define		_Alt_K		0xFDE6
#define		_Alt_L		0xFDE7
#define		_Alt_M		0xFDE8
#define		_Alt_N		0xFDE9
#define		_Alt_O		0xFDEA
#define		_Alt_P		0xFDEB
#define		_Alt_Q		0xFDEC
#define		_Alt_R		0xFDED
#define		_Alt_S		0xFDEE
#define		_Alt_T		0xFDEF
#define		_Alt_U		0xFDF0
#define		_Alt_V		0xFDF1
#define		_Alt_W		0xFDF2
#define		_Alt_X		0xFDF3
#define		_Alt_Y		0xFDF4
#define		_Alt_Z		0xFDF5

#define		_Alt_0		0xFDF6
#define		_Alt_1		0xFDF7
#define 	_Alt_2		0xFDF8
#define 	_Alt_3		0xFDF9
#define		_Alt_4		0xFDFA
#define		_Alt_5		0xFDFB
#define		_Alt_6		0xFDFC
#define		_Alt_7		0xFDFD
#define		_Alt_8		0xFDFE
#define		_Alt_9		0xFDFF

#define		_Alt_Minus	0XE061
#define		_Alt_Left	0xE065
#define		_Alt_Right	0xE066
#define		_Alt_Up		0xE067
#define		_Alt_Down	0xE068
#define		_Alt_Home	0xE069
#define		_Alt_Plus	0XE06B/*                      SYSTEM VARIABLES
 *==========================================================================*
 *              Name                            Value                       *
 *==========================================================================*/
#define		WPSYS_LeftMargin 		0
#define		WPSYS_RightMargin 		1
#define		WPSYS_Name			2
#define		WPSYS_Path			3
#define		WPSYS_Justification		4
#define		WPSYS_Random			5
#define		WPSYS_OriginalKey		6
#define		WPSYS_Block			7
#define		WPSYS_FontExtraLarge		8
#define		WPSYS_FontVeryLarge		9
#define		WPSYS_FontLarge			10
#define		WPSYS_FontSmall			11
#define		WPSYS_FontFine			12
#define		WPSYS_FontSuperscript		13
#define		WPSYS_FontSubscript		14
#define		WPSYS_FontOutline		15
#define		WPSYS_FontItalics		16
#define		WPSYS_FontShadow		17
#define		WPSYS_FontRedline		18
#define		WPSYS_FontDoubleUnderline	19
#define		WPSYS_FontBold			20
#define		WPSYS_FontStrikeout		21
#define		WPSYS_FontUnderline		22
#define		WPSYS_FontSmallCaps		23
#define		WPSYS_DocumentModified		24
#define		WPSYS_DocumentNeedsGenerating	25
#define		WPSYS_DocumentBlank		26
#define		WPSYS_BetweenTableCodes		27
#define		WPSYS_BetweenMathCodes		28
#define		WPSYS_InterimRelease		29
#define		WPSYS_BetweenColumnCodes	30
#define		WPSYS_Column			31
#define		WPSYS_Row			32
#define		WPSYS_Endnote			33
#define		WPSYS_PathSetfile		34
#define		WPSYS_TempDocName		35
#define		WPSYS_Footnote			36
#define		WPSYS_Page			37
#define		WPSYS_Line			38
#define		WPSYS_Pos			39
#define		WPSYS_PrintNoChar		40
#define		WPSYS_PrintAttempt		41
#define		WPSYS_PrintGo			42
#define		WPSYS_PrintNetDown		43
#define		WPSYS_PrintDownload		44
#define		WPSYS_PrintAbnormal		45
#define		WPSYS_PrintProgress		46
#define		WPSYS_PrintColor		47
#define		WPSYS_PDM			48
#define		WPSYS_ShellVersionMinor		49
#define		WPSYS_ShellVersionMajor		50
#define		WPSYS_KeyRightShift		51
#define		WPSYS_KeyLeftShift		52
#define		WPSYS_KeyCtrl			53
#define		WPSYS_KeyAlt			54
#define		WPSYS_KeyScrollLock		55
#define		WPSYS_KeyNumLock		56
#define		WPSYS_KeyCapsLock		57
#define		WPSYS_ButtonBar			58
#define		WPSYS_RowState			59
#define		WPSYS_MajorVersion		60
#define		WPSYS_MinorVersion		61
#define		WPSYS_Network			62
#define		WPSYS_Direction			63
#define		WPSYS_Language			64
#define		WPSYS_NotFound			65
#define		WPSYS_MainEditScreen		66
#define		WPSYS_BlockActive		67
#define		WPSYS_DocumentNumber		68
#define		WPSYS_MacroDefinition		69
#define		WPSYS_MergeActive		70
#define		WPSYS_RevealCodesActive		71
#define		WPSYS_Substructure		72
#define		WPSYS_TypeoverActive		73
#define		WPSYS_CellExtraLarge		74
#define		WPSYS_CellVeryLarge		75
#define		WPSYS_CellLarge			76
#define		WPSYS_CellSmall			77
#define		WPSYS_CellFine			78
#define		WPSYS_CellSuperscript		79
#define		WPSYS_CellSubscript		80
#define		WPSYS_CellOutline		81
#define		WPSYS_CellItalics		82
#define		WPSYS_CellShadow		83
#define		WPSYS_CellRedline		84
#define		WPSYS_CellDoubleUnderline	85
#define		WPSYS_CellBold			86
#define		WPSYS_CellStrikeout		87
#define		WPSYS_CellUnderline		88
#define		WPSYS_CellSmallCaps		89
#define		WPSYS_Cell			90
#define		WPSYS_LeftChar			91
#define		WPSYS_RightChar			92
#define		WPSYS_LeftCode			93
#define		WPSYS_RightCode			94
#define		WPSYS_ReadOnlyDoc		95
#define		WPSYS_FontNormal		96
#define		WPSYS_CellNormal		97
#define		WPSYS_Year			98
#define		WPSYS_Month			99
#define		WPSYS_Day			100
#define		WPSYS_Hour			101
#define		WPSYS_Minute			102
#define		WPSYS_Second			103
#define		WPSYS_PathPrinter		104
#define		WPSYS_PathDictionary		105
#define		WPSYS_PathBackup		106
#define		WPSYS_PathMacroPersonal		107
#define		WPSYS_PathGraphic		108
#define		WPSYS_PathShared		109
#define		WPSYS_PathUnshared		110
#define		WPSYS_Entry			111
#define		WPSYS_MoveMode			112
#define		WPSYS_Initials			113
#define		WPSYS_List			114
#define		WPSYS_MouseX			115
#define		WPSYS_MouseY			116
#define		WPSYS_MouseLeft			117
#define		WPSYS_MouseLeftClick		118
#define		WPSYS_MouseLeftDouble		119
#define		WPSYS_MouseRight		120
#define		WPSYS_MouseRightClick		121
#define		WPSYS_MouseRightDouble		122
#define		WPSYS_MouseMiddle		123
#define		WPSYS_MouseMiddleClick		124
#define		WPSYS_DialogControl		125
#define		WPSYS_Hundreth			126
#define		WPSYS_Weekday			127
#define		WPSYS_NetworkVersion		128
#define		WPSYS_MacroEdit			129
#define		WPSYS_MacroPlaying		130
#define		WPSYS_Dialog			131
#define		WPSYS_TopMargin			132
#define		WPSYS_BottomMargin		133
#define		WPSYS_SecondaryPage		134
#define		WPSYS_Chapter			135
#define		WPSYS_Volume			136
#define		WPSYS_CellJustification		137
#define		WPSYS_CellSpecificJustification	138
#define		WPSYS_CellSpecificAttribute	139
#define		WPSYS_CellAlignment		140
#define		WPSYS_CellLocked		141
#define		WPSYS_CellNoCalc		142
#define		WPSYS_CellFormula		143
#define		WPSYS_PathMacroShared		144
#define		WPSYS_TableLastCell		145
#define		WPSYS_OutlineBar		146
#define		WPSYS_Ribbon			147
#define		WPSYS_ScreenWide 		148
#define		WPSYS_ScreenHigh 		149
#define		WPSYS_WP51Cursor		150
#define		WPSYS_DocSmyAbstract		151
#define		WPSYS_DocSmyAccount		152
#define		WPSYS_DocSmyAddress		153
#define		WPSYS_DocSmyAttachments		154
#define		WPSYS_DocSmyAuthor		155
#define		WPSYS_DocSmyAuthorization	156
#define		WPSYS_DocSmyBillTo		157
#define		WPSYS_DocSmyBlindCopy		158
#define		WPSYS_DocSmyCarbonCopy		159
#define		WPSYS_DocSmyCategory		160
#define		WPSYS_DocSmyCheckedBy		161
#define		WPSYS_DocSmyClient		162
#define		WPSYS_DocSmyComments		163
#define		WPSYS_DocSmyCreationDate	164
#define		WPSYS_DocSmyDateCompleted	165
#define		WPSYS_DocSmyDepartment		166
#define		WPSYS_DocSmyDescriptiveName	167
#define		WPSYS_DocSmyDescriptiveType	168
#define		WPSYS_DocSmyDestination		169
#define		WPSYS_DocSmyDisposition		170
#define		WPSYS_DocSmyDivision		171
#define		WPSYS_DocSmyDocumentNumber	172
#define		WPSYS_DocSmyEditor		173
#define		WPSYS_DocSmyForwardTo		174
#define		WPSYS_DocSmyGroup		175
#define		WPSYS_DocSmyKeywords		176
#define		WPSYS_DocSmyLanguage		177
#define		WPSYS_DocSmyMailStop		178
#define		WPSYS_DocSmyMatter		179
#define		WPSYS_DocSmyOffice		180
#define		WPSYS_DocSmyOwner		181
#define		WPSYS_DocSmyProject		182
#define		WPSYS_DocSmyPublisher		183
#define		WPSYS_DocSmyPurpose		184
#define		WPSYS_DocSmyReceivedFrom	185
#define		WPSYS_DocSmyRecordedBy		186
#define		WPSYS_DocSmyRecordedDate	187
#define		WPSYS_DocSmyReference		188
#define		WPSYS_DocSmyRevisionDate	189
#define		WPSYS_DocSmyRevisionNotes	190
#define		WPSYS_DocSmyRevisionNumber	191
#define		WPSYS_DocSmySection		192
#define		WPSYS_DocSmySecurity		193
#define		WPSYS_DocSmySource		194
#define		WPSYS_DocSmyStatus		195
#define		WPSYS_DocSmySubject		196
#define		WPSYS_DocSmyTelephoneNumber	197
#define		WPSYS_DocSmyTypist		198
#define		WPSYS_DocSmyVersionDate		199
#define		WPSYS_DocSmyVersionNotes	200
#define		WPSYS_DocSmyVersionNumber	201
#define		WPSYS_KeyPressed		202
/*            System/Merge Variable Buffer Data Types
 *=======================================================================*
		CODE NAME	VALUE		DISCRIPTION
 *=======================================================================*/
#define		T0DataError	0		/* There was some error in getting data */
#define		T1Boolen	1		/* 1st byte of buffer */
#define		T3Integer	3		/* 1st 2 bytes of buffer */
#define		T4Double	4		/* all 8 bytes of buffer */
#define		T5WordString	5		/* all 8 bytes of buffer */
#define		T7WPU		7		/* 1st 2 bytes of buffer */

/*       		OpenInterface Product Types
 =========================================================================
		CODE NAME	HEX VALUE	DESCRIPTION
 =========================================================================
*/
#define		WordPerfect	0x3681		/*version 6.0 only */


/*                  Data Buffer Union Definition
 *=======================================================================*/
static union VariableData
{
	char RawBuffer [8];
	unsigned char Type1;
	int	Type3;
	double Type4;
	unsigned int far *Type5;
	int	Type7;
} WPRequestedData, far *DataRequested;


/*      Lib60.OBJ 'Library' Function External Definitions
 *======================================================================*/
extern int far OpenInterface (unsigned int Product,
				unsigned int (far *KeyFunction)(),
				unsigned int (far *TokenFunction)(), 
				int (far *RecordFunction)());
extern int far CloseInterface (void);
extern int far WPPurgeCache (void);
extern int far SystemVariable (unsigned int SysVar,
				union VariableData far *VarData);
extern int far GetMergeVariable (unsigned far *VarName,
				union VariableData far *VarData);
extern int far SetMergeVariable (unsigned far *VarName,
				union VariableData far *VarData,
				int VarType);

