;SOURCE_FILE*****************************************************
;File	intr60.asm
;Title	DOS Third-party interface source for intrface.obj file
;Owner	Russ Lundberg
;Tabs	5, 4
;
;	Copyright (C) 1990 WordPerfect corp., All Rights Reserved 

;-------------------------------------------------------------------
;This is the sample Third-Party interface source code.  The file is currently 
;setup to interface with WP.
;
;
;Revision History (Most recent change first)
;Name				Date			Description
;Russ Lundberg 		3/3/93			Modified for WP6.0 Beta
;Russ Lundberg		1/15/93			Creation
									; This asm file was derived from the old
									;intrface.asm from WP5.1 sample.
									;
									;Creating assembly interface for the WP6.0
									;interface.

DGROUP	group	_DATA,_BSS

assume	cs:_TEXT,ds:DGROUP

_DATA	segment word public 'DATA'
_DATA	ends

_BSS	segment word public 'BSS'
_BSS	ends

_TEXT	segment byte public 'CODE'
stk_offset equ	500

ss_seg	dw	?		; variable to save the stack segment and stack
ss_ptr	dw	?		;pointer


; the following variables are store at initialization time and used to
;switch from WP's stack to this C programs original stack area.  The
;"stk_ptr" variable is calculated so as to not use STACK area that in needed 
;by the spawnlp process.  Both variable are saved in the INIT_3rd
;routine which can be found in this file.
stk_seg		dw	?	; used to store original C programs stack seg
stk_ptr		dw	?	; used to store original C programs
				;adjusted stack pointer

; extern routines found in third60.c
extrn	_Ctkn_handler:far	
extrn _Ckey_handler:far	  
extrn _Crec_handler:far

save_ax		dw	?	; used to store keystroke from WP
save_bx		dw	?	; used to store WP state
save_ss		dw	?	; used to store WP's stack segment
save_sp		dw	?	; used to store WP's stack pointer

;_WPServ		db 	0 ; WP service to execute
;_WPSysvar	dw	0 ; WP system variable to get
;_WPRetBuf	db	8 dup (0) ; 8 byte buffer to sent to and return from WP

wpstring	db	"WPCORP",0 ; WPCorp id string to compare
str_len		equ	$-wpstring ; length of WPCorp id string

wp_rout		dd	?	; Address for WP request routine

;	routine: Token_handler
;
;	This routine is designed to relieve C programmers from having
;	to check or set the AX and BX registers explicitly.
;	Pointers to their values are passed to the C function named
;	'handler' that is supplied by the 3rd party developer.

_Token_handler	proc	far


; stack switch to original C program stack (C stack buffer)
	cli					; disable interrupts
	mov	cs:save_ss,ss	; save Stack Segment
	mov	cs:save_sp,sp	; save Stack Pointer
	mov	ss,stk_seg		; ss <- original C stack segment
	mov	sp,stk_ptr		; sp <- readjusted stack segment
	sti					; enable interrupts
; End of stack switch


	push	si			; save registers
	push	di
	push	dx
	push	ds
	push	cx			
	push	es
	push	bx
	push	ax
	mov	save_ax,ax		; save ax
	mov	save_bx,bx		; save bx
	mov	bx,sp			; bx (use as the base pointer) <- sp

	mov	ax,DGROUP		;ds <- get our data segment
	mov	ds,ax
	
	cmp		save_ax,0		; is AX zero?
	 jz		tkn10
	mov		ax,0		; leave AX alone.  This is just for Debugging.

tkn10:
	push	es			; buffer segment
	;push	word ptr [bx+2] ;push wp buf offset on stack
	mov		ax,word ptr [bx+2] ;offset for bx location
	push	ax			; 

	;push	ax			; push indirect address of bx on stack
	
	push	ss			; push SS for far address to param
	lea	ax,word ptr [bx+4]	; offset of es location
	push	ax			; push indirect address of es on stack
	
	push	ss			; push SS for far address to parameter
	lea	ax,word ptr [bx+6]; offset of cx location
	push	ax			; push indirect address of cx on stack
	
	push	ss			; push SS for far address to parameter
	lea	ax,word ptr [bx+2] ; offset for bx location
	push 	ax			; push indirect address of bx on stack

	push	ss			; push SS for far address to parameter
	lea	ax,word ptr [bx] ;offset for ax location
	push	ax			; push indirect address of ax on stack 
	
	call	far ptr _Ctkn_handler ;call the C routine 'handler'
	
	add	sp,20			; clean up the stack

	pop	ax				; restore saved register
	pop	bx
	pop	es
	pop	cx		
	pop	ds
	pop	dx
	pop	di
	pop	si


;restore WP's stack
	cli
	mov	ss,save_ss
	mov	sp,save_sp
	sti
;End restore WP's stack

	ret				; return to WP
_Token_handler	endp

;	routine: Key_handler
;
;	This routine is designed to relieve C programmers from having
;	to check or set the AX and BX registers explicitly.
;	Pointers to their values are passed to the C function named 
;	'handler' that is supplied by the 3rd party developer.

_Key_handler	proc	far


; stack switch to original C program stack (C stack buffer)
	cli					; disable interrupts
	mov	cs:save_ss,ss	; save Stack Segment
	mov	cs:save_sp,sp	; save Stack Pointer
	mov	ss,stk_seg		; ss <- original C stack segment
	mov	sp,stk_ptr		; sp <- readjusted stack segment
	sti					; enable interrupts
; End of stack switch

	push	cx			; save registers
	push	si		
	push	di
	push	es
	push	dx
	push	ds
	push	bx
	push	ax
	mov	save_ax,ax		; save ax
	mov	save_bx,bx		; save bx
	mov	bx,sp			; bx (use as the base pointer) <- sp

	mov	ax,DGROUP		;ds <- get our data segment
	mov	ds,ax

;	push	ss			; push SS for far address to parameter
;	lea	ax,word ptr [bx+2] ;offset for bx location
;	push	ax			; push indirect address of bx on stack
	
	push	ss			; push SS for far address to parameter
	lea	ax,word ptr [bx] ;offset for ax location
	push	ax			; push indirect address of ax on stack 
	
	call	far ptr _Ckey_handler ;call the C routine 'handler'
	
	add	sp,4			; clean up the stack

	pop	ax				; restore saved register
	pop	bx
	pop	ds
	pop	dx
	pop	es
	pop	di
	pop	si
	pop	cx		

;restore WP's stack
	cli
	mov	ss,save_ss
	mov	sp,save_sp
	sti
;End restore WP's stack

	ret				; return to WP
_Key_handler	endp
;	routine: Record_handler
;
;	This routine is designed to relieve C programmers from having
;	to check or set the AX and BX registers explicitly.
;	Pointers to their values are passed to the C function named 
;	'handler' that is supplied by the 3rd party developer.

_Record_handler	proc	far


; stack switch to original C program stack (C stack buffer)
	cli					; disable interrupts
	mov	cs:save_ss,ss	; save Stack Segment
	mov	cs:save_sp,sp	; save Stack Pointer
	mov	ss,stk_seg		; ss <- original C stack segment
	mov	sp,stk_ptr		; sp <- readjusted stack segment
	sti					; enable interrupts
; End of stack switch

	push	cx			; save registers
	push	si		
	push	di
	push	dx
	push	ds
	push	es
	push	bx
	push	ax
	mov	save_ax,ax		; save ax
	mov	save_bx,bx		; save bx
	mov	bx,sp			; bx (use as the base pointer) <- sp

	mov	ax,DGROUP		;ds <- get our data segment
	mov	ds,ax

	lea	ax,word ptr [bx+4] ; offset of es location
	push	ax			; push indirect address of es on stack
	lea	ax,word ptr [bx+2] ; offset for bx location
	push	ax			; push indirect address of bx on stack

	push	ss
	lea	ax,word ptr [bx+2] ; offset for bx location
	push 	ax			; push indirect address of bx on stack

	push	ss			; push SS for far address to parameter
	lea	ax,word ptr [bx] ;offset for ax location
	push	ax			; push indirect address of ax on stack 
	
	call	far ptr _Crec_handler ;call the C routine 'handler'
	
	add	sp,12			; clean up the stack

	pop	ax				; restore saved register
	pop	bx
	pop	es
	pop	ds
	pop	dx
	pop	di
	pop	si
	pop	cx		

;restore WP's stack
	cli
	mov	ss,save_ss
	mov	sp,save_sp
	sti
;End restore WP's stack

	ret				; return to WP
_Record_handler	endp


;	routine: init_3rd
;
;	This routine saves the old 1Ah interrupt vector and sets
;	the new vector to the address of 'third_hook'.

public	_init_3rd
_init_3rd	proc	far

	push	ax			; save registers
	push	bx
	push	dx
	push	ds
	push	es

; setup the correct pointer to the original stack to prepare for stack
;switch.  The stack switch is performed in the low_handler routine.
; The stk_ptr variable is offset 500 bytes from the top of the stack to 
;preserve any values that have been saved on the stack during the start of
;the program.  The idea is to use an unused area of the original C stack 
;as the buffer area for the new stack.  The stack offset (sk_offset) may
;need to be increased if code is added to the MAIN part of the C program. 
;To increase the stack offset change the value of the stk_offset equate at
;the beginning of this file.
	mov	stk_seg,ss		; stk_seg (used for stack switch) <- ss
	mov	stk_ptr,sp		; stk_ptr (used for stack switch) <- sp
	sub	stk_ptr,stk_offset ; readjust the stack pointer to allow for spawn

	mov	ah,35h			; request interrupt vector address
	mov	al,1ah			; interrupt vector to request addr of
	int	21h				;request vector for int 1ah
						;returned in ES:BX
	mov	cs:_old_handler,bx ;save current interrupt vector
	mov	ax,es		   	; ''
	mov	cs:_old_handler+2,ax ; ''

	mov	dx,offset third_hook ; setup new interrupt handler
	push	cs			; ds <- cs
	pop	ds				; ''
						;ds:dx = address of new interrupt handler
	mov	ah,25h			;set new interrupt vector function
	mov	al,1ah			; interrupt vector to set
	int	21h				; CALL DOS

	pop	es				; restore registers
	pop	ds
	pop	dx
	pop	bx
	pop	ax

	ret					; return to C program
_init_3rd	endp

;-------------------------------------------------
;name: WPCallSys
;input: Global data
;				WPServ = WordPerfect Service
;				WPSysvar = System variable to get
;				WPRetBuf = return buffer for WordPerfect to return info
;output: none
;return: WPRetBuf contains return value
;-------------------------------------------------
csave_ss dw ?
csave_sp dw ?

public _WPCallSys
_WPCallSys proc far
	push bp
	mov	bp,sp
	push ax
	push bx
	push es
	push di
	push si


	;mov	ax,cs     	;setup to address 8 byte buffer
	;mov	es,ax
	xor		ax,ax		; clear ax
	mov	ah,byte ptr[bp+6]	; ah <- get service number
	mov	bx,word ptr[bp+8]	; bx <- get sysvar # not address
	mov	di,word ptr[bp+10]	; di <- get 8 byte buffer offset
	mov	es,word ptr[bp+12]	; es <- get 8 byte buffer setment
	mov	si,word ptr[bp+14]	; si <- get value type offset
	mov	al,byte ptr es:[si]	; al <- get value type

	; stack switch to original WP stack 
	;cli					; disable interrupts
	;mov	cs:csave_ss,ss	; save Stack Segment
	;mov	cs:csave_sp,sp	; save Stack Pointer
	;mov	ss,save_ss		; ss <- original C stack segment
	;mov	sp,save_sp		; sp <- readjusted stack segment
	;sti					; enable interrupts
	; End of stack switch

	call	wp_rout			; call the WP6.0 request routine

	;restore C program stack 
	;cli
	;mov	ss,csave_ss
	;mov	sp,csave_sp
	;sti
	;End restore WP's stack

	mov	byte ptr es:[si], al			; save value type returned

	pop	si
	pop di
	pop es
	pop	bx
	pop ax
	mov	sp,bp
	pop	bp

	ret

_WPCallSys endp

;-------------------------------------------------
;name: WPCall
;input: Global data
;				WPServ = WordPerfect Service
;				WPSysvar = System variable to get
;				WPRetBuf = return buffer for WordPerfect to return info
;output: none
;return: WPRetBuf contains return value
;-------------------------------------------------

public _WPCall
_WPCall proc far
	push bp
	mov	bp,sp
	push ax
	push bx
	push es
	push di
	push si


	;mov	ax,cs     	;setup to address 8 byte buffer
	;mov	es,ax
	xor		ax,ax		; clear ax
	mov	ah,byte ptr[bp+6]	; ah <- get service number
	mov	bx,word ptr[bp+8]	; bx <- get merge var offset
	mov	di,word ptr[bp+10]	; di <- get 8 byte buffer offset
	mov	es,word ptr[bp+12]	; es <- get 8 byte buffer segment
	mov	si,word ptr[bp+14]	; si <- get value type offset
	mov	al,byte ptr es:[si] ; al <- get value type

	; stack switch to original WP stack 
	;cli					; disable interrupts
	;mov	cs:csave_ss,ss	; save Stack Segment
	;mov	cs:csave_sp,sp	; save Stack Pointer
	;mov	ss,save_ss		; ss <- original C stack segment
	;mov	sp,save_sp		; sp <- readjusted stack segment
	;sti					; enable interrupts
	; End of stack switch

	call	wp_rout			; call the WP6.0 request routine

	;restore C program stack
	;cli
	;mov	ss,csave_ss
	;mov	sp,csave_sp
	;sti
	;End restore WP's stack

	mov	byte ptr es:[si], al			; save value type returned

	pop	si
	pop di
	pop es
	pop	bx
	pop ax
	mov	sp,bp
	pop	bp

	ret

_WPCall endp
;-------------------------------------------------
;	routine: rest_3rd
;	input:	none
;	output:	none
;	purpose: to unhook from "int 1ah" and restore the orginal interrupt
;		address
;	registers used:  ax, dx
;	unsaved registers: none
;-------------------------------------------------

public _rest_3rd
_rest_3rd	proc	far
	push	ax			; save registers
	push	dx

	mov	dx,cs:_old_handler ; ds:dx <- address of old Interrupt
	mov	ax,cs:_old_handler+2 ;vector to restore
	push	ds			; save ds
	mov	ds,ax			; ds <- ax
	mov	ah,25h			;set interrupt function
	mov	al,1ah			;Interrupt to set
	int	21h				; CALL DOS
	pop	ds				; restore ds

	pop	dx				; restore registers
	pop	ax
	ret
_rest_3rd	endp
;-----------------------------------------------
;	routine: third_hook
;	input: ax = 3601h
;	output: ds:si = address of _low_handler routine
;	registers used: ds, si
;	unrestored registers: ds, si
;	Purpose:
;	This routine is our installed handler for interrupt 1Ah.
;	If AH = 3601h, ds:si is set to the address of the C keyboard monitor
;	function and control is returned to WP. If AH is not 3601h, control
;	is passed to the original 1Ah interrupt handler
;------------------------------------------------

_old_handler	dw	0,0	;pointer to old 1Ah handler

third_hook	proc	far

	cmp	ax,3681h		;possibly WP6.0?
	 je	thrd100			;yes, setup handler routines

;------	we don't come back from the jump, the old handler will return
	jmp	dword ptr cs:_old_handler

thrd100:
	push ax
	push di
	;push ds
	push es
	
	mov	word ptr cs:wp_rout,di	; save WP routine offset
	mov	word ptr cs:wp_rout+2,es; save WP routine segment

	;make sure this is WP6.0 by checking wpstring and BX
	mov	ax,_TEXT		; setup es:di = wpstring ("WPCORP",0)
	mov	es,ax
	mov	di,offset wpstring	;es:di = wpstring
	mov	cx,str_len		;cx = length of wpstring
	repe	cmpsb			;compare strings ds:si to es:di
	jne	thrd999			;if not equal then not WP6.0

	cmp	BX,0600h		;bh = 6, bl = 0 for 6.0
	jne	thrd999			;if BX != to 0600h then just return
	
	mov ax, seg _key_handler ; get segment of key handler
	;setup key handler
	mov	ax,0ff00h			; ah = 0ffh function to store key handler addr
	mov	di,offset _Key_handler	; es:di -> offset of key handler
	call	cs:wp_rout			; call the WP6.0 request routine

	;setup token handler
	mov	ax,0fe00h			; function to store token handler addr
	mov	di,offset _Token_handler; es:di -> offset of token handler
	call	cs:wp_rout

	;setup record handler
	mov	ax,0fd00h			; function to store record handler
	mov	di, offset _Record_handler; es:di -> offset of record handler
	call	cs:wp_rout

thrd999:
	pop	es
	;pop	ds
	pop	di
	pop	ax

	jmp dword ptr cs:_old_handler	; jump to previous interrupt handler
third_hook	endp


_TEXT	ends
	end
