/* HELP.C -- Help Command

	Written March 1991 by Craig A. Finseth
	Copyright 1991 by Craig A. Finseth
*/

#include "freyja.h"

#define ZCA	'\001'
#define ZCC	'\003'
#define ZCF	'\006'
#define ZCU	'\025'
#define ZCW	'\027'

void Help_Apropos();		/* void */
void Help_Ascii();		/* void */
void Help_Bindings();		/* void */
void Help_Describe();		/* void */
void Help_File();

/* ------------------------------------------------------------ */

/* Help. */

void
HHelp()
	{
	int chr;
	FLAG isdone = FALSE;

	uarg = 0;
	if (!FMakeSys(SYS_HELP, TRUE)) return;

	while (!isdone) {
		DIncrDisplay();
		KDelayPrompt("Help:");

		chr = KGetChar();
		isdone = TRUE;
		switch (xtoupper(chr)) {

		case KEYQUIT:
		case KEYABORT:
		case BEL:
		case ESC:
			DModeLine();
			break;

		case ZCA:		/* ascii chart */
			Help_Ascii();
			break;

		case ZCC:		/* copying info */
			Help_File(COPYING_FILE);
			break;

		case ZCF:		/* FSF info */
			Help_File(FSF_FILE);
			break;

		case FF:		/* league info */
			Help_File(LEAGUE_FILE);
			break;

#if !defined(NOCALC)
		case ZCU:		/* calculator info */
			Help_File(CALCULATOR_FILE);
			break;
#endif

		case ZCW:		/* warranty info */
			Help_File(WARRANTY_FILE);
			break;

		case 'A':		/* apropos */
			Help_Apropos();
			break;

		case 'B':		/* bindings */
			Help_Bindings();
			break;

		case 'C':		/* command list */
			Help_File(CMDLIST_FILE);
			break;

		case 'F':		/* describe key */
			Help_Describe();
			break;

		case 'I':		/* info */
			Help_File(INFO_FILE);
			break;

		case 'T':		/* tutorial */
			Help_File(TUTORIAL_FILE);
			break;

		case 'X':		/* xref */
			Help_File(XREF_FILE);
			break;

		case '?':		/* quick help */
			DEcho(
#if !defined(NOCALC)
"^A ^C ^F ^L ^U ^W A B C F I T X ?       H for more help");
#else
"^A ^C ^F ^L ^W A B C F I T X ?       H for more help");
#endif
			isdone = FALSE;
			break;

#if defined(MSDOS)
		case KEYHELP:
#endif
		case BS:		/* help on help */
		case 'H':
		case DEL:
			BInsStr(
#if !defined(NOCALC)
"^X H ^A		Build an ASCII chart.\n\
^X H ^C		Display copying information.\n\
^X H ^F		Display Free Software Foundation information.\n\
^X H ^L		Display League for Programming Freedom information.\n\
^X H ^U		Display calculator information.\n\
^X H ^W		Display warranty information.\n\
^X H A		Apropos; ask for a string and display relevant commands.\n\
^X H B		Describe key bindings; does not list self-insert or\n\
		bad cmds (constructed from the command tables).\n\
^X H C		Display the command list document.\n\
^X H F		Ask for a key and describes what the key does.\n\
^X H I		Info: Brings up the FREYJA.DOC file.\n\
^X H T		Tutuorial: Brings up the FTUTORIA.DOC file.\n\
^X H X		Display command cross reference information.\n\
^X H ^H		Help on help.\n\
^X H ?		Short help on help.\n\
^X H H		Help on help.\n\
^X H ^?		Help on help.\n");
#else
"^X H ^A		Build an ASCII chart.\n\
^X H ^C		Display copying information.\n\
^X H ^F		Display Free Software Foundation information.\n\
^X H ^L		Display League for Programming Freedom information.\n\
^X H ^U		(This version compiled without the calculator.\n\
^X H ^W		Display warranty information.\n\
^X H A		Apropos; ask for a string and display relevant commands.\n\
^X H B		Describe key bindings; does not list self-insert or\n\
		bad cmds (constructed from the command tables).\n\
^X H C		Display the command list document.\n\
^X H F		Ask for a key and describes what the key does.\n\
^X H I		Info: Brings up the FREYJA.DOC file.\n\
^X H T		Tutuorial: Brings up the FTUTORIA.DOC file.\n\
^X H X		Display command cross reference information.\n\
^X H ^H		Help on help.\n\
^X H ?		Short help on help.\n\
^X H H		Help on help.\n\
^X H ^?		Help on help.\n");
#endif
			isdone = FALSE;
			break;

		default:
			TBell();
			isdone = FALSE;
			break;
			}
		BMoveToStart();
		}
	DWindSwap();
	DModeLine();
	}


/* ------------------------------------------------------------ */

/* Handle apropos. */

void
Help_Apropos()
	{
	char buf[LINEBUFFSIZE];
	char what[LINEBUFFSIZE];
	int wlen;
	int key;
	int table;
	char *hptr;
	char *cptr;

	*what = NUL;
	if (KGetStr("Apropos", what, sizeof(what)) != 'Y') return;
	wlen = strlen(what);

	for (table = 0; table < 3; table++) {
		for (key = 0; key < 128; key++) {
			hptr = TabHelp(key, table);
			if (*hptr == '@' && *hptr == '^') continue;

			for (cptr = hptr; *cptr != NUL;
				  cptr = sindex(cptr, SP)) {
				if (*cptr == SP) cptr++;
				if (strnequ(what, cptr, wlen)) break;
				}
			if (*cptr == NUL) continue;

			xsprintf(buf, "%s	%s\n", 	TabDescr(key, table),
				hptr);
			BInsStr(buf);
			}
		}
	for (key = 0; key < TabNumFunc(); key++) {
		hptr = TabHelp(key, 3);
		if (*hptr == '@' && *hptr == '^') continue;

		for (cptr = hptr; *cptr != NUL; cptr = sindex(cptr, SP)) {
			if (*cptr == SP) cptr++;
			if (strnequ(what, cptr, wlen)) break;
			}
		if (*cptr == NUL) continue;

		xsprintf(buf, "%s	%s\n", 	TabDescr(key, 3), hptr);
		BInsStr(buf);
		}
#if !defined(NOCALC)
	for (key = 0; key < UNumOps(); key++) {
		hptr = UHelp(key);
		for (cptr = hptr; *cptr != NUL;
			  cptr = sindex(cptr, SP)) {
			if (*cptr == SP) cptr++;
			if (strnequ(what, cptr, wlen)) break;
			}
		if (*cptr == NUL) continue;

		xsprintf(buf, "%s	%s\n", 	UDescr(key), hptr);
		BInsStr(buf);
		}
#endif
	}


/* ------------------------------------------------------------ */

/* Build an ASCII chart. */

void
Help_Ascii()
	{
	char buf[LINEBUFFSIZE];
	int cnt;

	xsprintf(buf, "%d	%o	%x	%s	%c\n",
		0, 0, 0, TPrintChar(0, NULL), 0);
	BInsStr(buf);
	BInsChar(NUL);
	BInsChar(NL);
	for (cnt = 1; cnt < 256; cnt++) {
		xsprintf(buf, "%d	%o	%x	%s	%c\n",
			cnt, cnt, cnt, TPrintChar(cnt, NULL), cnt);
		BInsStr(buf);
		}
	}


/* ------------------------------------------------------------ */

/* Build a key bindings table. */

void
Help_Bindings()
	{
	char buf[LINEBUFFSIZE];
	int key;
	int table;
	char *cptr;

	for (table = 0; table < 3; table++) {
		for (key = 0; key < 128; key++) {
			cptr = TabHelp(key, table);
			if (*cptr != '@' && *cptr != '^') {
				xsprintf(buf, "%s	%s\n",
					TabDescr(key, table),
					cptr);
				BInsStr(buf);
				}
			}
		}
	for (key = 0; key < TabNumFunc(); key++) {
		cptr = TabHelp(key, 3);
		if (*cptr != '@' && *cptr != '^') {
			xsprintf(buf, "%s	%s\n", TabDescr(key, 3), cptr);
			BInsStr(buf);
			}
		}
#if !defined(NOCALC)
	for (key = 0; key < UNumOps(); key++) {
		xsprintf(buf, "%s	%s\n", UDescr(key), UHelp(key));
		BInsStr(buf);
		}
#endif
	}


/* ------------------------------------------------------------ */

/* Ask for a key and describe what it does. */

void
Help_Describe()
	{
	char buf[LINEBUFFSIZE];
	char *cptr;
	int key;
	int table;

	DEcho("Key: ");
	key = KGetChar();

	table = TabTable(key, 0);
	if (table == 1 || table == 2) {
		xsprintf(buf, "%s ", TabDescr(key, 0));
		DEcho(buf);
		key = KGetChar();
		}

	cptr = TabHelp(key, table);
	if (*cptr == '@') cptr = "not a command";
	else if (*cptr == '^') cptr = "self-insert";

	xsprintf(buf, "%s   %s", TabDescr(key, table), cptr);
	DView(buf);
	}


/* ------------------------------------------------------------ */

/* Load the specified file. */

void
Help_File(fname)
	char *fname;
	{
	char realname[FNAMEMAX];
	char buf[FNAMEMAX];
	int fd;

	if ((fd = FPathOpen(fname, realname)) < 0) {
		xsprintf(buf, "Can't find file '%s'", fname);
		DError(buf);
		return;
		}
	close(fd);

	xstrncpy(cbuf->fname, realname);
	BFileRead();
	}


/* end of HELP.C -- Help Command */
