/* LIB.C -- Miscellaneous Library Functions

	Written July 1988 by Craig Finseth
*/

#include "fgenlib.h"

/* ------------------------------------------------------------ */

/* Return the larger of the two numbers. */

int
max(a, b)
	int a;
	int b;
	{
	return(a > b ? a : b);
	}


/* ------------------------------------------------------------ */

/* Return the smaller of the two numbers. */

int
min(a, b)
	int a;
	int b;
	{
	return(a < b ? a : b);
	}


/* ------------------------------------------------------------ */

/* Return a pointer to the first occurrance of C in STR. */

char *
sindex(str, chr)
	char *str;
	char chr;
	{
	while (*str != NUL && *str != chr) str++;
	return(str);
	}


/* ------------------------------------------------------------ */

/* Convert the value in STR to a decimal number and return it in N. 
The number is in base BASE.  Return TRUE if the conversion was
successful, FALSE if the string was not a valid number.

This routine allows for leading whitespace and can handle leading + or
- signs. */

FLAG
SToN(str, n, base)
	char *str;
	int *n;
	int base;
	{
	unsigned val;
	int minus;
	char chr;

	while (*str == SP || *str == TAB) str++;
	if (*str == '-') {
		minus = -1;
		str++;
		}
	else	{
		minus = 1;
		if (*str == '+') ++str;
		}
	for (val = 0; *str; ++str) {
		chr = xtoupper(*str);
		if (xisalpha(chr)) chr -= 'A' - 10;
		else if (xisdigit(chr)) chr -= '0';
		else return(FALSE);
		if (chr >= base) return(FALSE);
		val = val * base + chr;
		}
	*n = val * minus;
	return(TRUE);
	}


/* ------------------------------------------------------------ */

/* Compare two strings.  Return FALSE on not equal, TRUE on equal.
Comparison is case-independant. */

FLAG
strequ(a, b)
	char *a;
	char *b;
	{
	while (*a && *b) if (xtolower(*a++) != xtolower(*b++)) return(FALSE);
	if (*a || *b) return(FALSE);
	return(TRUE);
	}


/* ------------------------------------------------------------ */

/* Compare two strings.  Return FALSE on not equal, TRUE on equal.
Comparison is case-independant.  Compare at most LEN characters. */

FLAG
strnequ(a, b, len)
	char *a;
	char *b;
	int len;
	{
	while (*a && *b && len-- > 0) {
		if (xtolower(*a++) != xtolower(*b++)) return(FALSE);
		}
	if (len <= 0) return(TRUE);
	if (*a || *b) return(FALSE);
	return(TRUE);
	}


/* ------------------------------------------------------------ */

/* As ANSI version, but no domain limits. */

FLAG
xisalnum(c)
	int c;
	{
	return(xisalpha(c) || xisdigit(c));
	}


/* ------------------------------------------------------------ */

/* As ANSI version, but no domain limits. */

FLAG
xisalpha(c)
	int c;
	{
	return(xisupper(c) || xislower(c));
	}


/* ------------------------------------------------------------ */

/* As ANSI version, but no domain limits. */

FLAG
xisdigit(c)
	int c;
	{
	return(c >= '0' && c <= '9');
	}


/* ------------------------------------------------------------ */

/* Return TRUE if C is a grayspace character (Space, Tab, CR, LF, FF:
see iswhite). */

FLAG
xisgray(c)
	char c;
	{
	return(c == TAB || c == SP || c == CR || c == NL || c == FF);
	}


/* ------------------------------------------------------------ */

/* As ANSI version, but no domain limits. */

FLAG
xislower(c)
	int c;
	{
	return(c >= 'a' && c <= 'z');
	}


/* ------------------------------------------------------------ */

/* As ANSI version, but no domain limits. */

FLAG
xisupper(c)
	int c;
	{
	return(c >= 'A' && c <= 'Z');
	}


/* ------------------------------------------------------------ */

/* As ANSI version, but handle overlapping strings. */

void
xstrcpy(dest, src)
	char *dest;
	char *src;
	{
	do	{
		*dest++ = *src;
		} while (*src++);
	}


/* ------------------------------------------------------------ */

/* As ANSI version, but no domain limits. */

int
xtolower(c)
	int c;
	{
	return(xisupper(c) ? c + ('a' - 'A') : c);
	}


/* ------------------------------------------------------------ */

/* As ANSI version, but no domain limits. */

int
xtoupper(c)
	int c;
	{
	return(xislower(c) ? c + ('A' - 'a') : c);
	}


/* end of LIB.C -- Miscellaneous Library Functions */
